/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import groovy.lang.Closure;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProcessor;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProvider;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0017H\u0014R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/Kotlin2JsSourceSetProcessor;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProcessor;", "Lorg/jetbrains/kotlin/gradle/tasks/Kotlin2JsCompile;", "project", "Lorg/gradle/api/Project;", "javaBasePlugin", "Lorg/gradle/api/plugins/JavaBasePlugin;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "kotlinSourceSetProvider", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProvider;", "(Lorg/gradle/api/Project;Lorg/gradle/api/plugins/JavaBasePlugin;Lorg/gradle/api/tasks/SourceSet;Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProvider;)V", "build", "Lorg/gradle/api/Task;", "kotlin.jvm.PlatformType", "clean", "defaultKotlinDestinationDir", "Ljava/io/File;", "getDefaultKotlinDestinationDir", "()Ljava/io/File;", "createCleanSourceMapTask", "", "doCreateTask", "taskName", "", "doTargetSpecificProcessing", "kotlin-gradle-plugin"})
public final class Kotlin2JsSourceSetProcessor
extends KotlinSourceSetProcessor<Kotlin2JsCompile> {
    private final Task clean;
    private final Task build;

    @Override
    @NotNull
    protected File getDefaultKotlinDestinationDir() {
        return new File(this.getProject().getBuildDir(), "kotlin2js/" + this.getSourceSetName());
    }

    @Override
    @NotNull
    protected Kotlin2JsCompile doCreateTask(@NotNull Project project, @NotNull String taskName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
        KotlinTasksProvider kotlinTasksProvider = this.getTasksProvider();
        String string = this.getSourceSet().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceSet.name");
        return kotlinTasksProvider.createKotlinJSTask(project, taskName, string);
    }

    @Override
    protected void doTargetSpecificProcessing() {
        String taskName = ((Kotlin2JsCompile)this.getKotlinTask()).getName();
        Task task = this.build;
        if (task != null) {
            task.dependsOn(new Object[]{taskName});
        }
        Task task2 = this.clean;
        if (task2 != null) {
            task2.dependsOn(new Object[]{"clean" + StringsKt.capitalize((String)taskName)});
        }
        ((Kotlin2JsCompile)this.getKotlinTask()).source(new Object[]{this.getKotlinSourceSet().getKotlin()});
        this.createCleanSourceMapTask();
    }

    private final void createCleanSourceMapTask() {
        block0: {
            String taskName = this.getSourceSet().getTaskName("clean", "sourceMap");
            Delete task = (Delete)this.getProject().getTasks().create(taskName, Delete.class);
            task.onlyIf((Spec)new Spec<Task>(this){
                final /* synthetic */ Kotlin2JsSourceSetProcessor this$0;

                public final boolean isSatisfiedBy(Task it) {
                    return ((Kotlin2JsCompile)this.this$0.getKotlinTask()).getKotlinOptions().getSourceMap();
                }
                {
                    this.this$0 = kotlin2JsSourceSetProcessor;
                }
            });
            task.delete(new Object[]{new Closure<String>(this, (Object)this){
                final /* synthetic */ Kotlin2JsSourceSetProcessor this$0;

                @Nullable
                public String call() {
                    Object object = ((Kotlin2JsCompile)this.this$0.getKotlinTask()).property("outputFile");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    return (String)object + ".map";
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            }});
            Task task2 = this.clean;
            if (task2 == null) break block0;
            task2.dependsOn(new Object[]{taskName});
        }
    }

    public Kotlin2JsSourceSetProcessor(@NotNull Project project, @NotNull JavaBasePlugin javaBasePlugin, @NotNull SourceSet sourceSet, @NotNull KotlinTasksProvider tasksProvider, @NotNull KotlinSourceSetProvider kotlinSourceSetProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)javaBasePlugin, (String)"javaBasePlugin");
        Intrinsics.checkParameterIsNotNull((Object)sourceSet, (String)"sourceSet");
        Intrinsics.checkParameterIsNotNull((Object)tasksProvider, (String)"tasksProvider");
        Intrinsics.checkParameterIsNotNull((Object)kotlinSourceSetProvider, (String)"kotlinSourceSetProvider");
        String string = "kotlin2Js";
        String string2 = "Compiles the kotlin sources in " + sourceSet + " to JavaScript.";
        super(project, javaBasePlugin, sourceSet, tasksProvider, kotlinSourceSetProvider, KotlinPluginKt.getKOTLIN_JS_DSL_NAME(), string, string2);
        this.clean = (Task)project.getTasks().findByName("clean");
        this.build = (Task)project.getTasks().findByName("build");
    }
}

