/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.ChangedJavaFilesProcessor;
import org.jetbrains.kotlin.incremental.ChangesEither;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.LookupSymbol;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/incremental/ChangedJavaFilesProcessor;", "", "()V", "allChangedSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "getAllChangedSymbols", "()Ljava/util/Collection;", "allSymbols", "Ljava/util/HashSet;", "javaLang", "Lorg/jetbrains/kotlin/com/intellij/lang/java/JavaLanguage;", "kotlin.jvm.PlatformType", "log", "Lorg/gradle/api/logging/Logger;", "psiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "getPsiFileFactory", "()Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "psiFileFactory$delegate", "Lkotlin/Lazy;", "process", "Lorg/jetbrains/kotlin/incremental/ChangesEither;", "filesDiff", "Lorg/jetbrains/kotlin/incremental/ChangedFiles$Known;", "addLookupSymbols", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiClass;", "symbols", "", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "Ljava/io/File;", "kotlin-gradle-plugin"})
public final class ChangedJavaFilesProcessor {
    private final Logger log = Logging.getLogger((String)this.getClass().getSimpleName());
    private final HashSet<LookupSymbol> allSymbols = new HashSet();
    private final JavaLanguage javaLang = JavaLanguage.INSTANCE;
    private final Lazy psiFileFactory$delegate = LazyKt.lazy((Function0)psiFileFactory.2.INSTANCE);
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final PsiFileFactory getPsiFileFactory() {
        Lazy lazy = this.psiFileFactory$delegate;
        ChangedJavaFilesProcessor changedJavaFilesProcessor = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (PsiFileFactory)lazy.getValue();
    }

    @NotNull
    public final Collection<LookupSymbol> getAllChangedSymbols() {
        return this.allSymbols;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesEither process(@NotNull ChangedFiles.Known filesDiff) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Logger $receiver$iv;
        void destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)filesDiff, (String)"filesDiff");
        Iterable $receiver$iv2 = filesDiff.getModified();
        Iterable iterable = $receiver$iv2;
        Collection collection = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            File p1 = (File)element$iv$iv2;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List modifiedJava = (List)destination$iv$iv2;
        $receiver$iv$iv2 = filesDiff.getRemoved();
        destination$iv$iv2 = $receiver$iv;
        Iterator iterator = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File p1 = (File)element$iv$iv;
            if (!FileUtilsKt.isJavaFile(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedJava = (List)destination$iv$iv;
        if (CollectionsKt.any((Iterable)removedJava)) {
            $receiver$iv = this.log;
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Some java files are removed: [" + CollectionsKt.joinToString$default((Iterable)removedJava, null, null, null, (int)0, null, null, (int)63, null) + "]";
                GradleUtilsKt.kotlinDebug(logger, string);
            }
            return new ChangesEither.Unknown();
        }
        HashSet symbols = new HashSet();
        for (File javaFile : modifiedJava) {
            Object[] $receiver$iv3;
            Object element$iv$iv;
            boolean element$iv$iv2 = StringsKt.equals((String)FilesKt.getExtension((File)javaFile), (String)"java", (boolean)true);
            if (_Assertions.ENABLED && !element$iv$iv2) {
                element$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(element$iv$iv));
            }
            PsiFile psiFile = this.psiFile(javaFile);
            if (!(psiFile instanceof PsiJavaFile)) {
                element$iv$iv = this.log;
                if ($receiver$iv3.isDebugEnabled()) {
                    Object[] objectArray = $receiver$iv3;
                    PsiFile psiFile2 = psiFile;
                    String string = "Expected PsiJavaFile, got " + (psiFile2 != null ? psiFile2.getClass() : null);
                    GradleUtilsKt.kotlinDebug((Logger)objectArray, string);
                }
                return new ChangesEither.Unknown();
            }
            $receiver$iv3 = ((PsiJavaFile)psiFile).getClasses();
            for (int i = 0; i < $receiver$iv3.length; ++i) {
                Object element$iv = $receiver$iv3[i];
                PsiClass it = (PsiClass)element$iv;
                this.addLookupSymbols(it, symbols);
            }
        }
        this.allSymbols.addAll(symbols);
        return new ChangesEither.Known(symbols, null, 2, null);
    }

    private final void addLookupSymbols(@NotNull PsiClass $receiver, Set<LookupSymbol> symbols) {
        PsiMethod it;
        Object element$iv;
        Object[] $receiver$iv;
        int n;
        String string;
        Object[] objectArray;
        LookupSymbol lookupSymbol;
        Object[] objectArray2 = $receiver.getQualifiedName();
        Object[] objectArray3 = objectArray2;
        if (objectArray2 == null) {
            objectArray3 = "";
        }
        Object[] fqn = objectArray3;
        objectArray2 = $receiver.getName();
        LookupSymbol lookupSymbol2 = lookupSymbol;
        LookupSymbol lookupSymbol3 = lookupSymbol;
        Set<LookupSymbol> set = symbols;
        Object[] objectArray4 = objectArray2;
        if (objectArray2 == null) {
            objectArray4 = objectArray = "";
        }
        if (Intrinsics.areEqual((Object)fqn, (Object)$receiver.getName())) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(".");
            String string2 = $receiver.getName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = StringsKt.removeSuffix((String)fqn, (CharSequence)stringBuilder.append(string2).toString());
        }
        lookupSymbol2((String)objectArray, string);
        set.add(lookupSymbol3);
        objectArray2 = $receiver.getMethods();
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (PsiMethod)element$iv;
            String string3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.name");
            symbols.add(new LookupSymbol(string3, (String)fqn));
        }
        $receiver$iv = $receiver.getFields();
        for (n = 0; n < $receiver$iv.length; ++n) {
            LookupSymbol lookupSymbol4;
            element$iv = $receiver$iv[n];
            it = (PsiField)element$iv;
            String $i$a$1$forEach = it.getName();
            LookupSymbol $i$f$forEach = lookupSymbol4;
            LookupSymbol lookupSymbol5 = lookupSymbol4;
            Set<LookupSymbol> set2 = symbols;
            String string4 = $i$a$1$forEach;
            if (string4 == null) {
                string4 = "";
            }
            String string5 = string4;
            $i$f$forEach(string5, (String)fqn);
            set2.add(lookupSymbol5);
        }
        $receiver$iv = $receiver.getInnerClasses();
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (PsiClass)element$iv;
            this.addLookupSymbols((PsiClass)it, symbols);
        }
    }

    private final PsiFile psiFile(@NotNull File $receiver) {
        return this.getPsiFileFactory().createFileFromText(FilesKt.getNameWithoutExtension((File)$receiver), (Language)this.javaLang, (CharSequence)FilesKt.readText$default((File)$receiver, null, (int)1, null));
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ChangedJavaFilesProcessor.class), "psiFileFactory", "getPsiFileFactory()Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;"))};
    }
}

