/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.Kapt3GradleSubplugin;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.plugin.android.AndroidGradleWrapper;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002,-B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0019J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0002H\u0016J\u001a\u0010$\u001a\u00020%*\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000e0(H\u0002J\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000e0\b*\u00020&H\u0002J\f\u0010*\u001a\u00020%*\u00020&H\u0002J\f\u0010+\u001a\u00020%*\u00020&H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u0006\u0012\u0002\b\u00030\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "()V", "kotlinToKaptTasksMap", "", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "sourceProviders", "", "Lcom/android/builder/model/SourceProvider;", "Lcom/android/build/gradle/internal/variant/BaseVariantData;", "getSourceProviders", "(Lcom/android/build/gradle/internal/variant/BaseVariantData;)Ljava/util/List;", "apply", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "project", "Lorg/gradle/api/Project;", "kotlinCompile", "javaCompile", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "variantData", "", "javaSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "getArtifactName", "", "getCompilerPluginId", "getGroupName", "getKaptGeneratedDir", "Ljava/io/File;", "sourceSetName", "getKaptStubsDir", "getSubpluginKotlinTasks", "isApplicable", "", "task", "addMiscOptions", "", "Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin$Kapt3SubpluginContext;", "pluginOptions", "", "buildOptions", "createKaptKotlinTask", "disableAnnotationProcessingInJavaTask", "Companion", "Kapt3SubpluginContext", "kotlin-gradle-plugin"})
public final class Kapt3KotlinGradleSubplugin
implements KotlinGradleSubplugin<KotlinCompile> {
    private final Map<KotlinCompile, KaptTask> kotlinToKaptTasksMap = MapsKt.mutableMapOf((Pair[])new Pair[0]);
    private static final String VERBOSE_OPTION_NAME = "kapt.verbose";
    @NotNull
    private static final String MAIN_KAPT_CONFIGURATION_NAME = "kapt";
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull Project project, @NotNull KotlinCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return Kapt3GradleSubplugin.Companion.isEnabled(project);
    }

    @NotNull
    public final File getKaptGeneratedDir(@NotNull Project project, @NotNull String sourceSetName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
        return new File(project.getProject().getBuildDir(), "generated/source/kapt/" + sourceSetName);
    }

    @NotNull
    public final File getKaptStubsDir(@NotNull Project project, @NotNull String sourceSetName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
        File dir = new File(project.getProject().getBuildDir(), "tmp/kapt3/stubs/" + sourceSetName);
        dir.mkdirs();
        return dir;
    }

    @NotNull
    public List<SubpluginOption> apply(@NotNull Project project, @NotNull KotlinCompile kotlinCompile, @NotNull AbstractCompile javaCompile, @Nullable Object variantData, @Nullable SourceSet javaSourceSet) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
        Intrinsics.checkParameterIsNotNull((Object)javaCompile, (String)"javaCompile");
        boolean bl = variantData != null ^ javaSourceSet != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ArrayList kaptClasspath = CollectionsKt.arrayListOf((Object[])new File[0]);
        Function1<String, Unit> handleSourceSet$ = new Function1<String, Unit>(project, javaCompile, kaptClasspath){
            final /* synthetic */ Project $project;
            final /* synthetic */ AbstractCompile $javaCompile;
            final /* synthetic */ ArrayList $kaptClasspath;

            public final void invoke(@NotNull String sourceSetName) {
                Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
                Configuration kaptConfiguration = Kapt3KotlinGradleSubplugin.Companion.findKaptConfiguration(this.$project, sourceSetName);
                if (kaptConfiguration != null && kaptConfiguration.getDependencies().size() > 1) {
                    this.$javaCompile.dependsOn(new Object[]{kaptConfiguration.getBuildDependencies()});
                    this.$kaptClasspath.addAll(kaptConfiguration.resolve());
                }
            }
            {
                this.$project = project;
                this.$javaCompile = abstractCompile;
                this.$kaptClasspath = arrayList;
                super(1);
            }
        };
        if (variantData != null) {
            Object object = variantData;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.variant.BaseVariantData<*>");
            }
            Iterator<SourceProvider> iterator = this.getSourceProviders((BaseVariantData)object).iterator();
            while (iterator.hasNext()) {
                SourceProvider provider;
                SourceProvider sourceProvider = provider = iterator.next();
                if (sourceProvider == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.api.AndroidSourceSet");
                }
                String string3 = ((AndroidSourceSet)sourceProvider).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(provider as AndroidSourceSet).name");
                handleSourceSet$.invoke(string3);
            }
            string = ((BaseVariantData)variantData).getName();
        } else {
            if (javaSourceSet == null) {
                String provider = "Java source set should not be null";
                throw (Throwable)new IllegalStateException(provider.toString());
            }
            String string4 = javaSourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"javaSourceSet.name");
            handleSourceSet$.invoke(string4);
            string = javaSourceSet.getName();
        }
        String sourceSetName = string;
        KaptExtension kaptExtension = (KaptExtension)project.getExtensions().getByType(KaptExtension.class);
        String string5 = sourceSetName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSetName");
        KaptExtension kaptExtension2 = kaptExtension;
        Intrinsics.checkExpressionValueIsNotNull((Object)kaptExtension2, (String)"kaptExtension");
        Kapt3SubpluginContext context = new Kapt3SubpluginContext(project, kotlinCompile, javaCompile, variantData, string5, kaptExtension2, kaptClasspath);
        this.createKaptKotlinTask(context);
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<KaptTask> getSubpluginKotlinTasks(@NotNull Project project, @NotNull KotlinCompile kotlinCompile) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
                object = this.kotlinToKaptTasksMap.get(kotlinCompile);
                if (object == null) break block2;
                KaptTask kaptTask = object;
                KaptTask it = kaptTask;
                object = CollectionsKt.listOf((Object)((Object)it));
                if (object != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final List<SubpluginOption> buildOptions(@NotNull Kapt3SubpluginContext $receiver) {
        Map map;
        BaseExtension androidPlugin;
        BaseExtension baseExtension;
        Object object;
        Object object2;
        Collection $receiver$iv;
        List pluginOptions = CollectionsKt.mutableListOf((Object[])new SubpluginOption[0]);
        File generatedFilesDir = this.getKaptGeneratedDir($receiver.getProject(), $receiver.getSourceSetName());
        if ($receiver.getVariantData() != null) {
            Object object3 = $receiver.getVariantData();
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.variant.BaseVariantData<*>");
            }
            ((BaseVariantData)object3).addJavaSourceFoldersToModel(new File[]{generatedFilesDir});
        }
        Iterable iterable = pluginOptions;
        Object object4 = new SubpluginOption("aptOnly", "true");
        iterable.add(object4);
        this.disableAnnotationProcessingInJavaTask($receiver);
        if ($receiver.getKaptClasspath().isEmpty()) {
            return pluginOptions;
        }
        iterable = $receiver.getKaptClasspath();
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            object2 = pluginOptions;
            String string = it.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
            object = new SubpluginOption("apclasspath", string);
            object2.add(object);
        }
        $receiver.getJavaCompile().source(new Object[]{generatedFilesDir});
        $receiver$iv = pluginOptions;
        String string = generatedFilesDir.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generatedFilesDir.canonicalPath");
        object4 = new SubpluginOption("sources", string);
        $receiver$iv.add(object4);
        $receiver$iv = pluginOptions;
        String string2 = $receiver.getKotlinCompile().getDestinationDir().getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"kotlinCompile.destinationDir.canonicalPath");
        object4 = new SubpluginOption("classes", string2);
        $receiver$iv.add(object4);
        Object object5 = $receiver.getVariantData();
        if (object5 != null) {
            object4 = object5;
            Object it = object4;
            Object object6 = $receiver.getProject().getExtensions().findByName("android");
            if (!(object6 instanceof BaseExtension)) {
                object6 = null;
            }
            baseExtension = (BaseExtension)object6;
        } else {
            baseExtension = androidPlugin = null;
        }
        if ($receiver.getVariantData() != null) {
            map = AndroidGradleWrapper.getAnnotationProcessorOptionsFromAndroidVariant($receiver.getVariantData());
            if (map == null) {
                map = MapsKt.emptyMap();
            }
        } else {
            map = MapsKt.emptyMap();
        }
        Map androidOptions = map;
        Map<String, String> map2 = $receiver.getKaptExtension().getAdditionalArguments($receiver.getProject(), $receiver.getVariantData(), androidPlugin);
        Map map3 = androidOptions;
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"androidOptions");
        Map apOptions = MapsKt.plus(map2, (Map)map3);
        object = apOptions;
        object2 = object.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry entry;
            Map.Entry $i$a$1$forEach = entry = (Map.Entry)object2.next();
            String key = (String)$i$a$1$forEach.getKey();
            Object object7 = entry;
            String value = (String)object7.getValue();
            object7 = pluginOptions;
            SubpluginOption subpluginOption = new SubpluginOption("apoption", key + ":" + value);
            object7.add(subpluginOption);
        }
        this.addMiscOptions($receiver, pluginOptions);
        return pluginOptions;
    }

    private final void addMiscOptions(@NotNull Kapt3SubpluginContext $receiver, List<SubpluginOption> pluginOptions) {
        if ($receiver.getKaptExtension().getGenerateStubs()) {
            $receiver.getProject().getLogger().warn("'kapt.generateStubs' is not used by the 'kotlin-kapt' plugin");
        }
        Collection collection = pluginOptions;
        SubpluginOption subpluginOption = new SubpluginOption("useLightAnalysis", String.valueOf($receiver.getKaptExtension().getUseLightAnalysis()));
        collection.add(subpluginOption);
        if ($receiver.getProject().hasProperty(Kapt3KotlinGradleSubplugin.Companion.getVERBOSE_OPTION_NAME()) && Intrinsics.areEqual((Object)$receiver.getProject().property(Kapt3KotlinGradleSubplugin.Companion.getVERBOSE_OPTION_NAME()), (Object)"true")) {
            collection = pluginOptions;
            subpluginOption = new SubpluginOption("verbose", "true");
            collection.add(subpluginOption);
            collection = pluginOptions;
            String string = this.getKaptStubsDir($receiver.getProject(), $receiver.getSourceSetName()).getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getKaptStubsDir(project,\u2026rceSetName).canonicalPath");
            subpluginOption = new SubpluginOption("stubs", string);
            collection.add(subpluginOption);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createKaptKotlinTask(@NotNull Kapt3SubpluginContext $receiver) {
        void destination$iv$iv;
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        File sourcesOutputDir = this.getKaptGeneratedDir($receiver.getProject(), $receiver.getSourceSetName());
        boolean bl = StringsKt.startsWith$default((String)$receiver.getKotlinCompile().getName(), (String)"compile", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String kaptTaskName = StringsKt.replaceFirst$default((String)$receiver.getKotlinCompile().getName(), (String)"compile", (String)MAIN_KAPT_CONFIGURATION_NAME, (boolean)false, (int)4, null);
        KaptTask kaptTask = (KaptTask)$receiver.getProject().getTasks().create(kaptTaskName, KaptTask.class);
        kaptTask.setKotlinCompileTask$kotlin_gradle_plugin($receiver.getKotlinCompile());
        Map<KotlinCompile, Object> map = this.kotlinToKaptTasksMap;
        KotlinCompile kotlinCompile = $receiver.getKotlinCompile();
        KaptTask kaptTask2 = kaptTask;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kaptTask2), (String)"kaptTask");
        Object object = kaptTask2;
        map.put(kotlinCompile, object);
        map = KotlinPluginKt.resolveSubpluginArtifacts($receiver.getProject(), CollectionsKt.listOf((Object)this));
        kotlinCompile = $receiver$iv;
        object = new ArrayList();
        Iterator<SubpluginOption> iterator = $receiver$iv$iv;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            kaptTask.getPluginOptions$kotlin_gradle_plugin().addClasspathEntry(it);
        }
        GradleUtilsKt.mapClasspath(kaptTask, (Function0<? extends FileCollection>)((Function0)new Function0<FileCollection>($receiver){
            final /* synthetic */ Kapt3SubpluginContext receiver$0;

            public final FileCollection invoke() {
                FileCollection fileCollection = this.receiver$0.getKotlinCompile().getClasspath();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"kotlinCompile.classpath");
                return fileCollection;
            }
            {
                this.receiver$0 = kapt3SubpluginContext;
                super(0);
            }
        }));
        kaptTask.setDestinationDir(sourcesOutputDir);
        $receiver.getKotlinCompile().dependsOn(new Object[]{kaptTask});
        $receiver.getKotlinCompile().source(sourcesOutputDir);
        $receiver.getJavaCompile().source(new Object[]{sourcesOutputDir});
        CompilerPluginOptions pluginOptions = kaptTask.getPluginOptions$kotlin_gradle_plugin();
        String compilerPluginId = this.getCompilerPluginId();
        for (SubpluginOption option : this.buildOptions($receiver)) {
            pluginOptions.addPluginArgument(compilerPluginId, option.getKey(), option.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void disableAnnotationProcessingInJavaTask(@NotNull Kapt3SubpluginContext $receiver) {
        block2: {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            AbstractCompile abstractCompile = $receiver.getJavaCompile();
            if (!(abstractCompile instanceof JavaCompile)) {
                abstractCompile = null;
            }
            JavaCompile javaCompile = (JavaCompile)abstractCompile;
            if (javaCompile == null) break block2;
            JavaCompile javaCompile2 = javaCompile;
            JavaCompile javaCompile3 = javaCompile2;
            CompileOptions options = javaCompile3.getOptions();
            Iterable iterable = options.getCompilerArgs();
            CompileOptions compileOptions = options;
            void var7_7 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!(!StringsKt.startsWith$default((String)it, (String)"-proc:", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            compileOptions.setCompilerArgs(CollectionsKt.plus((Collection)list, (Object)"-proc:none"));
        }
    }

    private final List<SourceProvider> getSourceProviders(@NotNull BaseVariantData<?> $receiver) {
        List list = $receiver.getVariantConfiguration().getSortedSourceProviders();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variantConfiguration.sortedSourceProviders");
        return list;
    }

    @NotNull
    public String getCompilerPluginId() {
        return "org.jetbrains.kotlin.kapt3";
    }

    @NotNull
    public String getGroupName() {
        return "org.jetbrains.kotlin";
    }

    @NotNull
    public String getArtifactName() {
        return "kotlin-annotation-processing";
    }

    static {
        VERBOSE_OPTION_NAME = VERBOSE_OPTION_NAME;
        MAIN_KAPT_CONFIGURATION_NAME = MAIN_KAPT_CONFIGURATION_NAME;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin$Kapt3SubpluginContext;", "", "project", "Lorg/gradle/api/Project;", "kotlinCompile", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "javaCompile", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "variantData", "sourceSetName", "", "kaptExtension", "Lorg/jetbrains/kotlin/gradle/plugin/KaptExtension;", "kaptClasspath", "", "Ljava/io/File;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;Lorg/gradle/api/tasks/compile/AbstractCompile;Ljava/lang/Object;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/KaptExtension;Ljava/util/List;)V", "getJavaCompile", "()Lorg/gradle/api/tasks/compile/AbstractCompile;", "getKaptClasspath", "()Ljava/util/List;", "getKaptExtension", "()Lorg/jetbrains/kotlin/gradle/plugin/KaptExtension;", "getKotlinCompile", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "getProject", "()Lorg/gradle/api/Project;", "getSourceSetName", "()Ljava/lang/String;", "getVariantData", "()Ljava/lang/Object;", "kotlin-gradle-plugin"})
    private static final class Kapt3SubpluginContext {
        @NotNull
        private final Project project;
        @NotNull
        private final KotlinCompile kotlinCompile;
        @NotNull
        private final AbstractCompile javaCompile;
        @Nullable
        private final Object variantData;
        @NotNull
        private final String sourceSetName;
        @NotNull
        private final KaptExtension kaptExtension;
        @NotNull
        private final List<File> kaptClasspath;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final KotlinCompile getKotlinCompile() {
            return this.kotlinCompile;
        }

        @NotNull
        public final AbstractCompile getJavaCompile() {
            return this.javaCompile;
        }

        @Nullable
        public final Object getVariantData() {
            return this.variantData;
        }

        @NotNull
        public final String getSourceSetName() {
            return this.sourceSetName;
        }

        @NotNull
        public final KaptExtension getKaptExtension() {
            return this.kaptExtension;
        }

        @NotNull
        public final List<File> getKaptClasspath() {
            return this.kaptClasspath;
        }

        public Kapt3SubpluginContext(@NotNull Project project, @NotNull KotlinCompile kotlinCompile, @NotNull AbstractCompile javaCompile, @Nullable Object variantData, @NotNull String sourceSetName, @NotNull KaptExtension kaptExtension, @NotNull List<File> kaptClasspath) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
            Intrinsics.checkParameterIsNotNull((Object)javaCompile, (String)"javaCompile");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkParameterIsNotNull((Object)kaptExtension, (String)"kaptExtension");
            Intrinsics.checkParameterIsNotNull(kaptClasspath, (String)"kaptClasspath");
            this.project = project;
            this.kotlinCompile = kotlinCompile;
            this.javaCompile = javaCompile;
            this.variantData = variantData;
            this.sourceSetName = sourceSetName;
            this.kaptExtension = kaptExtension;
            this.kaptClasspath = kaptClasspath;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\n*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin$Companion;", "", "()V", "MAIN_KAPT_CONFIGURATION_NAME", "", "getMAIN_KAPT_CONFIGURATION_NAME", "()Ljava/lang/String;", "VERBOSE_OPTION_NAME", "getVERBOSE_OPTION_NAME", "findMainKaptConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "project", "Lorg/gradle/api/Project;", "getKaptConfigurationName", "sourceSetName", "findKaptConfiguration", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String getVERBOSE_OPTION_NAME() {
            return VERBOSE_OPTION_NAME;
        }

        @NotNull
        public final String getMAIN_KAPT_CONFIGURATION_NAME() {
            return MAIN_KAPT_CONFIGURATION_NAME;
        }

        @NotNull
        public final String getKaptConfigurationName(@NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            return Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ^ true ? this.getMAIN_KAPT_CONFIGURATION_NAME() + StringsKt.capitalize((String)sourceSetName) : this.getMAIN_KAPT_CONFIGURATION_NAME();
        }

        @Nullable
        public final Configuration findKaptConfiguration(@NotNull Project $receiver, @NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            return (Configuration)$receiver.getProject().getConfigurations().findByName(this.getKaptConfigurationName(sourceSetName));
        }

        @Nullable
        public final Configuration findMainKaptConfiguration(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.findKaptConfiguration(project, this.getMAIN_KAPT_CONFIGURATION_NAME());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

