/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.incremental.CompilationResult;
import org.jetbrains.kotlin.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.modules.TargetId;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001d\u001eB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0018\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl;", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/kotlin/modules/TargetId;", "targetDataRoot", "Ljava/io/File;", "targetOutputDir", "target", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/modules/TargetId;)V", "generatedSourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getGeneratedSourceSnapshotMap$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "sourceSnapshotMap", "getSourceSnapshotMap$kotlin_gradle_plugin", "sourceToClassfilesMap", "Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$SourceToClassfilesMap;", "getSourceToClassfilesMap$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$SourceToClassfilesMap;", "removeClassfilesBySources", "", "sources", "", "saveFileToCache", "Lorg/jetbrains/kotlin/incremental/CompilationResult;", "generatedClass", "Lorg/jetbrains/kotlin/build/GeneratedJvmClass;", "Companion", "SourceToClassfilesMap", "kotlin-gradle-plugin"})
public final class GradleIncrementalCacheImpl
extends IncrementalCacheImpl<TargetId> {
    private final Logger log;
    @NotNull
    private final SourceToClassfilesMap sourceToClassfilesMap;
    @NotNull
    private final FileSnapshotMap generatedSourceSnapshotMap;
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    private static final String SOURCES_TO_CLASSFILES = "sources-to-classfiles";
    private static final String GENERATED_SOURCE_SNAPSHOTS = "generated-source-snapshot";
    private static final String SOURCE_SNAPSHOTS = "source-snapshot";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SourceToClassfilesMap getSourceToClassfilesMap$kotlin_gradle_plugin() {
        return this.sourceToClassfilesMap;
    }

    @NotNull
    public final FileSnapshotMap getGeneratedSourceSnapshotMap$kotlin_gradle_plugin() {
        return this.generatedSourceSnapshotMap;
    }

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$kotlin_gradle_plugin() {
        return this.sourceSnapshotMap;
    }

    public final void removeClassfilesBySources(@NotNull Iterable<? extends File> sources) {
        Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
        Iterable<? extends File> $receiver$iv = sources;
        Iterator<? extends File> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            File element$iv;
            File it = element$iv = iterator.next();
            this.sourceToClassfilesMap.remove(it);
        }
    }

    @NotNull
    public CompilationResult saveFileToCache(@NotNull GeneratedJvmClass<TargetId> generatedClass) {
        Intrinsics.checkParameterIsNotNull(generatedClass, (String)"generatedClass");
        Iterable $receiver$iv = generatedClass.getSourceFiles();
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.sourceToClassfilesMap.add(it, generatedClass.getOutputFile());
        }
        return super.saveFileToCache(generatedClass);
    }

    public GradleIncrementalCacheImpl(@NotNull File targetDataRoot, @Nullable File targetOutputDir, @NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        super(targetDataRoot, targetOutputDir, (Object)target);
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
        this.sourceToClassfilesMap = (SourceToClassfilesMap)this.registerMap((BasicMap)new SourceToClassfilesMap(this.getStorageFile(GradleIncrementalCacheImpl.Companion.getSOURCES_TO_CLASSFILES())));
        this.generatedSourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile(GradleIncrementalCacheImpl.Companion.getGENERATED_SOURCE_SNAPSHOTS())));
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile(GradleIncrementalCacheImpl.Companion.getSOURCE_SNAPSHOTS())));
    }

    static {
        SOURCES_TO_CLASSFILES = SOURCES_TO_CLASSFILES;
        GENERATED_SOURCE_SNAPSHOTS = GENERATED_SOURCE_SNAPSHOTS;
        SOURCE_SNAPSHOTS = SOURCE_SNAPSHOTS;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\t\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$SourceToClassfilesMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourceFile", "classFile", "dumpValue", "value", "get", "remove", "file", "kotlin-gradle-plugin"})
    public final class SourceToClassfilesMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void add(@NotNull File sourceFile, @NotNull File classFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            String string2 = classFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"classFile.absolutePath");
            lazyStorage.append((Object)string, string2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<File> get(@NotNull File sourceFile) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            Collection collection = (Collection)lazyStorage.get((Object)string);
            Collection collection2 = collection;
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            Iterable $receiver$iv = collection2;
            Iterable iterable = $receiver$iv;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string2 = (String)item$iv$iv;
                void var11_8 = destination$iv$iv;
                File file = new File((String)p1);
                var11_8.add(file);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        /*
         * WARNING - void declaration
         */
        public final void remove(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Iterable $receiver$iv = this.get(file);
            for (Object element$iv : $receiver$iv) {
                void $receiver$iv2;
                File it = (File)element$iv;
                Logger logger = GradleIncrementalCacheImpl.this.log;
                if ($receiver$iv2.isDebugEnabled()) {
                    void var7_7 = $receiver$iv2;
                    String string = "Deleting " + it + " on clearing cache for " + file;
                    GradleUtilsKt.kotlinDebug((Logger)var7_7, string);
                }
                it.delete();
            }
            LazyStorage lazyStorage = this.getStorage();
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            lazyStorage.remove((Object)string);
        }

        public SourceToClassfilesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, (KeyDescriptor)PathStringDescriptor.INSTANCE, (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/GradleIncrementalCacheImpl$Companion;", "", "()V", "GENERATED_SOURCE_SNAPSHOTS", "", "getGENERATED_SOURCE_SNAPSHOTS", "()Ljava/lang/String;", "SOURCES_TO_CLASSFILES", "getSOURCES_TO_CLASSFILES", "SOURCE_SNAPSHOTS", "getSOURCE_SNAPSHOTS", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String getSOURCES_TO_CLASSFILES() {
            return SOURCES_TO_CLASSFILES;
        }

        private final String getGENERATED_SOURCE_SNAPSHOTS() {
            return GENERATED_SOURCE_SNAPSHOTS;
        }

        private final String getSOURCE_SNAPSHOTS() {
            return SOURCE_SNAPSHOTS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

