/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.AndroidExtensionsSubpluginIndicator;
import org.jetbrains.kotlin.gradle.internal.AndroidSubplugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.plugin.android.AndroidGradleWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.w3c.dom.Document;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\n\u0010\u001a\u001a\u00020\u001b*\u00020\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AndroidSubplugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "()V", "apply", "", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "project", "Lorg/gradle/api/Project;", "kotlinCompile", "javaCompile", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "variantData", "", "javaSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "getApplicationPackageFromManifest", "", "manifestFile", "Ljava/io/File;", "getArtifactName", "getCompilerPluginId", "getGroupName", "isApplicable", "", "task", "parseXml", "Lorg/w3c/dom/Document;", "Companion", "kotlin-gradle-plugin"})
public final class AndroidSubplugin
implements KotlinGradleSubplugin<KotlinCompile> {
    private static volatile boolean migrateWarningReported;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public boolean isApplicable(@NotNull Project project, @NotNull KotlinCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        try {
            Object object = project.getExtensions().getByName("android");
            if (!(object instanceof BaseExtension)) {
                object = null;
            }
            if ((BaseExtension)object == null) {
                return false;
            }
        }
        catch (UnknownDomainObjectException e) {
            return false;
        }
        if (project.getPlugins().findPlugin(AndroidExtensionsSubpluginIndicator.class) == null) {
            boolean bl;
            block7: {
                void $receiver$iv;
                DependencySet dependencies2 = project.getBuildscript().getConfigurations().getByName("classpath").getDependencies();
                Iterable iterable = (Iterable)dependencies2;
                for (Object element$iv : $receiver$iv) {
                    Dependency it = (Dependency)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)this.getArtifactName()) && Intrinsics.areEqual((Object)it.getGroup(), (Object)this.getGroupName()))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl && !Companion.getMigrateWarningReported()) {
                project.getLogger().warn("To enable Android Extensions, use: \"apply plugin: 'kotlin-android-extensions'\"");
                Companion.setMigrateWarningReported(true);
            }
            return false;
        }
        return true;
    }

    @NotNull
    public List<SubpluginOption> apply(@NotNull Project project, @NotNull KotlinCompile kotlinCompile, @NotNull AbstractCompile javaCompile, @Nullable Object variantData, @Nullable SourceSet javaSourceSet) {
        Object object;
        File manifestFile;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
        Intrinsics.checkParameterIsNotNull((Object)javaCompile, (String)"javaCompile");
        Object object2 = project.getExtensions().getByName("android");
        if (!(object2 instanceof BaseExtension)) {
            object2 = null;
        }
        BaseExtension baseExtension = (BaseExtension)object2;
        if (baseExtension == null) {
            return CollectionsKt.emptyList();
        }
        BaseExtension androidExtension = baseExtension;
        NamedDomainObjectContainer sourceSets = androidExtension.getSourceSets();
        ArrayList pluginOptions = CollectionsKt.arrayListOf((Object[])new SubpluginOption[0]);
        AndroidSourceSet mainSourceSet = (AndroidSourceSet)sourceSets.getByName("main");
        File file = manifestFile = mainSourceSet.getManifest().getSrcFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"manifestFile");
        String string = this.getApplicationPackageFromManifest(file);
        if (string == null) {
            object = this;
            AndroidSubplugin androidSubplugin = (AndroidSubplugin)object;
            project.getLogger().warn("Application package name is not present in the manifest file (" + manifestFile.getAbsolutePath() + ")");
            string = "";
        }
        String applicationPackage = string;
        object = pluginOptions;
        SubpluginOption $receiver = new SubpluginOption("package", applicationPackage);
        object.add($receiver);
        Function1<AndroidSourceSet, Unit> addVariant$ = new Function1<AndroidSourceSet, Unit>(pluginOptions){
            final /* synthetic */ ArrayList $pluginOptions;

            public final void invoke(@NotNull AndroidSourceSet sourceSet) {
                Intrinsics.checkParameterIsNotNull((Object)sourceSet, (String)"sourceSet");
                Collection collection = this.$pluginOptions;
                SubpluginOption subpluginOption = new SubpluginOption("variant", sourceSet.getName() + ';' + CollectionsKt.joinToString$default((Iterable)sourceSet.getRes().getSrcDirs(), (CharSequence)";", null, null, (int)0, null, (Function1)apply.1.INSTANCE, (int)30, null));
                collection.add(subpluginOption);
            }
            {
                this.$pluginOptions = arrayList;
                super(1);
            }
        };
        AndroidSourceSet androidSourceSet = mainSourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"mainSourceSet");
        addVariant$.invoke(androidSourceSet);
        List flavorSourceSets = CollectionsKt.filterNotNull((Iterable)AndroidGradleWrapper.getProductFlavorsSourceSets(androidExtension));
        for (AndroidSourceSet sourceSet : flavorSourceSets) {
            addVariant$.invoke(sourceSet);
        }
        return pluginOptions;
    }

    private final String getApplicationPackageFromManifest(File manifestFile) {
        try {
            return this.parseXml(manifestFile).getDocumentElement().getAttribute("package");
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public String getCompilerPluginId() {
        return "org.jetbrains.kotlin.android";
    }

    @NotNull
    public String getGroupName() {
        return "org.jetbrains.kotlin";
    }

    @NotNull
    public String getArtifactName() {
        return "kotlin-android-extensions";
    }

    @NotNull
    public final Document parseXml(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"builder.parse(this)");
        return document;
    }

    static {
        Companion = new Companion(null);
    }

    @NotNull
    public List<AbstractCompile> getSubpluginKotlinTasks(@NotNull Project project, @NotNull KotlinCompile kotlinCompile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
        return KotlinGradleSubplugin.DefaultImpls.getSubpluginKotlinTasks((KotlinGradleSubplugin)this, (Project)project, (AbstractCompile)kotlinCompile);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AndroidSubplugin$Companion;", "", "()V", "migrateWarningReported", "", "getMigrateWarningReported", "()Z", "setMigrateWarningReported", "(Z)V", "kotlin-gradle-plugin"})
    private static final class Companion {
        public final boolean getMigrateWarningReported() {
            return migrateWarningReported;
        }

        public final void setMigrateWarningReported(boolean bl) {
            migrateWarningReported = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

