/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang.SystemUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.core.JavaCoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.ZipFileCache;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServicesKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "", "()V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "cleanJarCache", "", "invoke", "gradleVersion", "", "stopZipFileCache", "kotlin-gradle-plugin"})
public final class CompilerServicesCleanup {
    private final Logger log = Logging.getLogger(this.getClass());

    public final void invoke(@NotNull String gradleVersion) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
            GradleUtilsKt.kotlinDebug(this.log, "compiler services cleanup");
            if (SystemUtils.IS_OS_WINDOWS) {
                this.cleanJarCache();
            }
            JavaCoreApplicationEnvironment javaCoreApplicationEnvironment = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
            Object object = javaCoreApplicationEnvironment != null ? javaCoreApplicationEnvironment.getJarFileSystem() : null;
            if (!(object instanceof CoreJarFileSystem)) {
                object = null;
            }
            CoreJarFileSystem coreJarFileSystem = (CoreJarFileSystem)object;
            if (coreJarFileSystem != null) {
                coreJarFileSystem.clearHandlersCache();
            }
            String string = KotlinGradleBuildServicesKt.access$comparableVersionStr(gradleVersion);
            if (string == null) break block5;
            String string2 = string;
            String it = string2;
            GradleUtilsKt.kotlinDebug(this.log, "detected gradle version " + it);
            String string3 = KotlinGradleBuildServicesKt.access$comparableVersionStr("2.4");
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            if (it.compareTo(string3) < 0) {
                this.stopZipFileCache();
            }
        }
    }

    private final void stopZipFileCache() {
        ZipFileCache.stopBackgroundThread();
        GradleUtilsKt.kotlinDebug(this.log, "ZipFileCache finished successfully");
    }

    private final void cleanJarCache() {
        GradleUtilsKt.kotlinDebug(this.log, "Clean JAR cache");
        ZipHandler.clearFileAccessorCache();
        GradleUtilsKt.kotlinDebug(this.log, "JAR cache cleared");
    }
}

