/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.model.SourceProvider;
import com.android.sdklib.BuildToolInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptionsImpl;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManagerKt;
import org.jetbrains.kotlin.gradle.internal.Kapt3GradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSetProvider;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironment;
import org.jetbrains.kotlin.gradle.plugin.android.AndroidGradleWrapper;
import org.jetbrains.kotlin.gradle.plugin.android.KotlinJillTask;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;
import org.jetbrains.kotlin.incremental.MultiProjectIncrementalCompilationUtilKt;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryProvider;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryProviderAndroidWrapper;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J \u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0014H\u0002JR\u0010\u001f\u001a\u00020\u00182\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u00140\u00122\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0002J\u001a\u0010*\u001a\u0004\u0018\u00010+*\u00020\u00022\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u0006\u0012\u0002\b\u00030\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "kotlinSourceSetProvider", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProvider;", "kotlinPluginVersion", "", "kotlinGradleBuildServices", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "(Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSetProvider;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getTasksProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "sourceProviders", "", "Lcom/android/builder/model/SourceProvider;", "Lcom/android/build/gradle/internal/variant/BaseVariantData;", "getSourceProviders", "(Lcom/android/build/gradle/internal/variant/BaseVariantData;)Ljava/util/List;", "apply", "", "project", "configureSources", "compileTask", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "variantData", "Lcom/android/build/gradle/internal/variant/BaseVariantOutputData;", "processVariantData", "variantDataList", "androidExt", "Lcom/android/build/gradle/BaseExtension;", "androidPlugin", "Lcom/android/build/gradle/BasePlugin;", "aptConfigurations", "", "Lorg/gradle/api/artifacts/Configuration;", "rootKotlinOptions", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmOptionsImpl;", "tryGetSingleArtifact", "Ljava/io/File;", "kotlin-gradle-plugin"})
public class KotlinAndroidPlugin
implements Plugin<Project> {
    private final Logger log;
    @NotNull
    private final KotlinTasksProvider tasksProvider;
    private final KotlinSourceSetProvider kotlinSourceSetProvider;
    private final String kotlinPluginVersion;
    private final KotlinGradleBuildServices kotlinGradleBuildServices;

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void name$iv;
        void $receiver$iv;
        String minimalVersion;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = project.getExtensions().getByName("android");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
        }
        BaseExtension ext = (BaseExtension)object;
        String version2 = KotlinPluginKt.access$loadAndroidPluginVersion();
        if (version2 != null && KotlinPluginKt.access$compareVersionNumbers(version2, minimalVersion = "1.1.0") < 0) {
            throw (Throwable)new IllegalStateException("Kotlin: Unsupported version of com.android.tools.build:gradle plugin: version " + minimalVersion + " or higher should be used with kotlin-android plugin");
        }
        HashMap aptConfigurations = MapsKt.hashMapOf((Pair[])new Pair[0]);
        ext.getSourceSets().all((Action)new Action<AndroidSourceSet>(this, project, aptConfigurations){
            final /* synthetic */ KotlinAndroidPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap $aptConfigurations;

            /*
             * WARNING - void declaration
             */
            public final void execute(AndroidSourceSet sourceSet) {
                void name$iv;
                void $receiver$iv;
                GradleUtilsKt.kotlinDebug(KotlinAndroidPlugin.access$getLog$p(this.this$0), "Creating KotlinSourceSet for source set " + sourceSet);
                KotlinSourceSetProvider kotlinSourceSetProvider = KotlinAndroidPlugin.access$getKotlinSourceSetProvider$p(this.this$0);
                String string = sourceSet.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceSet.name");
                KotlinSourceSet kotlinSourceSet = kotlinSourceSetProvider.create(string);
                kotlinSourceSet.getKotlin().srcDir((Object)this.$project.file((Object)this.$project.file((Object)("src/" + sourceSet.getName() + "/kotlin"))));
                AndroidSourceSet androidSourceSet = sourceSet;
                String string2 = KotlinPluginKt.getKOTLIN_DSL_NAME();
                void v2 = $receiver$iv;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.HasConvention");
                }
                Map map = ((HasConvention)v2).getConvention().getPlugins();
                KotlinSourceSet kotlinSourceSet2 = kotlinSourceSet;
                map.put(name$iv, kotlinSourceSet2);
                String string3 = sourceSet.getName();
                String string4 = sourceSet.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sourceSet.name");
                this.$aptConfigurations.put(string3, KotlinPluginKt.access$createAptConfiguration(this.$project, string4, KotlinAndroidPlugin.access$getKotlinPluginVersion$p(this.this$0)));
            }
            {
                this.this$0 = kotlinAndroidPlugin;
                this.$project = project;
                this.$aptConfigurations = hashMap;
            }
        });
        KotlinJvmOptionsImpl kotlinOptions = new KotlinJvmOptionsImpl();
        kotlinOptions.setNoJdk(true);
        BaseExtension baseExtension = ext;
        String string = KotlinPluginKt.getKOTLIN_OPTIONS_DSL_NAME();
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        }
        ((ExtensionAware)v1).getExtensions().add((String)name$iv, (Object)kotlinOptions);
        KotlinPluginKt.access$createKaptExtension(project);
        project.afterEvaluate((Action)new Action<Project>(this, ext, aptConfigurations, kotlinOptions){
            final /* synthetic */ KotlinAndroidPlugin this$0;
            final /* synthetic */ BaseExtension $ext;
            final /* synthetic */ HashMap $aptConfigurations;
            final /* synthetic */ KotlinJvmOptionsImpl $kotlinOptions;

            public final void execute(Project project) {
                if (project != null) {
                    Plugin plugin;
                    Plugin plugin2 = project.getPlugins().findPlugin("android");
                    if (plugin2 == null) {
                        plugin2 = plugin = project.getPlugins().findPlugin("android-library");
                    }
                    if (plugin2 == null) {
                        Plugin plugin3 = project.getPlugins().findPlugin("com.android.test");
                        plugin = plugin3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)plugin3, (String)"project.plugins.findPlugin(\"com.android.test\")");
                    }
                    if (plugin == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.BasePlugin");
                    }
                    BasePlugin plugin4 = (BasePlugin)plugin;
                    VariantManager variantManager = AndroidGradleWrapper.getVariantDataManager(plugin4);
                    List list = variantManager.getVariantDataList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variantManager.variantDataList");
                    KotlinAndroidPlugin.access$processVariantData(this.this$0, list, project, this.$ext, plugin4, this.$aptConfigurations, this.$kotlinOptions);
                }
            }
            {
                this.this$0 = kotlinAndroidPlugin;
                this.$ext = baseExtension;
                this.$aptConfigurations = hashMap;
                this.$kotlinOptions = kotlinJvmOptionsImpl;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void processVariantData(List<? extends BaseVariantData<? extends BaseVariantOutputData>> variantDataList, Project project, BaseExtension androidExt, BasePlugin androidPlugin, Map<String, ? extends Configuration> aptConfigurations, KotlinJvmOptionsImpl rootKotlinOptions) {
        Logger logger = project.getLogger();
        SubpluginEnvironment subpluginEnvironment = KotlinPluginKt.access$loadSubplugins(project);
        for (BaseVariantData<? extends BaseVariantOutputData> baseVariantData : variantDataList) {
            void destination$iv$iv;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Object kaptManager;
            void aptWorkingDir;
            Iterable aptOutputDir;
            Object aptConfiguration;
            String variantDataName = baseVariantData.getName();
            GradleUtilsKt.kotlinDebug(logger, "Process variant [" + variantDataName + "]");
            AbstractCompile javaTask = AndroidGradleWrapper.getJavaTask(baseVariantData);
            if (javaTask == null) {
                logger.info("KOTLIN: javaTask is missing for " + variantDataName + ", so Kotlin files won't be compiled for it");
                continue;
            }
            String kotlinTaskName = "compile" + StringsKt.capitalize((String)variantDataName) + "Kotlin";
            String string = baseVariantData.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantData.name");
            KotlinCompile kotlinTask = this.tasksProvider.createKotlinJVMTask(project, kotlinTaskName, string);
            kotlinTask.setParentKotlinOptionsImpl$kotlin_gradle_plugin(rootKotlinOptions);
            kotlinTask.setDestinationDir(new File(project.getBuildDir(), "tmp/kotlin-classes/" + variantDataName));
            kotlinTask.setDescription("Compiles the " + variantDataName + " kotlin.");
            kotlinTask.setDependsOn(javaTask.getDependsOn());
            boolean isKapt2Enabled = Kapt3GradleSubplugin.Companion.isEnabled(project);
            ArrayList aptFiles = CollectionsKt.arrayListOf((Object[])new File[0]);
            if (!isKapt2Enabled) {
                Iterator<SourceProvider> iterator = this.getSourceProviders(baseVariantData).iterator();
                while (iterator.hasNext()) {
                    SourceProvider provider;
                    SourceProvider sourceProvider = provider = iterator.next();
                    if (sourceProvider == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.api.AndroidSourceSet");
                    }
                    aptConfiguration = aptConfigurations.get(((AndroidSourceSet)sourceProvider).getName());
                    if (aptConfiguration == null || aptConfiguration.getAllDependencies().size() <= 1) continue;
                    javaTask.dependsOn(new Object[]{aptConfiguration.getBuildDependencies()});
                    aptFiles.addAll(aptConfiguration.resolve());
                }
            }
            List<KotlinGradleSubplugin<KotlinCompile>> appliedPlugins = subpluginEnvironment.addSubpluginOptions(project, kotlinTask, javaTask, baseVariantData, null);
            GradleUtilsKt.mapClasspath(kotlinTask, (Function0<? extends FileCollection>)((Function0)new Function0<FileCollection>(javaTask, project, androidPlugin, androidExt){
                final /* synthetic */ AbstractCompile $javaTask;
                final /* synthetic */ Project $project;
                final /* synthetic */ BasePlugin $androidPlugin;
                final /* synthetic */ BaseExtension $androidExt;

                public final FileCollection invoke() {
                    FileCollection fileCollection = this.$javaTask.getClasspath().plus((FileCollection)this.$project.files(new Object[]{AndroidGradleWrapper.getRuntimeJars(this.$androidPlugin, this.$androidExt)}));
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"javaTask.classpath + pro\u2026droidPlugin, androidExt))");
                    return fileCollection;
                }
                {
                    this.$javaTask = abstractCompile;
                    this.$project = project;
                    this.$androidPlugin = basePlugin;
                    this.$androidExt = baseExtension;
                    super(0);
                }
            }));
            KotlinCompile kotlinAfterJavaTask = null;
            if (javaTask instanceof JavaCompile) {
                aptConfiguration = aptFiles;
                if (!aptConfiguration.isEmpty() && !isKapt2Enabled) {
                    String string2 = variantDataName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variantDataName");
                    Pair pair = KotlinPluginKt.access$getAptDirsForSourceSet(project, string2);
                    aptConfiguration = (File)pair.component1();
                    File file = (File)pair.component2();
                    pair = null;
                    baseVariantData.addJavaSourceFoldersToModel(new File[]{aptOutputDir});
                    AbstractCompile abstractCompile = kotlinTask;
                    JavaCompile javaCompile = (JavaCompile)javaTask;
                    String string3 = variantDataName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"variantDataName");
                    kaptManager = new AnnotationProcessingManager(abstractCompile, javaCompile, string3, CollectionsKt.toSet((Iterable)aptFiles), (File)((Object)aptOutputDir), (File)aptWorkingDir, baseVariantData);
                    String string4 = variantDataName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"variantDataName");
                    kotlinAfterJavaTask = AnnotationProcessingManagerKt.initKapt(project, kotlinTask, javaTask, (AnnotationProcessingManager)kaptManager, string4, rootKotlinOptions, subpluginEnvironment, this.tasksProvider);
                }
            }
            this.configureSources(kotlinTask, baseVariantData);
            if (kotlinAfterJavaTask != null) {
                this.configureSources(kotlinAfterJavaTask, baseVariantData);
            }
            aptOutputDir = appliedPlugins;
            aptWorkingDir = $receiver$iv;
            kaptManager = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                KotlinGradleSubplugin it = (KotlinGradleSubplugin)element$iv$iv;
                Iterable list$iv$iv = it.getSubpluginKotlinTasks(project, (AbstractCompile)kotlinTask);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv.iterator();
            while ($receiver$iv$iv.hasNext()) {
                Object element$iv = $receiver$iv$iv.next();
                AbstractCompile it = (AbstractCompile)element$iv;
                this.configureSources(it, baseVariantData);
            }
            Logger logger2 = logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
            KotlinPluginKt.access$configureJavaTask(kotlinTask, javaTask, logger2);
            String string5 = variantDataName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"variantDataName");
            KotlinPluginKt.access$createSyncOutputTask(project, kotlinTask, javaTask, kotlinAfterJavaTask, string5);
            KotlinCompile kotlinCompile = kotlinAfterJavaTask;
            if (kotlinCompile == null) {
                kotlinCompile = kotlinTask;
            }
            if (kotlinCompile.getIncremental()) {
                Map<File, File> jarToAarMapping = AndroidGradleWrapper.getJarToAarMapping(baseVariantData);
                File artifactFile = this.tryGetSingleArtifact(project, baseVariantData);
                ArtifactDifferenceRegistryProvider artifactDifferenceRegistryProvider = this.kotlinGradleBuildServices.getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin();
                Map<File, File> map = jarToAarMapping;
                Intrinsics.checkExpressionValueIsNotNull(map, (String)"jarToAarMapping");
                ArtifactDifferenceRegistryProviderAndroidWrapper artifactDifferenceRegistryProvider2 = new ArtifactDifferenceRegistryProviderAndroidWrapper(artifactDifferenceRegistryProvider, map);
                MultiProjectIncrementalCompilationUtilKt.configureMultiProjectIncrementalCompilation(project, kotlinTask, javaTask, kotlinAfterJavaTask, artifactDifferenceRegistryProvider2, artifactFile);
            }
            if (!AndroidGradleWrapper.isJackEnabled(baseVariantData)) continue;
            VariantScope scope = baseVariantData.getScope();
            File kotlinDestinationDir = kotlinTask.getDestinationDir();
            File jarPath = new File(kotlinDestinationDir.getParent(), kotlinDestinationDir.getName() + ".jar");
            String zipTaskName = scope.getTaskName("zipKotlinClassesFor");
            project.getTasks().create(zipTaskName, Zip.class, (Action)new Action<Zip>(kotlinDestinationDir, jarPath, kotlinTask){
                final /* synthetic */ File $kotlinDestinationDir;
                final /* synthetic */ File $jarPath;
                final /* synthetic */ KotlinCompile $kotlinTask;

                public final void execute(Zip zipTask) {
                    zipTask.from(new Object[]{this.$kotlinDestinationDir});
                    zipTask.setDestinationDir(new File(this.$jarPath.getParent()));
                    zipTask.setArchiveName(this.$jarPath.getName());
                    zipTask.dependsOn(new Object[]{this.$kotlinTask});
                }
                {
                    this.$kotlinDestinationDir = file;
                    this.$jarPath = file2;
                    this.$kotlinTask = kotlinCompile;
                }
            });
            String kotlinJillTaskName = scope.getTaskName("transformKotlinClassesWithJillFor");
            File jillOutputFilePath = new File(jarPath.getAbsolutePath() + ".jill");
            project.getTasks().create(kotlinJillTaskName, KotlinJillTask.class, (Action)new Action<KotlinJillTask>(baseVariantData, jarPath, jillOutputFilePath, zipTaskName){
                final /* synthetic */ BaseVariantData $variantData;
                final /* synthetic */ File $jarPath;
                final /* synthetic */ File $jillOutputFilePath;
                final /* synthetic */ String $zipTaskName;

                public final void execute(KotlinJillTask jillTask) {
                    BuildToolInfo buildToolInfo = this.$variantData.getScope().getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools();
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildToolInfo, (String)"variantData.scope.global\u2026der.targetInfo.buildTools");
                    jillTask.setBuildTools(buildToolInfo);
                    jillTask.setInputJarFile(this.$jarPath);
                    jillTask.setOutputJillFile(this.$jillOutputFilePath);
                    jillTask.dependsOn(new Object[]{this.$zipTaskName});
                }
                {
                    this.$variantData = baseVariantData;
                    this.$jarPath = file;
                    this.$jillOutputFilePath = file2;
                    this.$zipTaskName = string;
                }
            });
            AndroidGradleWrapper.configureJackTask(baseVariantData, jillOutputFilePath, kotlinJillTaskName);
        }
    }

    private final void configureSources(AbstractCompile compileTask, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        Logger logger = compileTask.getProject().getLogger();
        for (SourceProvider provider : this.getSourceProviders(variantData)) {
            KotlinSourceSet kotlinSourceSet;
            Object object = GradleUtilsKt.getConvention(provider, KotlinPluginKt.getKOTLIN_DSL_NAME());
            if (!(object instanceof KotlinSourceSet)) {
                object = null;
            }
            if ((KotlinSourceSet)object == null) {
                continue;
            }
            compileTask.source(new Object[]{kotlinSourceSet.getKotlin()});
        }
        for (File javaSrcDir : AndroidGradleWrapper.getJavaSources(variantData)) {
            compileTask.source(new Object[]{javaSrcDir});
            GradleUtilsKt.kotlinDebug(logger, "Source directory " + javaSrcDir + " was added to kotlin source for " + compileTask.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File tryGetSingleArtifact(@NotNull Project $receiver, BaseVariantData<?> variantData) {
        List outputs;
        String string;
        void var20_5;
        void $receiver$iv;
        Logger log;
        Logger logger = log = $receiver.getLogger();
        if ($receiver$iv.isDebugEnabled()) {
            var20_5 = $receiver$iv;
            string = "Trying to determine single artifact for project " + $receiver.getPath();
            GradleUtilsKt.kotlinDebug((Logger)var20_5, string);
        }
        if ((outputs = variantData.getOutputs()).size() != 1) {
            void $receiver$iv2;
            Logger $i$a$1$kotlinDebug = log;
            if ($receiver$iv2.isDebugEnabled()) {
                List list;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv3;
                var20_5 = $receiver$iv2;
                Iterable $i$f$kotlinDebug = outputs;
                StringBuilder stringBuilder = new StringBuilder().append("Output count != 1 for variant: ");
                void var8_10 = $receiver$iv3;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    BaseVariantOutputData baseVariantOutputData = (BaseVariantOutputData)item$iv$iv;
                    list = destination$iv$iv;
                    File file = it.getOutputFile();
                    File file2 = $receiver.getRootDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootDir");
                    String string2 = FilesKt.relativeTo((File)file, (File)file2).getPath();
                    list.add(string2);
                }
                list = (List)destination$iv$iv;
                string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).toString();
                GradleUtilsKt.kotlinDebug((Logger)var20_5, string);
            }
            return null;
        }
        return ((BaseVariantOutputData)CollectionsKt.first((List)variantData.getOutputs())).getOutputFile();
    }

    private final List<SourceProvider> getSourceProviders(@NotNull BaseVariantData<?> $receiver) {
        List list = $receiver.getVariantConfiguration().getSortedSourceProviders();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"variantConfiguration.sortedSourceProviders");
        return list;
    }

    @NotNull
    public final KotlinTasksProvider getTasksProvider() {
        return this.tasksProvider;
    }

    public KotlinAndroidPlugin(@NotNull KotlinTasksProvider tasksProvider, @NotNull KotlinSourceSetProvider kotlinSourceSetProvider, @NotNull String kotlinPluginVersion, @NotNull KotlinGradleBuildServices kotlinGradleBuildServices) {
        Intrinsics.checkParameterIsNotNull((Object)tasksProvider, (String)"tasksProvider");
        Intrinsics.checkParameterIsNotNull((Object)kotlinSourceSetProvider, (String)"kotlinSourceSetProvider");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinGradleBuildServices), (String)"kotlinGradleBuildServices");
        this.tasksProvider = tasksProvider;
        this.kotlinSourceSetProvider = kotlinSourceSetProvider;
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.kotlinGradleBuildServices = kotlinGradleBuildServices;
        this.log = Logging.getLogger(this.getClass());
    }

    public static final /* synthetic */ Logger access$getLog$p(KotlinAndroidPlugin $this) {
        return $this.log;
    }

    @NotNull
    public static final /* synthetic */ KotlinSourceSetProvider access$getKotlinSourceSetProvider$p(KotlinAndroidPlugin $this) {
        return $this.kotlinSourceSetProvider;
    }

    @NotNull
    public static final /* synthetic */ String access$getKotlinPluginVersion$p(KotlinAndroidPlugin $this) {
        return $this.kotlinPluginVersion;
    }

    public static final /* synthetic */ void access$processVariantData(KotlinAndroidPlugin $this, @NotNull List variantDataList, @NotNull Project project, @NotNull BaseExtension androidExt, @NotNull BasePlugin androidPlugin, @NotNull Map aptConfigurations, @NotNull KotlinJvmOptionsImpl rootKotlinOptions) {
        $this.processVariantData(variantDataList, project, androidExt, androidPlugin, aptConfigurations, rootKotlinOptions);
    }
}

