/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\n\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"K2JS_COMPILER_CLASS", "", "K2JVM_COMPILER_CLASS", "KOTLIN_COMPILER_EMBEDDABLE", "KOTLIN_GRADLE_PLUGIN", "KOTLIN_MODULE_GROUP", "findCompilerEmbeddable", "Lorg/gradle/api/artifacts/ResolvedDependency;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "findJarByClass", "Ljava/io/File;", "klass", "Ljava/lang/Class;", "findKotlinCompilerJar", "project", "Lorg/gradle/api/Project;", "compilerClassName", "findKotlinJsCompilerJar", "findKotlinJvmCompilerJar", "findPotentialCompilerJars", "", "findToolsJar", "hasEntry", "", "entryToFind", "kotlin-gradle-plugin"})
public final class JarSearchingUtilKt {
    private static final String K2JVM_COMPILER_CLASS = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER_CLASS = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String KOTLIN_MODULE_GROUP = "org.jetbrains.kotlin";
    private static final String KOTLIN_GRADLE_PLUGIN = "kotlin-gradle-plugin";
    private static final String KOTLIN_COMPILER_EMBEDDABLE = "kotlin-compiler-embeddable";

    @Nullable
    public static final File findKotlinJvmCompilerJar(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinCompilerJar(project, K2JVM_COMPILER_CLASS);
    }

    @Nullable
    public static final File findKotlinJsCompilerJar(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinCompilerJar(project, K2JS_COMPILER_CLASS);
    }

    @Nullable
    public static final File findToolsJar() {
        File file;
        Class<?> clazz = Class.forName("com.sun.tools.javac.util.Context");
        if (clazz != null) {
            Class<?> clazz2 = clazz;
            Class<?> p1 = clazz2;
            file = JarSearchingUtilKt.findJarByClass(p1);
        } else {
            file = null;
        }
        return file;
    }

    private static final File findJarByClass(Class<?> klass) {
        String classFileName = StringsKt.substringAfterLast$default((String)klass.getName(), (String)".", null, (int)2, null) + ".class";
        URL uRL = klass.getResource(classFileName);
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String uri = resource.toString();
        if (!StringsKt.startsWith$default((String)uri, (String)"jar:file:", (boolean)false, (int)2, null)) {
            return null;
        }
        String fileName = URLDecoder.decode(StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)uri, (CharSequence)"jar:file:"), (String)"!", null, (int)2, null), Charset.defaultCharset().name());
        return new File(fileName);
    }

    /*
     * WARNING - void declaration
     */
    private static final File findKotlinCompilerJar(Project project, String compilerClassName) {
        Object v0;
        block1: {
            void $receiver$iv;
            Iterable<File> filesToCheck = JarSearchingUtilKt.findPotentialCompilerJars(project);
            String entryToFind = StringsKt.replace$default((String)compilerClassName, (String)".", (String)"/", (boolean)false, (int)4, null) + ".class";
            Iterable<File> iterable = filesToCheck;
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                if (!JarSearchingUtilKt.hasEntry(it, entryToFind)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable<File> findPotentialCompilerJars(Project project) {
        Sequence projects2 = SequencesKt.generateSequence((Object)project, (Function1)findPotentialCompilerJars.projects.1.INSTANCE);
        Sequence classpathConfigurations2 = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)projects2, (Function1)findPotentialCompilerJars.classpathConfigurations.1.INSTANCE));
        HashSet allFiles = new HashSet();
        for (Configuration configuration : classpathConfigurations2) {
            ResolvedDependency compilerEmbeddable = JarSearchingUtilKt.findCompilerEmbeddable(configuration);
            if (compilerEmbeddable != null) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = compilerEmbeddable.getModuleArtifacts();
                void var8_8 = $receiver$iv;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv$iv;
                    void var16_13 = destination$iv$iv;
                    File file = it.getFile();
                    var16_13.add(file);
                }
                return (List)destination$iv$iv;
            }
            allFiles.addAll(configuration.getFiles());
        }
        return allFiles;
    }

    private static final ResolvedDependency findCompilerEmbeddable(Configuration configuration) {
        findCompilerEmbeddable.1 findDependency$ = findCompilerEmbeddable.1.INSTANCE;
        Set firstLevelModuleDependencies = configuration.getResolvedConfiguration().getFirstLevelModuleDependencies();
        ResolvedDependency gradlePlugin = findDependency$.invoke(firstLevelModuleDependencies, KOTLIN_MODULE_GROUP, KOTLIN_GRADLE_PLUGIN);
        Object object = gradlePlugin;
        return object != null && (object = object.getChildren()) != null ? findDependency$.invoke((Iterable)object, KOTLIN_MODULE_GROUP, KOTLIN_COMPILER_EMBEDDABLE) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean hasEntry(@NotNull File $receiver, String entryToFind) {
        ZipFile zip = new ZipFile($receiver);
        try {
            void e;
            boolean bl = zip.getEntry(entryToFind) != null;
            return (boolean)e;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            zip.close();
        }
    }

    static {
        K2JVM_COMPILER_CLASS = K2JVM_COMPILER_CLASS;
        K2JS_COMPILER_CLASS = K2JS_COMPILER_CLASS;
        KOTLIN_MODULE_GROUP = KOTLIN_MODULE_GROUP;
        KOTLIN_GRADLE_PLUGIN = KOTLIN_GRADLE_PLUGIN;
        KOTLIN_COMPILER_EMBEDDABLE = KOTLIN_COMPILER_EMBEDDABLE;
    }
}

