/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.CompilerServicesCleanup;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.incremental.BuildCacheStorage;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryProvider;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\u000f\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/BuildAdapter;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "(Lorg/gradle/api/invocation/Gradle;)V", "artifactDifferenceRegistryProvider", "Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "buildCacheStorage", "Lorg/jetbrains/kotlin/incremental/BuildCacheStorage;", "cleanup", "Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "startMemory", "", "Ljava/lang/Long;", "workingDir", "Ljava/io/File;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "getUsedMemoryKb", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinGradleBuildServices
extends BuildAdapter {
    private final Logger log = Logging.getLogger(((Object)((Object)this)).getClass());
    private final CompilerServicesCleanup cleanup = new CompilerServicesCleanup();
    private Long startMemory;
    private final File workingDir;
    private final BuildCacheStorage buildCacheStorage;
    private static final String CLASS_NAME;
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    @NotNull
    private static final String INIT_MESSAGE;
    @NotNull
    private static final String DISPOSE_MESSAGE;
    @NotNull
    private static final String ALREADY_INITIALIZED_MESSAGE;
    private static volatile KotlinGradleBuildServices instance;
    public static final Companion Companion;

    @NotNull
    public final ArtifactDifferenceRegistryProvider getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin() {
        return this.buildCacheStorage;
    }

    public final void buildStarted() {
        if (this.log.isDebugEnabled()) {
            Long l = this.getUsedMemoryKb();
            if (l == null) {
                Intrinsics.throwNpe();
            }
            this.startMemory = l;
        }
    }

    public void buildFinished(@NotNull BuildResult result) {
        boolean kotlinCompilerCalled;
        Object object;
        Object object2;
        Gradle gradle;
        block9: {
            boolean bl;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            Gradle gradle2 = result.getGradle();
            if (gradle2 == null) {
                Intrinsics.throwNpe();
            }
            gradle = gradle2;
            object2 = gradle.getRootProject().getAllprojects();
            void var5_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            object = $receiver$iv$iv.iterator();
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                Project it = (Project)element$iv$iv;
                Iterable list$iv$iv = (Iterable)it.getTasks();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Task it = (Task)element$iv;
                if (!(it instanceof AbstractKotlinCompile && ((AbstractKotlinCompile)it).getCompilerCalled$kotlin_gradle_plugin())) continue;
                bl = true;
                break block9;
            }
            bl = kotlinCompilerCalled = false;
        }
        if (kotlinCompilerCalled) {
            GradleUtilsKt.kotlinDebug(this.log, "Cleanup after kotlin");
            String string = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradle.gradleVersion");
            this.cleanup.invoke(string);
        } else {
            GradleUtilsKt.kotlinDebug(this.log, "Skipping kotlin cleanup since compiler wasn't called");
        }
        if (kotlinCompilerCalled) {
            Long l = this.startMemory;
            if (l != null) {
                Unit unit;
                object2 = l;
                long startMemoryCopy = ((Number)object2).longValue();
                Long l2 = this.getUsedMemoryKb();
                if (l2 != null) {
                    object = l2;
                    long endMemory = ((Number)object).longValue();
                    String string = "%+d";
                    Object[] objectArray = new Object[]{endMemory - startMemoryCopy};
                    StringBuilder stringBuilder = new StringBuilder().append("[PERF] Used memory after build: ").append(endMemory).append(" kb (difference since build start: ");
                    Logger logger = this.log;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                    String string3 = string2;
                    GradleUtilsKt.kotlinDebug(logger, stringBuilder.append(string3).append(" kb)").toString());
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
        }
        this.buildCacheStorage.flush(false);
        this.buildCacheStorage.close();
        gradle.removeListener((Object)this);
        KotlinGradleBuildServices.Companion.setInstance(null);
        GradleUtilsKt.kotlinDebug(this.log, Companion.getDISPOSE_MESSAGE());
    }

    private final Long getUsedMemoryKb() {
        if (!this.log.isDebugEnabled()) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        System.gc();
        System.runFinalization();
        System.gc();
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    private KotlinGradleBuildServices(Gradle gradle) {
        File file;
        File file2 = new File(gradle.getRootProject().getBuildDir(), "kotlin-build");
        KotlinGradleBuildServices kotlinGradleBuildServices = this;
        File $receiver = file2;
        $receiver.mkdirs();
        kotlinGradleBuildServices.workingDir = file = file2;
        this.buildCacheStorage = new BuildCacheStorage(this.workingDir);
    }

    static {
        Companion = new Companion(null);
        CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
        INIT_MESSAGE = "Initialized " + KotlinGradleBuildServices.Companion.getCLASS_NAME();
        DISPOSE_MESSAGE = "Disposed " + KotlinGradleBuildServices.Companion.getCLASS_NAME();
        ALREADY_INITIALIZED_MESSAGE = KotlinGradleBuildServices.Companion.getCLASS_NAME() + " is already initialized";
    }

    public /* synthetic */ KotlinGradleBuildServices(@NotNull Gradle gradle, DefaultConstructorMarker $constructor_marker) {
        this(gradle);
    }

    @JvmStatic
    @NotNull
    public static final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        return Companion.getInstance(gradle);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R \u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "ALREADY_INITIALIZED_MESSAGE", "", "getALREADY_INITIALIZED_MESSAGE", "()Ljava/lang/String;", "CLASS_NAME", "kotlin.jvm.PlatformType", "getCLASS_NAME", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "FORCE_SYSTEM_GC_MESSAGE", "INIT_MESSAGE", "getINIT_MESSAGE", "instance", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "getInstance", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "setInstance", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;)V", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String getCLASS_NAME() {
            return CLASS_NAME;
        }

        @NotNull
        public final String getINIT_MESSAGE() {
            return INIT_MESSAGE;
        }

        @NotNull
        public final String getDISPOSE_MESSAGE() {
            return DISPOSE_MESSAGE;
        }

        @NotNull
        public final String getALREADY_INITIALIZED_MESSAGE() {
            return ALREADY_INITIALIZED_MESSAGE;
        }

        private final KotlinGradleBuildServices getInstance() {
            return instance;
        }

        private final void setInstance(KotlinGradleBuildServices kotlinGradleBuildServices) {
            instance = kotlinGradleBuildServices;
        }

        @JvmStatic
        @NotNull
        public final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            Logger log = Logging.getLogger(KotlinGradleBuildServices.class);
            if (this.getInstance() != null) {
                GradleUtilsKt.kotlinDebug(log, this.getALREADY_INITIALIZED_MESSAGE());
                KotlinGradleBuildServices kotlinGradleBuildServices = this.getInstance();
                if (kotlinGradleBuildServices == null) {
                    Intrinsics.throwNpe();
                }
                return kotlinGradleBuildServices;
            }
            KotlinGradleBuildServices services = new KotlinGradleBuildServices(gradle, null);
            gradle.addBuildListener((BuildListener)services);
            this.setInstance(services);
            GradleUtilsKt.kotlinDebug(log, this.getINIT_MESSAGE());
            services.buildStarted();
            return services;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ KotlinGradleBuildServices access$getInstance$p(Companion $this) {
            return $this.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

