/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.android;

import com.android.builder.core.BuildToolsServiceLoader;
import com.android.jill.api.JillConfig;
import com.android.jill.api.JillProvider;
import com.android.jill.api.v01.Api01Config;
import com.android.sdklib.BuildToolInfo;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/android/KotlinJillTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildTools", "Lcom/android/sdklib/BuildToolInfo;", "getBuildTools", "()Lcom/android/sdklib/BuildToolInfo;", "setBuildTools", "(Lcom/android/sdklib/BuildToolInfo;)V", "inputJarFile", "Ljava/io/File;", "getInputJarFile", "()Ljava/io/File;", "setInputJarFile", "(Ljava/io/File;)V", "outputJillFile", "getOutputJillFile", "setOutputJillFile", "transform", "", "kotlin-gradle-plugin"})
public class KotlinJillTask
extends DefaultTask {
    @InputFile
    @NotNull
    public File inputJarFile;
    @OutputFile
    @NotNull
    public File outputJillFile;
    @NotNull
    public BuildToolInfo buildTools;

    @NotNull
    public final File getInputJarFile() {
        File file = this.inputJarFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputJarFile");
        }
        return file;
    }

    public final void setInputJarFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.inputJarFile = file;
    }

    @NotNull
    public final File getOutputJillFile() {
        File file = this.outputJillFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputJillFile");
        }
        return file;
    }

    public final void setOutputJillFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputJillFile = file;
    }

    @NotNull
    public final BuildToolInfo getBuildTools() {
        BuildToolInfo buildToolInfo = this.buildTools;
        if (buildToolInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildTools");
        }
        return buildToolInfo;
    }

    public final void setBuildTools(@NotNull BuildToolInfo buildToolInfo) {
        Intrinsics.checkParameterIsNotNull((Object)buildToolInfo, (String)"<set-?>");
        this.buildTools = buildToolInfo;
    }

    @TaskAction
    public final void transform() {
        BuildToolInfo buildToolInfo = this.buildTools;
        if (buildToolInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildTools");
        }
        JillProvider jillProvider = (JillProvider)CollectionsKt.firstOrNull((Iterable)BuildToolsServiceLoader.INSTANCE.forVersion(buildToolInfo).getServiceLoader(BuildToolsServiceLoader.JILL));
        if (jillProvider == null) {
            String string = "Jill provider not found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        JillProvider jillProvider2 = jillProvider;
        File file = this.outputJillFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputJillFile");
        }
        file.getParentFile().mkdirs();
        JillConfig jillConfig = jillProvider2.createConfig(Api01Config.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jillConfig, (String)"jillProvider.createConfig(Api01Config::class.java)");
        Api01Config config01 = (Api01Config)jillConfig;
        File file2 = this.inputJarFile;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputJarFile");
        }
        config01.setInputJavaBinaryFile(file2);
        File file3 = this.outputJillFile;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputJillFile");
        }
        config01.setOutputJackFile(file3);
        config01.getTask().run();
    }
}

