/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.report.CompileIterationResult;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilationResults;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "Ljava/rmi/server/UnicastRemoteObject;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "projectRootFile", "Ljava/io/File;", "add", "", "compilationResultCategory", "", "value", "Ljava/io/Serializable;", "kotlin-gradle-plugin_main"})
public final class GradleCompilationResults
extends UnicastRemoteObject
implements CompilationResults {
    private final Logger log;
    private final File projectRootFile;

    public void add(int compilationResultCategory, @NotNull Serializable value) throws RemoteException {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (compilationResultCategory == CompilationResultCategory.IC_COMPILE_ITERATION.getCode()) {
            CompileIterationResult compileIterationResult;
            Serializable serializable = value;
            if (!(serializable instanceof CompileIterationResult)) {
                serializable = null;
            }
            if ((compileIterationResult = (CompileIterationResult)serializable) != null) {
                String string;
                Logger logger;
                Logger $receiver$iv;
                Iterable sourceFiles = compileIterationResult.getSourceFiles();
                if (CollectionsKt.any((Iterable)sourceFiles) && ($receiver$iv = this.log).isDebugEnabled()) {
                    logger = $receiver$iv;
                    StringBuilder stringBuilder = new StringBuilder().append("compile iteration: ");
                    File file = this.projectRootFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"projectRootFile");
                    string = stringBuilder.append(FileUtilsKt.pathsAsStringRelativeTo(sourceFiles, file)).toString();
                    GradleUtilsKt.kotlinDebug(logger, string);
                }
                String exitCode = compileIterationResult.getExitCode();
                Logger $receiver$iv2 = this.log;
                if ($receiver$iv2.isDebugEnabled()) {
                    logger = $receiver$iv2;
                    string = "compiler exit code: " + exitCode;
                    GradleUtilsKt.kotlinDebug(logger, string);
                }
            }
        }
    }

    public GradleCompilationResults(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(NetworkUtilsKt.getSOCKET_ANY_FREE_PORT(), (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.log = project.getLogger();
        this.projectRootFile = project.getRootProject().getProjectDir();
    }
}

