/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.SyncOutputTaskKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u00101\u001a\u000202H\u0007J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u00020-H\u0002J\u0010\u00107\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0018\u00108\u001a\u00020\u0005*\u00020\u00052\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R+\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR+\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00058G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR+\u0010\u0014\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00058G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR'\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#R\u001b\u0010&\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010%\u001a\u0004\b'\u0010\u000bR\u001b\u0010)\u001a\u00020\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010%\u001a\u0004\b*\u0010\u000b\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/SyncOutputTask;", "Lorg/gradle/api/DefaultTask;", "()V", "classesDirs", "", "Ljava/io/File;", "getClassesDirs", "()Ljava/util/List;", "<set-?>", "javaOutputDir", "getJavaOutputDir", "()Ljava/io/File;", "setJavaOutputDir", "(Ljava/io/File;)V", "javaOutputDir$delegate", "Lkotlin/properties/ReadWriteProperty;", "kaptClassesDir", "getKaptClassesDir", "setKaptClassesDir", "kaptClassesDir$delegate", "kotlinOutputDir", "getKotlinOutputDir", "setKotlinOutputDir", "kotlinOutputDir$delegate", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "kotlinTask", "getKotlinTask", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "setKotlinTask", "(Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;)V", "kotlinTask$delegate", "timestamps", "", "", "getTimestamps", "()Ljava/util/Map;", "timestamps$delegate", "Lkotlin/Lazy;", "timestampsFile", "getTimestampsFile", "timestampsFile$delegate", "workingDir", "getWorkingDir", "workingDir$delegate", "copy", "", "fileInKotlinDir", "fileInJavaDir", "execute", "inputs", "Lorg/gradle/api/tasks/incremental/IncrementalTaskInputs;", "processIncrementally", "input", "Lorg/gradle/api/tasks/incremental/InputFileDetails;", "processNonIncrementally", "remove", "siblingInJavaDir", "baseDir", "kotlin-gradle-plugin_main"})
public class SyncOutputTask
extends DefaultTask {
    @NotNull
    private final ReadWriteProperty kotlinOutputDir$delegate = Delegates.INSTANCE.notNull();
    @NotNull
    private final ReadWriteProperty kaptClassesDir$delegate = Delegates.INSTANCE.notNull();
    @NotNull
    private final ReadWriteProperty javaOutputDir$delegate = Delegates.INSTANCE.notNull();
    @NotNull
    private final ReadWriteProperty kotlinTask$delegate = Delegates.INSTANCE.notNull();
    @NotNull
    private final Lazy workingDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ SyncOutputTask this$0;

        @NotNull
        public final File invoke() {
            return new File(this.this$0.getKotlinTask().getTaskBuildDirectory$kotlin_gradle_plugin_main(), "sync");
        }
        {
            this.this$0 = syncOutputTask;
            super(0);
        }
    }));
    private final Lazy timestampsFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ SyncOutputTask this$0;

        @NotNull
        public final File invoke() {
            return new File(this.this$0.getWorkingDir(), SyncOutputTaskKt.access$getTIMESTAMP_FILE_NAME$p());
        }
        {
            this.this$0 = syncOutputTask;
            super(0);
        }
    }));
    private final Lazy timestamps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<File, Long>>(this){
        final /* synthetic */ SyncOutputTask this$0;

        @NotNull
        public final Map<File, Long> invoke() {
            return SyncOutputTaskKt.access$readTimestamps(SyncOutputTask.access$getTimestampsFile$p(this.this$0), this.this$0.getJavaOutputDir());
        }
        {
            this.this$0 = syncOutputTask;
            super(0);
        }
    }));
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    @InputFiles
    @NotNull
    public final File getKotlinOutputDir() {
        return (File)this.kotlinOutputDir$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setKotlinOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.kotlinOutputDir$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)file);
    }

    @InputFiles
    @NotNull
    public final File getKaptClassesDir() {
        return (File)this.kaptClassesDir$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setKaptClassesDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.kaptClassesDir$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)file);
    }

    /*
     * WARNING - void declaration
     */
    @Input
    private final List<File> getClassesDirs() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.listOf((Object[])new File[]{this.getKotlinOutputDir(), this.getKaptClassesDir()});
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            File p1 = (File)element$iv$iv;
            if (!p1.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public final File getJavaOutputDir() {
        return (File)this.javaOutputDir$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setJavaOutputDir(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.javaOutputDir$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)file);
    }

    @NotNull
    public final KotlinCompile getKotlinTask() {
        return (KotlinCompile)this.kotlinTask$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setKotlinTask(@NotNull KotlinCompile kotlinCompile) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"<set-?>");
        this.kotlinTask$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)kotlinCompile);
    }

    @OutputDirectory
    @NotNull
    public final File getWorkingDir() {
        Lazy lazy = this.workingDir$delegate;
        SyncOutputTask syncOutputTask = this;
        KProperty kProperty = $$delegatedProperties[4];
        return (File)lazy.getValue();
    }

    private final File getTimestampsFile() {
        Lazy lazy = this.timestampsFile$delegate;
        SyncOutputTask syncOutputTask = this;
        KProperty kProperty = $$delegatedProperties[5];
        return (File)lazy.getValue();
    }

    private final Map<File, Long> getTimestamps() {
        Lazy lazy = this.timestamps$delegate;
        SyncOutputTask syncOutputTask = this;
        KProperty kProperty = $$delegatedProperties[6];
        return (Map)lazy.getValue();
    }

    @TaskAction
    public final void execute(@NotNull IncrementalTaskInputs inputs) {
        Intrinsics.checkParameterIsNotNull((Object)inputs, (String)"inputs");
        String sourceDirs = CollectionsKt.joinToString$default((Iterable)this.getClassesDirs(), null, null, null, (int)0, null, null, (int)63, null);
        if (inputs.isIncremental()) {
            Logger $receiver$iv = this.getLogger();
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Incremental copying files from " + sourceDirs + " to " + this.getJavaOutputDir();
                GradleUtilsKt.kotlinDebug(logger, string);
            }
            inputs.outOfDate((Action)new Action<InputFileDetails>(this){
                final /* synthetic */ SyncOutputTask this$0;

                public final void execute(InputFileDetails it) {
                    InputFileDetails inputFileDetails = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputFileDetails, (String)"it");
                    SyncOutputTask.access$processIncrementally(this.this$0, inputFileDetails);
                }
                {
                    this.this$0 = syncOutputTask;
                }
            });
            inputs.removed((Action)new Action<InputFileDetails>(this){
                final /* synthetic */ SyncOutputTask this$0;

                public final void execute(InputFileDetails it) {
                    InputFileDetails inputFileDetails = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputFileDetails, (String)"it");
                    SyncOutputTask.access$processIncrementally(this.this$0, inputFileDetails);
                }
                {
                    this.this$0 = syncOutputTask;
                }
            });
        } else {
            Logger $receiver$iv = this.getLogger();
            if ($receiver$iv.isDebugEnabled()) {
                Logger logger = $receiver$iv;
                String string = "Non-incremental copying files from " + sourceDirs + " to " + this.getJavaOutputDir();
                GradleUtilsKt.kotlinDebug(logger, string);
            }
            this.processNonIncrementally();
        }
        SyncOutputTaskKt.access$saveTimestamps(this.getTimestampsFile(), this.getTimestamps(), this.getJavaOutputDir());
    }

    private final void processNonIncrementally() {
        Map<File, Long> map = this.getTimestamps();
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<File, Long> entry;
            Map.Entry<File, Long> entry2 = entry = iterator.next();
            File file = entry2.getKey();
            entry2 = entry;
            long timestamp = ((Number)entry2.getValue()).longValue();
            if (file.lastModified() != timestamp) continue;
            file.delete();
        }
        this.getTimestampsFile().delete();
        this.getTimestamps().clear();
        for (File dir : this.getClassesDirs()) {
            Sequence $receiver$iv = (Sequence)FilesKt.walkTopDown((File)dir);
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                this.copy(it, this.siblingInJavaDir(it, dir));
            }
        }
    }

    private final void processIncrementally(InputFileDetails input) {
        File fileInKotlinDir = input.getFile();
        File fileInJavaDir = SyncOutputTask.siblingInJavaDir$default(this, fileInKotlinDir, null, 1, null);
        if (input.isRemoved()) {
            this.remove(fileInJavaDir);
        } else {
            File file = fileInKotlinDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"fileInKotlinDir");
            this.copy(file, fileInJavaDir);
        }
    }

    private final void remove(File fileInJavaDir) {
        if (!fileInJavaDir.isFile()) {
            return;
        }
        fileInJavaDir.delete();
        this.getTimestamps().remove(fileInJavaDir);
        Logger $receiver$iv = this.getLogger();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Removed kotlin class " + FilesKt.relativeTo((File)fileInJavaDir, (File)this.getJavaOutputDir()).getPath() + " from " + this.getJavaOutputDir();
            GradleUtilsKt.kotlinDebug(logger, string);
        }
    }

    private final void copy(File fileInKotlinDir, File fileInJavaDir) {
        if (!fileInKotlinDir.isFile()) {
            return;
        }
        fileInJavaDir.getParentFile().mkdirs();
        FilesKt.copyTo$default((File)fileInKotlinDir, (File)fileInJavaDir, (boolean)true, (int)0, (int)4, null);
        Map<File, Long> map = this.getTimestamps();
        Long l = fileInJavaDir.lastModified();
        map.put(fileInJavaDir, l);
        Logger $receiver$iv = this.getLogger();
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            String string = "Copied kotlin class " + FilesKt.relativeTo((File)fileInKotlinDir, (File)this.getKotlinOutputDir()).getPath() + " from " + this.getKotlinOutputDir() + " to " + this.getJavaOutputDir();
            GradleUtilsKt.kotlinDebug(logger, string);
        }
    }

    private final File siblingInJavaDir(@NotNull File $receiver, File baseDir) {
        File file = baseDir;
        if (file == null) {
            Object v1;
            block3: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)this.getClassesDirs();
                for (Object t : iterable2) {
                    File it = (File)t;
                    if (!FileUtil.isAncestor((File)it, (File)$receiver, (boolean)true)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            file = v1;
        }
        File base = file;
        return new File(this.getJavaOutputDir(), FilesKt.relativeTo((File)$receiver, (File)base).getPath());
    }

    static /* bridge */ /* synthetic */ File siblingInJavaDir$default(SyncOutputTask syncOutputTask, File file, File file2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: siblingInJavaDir");
        }
        if ((n & 1) != 0) {
            file2 = null;
        }
        return syncOutputTask.siblingInJavaDir(file, file2);
    }

    public SyncOutputTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Map map = this.getTimestamps();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Logger $receiver$iv;
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    File file = (File)entry2.getKey();
                    entry2 = entry;
                    long ts = ((Number)entry2.getValue()).longValue();
                    if (!file.exists()) {
                        $receiver$iv = this.getLogger();
                        if ($receiver$iv.isDebugEnabled()) {
                            Logger logger = $receiver$iv;
                            String string = file + " does not exist";
                            GradleUtilsKt.kotlinDebug(logger, string);
                        }
                        return false;
                    }
                    if (file.lastModified() == ts) continue;
                    $receiver$iv = this.getLogger();
                    if ($receiver$iv.isDebugEnabled()) {
                        Logger logger = $receiver$iv;
                        String string = file + " ts is different";
                        GradleUtilsKt.kotlinDebug(logger, string);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "kotlinOutputDir", "getKotlinOutputDir()Ljava/io/File;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "kaptClassesDir", "getKaptClassesDir()Ljava/io/File;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "javaOutputDir", "getJavaOutputDir()Ljava/io/File;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "kotlinTask", "getKotlinTask()Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "workingDir", "getWorkingDir()Ljava/io/File;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "timestampsFile", "getTimestampsFile()Ljava/io/File;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SyncOutputTask.class), "timestamps", "getTimestamps()Ljava/util/Map;"))};
    }

    public static final /* synthetic */ void access$processIncrementally(SyncOutputTask $this, @NotNull InputFileDetails input) {
        $this.processIncrementally(input);
    }

    @NotNull
    public static final /* synthetic */ File access$getTimestampsFile$p(SyncOutputTask $this) {
        return $this.getTimestampsFile();
    }
}

