/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.CharRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleCompilationResults;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner$WhenMappings;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.GradleIncrementalCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleIncrementalCompilerServicesFacadeImpl;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinLogger;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.UtilsKt;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.ChangedFiles;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunnerKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J+\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0002J.\u0010)\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00020!0\u00132\u0006\u0010+\u001a\u00020,H\u0002\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010/\u001a\u00020\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u0002042\u0006\u0010\u0016\u001a\u00020\u0002J2\u00105\u001a\u00020\u00112\f\u00106\u001a\b\u0012\u0004\u0012\u000202012\f\u00107\u001a\b\u0012\u0004\u0012\u000202082\u0006\u00103\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\u0002J$\u0010:\u001a\u00020\u00112\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u00103\u001a\u00020;2\u0006\u0010\u0016\u001a\u00020\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner;", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "log", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinLogger;", "getLog", "()Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinLogger;", "loggingMessageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getLoggingMessageCollector", "()Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "loggingMessageCollector$delegate", "Lkotlin/Lazy;", "compileInProcess", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "argsArray", "", "", "compilerClassName", "environment", "([Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compileOutOfProcess", "compileWithDaemon", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "compileWithDaemonOrFallback", "getDaemonConnection", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "incrementalCompilationWithDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "daemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "Lorg/jetbrains/kotlin/compilerRunner/GradleIncrementalCompilerEnvironment;", "logFinish", "", "strategy", "nonIncrementalCompilationWithDaemon", "reportCategories", "verbose", "", "(Z)[Ljava/lang/Integer;", "reportSeverity", "runJsCompiler", "kotlinSources", "", "Ljava/io/File;", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "runJvmCompiler", "sourcesToCompile", "javaSourceRoots", "", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "runMetadataCompiler", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "Companion", "kotlin-gradle-plugin"})
public final class GradleCompilerRunner
extends KotlinCompilerRunner<GradleCompilerEnvironment> {
    @NotNull
    private final GradleKotlinLogger log;
    private final Lazy loggingMessageCollector$delegate;
    private final Project project;
    private static volatile File clientIsAliveFlagFile;
    private static volatile File sessionFlagFile;
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final Companion Companion;

    @NotNull
    protected GradleKotlinLogger getLog() {
        return this.log;
    }

    private final MessageCollector getLoggingMessageCollector() {
        Lazy lazy = this.loggingMessageCollector$delegate;
        GradleCompilerRunner gradleCompilerRunner = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (MessageCollector)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ExitCode runJvmCompiler(@NotNull List<? extends File> sourcesToCompile, @NotNull Iterable<? extends File> javaSourceRoots2, @NotNull K2JVMCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots2, (String)"javaSourceRoots");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        String string = args.moduleName;
        String string2 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"args.moduleName");
        boolean bl = false;
        File file = IncrementalJvmCompilerRunnerKt.getDestinationAsFile((K2JVMCompilerArguments)args);
        Iterable iterable2 = sourcesToCompile;
        Iterable<? extends File> iterable3 = javaSourceRoots2;
        Iterable iterable4 = IncrementalJvmCompilerRunnerKt.getClasspathAsList((K2JVMCompilerArguments)args);
        if (args.friendPaths != null) {
            Collection<File> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object[] objectArray = args.friendPaths;
            Iterable iterable5 = iterable4;
            Iterable<? extends File> iterable6 = iterable3;
            Iterable iterable7 = iterable2;
            File file2 = file;
            boolean bl2 = bl;
            String string3 = string2;
            void var7_13 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void p1;
                void item$iv$iv = $receiver$iv$iv[i];
                String string4 = (String)item$iv$iv;
                collection = destination$iv$iv;
                File file3 = new File((String)p1);
                collection.add(file3);
            }
            collection = (List)destination$iv$iv;
            string2 = string3;
            bl = bl2;
            file = file2;
            iterable2 = iterable7;
            iterable3 = iterable6;
            iterable4 = iterable5;
            iterable = collection;
        } else {
            String[] cfr_ignored_0 = args.friendPaths;
            iterable = CollectionsKt.emptyList();
        }
        File moduleFile = BuildUtilKt.makeModuleFile((String)string2, (boolean)bl, (File)file, (Iterable)iterable2, iterable3, (Iterable)iterable4, (Iterable)iterable);
        args.module = moduleFile.getAbsolutePath();
        if (!(environment instanceof GradleIncrementalCompilerEnvironment)) {
            args.destination = null;
        }
        boolean deleteModuleFile = true;
        try {
            ExitCode res = this.runCompiler(this.getK2JVM_COMPILER(), (CommonCompilerArguments)args, environment);
            deleteModuleFile = Intrinsics.areEqual((Object)res, (Object)ExitCode.OK) || System.getProperty("kotlin.compiler.leave.module.file.on.error") == null;
            ExitCode exitCode = res;
            return exitCode;
        }
        finally {
            if (deleteModuleFile) {
                moduleFile.delete();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExitCode runJsCompiler(@NotNull List<? extends File> kotlinSources, @NotNull K2JSCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Iterable iterable = kotlinSources;
        List list = args.freeArgs;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list.addAll((Collection)collection);
        return this.runCompiler(this.getK2JS_COMPILER(), (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExitCode runMetadataCompiler(@NotNull List<? extends File> kotlinSources, @NotNull K2MetadataCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Iterable iterable = kotlinSources;
        List list = args.freeArgs;
        void var5_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list.addAll((Collection)collection);
        return this.runCompiler(this.getK2METADATA_COMPILER(), (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected ExitCode compileWithDaemonOrFallback(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull GradleCompilerEnvironment environment) {
        Boolean bl;
        String executionStrategy;
        String string;
        String string2;
        Collection collection;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        if (compilerArgs.version) {
            this.project.getLogger().lifecycle("Kotlin version " + UtilsKt.loadCompilerVersion(environment.getCompilerJar()) + " (JRE " + System.getProperty("java.runtime.version") + ")");
            compilerArgs.version = false;
        }
        Collection collection2 = $receiver$iv = (Collection)ArgumentUtils.convertArgumentsToStringList((CommonCompilerArguments)compilerArgs);
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection2;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        $receiver$iv = this.project.getLogger();
        Collection $receiver = $receiver$iv;
        Collection $receiver$iv2 = $receiver;
        if ($receiver$iv2.isDebugEnabled()) {
            collection = $receiver$iv2;
            string2 = "Kotlin compiler class: " + compilerClassName;
            GradleUtilsKt.kotlinDebug((Logger)collection, string2);
        }
        if (($receiver$iv2 = $receiver).isDebugEnabled()) {
            Collection<String> collection3;
            void $receiver$iv$iv;
            void $receiver$iv3;
            collection = $receiver$iv2;
            Iterable $i$a$1$kotlinDebug = environment.getCompilerClasspath();
            StringBuilder $i$f$kotlinDebug = new StringBuilder().append("Kotlin compiler classpath: ");
            void var12_12 = $receiver$iv3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                collection3 = destination$iv$iv;
                String string3 = it.getCanonicalPath();
                collection3.add(string3);
            }
            collection3 = (List)destination$iv$iv;
            string2 = $i$f$kotlinDebug.append(CollectionsKt.joinToString$default((Iterable)collection3, null, null, null, (int)0, null, null, (int)63, null)).toString();
            GradleUtilsKt.kotlinDebug((Logger)collection, string2);
        }
        if (($receiver$iv2 = $receiver).isDebugEnabled()) {
            collection = $receiver$iv2;
            string2 = "Kotlin compiler args: " + ArraysKt.joinToString$default((Object[])argsArray, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            GradleUtilsKt.kotlinDebug((Logger)collection, string2);
        }
        if ((string = System.getProperty("kotlin.compiler.execution.strategy")) == null) {
            string = executionStrategy = "daemon";
        }
        if (Intrinsics.areEqual((Object)executionStrategy, (Object)"daemon")) {
            ExitCode daemonExitCode = this.compileWithDaemon(compilerClassName, compilerArgs, environment);
            if (daemonExitCode != null) {
                return daemonExitCode;
            }
            this.getLog().warn("Could not connect to kotlin daemon. Using fallback strategy.");
        }
        String string4 = System.getProperty("org.gradle.daemon");
        if (string4 != null) {
            String string5;
            String p1;
            string2 = p1 = (string5 = string4);
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = null;
        }
        Boolean isGradleDaemonUsed = bl;
        return Intrinsics.areEqual((Object)executionStrategy, (Object)"in-process") || Intrinsics.areEqual((Object)isGradleDaemonUsed, (Object)false) ? this.compileInProcess(argsArray, compilerClassName, environment) : this.compileOutOfProcess(argsArray, compilerClassName, environment);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected ExitCode compileWithDaemon(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull GradleCompilerEnvironment environment) {
        ExitCode exitCode;
        void daemon;
        CompileServiceSession compileServiceSession;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        try {
            compileServiceSession = this.getDaemonConnection(environment);
        }
        catch (Throwable e) {
            this.getLog().warn("Caught an exception trying to connect to Kotlin Daemon");
            e.printStackTrace();
            compileServiceSession = null;
        }
        CompileServiceSession connection = compileServiceSession;
        if (connection == null) {
            if (environment instanceof GradleIncrementalCompilerEnvironment) {
                this.getLog().warn("Could not perform incremental compilation: " + "Could not connect to Kotlin compile daemon");
            } else {
                this.getLog().warn("Could not connect to Kotlin compile daemon");
            }
            return null;
        }
        CompileServiceSession compileServiceSession2 = connection;
        compileServiceSession = compileServiceSession2.component1();
        int e = compileServiceSession2.component2();
        compileServiceSession2 = null;
        try {
            void sessionId;
            CompileService.CallResult<Integer> res = environment instanceof GradleIncrementalCompilerEnvironment ? this.incrementalCompilationWithDaemon((CompileService)daemon, (int)sessionId, (GradleIncrementalCompilerEnvironment)environment) : this.nonIncrementalCompilationWithDaemon((CompileService)daemon, (int)sessionId, compilerClassName, environment);
            exitCode = this.exitCodeFromProcessExitCode(((Number)res.get()).intValue());
        }
        catch (Throwable e2) {
            this.getLog().warn("Compilation with Kotlin compile daemon was not successful");
            e2.printStackTrace();
            exitCode = null;
        }
        ExitCode exitCode2 = exitCode;
        daemon.clearJarCache();
        this.logFinish("daemon");
        return exitCode2;
    }

    private final CompileService.CallResult<Integer> nonIncrementalCompilationWithDaemon(CompileService daemon, int sessionId, String compilerClassName, GradleCompilerEnvironment environment) {
        Collection $receiver$iv;
        CompilationOptions compilationOptions;
        CompileService.TargetPlatform targetPlatform;
        String string = compilerClassName;
        if (Intrinsics.areEqual((Object)string, (Object)this.getK2JVM_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.JVM;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getK2JS_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.JS;
        } else if (Intrinsics.areEqual((Object)string, (Object)this.getK2METADATA_COMPILER())) {
            targetPlatform = CompileService.TargetPlatform.METADATA;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown compiler type " + compilerClassName);
        }
        CompileService.TargetPlatform targetPlatform2 = targetPlatform;
        boolean verbose = environment.getCompilerArgs().verbose;
        int n = this.reportSeverity(verbose);
        Integer[] integerArray = this.reportCategories(verbose);
        CompileService.TargetPlatform targetPlatform3 = targetPlatform2;
        CompilerMode compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        CompilationOptions compilationOptions2 = compilationOptions;
        CompilationOptions compilationOptions3 = compilationOptions;
        Integer[] integerArray2 = new Integer[]{};
        compilationOptions2(compilerMode, targetPlatform3, integerArray, n, integerArray2);
        CompilationOptions compilationOptions4 = compilationOptions3;
        GradleCompilerServicesFacadeImpl servicesFacade = new GradleCompilerServicesFacadeImpl(this.project, environment.getMessageCollector(), 0, 4, null);
        Collection collection = $receiver$iv = (Collection)ArgumentUtils.convertArgumentsToStringList((CommonCompilerArguments)environment.getCompilerArgs());
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        return daemon.compile(sessionId, argsArray, compilationOptions4, (CompilerServicesFacadeBase)servicesFacade, null);
    }

    private final CompileService.CallResult<Integer> incrementalCompilationWithDaemon(CompileService daemon, int sessionId, GradleIncrementalCompilerEnvironment environment) {
        Collection $receiver$iv;
        CompileService.TargetPlatform elements$iv;
        IncrementalCompilationOptions incrementalCompilationOptions;
        ChangedFiles changedFiles = environment.getChangedFiles();
        if (!(changedFiles instanceof ChangedFiles.Known)) {
            changedFiles = null;
        }
        ChangedFiles.Known knownChangedFiles = (ChangedFiles.Known)changedFiles;
        boolean verbose = environment.getCompilerArgs().verbose;
        ChangedFiles.Known known = knownChangedFiles;
        ChangedFiles.Known known2 = knownChangedFiles;
        Object[] objectArray = new Integer[]{CompilationResultCategory.IC_COMPILE_ITERATION.getCode()};
        int n = this.reportSeverity(verbose);
        Integer[] integerArray = this.reportCategories(verbose);
        String string = "gradle-format-version.txt";
        int n2 = 3;
        File file = environment.getWorkingDir();
        List list = known2 != null ? known2.getRemoved() : null;
        List list2 = known != null ? known.getModified() : null;
        boolean bl = knownChangedFiles != null;
        IncrementalCompilationOptions incrementalCompilationOptions2 = incrementalCompilationOptions;
        IncrementalCompilationOptions incrementalCompilationOptions3 = incrementalCompilationOptions;
        void var24_17 = elements$iv;
        elements$iv = CompileService.TargetPlatform.JVM;
        CompilerMode compilerMode = CompilerMode.INCREMENTAL_COMPILER;
        Integer[] integerArray2 = (Integer[])var24_17;
        int n3 = n;
        Integer[] integerArray3 = integerArray;
        String string2 = string;
        int n4 = n2;
        incrementalCompilationOptions2(bl, list2, list, file, string2, n4, compilerMode, elements$iv, integerArray3, n3, integerArray2);
        IncrementalCompilationOptions compilationOptions = incrementalCompilationOptions3;
        GradleIncrementalCompilerServicesFacadeImpl servicesFacade = new GradleIncrementalCompilerServicesFacadeImpl(this.project, environment, 0, 4, null);
        Collection collection = $receiver$iv = (Collection)ArgumentUtils.convertArgumentsToStringList((CommonCompilerArguments)environment.getCompilerArgs());
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        return daemon.compile(sessionId, argsArray, (CompilationOptions)compilationOptions, (CompilerServicesFacadeBase)servicesFacade, (CompilationResults)new GradleCompilationResults(this.project));
    }

    /*
     * WARNING - void declaration
     */
    private final Integer[] reportCategories(boolean verbose) {
        Integer[] integerArray;
        if (!verbose) {
            Object[] elements$iv = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode()};
            integerArray = (Integer[])elements$iv;
        } else {
            void $receiver$iv$iv;
            Object $receiver$iv = ReportCategory.values();
            Object[] objectArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void it;
                void item$iv$iv = $receiver$iv$iv[i];
                ReportCategory reportCategory = (ReportCategory)item$iv$iv;
                Collection collection = destination$iv$iv;
                Integer n = it.getCode();
                collection.add(n);
            }
            $receiver$iv = (List)destination$iv$iv;
            Object thisCollection$iv = $receiver$iv;
            Integer[] integerArray2 = thisCollection$iv.toArray(new Integer[thisCollection$iv.size()]);
            if (integerArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            integerArray = integerArray2;
        }
        return integerArray;
    }

    private final int reportSeverity(boolean verbose) {
        return !verbose ? ReportSeverity.INFO.getCode() : ReportSeverity.DEBUG.getCode();
    }

    /*
     * WARNING - void declaration
     */
    private final ExitCode compileOutOfProcess(String[] argsArray, String compilerClassName, GradleCompilerEnvironment environment) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        Iterable iterable = $receiver$iv = (Iterable)environment.getCompilerClasspath();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        String classpathString = CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)javaBin);
        spreadBuilder.add((Object)"-cp");
        spreadBuilder.add((Object)classpathString);
        spreadBuilder.add((Object)compilerClassName);
        spreadBuilder.addSpread((Object)argsArray);
        ProcessBuilder builder = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        Process process = NativePlatformUtilKt.launchProcessWithFallback$default((ProcessBuilder)builder, (DaemonReportingTargets)new DaemonReportingTargets(null, null, this.getLoggingMessageCollector(), null, 11, null), null, (int)4, null);
        Thread readErrThread2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(process){
            final /* synthetic */ Process $process;

            public final void invoke() {
                InputStream inputStream = this.$process.getErrorStream();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Closeable closeable = inputStream2;
                closeable = new InputStreamReader((InputStream)closeable, charset);
                int n = 8192;
                TextStreamsKt.forEachLine((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), (Function1)compileOutOfProcess.readErrThread.1.INSTANCE);
            }
            {
                this.$process = process;
                super(0);
            }
        }), (int)31, null);
        InputStream inputStream = process.getInputStream();
        if (inputStream == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        InputStream inputStream3 = inputStream2;
        inputStream3 = new InputStreamReader(inputStream3, charset);
        int n = 8192;
        TextStreamsKt.forEachLine((Reader)(inputStream3 instanceof BufferedReader ? (BufferedReader)((Object)inputStream3) : new BufferedReader((Reader)((Object)inputStream3), n)), (Function1)compileOutOfProcess.1.INSTANCE);
        readErrThread2.join();
        int exitCode = process.waitFor();
        this.logFinish("out-of-process");
        return this.exitCodeFromProcessExitCode(exitCode);
    }

    private final ExitCode compileInProcess(String[] argsArray, String compilerClassName, GradleCompilerEnvironment environment) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(stream);
        ParentLastURLClassLoader classLoader = new ParentLastURLClassLoader(environment.getCompilerClasspathURLs(), ((Object)((Object)this)).getClass().getClassLoader());
        Class<?> servicesClass = Class.forName(Services.class.getCanonicalName(), true, classLoader);
        Object emptyServices = servicesClass.getField("EMPTY").get(servicesClass);
        Class<?> compiler = Class.forName(compilerClassName, true, classLoader);
        Method exec = compiler.getMethod("execAndOutputXml", PrintStream.class, servicesClass, String[].class);
        Object res = exec.invoke(compiler.newInstance(), out, emptyServices, argsArray);
        ExitCode exitCode = ExitCode.valueOf((String)res.toString());
        this.processCompilerOutput(environment, stream, exitCode);
        this.logFinish("in-process");
        return exitCode;
    }

    private final void logFinish(String strategy) {
        this.getLog().debug("Finished executing kotlin compiler using " + strategy + " strategy");
    }

    @Nullable
    protected CompileServiceSession getDaemonConnection(@NotNull GradleCompilerEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)environment.getCompilerClasspath());
        File clientIsAliveFlagFile = GradleCompilerRunner.Companion.getOrCreateClientFlagFile(this.project);
        File sessionIsAliveFlagFile = GradleCompilerRunner.Companion.getOrCreateSessionFlagFile(this.project);
        return KotlinCompilerRunner.newDaemonConnection$default((KotlinCompilerRunner)this, (CompilerId)compilerId, (File)clientIsAliveFlagFile, (File)sessionIsAliveFlagFile, (CompilerEnvironment)environment, null, (int)16, null);
    }

    public GradleCompilerRunner(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = this.project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        this.log = new GradleKotlinLogger(logger);
        this.loggingMessageCollector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<loggingMessageCollector.1>(this){
            final /* synthetic */ GradleCompilerRunner this$0;

            @NotNull
            public final loggingMessageCollector.1 invoke() {
                return new MessageCollector(this){
                    private boolean hasErrors;
                    private final MessageRenderer messageRenderer;
                    final /* synthetic */ loggingMessageCollector.2 this$0;

                    public void clear() {
                        this.hasErrors = false;
                    }

                    public boolean hasErrors() {
                        return this.hasErrors;
                    }

                    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageLocation location) {
                        Intrinsics.checkParameterIsNotNull((Object)severity, (String)"severity");
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        String locMessage = this.messageRenderer.render(severity, message, location);
                        switch (GradleCompilerRunner$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                            case 1: {
                                GradleKotlinLogger gradleKotlinLogger = this.this$0.this$0.getLog();
                                String string = locMessage;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locMessage");
                                gradleKotlinLogger.error(string);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                GradleKotlinLogger gradleKotlinLogger = this.this$0.this$0.getLog();
                                String string = locMessage;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locMessage");
                                gradleKotlinLogger.info(string);
                                break;
                            }
                            case 6: {
                                GradleKotlinLogger gradleKotlinLogger = this.this$0.this$0.getLog();
                                String string = locMessage;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"locMessage");
                                gradleKotlinLogger.debug(string);
                            }
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.messageRenderer = MessageRenderer.PLAIN_FULL_PATHS;
                    }
                };
            }
            {
                this.this$0 = gradleCompilerRunner;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GradleCompilerRunner.class), "loggingMessageCollector", "getLoggingMessageCollector()Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;"))};
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner$Companion;", "", "()V", "clientIsAliveFlagFile", "Ljava/io/File;", "getClientIsAliveFlagFile", "()Ljava/io/File;", "setClientIsAliveFlagFile", "(Ljava/io/File;)V", "sessionFlagFile", "getSessionFlagFile", "setSessionFlagFile", "getOrCreateClientFlagFile", "project", "Lorg/gradle/api/Project;", "getOrCreateSessionFlagFile", "sessionsDir", "sessionsDir$kotlin_gradle_plugin", "normalizeForFlagFile", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final File getClientIsAliveFlagFile() {
            return clientIsAliveFlagFile;
        }

        private final void setClientIsAliveFlagFile(File file) {
            clientIsAliveFlagFile = file;
        }

        /*
         * Unable to fully structure code
         */
        private final synchronized File getOrCreateClientFlagFile(Project project) {
            log = project.getLogger();
            if (this.getClientIsAliveFlagFile() == null) ** GOTO lbl-1000
            v0 = this.getClientIsAliveFlagFile();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                projectName = this.normalizeForFlagFile(project.getRootProject().getName());
                this.setClientIsAliveFlagFile(FileUtil.createTempFile((String)("kotlin-compiler-in-" + projectName + "-"), (String)".alive", (boolean)true));
                $receiver$iv = log;
                if ($receiver$iv.isDebugEnabled()) {
                    var7_6 = $receiver$iv;
                    v1 = new StringBuilder().append("Created client-is-alive flag file: ");
                    v2 = GradleCompilerRunner.Companion.getClientIsAliveFlagFile();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    var8_8 = v1.append(v2.getCanonicalPath()).toString();
                    GradleUtilsKt.kotlinDebug(var7_6, var8_8);
                }
            } else {
                $receiver$iv = log;
                if ($receiver$iv.isDebugEnabled()) {
                    var7_7 = $receiver$iv;
                    v3 = new StringBuilder().append("Existing client-is-alive flag file: ");
                    v4 = GradleCompilerRunner.Companion.getClientIsAliveFlagFile();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    var8_9 = v3.append(v4.getCanonicalPath()).toString();
                    GradleUtilsKt.kotlinDebug(var7_7, var8_9);
                }
            }
            v5 = this.getClientIsAliveFlagFile();
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            return v5;
        }

        /*
         * WARNING - void declaration
         */
        private final String normalizeForFlagFile(@NotNull String $receiver) {
            void $receiver$iv$iv;
            List validChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)"-_");
            String $receiver$iv = $receiver;
            CharSequence charSequence = $receiver$iv;
            Appendable destination$iv$iv = new StringBuilder();
            int n = 0;
            int n2 = $receiver$iv$iv.length() - 1;
            if (n <= n2) {
                while (true) {
                    void index$iv$iv;
                    char element$iv$iv;
                    char it;
                    if (validChars.contains(Character.valueOf(it = (element$iv$iv = $receiver$iv$iv.charAt((int)index$iv$iv))))) {
                        destination$iv$iv.append(element$iv$iv);
                    }
                    if (index$iv$iv == n2) break;
                    ++index$iv$iv;
                }
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return string;
        }

        private final File getSessionFlagFile() {
            return sessionFlagFile;
        }

        private final void setSessionFlagFile(File file) {
            sessionFlagFile = file;
        }

        /*
         * Unable to fully structure code
         */
        private final synchronized File getOrCreateSessionFlagFile(Project project) {
            log = project.getLogger();
            if (this.getSessionFlagFile() == null) ** GOTO lbl-1000
            v0 = this.getSessionFlagFile();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                $receiver = var4_3 = this.sessionsDir$kotlin_gradle_plugin(project);
                $receiver.mkdirs();
                sessionFilesDir = var4_3;
                this.setSessionFlagFile(FileUtil.createTempFile((File)sessionFilesDir, (String)"kotlin-compiler-", (String)".salive", (boolean)true));
                $receiver$iv = log;
                if ($receiver$iv.isDebugEnabled()) {
                    var7_7 = $receiver$iv;
                    v1 = new StringBuilder().append("Created session-is-alive flag file: ");
                    v2 = GradleCompilerRunner.Companion.getSessionFlagFile();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    var8_9 = v1.append(FileUtilsKt.relativeToRoot(v2, project)).toString();
                    GradleUtilsKt.kotlinDebug(var7_7, var8_9);
                }
            } else {
                $receiver$iv = log;
                if ($receiver$iv.isDebugEnabled()) {
                    var7_8 = $receiver$iv;
                    v3 = new StringBuilder().append("Existing session-is-alive flag file: ");
                    v4 = GradleCompilerRunner.Companion.getSessionFlagFile();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    var8_10 = v3.append(FileUtilsKt.relativeToRoot(v4, project)).toString();
                    GradleUtilsKt.kotlinDebug(var7_8, var8_10);
                }
            }
            v5 = this.getSessionFlagFile();
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            return v5;
        }

        @NotNull
        public final File sessionsDir$kotlin_gradle_plugin(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return new File(new File(project.getRootProject().getBuildDir(), "kotlin"), "sessions");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

