/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.plugin.CompilerServicesCleanup;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.incremental.BuildCacheStorage;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.JvmUtilsKt;
import org.jetbrains.kotlin.incremental.multiproject.ArtifactDifferenceRegistryProvider;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/BuildAdapter;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "(Lorg/gradle/api/invocation/Gradle;)V", "artifactDifferenceRegistryProvider", "Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/incremental/multiproject/ArtifactDifferenceRegistryProvider;", "buildCacheStorage", "Lorg/jetbrains/kotlin/incremental/BuildCacheStorage;", "cleanup", "Lorg/jetbrains/kotlin/gradle/plugin/CompilerServicesCleanup;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "workingDir", "Ljava/io/File;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "closeArtifactDifferenceRegistry", "getGcCount", "getUsedMemoryKb", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinGradleBuildServices
extends BuildAdapter {
    private final Logger log = Logging.getLogger(((Object)((Object)this)).getClass());
    private final CompilerServicesCleanup cleanup = new CompilerServicesCleanup();
    private Long startMemory;
    private final File workingDir;
    private final BuildCacheStorage buildCacheStorage;
    private final boolean shouldReportMemoryUsage;
    private static final String CLASS_NAME;
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    @NotNull
    public static final String SHOULD_REPORT_MEMORY_USAGE_PROPERTY = "kotlin.gradle.test.report.memory.usage";
    @NotNull
    private static final String INIT_MESSAGE;
    @NotNull
    private static final String DISPOSE_MESSAGE;
    @NotNull
    private static final String ALREADY_INITIALIZED_MESSAGE;
    private static volatile KotlinGradleBuildServices instance;
    public static final Companion Companion;

    @NotNull
    public final ArtifactDifferenceRegistryProvider getArtifactDifferenceRegistryProvider$kotlin_gradle_plugin() {
        return this.buildCacheStorage;
    }

    public final void buildStarted() {
        this.startMemory = this.getUsedMemoryKb();
    }

    public void buildFinished(@NotNull BuildResult result) {
        CharSequence charSequence;
        Logger logger;
        Project rootProject;
        boolean kotlinCompilerCalled;
        Gradle gradle;
        block11: {
            boolean bl;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            Gradle gradle2 = result.getGradle();
            if (gradle2 == null) {
                Intrinsics.throwNpe();
            }
            gradle = gradle2;
            Iterable iterable = gradle.getRootProject().getAllprojects();
            void var5_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Project it = (Project)element$iv$iv;
                Iterable list$iv$iv = (Iterable)it.getTasks();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Task it = (Task)element$iv;
                if (!(it instanceof AbstractKotlinCompile && ((AbstractKotlinCompile)it).getCompilerCalled$kotlin_gradle_plugin())) continue;
                bl = true;
                break block11;
            }
            bl = kotlinCompilerCalled = false;
        }
        if (kotlinCompilerCalled) {
            GradleUtilsKt.kotlinDebug(this.log, "Cleanup after kotlin");
            String string = gradle.getGradleVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gradle.gradleVersion");
            this.cleanup.invoke(string);
        } else {
            GradleUtilsKt.kotlinDebug(this.log, "Skipping kotlin cleanup since compiler wasn't called");
        }
        Project project = rootProject = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin(project);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (((Object[])sessionFiles).length > 1) {
                StringBuilder stringBuilder = new StringBuilder().append("w: Detected multiple Kotlin daemon sessions at ");
                Project project2 = rootProject;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"rootProject");
                this.log.warn(stringBuilder.append(FileUtilsKt.relativeToRoot(sessionsDir, project2)).toString());
            }
            for (int $i$a$2$any = 0; $i$a$2$any < sessionFiles.length; ++$i$a$2$any) {
                File file = sessionFiles[$i$a$2$any];
                file.delete();
                Logger $receiver$iv = this.log;
                if (!$receiver$iv.isDebugEnabled()) continue;
                logger = $receiver$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Deleted session-is-alive flag file: ");
                Project project3 = rootProject;
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"rootProject");
                charSequence = stringBuilder.append(FileUtilsKt.relativeToRoot(file, project3)).toString();
                GradleUtilsKt.kotlinDebug(logger, (String)charSequence);
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long startMem = l;
            Long l2 = this.getUsedMemoryKb();
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long endMem = l2;
            String string = "%+d";
            Object[] objectArray = new Object[]{endMem - startMem};
            charSequence = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            logger = this.log;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String string3 = string2;
            logger.lifecycle(((StringBuilder)charSequence).append(string3).append(" kb)").toString());
        }
        this.closeArtifactDifferenceRegistry();
        gradle.removeListener((Object)this);
        KotlinGradleBuildServices.Companion.setInstance(null);
        GradleUtilsKt.kotlinDebug(this.log, Companion.getDISPOSE_MESSAGE());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeArtifactDifferenceRegistry() {
        block18: {
            String string;
            Logger logger;
            Logger $receiver$iv;
            boolean caughtError = false;
            try {
                if (this.workingDir.exists()) {
                    this.buildCacheStorage.flush(false);
                }
            }
            catch (Throwable e) {
                $receiver$iv = this.log;
                if ($receiver$iv.isDebugEnabled()) {
                    logger = $receiver$iv;
                    string = "Error trying to flush artifact difference registry: " + JvmUtilsKt.getStackTraceStr(e);
                    GradleUtilsKt.kotlinDebug(logger, string);
                }
                caughtError = true;
            }
            finally {
                try {
                    this.buildCacheStorage.close();
                }
                catch (Throwable e) {
                    $receiver$iv = this.log;
                    if ($receiver$iv.isDebugEnabled()) {
                        logger = $receiver$iv;
                        string = "Error trying to close artifact difference registry: " + JvmUtilsKt.getStackTraceStr(e);
                        GradleUtilsKt.kotlinDebug(logger, string);
                    }
                    caughtError = true;
                }
            }
            if (caughtError && this.workingDir.exists()) {
                try {
                    FilesKt.deleteRecursively((File)this.workingDir);
                }
                catch (Throwable e) {
                    $receiver$iv = this.log;
                    if (!$receiver$iv.isDebugEnabled()) break block18;
                    logger = $receiver$iv;
                    string = "Error trying to delete kotlin-build " + this.workingDir + ": " + JvmUtilsKt.getStackTraceStr(e);
                    GradleUtilsKt.kotlinDebug(logger, string);
                }
            }
        }
    }

    private final Long getUsedMemoryKb() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var2_2;
        Iterable $receiver$iv = ManagementFactory.getGarbageCollectorMXBeans();
        long sum$iv = 0L;
        for (Object element$iv : $receiver$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            long l2 = Math.max(0L, it.getCollectionCount());
            sum$iv = l + l2;
        }
        return (long)var2_2;
    }

    private KotlinGradleBuildServices(Gradle gradle) {
        File file;
        File file2 = new File(gradle.getRootProject().getBuildDir(), "kotlin-build");
        KotlinGradleBuildServices kotlinGradleBuildServices = this;
        File $receiver = file2;
        $receiver.mkdirs();
        kotlinGradleBuildServices.workingDir = file = file2;
        this.buildCacheStorage = new BuildCacheStorage(this.workingDir);
        this.shouldReportMemoryUsage = System.getProperty(SHOULD_REPORT_MEMORY_USAGE_PROPERTY) != null;
    }

    static {
        Companion = new Companion(null);
        CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
        INIT_MESSAGE = "Initialized " + KotlinGradleBuildServices.Companion.getCLASS_NAME();
        DISPOSE_MESSAGE = "Disposed " + KotlinGradleBuildServices.Companion.getCLASS_NAME();
        ALREADY_INITIALIZED_MESSAGE = KotlinGradleBuildServices.Companion.getCLASS_NAME() + " is already initialized";
    }

    public /* synthetic */ KotlinGradleBuildServices(@NotNull Gradle gradle, DefaultConstructorMarker $constructor_marker) {
        this(gradle);
    }

    @JvmStatic
    @NotNull
    public static final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        return Companion.getInstance(gradle);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "ALREADY_INITIALIZED_MESSAGE", "", "getALREADY_INITIALIZED_MESSAGE", "()Ljava/lang/String;", "CLASS_NAME", "kotlin.jvm.PlatformType", "getCLASS_NAME", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "FORCE_SYSTEM_GC_MESSAGE", "INIT_MESSAGE", "getINIT_MESSAGE", "SHOULD_REPORT_MEMORY_USAGE_PROPERTY", "instance", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "getInstance", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "setInstance", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;)V", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String getCLASS_NAME() {
            return CLASS_NAME;
        }

        @NotNull
        public final String getINIT_MESSAGE() {
            return INIT_MESSAGE;
        }

        @NotNull
        public final String getDISPOSE_MESSAGE() {
            return DISPOSE_MESSAGE;
        }

        @NotNull
        public final String getALREADY_INITIALIZED_MESSAGE() {
            return ALREADY_INITIALIZED_MESSAGE;
        }

        private final KotlinGradleBuildServices getInstance() {
            return instance;
        }

        private final void setInstance(KotlinGradleBuildServices kotlinGradleBuildServices) {
            instance = kotlinGradleBuildServices;
        }

        @JvmStatic
        @NotNull
        public final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            Logger log = Logging.getLogger(KotlinGradleBuildServices.class);
            if (this.getInstance() != null) {
                GradleUtilsKt.kotlinDebug(log, this.getALREADY_INITIALIZED_MESSAGE());
                KotlinGradleBuildServices kotlinGradleBuildServices = this.getInstance();
                if (kotlinGradleBuildServices == null) {
                    Intrinsics.throwNpe();
                }
                return kotlinGradleBuildServices;
            }
            KotlinGradleBuildServices services = new KotlinGradleBuildServices(gradle, null);
            gradle.addBuildListener((BuildListener)services);
            this.setInstance(services);
            GradleUtilsKt.kotlinDebug(log, this.getINIT_MESSAGE());
            services.buildStarted();
            return services;
        }

        private Companion() {
        }

        @Nullable
        public static final /* synthetic */ KotlinGradleBuildServices access$getInstance$p(Companion $this) {
            return $this.getInstance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

