/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.builder.model.SourceProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.Kapt3GradleSubplugin;
import org.jetbrains.kotlin.gradle.internal.Kapt3KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.internal.Kapt3KotlinGradleSubpluginKt;
import org.jetbrains.kotlin.gradle.internal.KaptGenerateStubsTask;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.internal.KaptVariantData;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginOption;
import org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000267B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0014J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0014J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u001e\u0010\"\u001a\u00020#*\u00060$R\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0&H\u0002J \u0010'\u001a\u00020#*\u00060$R\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0014H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00060$R\u00020\u00002\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0018\u0010,\u001a\u00020\u001b*\u00060$R\u00020\u00002\u0006\u0010-\u001a\u00020\u0014H\u0002J\u0010\u0010.\u001a\u00020\u0006*\u00060$R\u00020\u0000H\u0002J\u0010\u0010/\u001a\u000200*\u00060$R\u00020\u0000H\u0002J\u0010\u00101\u001a\u00020#*\u00060$R\u00020\u0000H\u0002J\u0010\u00102\u001a\u00020\u001b*\u00060$R\u00020\u0000H\u0002J\u0010\u00103\u001a\u00020\u001b*\u00060$R\u00020\u0000H\u0002J\u0018\u00104\u001a\u00020\u0014*\u00060$R\u00020\u00002\u0006\u00105\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleSubplugin;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "()V", "kotlinToKaptGenerateStubsTasksMap", "", "Lorg/jetbrains/kotlin/gradle/internal/KaptGenerateStubsTask;", "apply", "", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginOption;", "project", "Lorg/gradle/api/Project;", "kotlinCompile", "javaCompile", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "variantData", "", "javaSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "encodeOptions", "", "options", "", "getArtifactName", "getCompilerPluginId", "getGroupName", "getKaptGeneratedDir", "Ljava/io/File;", "sourceSetName", "getKaptGeneratedDirForKotlin", "getSubpluginKotlinTasks", "isApplicable", "", "task", "addMiscOptions", "", "Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin$Kapt3SubpluginContext;", "pluginOptions", "", "buildAndAddOptionsTo", "container", "Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "aptMode", "buildOptions", "createAndReturnTemporaryKaptDirectory", "name", "createKaptGenerateStubsTask", "createKaptKotlinTask", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "disableAnnotationProcessingInJavaTask", "getKaptIncrementalDataDir", "getKaptStubsDir", "getKaptTaskName", "prefix", "Companion", "Kapt3SubpluginContext", "kotlin-gradle-plugin"})
public final class Kapt3KotlinGradleSubplugin
implements KotlinGradleSubplugin<KotlinCompile> {
    private final Map<KotlinCompile, KaptGenerateStubsTask> kotlinToKaptGenerateStubsTasksMap;
    private static final String VERBOSE_OPTION_NAME = "kapt.verbose";
    @NotNull
    private static final String MAIN_KAPT_CONFIGURATION_NAME = "kapt";
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull Project project, @NotNull KotlinCompile task) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        return Kapt3GradleSubplugin.Companion.isEnabled(project);
    }

    @NotNull
    public final File getKaptGeneratedDir(@NotNull Project project, @NotNull String sourceSetName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
        return new File(project.getProject().getBuildDir(), "generated/source/kapt/" + sourceSetName);
    }

    @NotNull
    public final File getKaptGeneratedDirForKotlin(@NotNull Project project, @NotNull String sourceSetName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
        return new File(project.getProject().getBuildDir(), "generated/source/kaptKotlin/" + sourceSetName);
    }

    private final File getKaptStubsDir(@NotNull Kapt3SubpluginContext $receiver) {
        return this.createAndReturnTemporaryKaptDirectory($receiver, "stubs");
    }

    private final File getKaptIncrementalDataDir(@NotNull Kapt3SubpluginContext $receiver) {
        return this.createAndReturnTemporaryKaptDirectory($receiver, "incrementalData");
    }

    private final File createAndReturnTemporaryKaptDirectory(@NotNull Kapt3SubpluginContext $receiver, String name) {
        File dir = new File($receiver.getProject().getBuildDir(), "tmp/kapt3/" + name + "/" + $receiver.getSourceSetName());
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<SubpluginOption> apply(@NotNull Project project, @NotNull KotlinCompile kotlinCompile, @NotNull AbstractCompile javaCompile, @Nullable Object variantData, @Nullable SourceSet javaSourceSet) {
        void $receiver$iv;
        String string;
        KaptVariantData kaptVariantData;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
        Intrinsics.checkParameterIsNotNull((Object)javaCompile, (String)"javaCompile");
        boolean bl = variantData != null ^ javaSourceSet != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        ArrayList kaptClasspath = new ArrayList();
        Function1<String, Unit> handleSourceSet$ = new Function1<String, Unit>(this, project, javaCompile, kaptClasspath){
            final /* synthetic */ Kapt3KotlinGradleSubplugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ AbstractCompile $javaCompile;
            final /* synthetic */ ArrayList $kaptClasspath;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String sourceSetName) {
                Collection collection;
                List filteredDependencies;
                List list;
                Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
                Configuration kaptConfiguration = Kapt3KotlinGradleSubplugin.Companion.findKaptConfiguration(this.$project, sourceSetName);
                Configuration configuration = kaptConfiguration;
                if (configuration != null && (configuration = configuration.getDependencies()) != null) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)configuration;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        Dependency it = (Dependency)element$iv$iv;
                        if (!(Intrinsics.areEqual((Object)it.getGroup(), (Object)this.this$0.getGroupName()) ^ true || Intrinsics.areEqual((Object)it.getName(), (Object)this.this$0.getArtifactName()) ^ true)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = filteredDependencies = CollectionsKt.emptyList();
                }
                if (kaptConfiguration != null && !(collection = (Collection)filteredDependencies).isEmpty()) {
                    this.$javaCompile.dependsOn(new Object[]{kaptConfiguration.getBuildDependencies()});
                    this.$kaptClasspath.addAll(kaptConfiguration.resolve());
                }
            }
            {
                this.this$0 = kapt3KotlinGradleSubplugin;
                this.$project = project;
                this.$javaCompile = abstractCompile;
                this.$kaptClasspath = arrayList;
                super(1);
            }
        };
        Object object = variantData;
        if (!(object instanceof KaptVariantData)) {
            object = null;
        }
        if ((kaptVariantData = (KaptVariantData)object) != null) {
            Iterator<SourceProvider> iterator = kaptVariantData.getSourceProviders().iterator();
            while (iterator.hasNext()) {
                SourceProvider provider;
                SourceProvider sourceProvider = provider = iterator.next();
                if (sourceProvider == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.api.AndroidSourceSet");
                }
                String string3 = ((AndroidSourceSet)sourceProvider).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(provider as AndroidSourceSet).name");
                handleSourceSet$.invoke(string3);
            }
            string = kaptVariantData.getName();
        } else {
            if (javaSourceSet == null) {
                String provider = "Java source set should not be null";
                throw (Throwable)new IllegalStateException(provider.toString());
            }
            String string4 = javaSourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"javaSourceSet.name");
            handleSourceSet$.invoke(string4);
            string = javaSourceSet.getName();
        }
        String sourceSetName = string;
        KaptExtension kaptExtension = (KaptExtension)project.getExtensions().getByType(KaptExtension.class);
        String string5 = sourceSetName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sourceSetName");
        KaptExtension kaptExtension2 = kaptExtension;
        Intrinsics.checkExpressionValueIsNotNull((Object)kaptExtension2, (String)"kaptExtension");
        Kapt3SubpluginContext context = new Kapt3SubpluginContext(project, kotlinCompile, javaCompile, kaptVariantData, string5, kaptExtension2, kaptClasspath);
        KaptGenerateStubsTask kaptGenerateStubsTask = this.createKaptGenerateStubsTask(context);
        KaptTask kaptTask = this.createKaptKotlinTask(context);
        Collection collection = kotlinCompile.getDependsOn();
        KaptGenerateStubsTask kaptGenerateStubsTask2 = kaptGenerateStubsTask;
        void v7 = $receiver$iv;
        if (v7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv = v7;
        Object[] objectArray = thisCollection$iv.toArray(new Object[thisCollection$iv.size()]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        kaptGenerateStubsTask2.dependsOn(Arrays.copyOf(objectArray2, objectArray2.length));
        kaptTask.dependsOn(new Object[]{kaptGenerateStubsTask});
        kotlinCompile.dependsOn(new Object[]{kaptTask});
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<AbstractCompile> getSubpluginKotlinTasks(@NotNull Project project, @NotNull KotlinCompile kotlinCompile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
        KaptGenerateStubsTask kaptGenerateStubsTask = this.kotlinToKaptGenerateStubsTasksMap.get(kotlinCompile);
        return kaptGenerateStubsTask == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)kaptGenerateStubsTask);
    }

    private final List<SubpluginOption> buildOptions(@NotNull Kapt3SubpluginContext $receiver, String aptMode) {
        Object object;
        BaseExtension androidPlugin;
        BaseExtension baseExtension;
        SubpluginOption subpluginOption;
        Collection collection;
        Object it;
        Object element$iv2;
        List pluginOptions = new ArrayList();
        File generatedFilesDir = this.getKaptGeneratedDir($receiver.getProject(), $receiver.getSourceSetName());
        KaptVariantData<?> kaptVariantData = $receiver.getKaptVariantData();
        if (kaptVariantData != null) {
            kaptVariantData.addJavaSourceFoldersToModel(generatedFilesDir);
        }
        Collection collection2 = pluginOptions;
        Object object2 = new SubpluginOption("aptMode", aptMode);
        collection2.add(object2);
        this.disableAnnotationProcessingInJavaTask($receiver);
        if ($receiver.getKaptClasspath().isEmpty()) {
            return pluginOptions;
        }
        Iterable $receiver$iv = $receiver.getKaptClasspath();
        for (Object element$iv2 : $receiver$iv) {
            it = (File)element$iv2;
            collection = pluginOptions;
            String string = ((File)it).getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
            subpluginOption = new SubpluginOption("apclasspath", string);
            collection.add(subpluginOption);
        }
        $receiver.getJavaCompile().source(new Object[]{generatedFilesDir});
        $receiver$iv = pluginOptions;
        String string = generatedFilesDir.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generatedFilesDir.canonicalPath");
        object2 = new SubpluginOption("sources", string);
        $receiver$iv.add(object2);
        $receiver$iv = pluginOptions;
        String string2 = Companion.getKaptClasssesDir($receiver.getProject(), $receiver.getSourceSetName()).getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getKaptClasssesDir(proje\u2026rceSetName).canonicalPath");
        object2 = new SubpluginOption("classes", string2);
        $receiver$iv.add(object2);
        $receiver$iv = pluginOptions;
        String string3 = this.getKaptIncrementalDataDir($receiver).getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"getKaptIncrementalDataDir().canonicalPath");
        object2 = new SubpluginOption("incrementalData", string3);
        $receiver$iv.add(object2);
        String annotationProcessors = $receiver.getKaptExtension().getProcessors();
        object2 = annotationProcessors;
        if (object2.length() > 0) {
            object2 = pluginOptions;
            element$iv2 = new SubpluginOption("processors", annotationProcessors);
            object2.add(element$iv2);
        }
        KaptVariantData<?> kaptVariantData2 = $receiver.getKaptVariantData();
        if (kaptVariantData2 != null) {
            element$iv2 = kaptVariantData2;
            it = element$iv2;
            Object object3 = $receiver.getProject().getExtensions().findByName("android");
            if (!(object3 instanceof BaseExtension)) {
                object3 = null;
            }
            baseExtension = (BaseExtension)object3;
        } else {
            baseExtension = androidPlugin = null;
        }
        if ((object = $receiver.getKaptVariantData()) == null || (object = ((KaptVariantData)object).getAnnotationProcessorOptions()) == null) {
            object = MapsKt.emptyMap();
        }
        Object androidOptions = object;
        $receiver.getKotlinSourcesOutputDir().mkdirs();
        KaptVariantData<?> kaptVariantData3 = $receiver.getKaptVariantData();
        Map apOptions = MapsKt.plus((Map)MapsKt.plus($receiver.getKaptExtension().getAdditionalArguments($receiver.getProject(), kaptVariantData3 != null ? kaptVariantData3.getVariantData() : null, androidPlugin), (Map)androidOptions), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"kapt.kotlin.generated", (Object)$receiver.getKotlinSourcesOutputDir().getAbsolutePath())));
        collection = pluginOptions;
        subpluginOption = new SubpluginOption("apoptions", this.encodeOptions(apOptions));
        collection.add(subpluginOption);
        collection = pluginOptions;
        subpluginOption = new SubpluginOption("javacArguments", this.encodeOptions($receiver.getKaptExtension().getJavacOptions()));
        collection.add(subpluginOption);
        this.addMiscOptions($receiver, pluginOptions);
        return pluginOptions;
    }

    private final void buildAndAddOptionsTo(@NotNull Kapt3SubpluginContext $receiver, CompilerPluginOptions container, String aptMode) {
        String compilerPluginId = this.getCompilerPluginId();
        for (SubpluginOption option : this.buildOptions($receiver, aptMode)) {
            container.addPluginArgument(compilerPluginId, option.getKey(), option.getValue());
        }
    }

    @NotNull
    public final String encodeOptions(@NotNull Map<String, String> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeInt(options.size());
        Iterator<Map.Entry<String, String>> iterator = options.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            String k = entry2.getKey();
            entry2 = entry;
            String v = entry2.getValue();
            oos.writeUTF(k);
            oos.writeUTF(v);
        }
        oos.flush();
        String string = DatatypeConverter.printBase64Binary((byte[])os.toByteArray());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"printBase64Binary(os.toByteArray())");
        return string;
    }

    private final void addMiscOptions(@NotNull Kapt3SubpluginContext $receiver, List<SubpluginOption> pluginOptions) {
        if ($receiver.getKaptExtension().getGenerateStubs()) {
            $receiver.getProject().getLogger().warn("'kapt.generateStubs' is not used by the 'kotlin-kapt' plugin");
        }
        Collection collection = pluginOptions;
        SubpluginOption subpluginOption = new SubpluginOption("useLightAnalysis", String.valueOf($receiver.getKaptExtension().getUseLightAnalysis()));
        collection.add(subpluginOption);
        collection = pluginOptions;
        subpluginOption = new SubpluginOption("correctErrorTypes", String.valueOf($receiver.getKaptExtension().getCorrectErrorTypes()));
        collection.add(subpluginOption);
        collection = pluginOptions;
        String string = this.getKaptStubsDir($receiver).getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getKaptStubsDir().canonicalPath");
        subpluginOption = new SubpluginOption("stubs", string);
        collection.add(subpluginOption);
        if ($receiver.getProject().hasProperty(Kapt3KotlinGradleSubplugin.Companion.getVERBOSE_OPTION_NAME()) && Intrinsics.areEqual((Object)$receiver.getProject().property(Kapt3KotlinGradleSubplugin.Companion.getVERBOSE_OPTION_NAME()), (Object)"true")) {
            collection = pluginOptions;
            subpluginOption = new SubpluginOption("verbose", "true");
            collection.add(subpluginOption);
        }
    }

    private final KaptTask createKaptKotlinTask(@NotNull Kapt3SubpluginContext $receiver) {
        KaptTask kaptTask = (KaptTask)$receiver.getProject().getTasks().create(this.getKaptTaskName($receiver, MAIN_KAPT_CONFIGURATION_NAME), KaptTask.class);
        kaptTask.setKotlinCompileTask$kotlin_gradle_plugin($receiver.getKotlinCompile());
        Iterable $receiver$iv = $receiver.getKaptClasspathArtifacts();
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            kaptTask.getPluginOptions$kotlin_gradle_plugin().addClasspathEntry(it);
        }
        kaptTask.setStubsDir(this.getKaptStubsDir($receiver));
        kaptTask.setDestinationDir($receiver.getSourcesOutputDir());
        GradleUtilsKt.mapClasspath(kaptTask, (Function0<? extends FileCollection>)((Function0)new Function0<FileCollection>($receiver){
            final /* synthetic */ Kapt3SubpluginContext receiver$0;

            public final FileCollection invoke() {
                FileCollection fileCollection = this.receiver$0.getKotlinCompile().getClasspath();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"kotlinCompile.classpath");
                return fileCollection;
            }
            {
                this.receiver$0 = kapt3SubpluginContext;
                super(0);
            }
        }));
        kaptTask.setClassesDir($receiver.getClassesOutputDir());
        GradleUtilsKt.mapSource(kaptTask, (Function0<? extends FileTree>)((Function0)new Function0<FileTree>($receiver, kaptTask){
            final /* synthetic */ Kapt3SubpluginContext receiver$0;
            final /* synthetic */ KaptTask $kaptTask;

            public final FileTree invoke() {
                FileTree sourcesFromKotlinTask2 = this.receiver$0.getKotlinCompile().getSource().filter((Spec)new Spec<File>(this){
                    final /* synthetic */ createKaptKotlinTask.3 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isSatisfiedBy(File it) {
                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"java")) return false;
                        KaptTask kaptTask = this.this$0.$kaptTask;
                        File file = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        if (kaptTask.isInsideDestinationDirs(file)) return false;
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).getAsFileTree();
                ConfigurableFileTree stubSources = this.receiver$0.getProject().fileTree((Object)this.$kaptTask.getStubsDir());
                FileTree fileTree = sourcesFromKotlinTask2.plus((FileTree)stubSources);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"sourcesFromKotlinTask + stubSources");
                return fileTree;
            }
            {
                this.receiver$0 = kapt3SubpluginContext;
                this.$kaptTask = kaptTask;
                super(0);
            }
        }));
        $receiver.getKotlinCompile().source($receiver.getSourcesOutputDir(), $receiver.getKotlinSourcesOutputDir());
        if ($receiver.getKaptVariantData() != null) {
            KaptVariantData<?> kaptVariantData = $receiver.getKaptVariantData();
            Project project = $receiver.getProject();
            KaptTask kaptTask2 = kaptTask;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kaptTask2), (String)"kaptTask");
            kaptVariantData.registerGeneratedJavaSource(project, kaptTask2, $receiver.getJavaCompile());
        } else {
            KaptTask kaptTask3 = kaptTask;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kaptTask3), (String)"kaptTask");
            Kapt3KotlinGradleSubpluginKt.registerGeneratedJavaSource(kaptTask3, $receiver.getJavaCompile());
        }
        this.buildAndAddOptionsTo($receiver, kaptTask.getPluginOptions$kotlin_gradle_plugin(), "apt");
        KaptTask kaptTask4 = kaptTask;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kaptTask4), (String)"kaptTask");
        return kaptTask4;
    }

    private final KaptGenerateStubsTask createKaptGenerateStubsTask(@NotNull Kapt3SubpluginContext $receiver) {
        KaptGenerateStubsTask kaptTask = (KaptGenerateStubsTask)$receiver.getProject().getTasks().create(this.getKaptTaskName($receiver, "kaptGenerateStubs"), KaptGenerateStubsTask.class);
        kaptTask.setKotlinCompileTask$kotlin_gradle_plugin($receiver.getKotlinCompile());
        Map<KotlinCompile, KaptGenerateStubsTask> map = this.kotlinToKaptGenerateStubsTasksMap;
        KotlinCompile kotlinCompile = $receiver.getKotlinCompile();
        KaptGenerateStubsTask kaptGenerateStubsTask = kaptTask;
        Intrinsics.checkExpressionValueIsNotNull((Object)kaptGenerateStubsTask, (String)"kaptTask");
        KaptGenerateStubsTask kaptGenerateStubsTask2 = kaptGenerateStubsTask;
        map.put(kotlinCompile, kaptGenerateStubsTask2);
        Iterable $receiver$iv = $receiver.getKaptClasspathArtifacts();
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            kaptTask.getPluginOptions$kotlin_gradle_plugin().addClasspathEntry(it);
        }
        kaptTask.setStubsDir(this.getKaptStubsDir($receiver));
        kaptTask.setDestinationDir(this.getKaptIncrementalDataDir($receiver));
        GradleUtilsKt.mapClasspath(kaptTask, (Function0<? extends FileCollection>)((Function0)new Function0<FileCollection>($receiver){
            final /* synthetic */ Kapt3SubpluginContext receiver$0;

            public final FileCollection invoke() {
                FileCollection fileCollection = this.receiver$0.getKotlinCompile().getClasspath();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"kotlinCompile.classpath");
                return fileCollection;
            }
            {
                this.receiver$0 = kapt3SubpluginContext;
                super(0);
            }
        }));
        kaptTask.setGeneratedSourcesDir($receiver.getSourcesOutputDir());
        this.buildAndAddOptionsTo($receiver, kaptTask.getPluginOptions$kotlin_gradle_plugin(), "stubs");
        KaptGenerateStubsTask kaptGenerateStubsTask3 = kaptTask;
        Intrinsics.checkExpressionValueIsNotNull((Object)kaptGenerateStubsTask3, (String)"kaptTask");
        return kaptGenerateStubsTask3;
    }

    private final String getKaptTaskName(@NotNull Kapt3SubpluginContext $receiver, String prefix) {
        String baseName = $receiver.getKotlinCompile().getName();
        boolean bl = StringsKt.startsWith$default((String)baseName, (String)"compile", (boolean)false, (int)2, null);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return StringsKt.replaceFirst$default((String)baseName, (String)"compile", (String)prefix, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void disableAnnotationProcessingInJavaTask(@NotNull Kapt3SubpluginContext $receiver) {
        block2: {
            void $receiver$iv;
            JavaCompile javaCompile;
            AbstractCompile abstractCompile = $receiver.getJavaCompile();
            if (!(abstractCompile instanceof JavaCompile)) {
                abstractCompile = null;
            }
            JavaCompile javaCompile2 = (JavaCompile)abstractCompile;
            if (javaCompile2 == null) break block2;
            JavaCompile javaCompile3 = javaCompile = javaCompile2;
            CompileOptions options = javaCompile3.getOptions();
            List list = options.getCompilerArgs();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"options.compilerArgs");
            List oldCompilerArgs = list;
            Iterable iterable = oldCompilerArgs;
            Collection destination$iv = new ArrayList();
            for (Object element$iv : $receiver$iv) {
                Object it = element$iv;
                if (!(!(it instanceof CharSequence) || !StringsKt.startsWith$default((String)it.toString(), (String)"-proc:", (boolean)false, (int)2, null))) continue;
                destination$iv.add(element$iv);
            }
            List newCompilerArgs = (List)destination$iv;
            newCompilerArgs.add("-proc:none");
            options.setCompilerArgs(newCompilerArgs);
        }
    }

    @NotNull
    public String getCompilerPluginId() {
        return "org.jetbrains.kotlin.kapt3";
    }

    @NotNull
    public String getGroupName() {
        return "org.jetbrains.kotlin";
    }

    @NotNull
    public String getArtifactName() {
        return "kotlin-annotation-processing";
    }

    public Kapt3KotlinGradleSubplugin() {
        Map map;
        Kapt3KotlinGradleSubplugin kapt3KotlinGradleSubplugin = this;
        kapt3KotlinGradleSubplugin.kotlinToKaptGenerateStubsTasksMap = map = (Map)new LinkedHashMap();
    }

    static {
        VERBOSE_OPTION_NAME = VERBOSE_OPTION_NAME;
        MAIN_KAPT_CONFIGURATION_NAME = MAIN_KAPT_CONFIGURATION_NAME;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0010\b\u0082\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0014\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin$Kapt3SubpluginContext;", "", "project", "Lorg/gradle/api/Project;", "kotlinCompile", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "javaCompile", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "kaptVariantData", "Lorg/jetbrains/kotlin/gradle/internal/KaptVariantData;", "sourceSetName", "", "kaptExtension", "Lorg/jetbrains/kotlin/gradle/plugin/KaptExtension;", "kaptClasspath", "", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin;Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;Lorg/gradle/api/tasks/compile/AbstractCompile;Lorg/jetbrains/kotlin/gradle/internal/KaptVariantData;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/KaptExtension;Ljava/util/List;)V", "classesOutputDir", "getClassesOutputDir", "()Ljava/io/File;", "getJavaCompile", "()Lorg/gradle/api/tasks/compile/AbstractCompile;", "getKaptClasspath", "()Ljava/util/List;", "kaptClasspathArtifacts", "", "getKaptClasspathArtifacts", "getKaptExtension", "()Lorg/jetbrains/kotlin/gradle/plugin/KaptExtension;", "getKaptVariantData", "()Lorg/jetbrains/kotlin/gradle/internal/KaptVariantData;", "getKotlinCompile", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "kotlinSourcesOutputDir", "getKotlinSourcesOutputDir", "getProject", "()Lorg/gradle/api/Project;", "getSourceSetName", "()Ljava/lang/String;", "sourcesOutputDir", "getSourcesOutputDir", "kotlin-gradle-plugin"})
    private final class Kapt3SubpluginContext {
        @NotNull
        private final File sourcesOutputDir;
        @NotNull
        private final File kotlinSourcesOutputDir;
        @NotNull
        private final File classesOutputDir;
        @NotNull
        private final List<File> kaptClasspathArtifacts;
        @NotNull
        private final Project project;
        @NotNull
        private final KotlinCompile kotlinCompile;
        @NotNull
        private final AbstractCompile javaCompile;
        @Nullable
        private final KaptVariantData<?> kaptVariantData;
        @NotNull
        private final String sourceSetName;
        @NotNull
        private final KaptExtension kaptExtension;
        @NotNull
        private final List<File> kaptClasspath;

        @NotNull
        public final File getSourcesOutputDir() {
            return this.sourcesOutputDir;
        }

        @NotNull
        public final File getKotlinSourcesOutputDir() {
            return this.kotlinSourcesOutputDir;
        }

        @NotNull
        public final File getClassesOutputDir() {
            return this.classesOutputDir;
        }

        @NotNull
        public final List<File> getKaptClasspathArtifacts() {
            return this.kaptClasspathArtifacts;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final KotlinCompile getKotlinCompile() {
            return this.kotlinCompile;
        }

        @NotNull
        public final AbstractCompile getJavaCompile() {
            return this.javaCompile;
        }

        @Nullable
        public final KaptVariantData<?> getKaptVariantData() {
            return this.kaptVariantData;
        }

        @NotNull
        public final String getSourceSetName() {
            return this.sourceSetName;
        }

        @NotNull
        public final KaptExtension getKaptExtension() {
            return this.kaptExtension;
        }

        @NotNull
        public final List<File> getKaptClasspath() {
            return this.kaptClasspath;
        }

        /*
         * WARNING - void declaration
         */
        public Kapt3SubpluginContext(@NotNull Project project, @NotNull KotlinCompile kotlinCompile, @Nullable AbstractCompile javaCompile, @NotNull KaptVariantData<?> kaptVariantData, @NotNull String sourceSetName, @NotNull KaptExtension kaptExtension, List<File> kaptClasspath) {
            List list;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)kotlinCompile, (String)"kotlinCompile");
            Intrinsics.checkParameterIsNotNull((Object)javaCompile, (String)"javaCompile");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            Intrinsics.checkParameterIsNotNull((Object)kaptExtension, (String)"kaptExtension");
            Intrinsics.checkParameterIsNotNull(kaptClasspath, (String)"kaptClasspath");
            this.project = project;
            this.kotlinCompile = kotlinCompile;
            this.javaCompile = javaCompile;
            this.kaptVariantData = kaptVariantData;
            this.sourceSetName = sourceSetName;
            this.kaptExtension = kaptExtension;
            this.kaptClasspath = kaptClasspath;
            this.sourcesOutputDir = Kapt3KotlinGradleSubplugin.this.getKaptGeneratedDir(this.project, this.sourceSetName);
            this.kotlinSourcesOutputDir = Kapt3KotlinGradleSubplugin.this.getKaptGeneratedDirForKotlin(this.project, this.sourceSetName);
            this.classesOutputDir = Companion.getKaptClasssesDir(this.project, this.sourceSetName);
            Map<KotlinGradleSubplugin<KotlinCompile>, List<File>> map = KotlinPluginKt.resolveSubpluginArtifacts(this.project, CollectionsKt.listOf((Object)Kapt3KotlinGradleSubplugin.this));
            Kapt3SubpluginContext kapt3SubpluginContext = this;
            void var10_11 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void var12_13 = $receiver$iv$iv;
            Iterator iterator = var12_13.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            kapt3SubpluginContext.kaptClasspathArtifacts = list = (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3KotlinGradleSubplugin$Companion;", "", "()V", "MAIN_KAPT_CONFIGURATION_NAME", "", "getMAIN_KAPT_CONFIGURATION_NAME", "()Ljava/lang/String;", "VERBOSE_OPTION_NAME", "getVERBOSE_OPTION_NAME", "findMainKaptConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "project", "Lorg/gradle/api/Project;", "getKaptClasssesDir", "Ljava/io/File;", "sourceSetName", "getKaptConfigurationName", "findKaptConfiguration", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final String getVERBOSE_OPTION_NAME() {
            return VERBOSE_OPTION_NAME;
        }

        @NotNull
        public final String getMAIN_KAPT_CONFIGURATION_NAME() {
            return MAIN_KAPT_CONFIGURATION_NAME;
        }

        @NotNull
        public final String getKaptConfigurationName(@NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            return Intrinsics.areEqual((Object)sourceSetName, (Object)"main") ^ true ? this.getMAIN_KAPT_CONFIGURATION_NAME() + StringsKt.capitalize((String)sourceSetName) : this.getMAIN_KAPT_CONFIGURATION_NAME();
        }

        @Nullable
        public final Configuration findKaptConfiguration(@NotNull Project $receiver, @NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            return (Configuration)$receiver.getProject().getConfigurations().findByName(this.getKaptConfigurationName(sourceSetName));
        }

        @Nullable
        public final Configuration findMainKaptConfiguration(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return this.findKaptConfiguration(project, this.getMAIN_KAPT_CONFIGURATION_NAME());
        }

        @NotNull
        public final File getKaptClasssesDir(@NotNull Project project, @NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            return new File(project.getProject().getBuildDir(), "tmp/kapt3/classes/" + sourceSetName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

