/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.Kotlin2JsPluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinJsDcePlugin;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinJsDce;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J0\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinJsDcePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "copyDependencies", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "outputDir", "Ljava/io/File;", "tmpDir", "dceTask", "Lorg/gradle/api/Task;", "processSourceSet", "Companion", "kotlin-gradle-plugin"})
public final class KotlinJsDcePlugin
implements Plugin<Project> {
    private static final String TASK_SUFFIX = "kotlinJs";
    private static final String UNPACK_DEPENDENCIES_TASK_PREFIX = "unpackDependencies";
    private static final String DEPENDENCIES_TASK_PREFIX = "copyDependencies";
    private static final String DCE_TASK_PREFIX = "runDce";
    private static final List<String> SUFFIXES;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getPluginManager().apply(Kotlin2JsPluginWrapper.class);
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSetContainer sourceSetContainer = javaPluginConvention.getSourceSets();
        if (sourceSetContainer != null) {
            Iterable $receiver$iv = (Iterable)sourceSetContainer;
            for (Object element$iv : $receiver$iv) {
                SourceSet it;
                SourceSet sourceSet = it = (SourceSet)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet, (String)"it");
                this.processSourceSet(project, sourceSet);
            }
        }
    }

    private final void processSourceSet(Project project, SourceSet sourceSet) {
        String kotlinTaskName = sourceSet.getCompileTaskName("kotlin2Js");
        Object object = project.getTasks().findByName(kotlinTaskName);
        if (!(object instanceof Kotlin2JsCompile)) {
            object = null;
        }
        Kotlin2JsCompile kotlin2JsCompile = (Kotlin2JsCompile)object;
        if (kotlin2JsCompile == null) {
            return;
        }
        Kotlin2JsCompile kotlinTask = kotlin2JsCompile;
        String dceTaskName = sourceSet.getTaskName(DCE_TASK_PREFIX, TASK_SUFFIX);
        Task task = project.getTasks().create(dceTaskName, KotlinJsDce.class);
        KotlinJsDce it = (KotlinJsDce)task;
        it.dependsOn(new Object[]{kotlinTask});
        Task task2 = (Task)project.getTasks().findByName("build");
        if (task2 != null) {
            task2.dependsOn(new Object[]{it});
        }
        KotlinJsDce dceTask = (KotlinJsDce)task;
        project.afterEvaluate((Action)new Action<Project>(this, kotlinTask, project, sourceSet, dceTask){
            final /* synthetic */ KotlinJsDcePlugin this$0;
            final /* synthetic */ Kotlin2JsCompile $kotlinTask;
            final /* synthetic */ Project $project;
            final /* synthetic */ SourceSet $sourceSet;
            final /* synthetic */ KotlinJsDce $dceTask;

            public final void execute(Project it) {
                KotlinJsDce kotlinJsDce;
                File outputDir = new File(this.$kotlinTask.getOutputFile()).getParentFile();
                File dependenciesDir = new File(outputDir, "dependencies");
                File dependenciesTemporaryDir = new File(outputDir, "dependencies-tmp");
                KotlinJsDce kotlinJsDce2 = this.$dceTask;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinJsDce2, (String)"dceTask");
                KotlinJsDcePlugin.access$copyDependencies(this.this$0, this.$project, this.$sourceSet, dependenciesDir, dependenciesTemporaryDir, kotlinJsDce2);
                List dceInputTrees = CollectionsKt.listOf((Object[])new ConfigurableFileTree[]{this.$project.fileTree((Object)this.$kotlinTask.getOutputFile()), this.$project.fileTree((Object)dependenciesDir)});
                UnionFileTree dceInputFiles = new UnionFileTree("dce-input", (Collection)dceInputTrees);
                KotlinJsDce $receiver = kotlinJsDce = this.$dceTask;
                $receiver.setClasspath(this.$sourceSet.getCompileClasspath());
                $receiver.setDestinationDir(new File(outputDir, "min"));
                $receiver.source(new Object[]{dceInputFiles.filter((Spec)processSourceSet.1.1.INSTANCE)});
            }
            {
                this.this$0 = kotlinJsDcePlugin;
                this.$kotlinTask = kotlin2JsCompile;
                this.$project = project;
                this.$sourceSet = sourceSet;
                this.$dceTask = kotlinJsDce;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void copyDependencies(Project project, SourceSet sourceSet, File outputDir, File tmpDir, Task dceTask) {
        Collection<FileTree> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        UnionFileCollection unionFileCollection;
        Configuration configuration = (Configuration)project.getConfigurations().findByName(sourceSet.getCompileConfigurationName());
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = configuration;
        Iterable iterable = (Iterable)configuration2;
        UnionFileCollection unionFileCollection2 = unionFileCollection;
        UnionFileCollection unionFileCollection3 = unionFileCollection;
        void var9_10 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            FileTree fileTree = project.zipTree((Object)it);
            collection.add(fileTree);
        }
        collection = (List)destination$iv$iv;
        unionFileCollection2((Iterable)collection);
        UnionFileCollection zippedFiles = unionFileCollection3;
        FileCollection files2 = project.fileTree((Object)tmpDir).filter((Spec)copyDependencies.files.1.INSTANCE).filter((Spec)copyDependencies.files.2.INSTANCE);
        String unpackName = sourceSet.getTaskName(UNPACK_DEPENDENCIES_TASK_PREFIX, TASK_SUFFIX);
        Task task = project.getTasks().create(unpackName, Copy.class);
        Copy $receiver = (Copy)task;
        $receiver.from(new Object[]{zippedFiles});
        $receiver.into((Object)tmpDir);
        Copy unpackTask = (Copy)task;
        String name = sourceSet.getTaskName(DEPENDENCIES_TASK_PREFIX, TASK_SUFFIX);
        Task task2 = project.getTasks().create(name, Copy.class);
        Copy $receiver2 = (Copy)task2;
        $receiver2.from(new Object[]{files2});
        $receiver2.into((Object)outputDir);
        $receiver2.setIncludeEmptyDirs(true);
        dceTask.dependsOn(new Object[]{$receiver2});
        $receiver2.dependsOn(new Object[]{unpackTask});
    }

    static {
        Companion = new Companion(null);
        SUFFIXES = CollectionsKt.listOf((Object[])new String[]{".js", ".js.map"});
    }

    public static final /* synthetic */ void access$copyDependencies(KotlinJsDcePlugin $this, @NotNull Project project, @NotNull SourceSet sourceSet, @NotNull File outputDir, @NotNull File tmpDir, @NotNull Task dceTask) {
        $this.copyDependencies(project, sourceSet, outputDir, tmpDir, dceTask);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinJsDcePlugin$Companion;", "", "()V", "DCE_TASK_PREFIX", "", "DEPENDENCIES_TASK_PREFIX", "SUFFIXES", "", "getSUFFIXES", "()Ljava/util/List;", "TASK_SUFFIX", "UNPACK_DEPENDENCIES_TASK_PREFIX", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final List<String> getSUFFIXES() {
            return SUFFIXES;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$getSUFFIXES$p(Companion $this) {
            return $this.getSUFFIXES();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

