/*
 * Copyright 2010-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.kotlin.gradle.utils

import java.lang.reflect.Field
import java.lang.reflect.InvocationTargetException

internal fun Class<*>.getDeclaredFieldInHierarchy(name: String): Field? {
    val inheritanceChain = generateSequence(this) { it.superclass }
    return inheritanceChain.map {
        try {
            it.getDeclaredField(name)
        } catch (_: NoSuchFieldException) {
            null
        }
    }.filterNotNull().first()
}

internal inline fun <T> checkedReflection(block: () -> T, onReflectionException: (Exception) -> T): T {
    return try {
        block()
    }
    catch (e: InvocationTargetException) {
        throw e.targetException
    }
    catch (e: ReflectiveOperationException) {
        onReflectionException(e)
    }
    catch (e: IllegalArgumentException) {
        onReflectionException(e)
    }
}