/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.model.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.model.CompilerArguments;
import org.jetbrains.kotlin.gradle.model.ExperimentalFeatures;
import org.jetbrains.kotlin.gradle.model.KotlinProject;
import org.jetbrains.kotlin.gradle.model.SourceSet;
import org.jetbrains.kotlin.gradle.model.impl.CompilerArgumentsImpl;
import org.jetbrains.kotlin.gradle.model.impl.ExperimentalFeaturesImpl;
import org.jetbrains.kotlin.gradle.model.impl.KotlinProjectImpl;
import org.jetbrains.kotlin.gradle.model.impl.SourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "kotlinPluginVersion", "", "(Ljava/lang/String;)V", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "kotlin-gradle-plugin"})
public final class KotlinModelBuilder
implements ToolingModelBuilder {
    private final String kotlinPluginVersion;
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName())) {
            void $receiver$iv$iv;
            void $receiver$iv;
            TaskCollection kotlinCompileTasks = project.getTasks().withType(AbstractKotlinCompile.class);
            KotlinProject.ProjectType projectType = KotlinModelBuilder.Companion.getProjectType(project);
            String string = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            TaskCollection taskCollection = kotlinCompileTasks;
            Intrinsics.checkExpressionValueIsNotNull((Object)taskCollection, (String)"kotlinCompileTasks");
            Iterable iterable = (Iterable)taskCollection;
            KotlinProject.ProjectType projectType2 = projectType;
            String string2 = this.kotlinPluginVersion;
            String string3 = string;
            void var6_9 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SourceSet sourceSet;
                AbstractKotlinCompile it;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                AbstractKotlinCompile abstractKotlinCompile = it = (AbstractKotlinCompile)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractKotlinCompile, (String)"it");
                if (KotlinModelBuilder.Companion.createSourceSet(abstractKotlinCompile, project, projectType) == null) continue;
                SourceSet it$iv$iv = sourceSet;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Collection collection = list;
            Collection collection2 = KotlinModelBuilder.Companion.getExpectedByDependencies(project);
            Object object = CollectionsKt.first((Iterable)((Iterable)kotlinCompileTasks));
            if (object == null) {
                Intrinsics.throwNpe();
            }
            ExperimentalFeatures experimentalFeatures = KotlinModelBuilder.Companion.createExperimentalFeatures((AbstractKotlinCompile)object);
            Collection collection3 = collection2;
            Collection collection4 = collection;
            KotlinProject.ProjectType projectType3 = projectType2;
            String string4 = string2;
            String string5 = string3;
            return new KotlinProjectImpl(string5, string4, projectType3, collection4, collection3, experimentalFeatures);
        }
        return null;
    }

    public KotlinModelBuilder(@NotNull String kotlinPluginVersion) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0014\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00050\u0005*\u00020\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion;", "", "()V", "getExpectedByDependencies", "", "", "project", "Lorg/gradle/api/Project;", "getProjectType", "Lorg/jetbrains/kotlin/gradle/model/KotlinProject$ProjectType;", "createCompilerArguments", "Lorg/jetbrains/kotlin/gradle/model/CompilerArguments;", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompile;", "createExperimentalFeatures", "Lorg/jetbrains/kotlin/gradle/model/ExperimentalFeatures;", "createSourceSet", "Lorg/jetbrains/kotlin/gradle/model/SourceSet;", "projectType", "findFriendSourceSets", "pathOrName", "kotlin.jvm.PlatformType", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final KotlinProject.ProjectType getProjectType(Project project) {
            return project.getPlugins().hasPlugin("kotlin") || project.getPlugins().hasPlugin("kotlin-platform-jvm") ? KotlinProject.ProjectType.PLATFORM_JVM : (project.getPlugins().hasPlugin("kotlin2js") || project.getPlugins().hasPlugin("kotlin-platform-js") ? KotlinProject.ProjectType.PLATFORM_JS : KotlinProject.ProjectType.PLATFORM_COMMON);
        }

        private final Collection<String> getExpectedByDependencies(Project project) {
            String it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = CollectionsKt.listOf((Object[])new String[]{"expectedBy", "implement"});
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (String)element$iv$iv;
                Configuration configuration = (Configuration)project.getConfigurations().findByName(it);
                Iterable list$iv$iv = configuration != null && (configuration = configuration.getDependencies()) != null ? (Set)configuration : SetsKt.emptySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof ProjectDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Project project2;
                Object element$iv$iv = element$iv$iv$iv;
                ProjectDependency it2 = (ProjectDependency)element$iv$iv;
                if (it2.getDependencyProject() == null) continue;
                Project it$iv$iv = project2;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                Object element$iv$iv$iv;
                element$iv$iv$iv = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string = Companion.pathOrName((Project)it);
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        private final String pathOrName(@NotNull Project $receiver) {
            return Intrinsics.areEqual((Object)$receiver.getPath(), (Object)":") ? $receiver.getName() : $receiver.getPath();
        }

        private final SourceSet createSourceSet(@NotNull AbstractKotlinCompile<?> $receiver, Project project, KotlinProject.ProjectType projectType) {
            SourceSet sourceSet;
            KotlinSourceSet kotlinSourceSet;
            Object object;
            org.gradle.api.tasks.SourceSet javaSourceSet;
            org.gradle.api.tasks.SourceSet sourceSet2;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention != null && (javaPluginConvention = javaPluginConvention.getSourceSets()) != null) {
                Object v2;
                block6: {
                    Iterable iterable;
                    Iterable iterable2 = iterable = (Iterable)javaPluginConvention;
                    for (Object t : iterable2) {
                        org.gradle.api.tasks.SourceSet it;
                        org.gradle.api.tasks.SourceSet sourceSet3 = it = (org.gradle.api.tasks.SourceSet)t;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet3, (String)"it");
                        if (!Intrinsics.areEqual((Object)sourceSet3.getName(), (Object)$receiver.getSourceSetName$kotlin_gradle_plugin())) continue;
                        v2 = t;
                        break block6;
                    }
                    v2 = null;
                }
                sourceSet2 = v2;
            } else {
                sourceSet2 = null;
            }
            org.gradle.api.tasks.SourceSet sourceSet4 = javaSourceSet = sourceSet2;
            if (!((sourceSet4 != null ? GradleUtilsKt.getConvention(sourceSet4, projectType == KotlinProject.ProjectType.PLATFORM_JS ? KotlinPluginKt.getKOTLIN_JS_DSL_NAME() : KotlinPluginKt.getKOTLIN_DSL_NAME()) : (object = null)) instanceof KotlinSourceSet)) {
                object = null;
            }
            if ((kotlinSourceSet = (KotlinSourceSet)object) != null) {
                String string = $receiver.getSourceSetName$kotlin_gradle_plugin();
                SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)$receiver.getSourceSetName$kotlin_gradle_plugin(), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
                Collection<String> collection = this.findFriendSourceSets($receiver);
                Set set = kotlinSourceSet.getKotlin().getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"kotlinSourceSet.kotlin.srcDirs");
                Collection collection2 = set;
                SourceDirectorySet sourceDirectorySet = javaSourceSet.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceDirectorySet, (String)"javaSourceSet.resources");
                Set set2 = sourceDirectorySet.getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"javaSourceSet.resources.srcDirs");
                Collection collection3 = set2;
                File file = $receiver.getDestinationDir();
                SourceSetOutput sourceSetOutput = javaSourceSet.getOutput();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetOutput, (String)"javaSourceSet.output");
                File file2 = sourceSetOutput.getResourcesDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"javaSourceSet.output.resourcesDir");
                sourceSet = new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, file, file2, this.createCompilerArguments($receiver));
            } else {
                sourceSet = null;
            }
            return sourceSet;
        }

        private final Collection<String> findFriendSourceSets(@NotNull AbstractKotlinCompile<?> $receiver) {
            ArrayList<Object> friendSourceSets;
            block0: {
                AbstractKotlinCompile<?> abstractKotlinCompile;
                friendSourceSets = new ArrayList<Object>();
                AbstractKotlinCompile<?> abstractKotlinCompile2 = $receiver.getFriendTask$kotlin_gradle_plugin();
                if (abstractKotlinCompile2 == null || (abstractKotlinCompile2 = abstractKotlinCompile2.getSourceSetName$kotlin_gradle_plugin()) == null) break block0;
                AbstractKotlinCompile<?> it = abstractKotlinCompile = abstractKotlinCompile2;
                friendSourceSets.add(it);
            }
            return friendSourceSets;
        }

        private final CompilerArguments createCompilerArguments(@NotNull AbstractKotlinCompile<?> $receiver) {
            return new CompilerArgumentsImpl($receiver.getSerializedCompilerArguments(), $receiver.getDefaultSerializedCompilerArguments(), CollectionsKt.toList($receiver.getCompileClasspath$kotlin_gradle_plugin()));
        }

        private final ExperimentalFeatures createExperimentalFeatures(@NotNull AbstractKotlinCompile<?> $receiver) {
            return new ExperimentalFeaturesImpl($receiver.getCoroutinesStr$kotlin_gradle_plugin());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

