/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinConfigurationTools;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.LegacyAndroidAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.tasks.AndroidTasksProvider;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "kotlinPluginVersion", "", "(Ljava/lang/String;)V", "apply", "", "project", "Companion", "kotlin-gradle-plugin"})
public class KotlinAndroidPlugin
implements Plugin<Project> {
    private final String kotlinPluginVersion;
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KotlinAndroidTarget androidTarget = new KotlinAndroidTarget("", project);
        AndroidTasksProvider tasksProvider = new AndroidTasksProvider(androidTarget.getTargetName());
        Companion.applyToTarget(project, androidTarget, tasksProvider, this.kotlinPluginVersion);
    }

    public KotlinAndroidPlugin(@NotNull String kotlinPluginVersion) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin$Companion;", "", "()V", "applyToTarget", "", "project", "Lorg/gradle/api/Project;", "kotlinTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "kotlinPluginVersion", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        public final void applyToTarget(@NotNull Project project, @NotNull KotlinAndroidTarget kotlinTarget, @NotNull KotlinTasksProvider tasksProvider, @NotNull String kotlinPluginVersion) {
            AbstractAndroidProjectHandler abstractAndroidProjectHandler;
            String minimalVersion;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)kotlinTarget, (String)"kotlinTarget");
            Intrinsics.checkParameterIsNotNull((Object)tasksProvider, (String)"tasksProvider");
            Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            String version = KotlinPluginKt.loadAndroidPluginVersion();
            if (version != null && KotlinPluginKt.compareVersionNumbers(version, minimalVersion = "1.1.0") < 0) {
                throw (Throwable)new IllegalStateException("Kotlin: Unsupported version of com.android.tools.build:gradle plugin: version " + minimalVersion + " or higher should be used with kotlin-android plugin");
            }
            KotlinConfigurationTools kotlinTools = new KotlinConfigurationTools(tasksProvider, kotlinPluginVersion);
            String legacyVersionThreshold = "2.5.0";
            if (KotlinPluginKt.compareVersionNumbers(version, legacyVersionThreshold) < 0) {
                abstractAndroidProjectHandler = new LegacyAndroidAndroidProjectHandler(kotlinTools);
            } else {
                Class<?> android25ProjectHandlerClass;
                Class<?> clazz = android25ProjectHandlerClass = Class.forName("org.jetbrains.kotlin.gradle.plugin.Android25ProjectHandler");
                Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"android25ProjectHandlerClass");
                Constructor<?>[] constructorArray = clazz.getConstructors();
                Intrinsics.checkExpressionValueIsNotNull(constructorArray, (String)"android25ProjectHandlerClass.constructors");
                Constructor<?>[] $receiver$iv = constructorArray;
                Constructor<?> single$iv = null;
                boolean found$iv = false;
                int n = $receiver$iv.length;
                for (int j = 0; j < n; ++j) {
                    Object[] objectArray;
                    Constructor<?> element$iv;
                    Constructor<?> it;
                    Constructor<?> constructor = it = (element$iv = $receiver$iv[j]);
                    Intrinsics.checkExpressionValueIsNotNull(constructor, (String)"it");
                    Intrinsics.checkExpressionValueIsNotNull(constructor.getParameterTypes(), (String)"it.parameterTypes");
                    Object[] objectArray2 = new Class[]{kotlinTools.getClass()};
                    if (!Arrays.equals(objectArray, objectArray2)) continue;
                    if (found$iv) {
                        throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
                }
                Constructor<?> ctor = single$iv;
                Object t = ctor.newInstance(kotlinTools);
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler<*>");
                }
                abstractAndroidProjectHandler = (AbstractAndroidProjectHandler)t;
            }
            AbstractAndroidProjectHandler variantProcessor = abstractAndroidProjectHandler;
            variantProcessor.handleProject(project, kotlinTarget);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

