/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.sources.ConsistencyCheck;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J0\u0010\r\u001a\u00020\n\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000e0\u0004R!\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/SourceSetConsistencyChecker;", "", "checks", "", "Lorg/jetbrains/kotlin/gradle/plugin/sources/ConsistencyCheck;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "(Ljava/util/List;)V", "getChecks", "()Ljava/util/List;", "runAllChecks", "", "dependent", "dependency", "runSingleCheck", "S", "check", "kotlin-gradle-plugin"})
public final class SourceSetConsistencyChecker {
    @NotNull
    private final List<ConsistencyCheck<KotlinSourceSet, ?>> checks;

    public final <S> void runSingleCheck(@NotNull KotlinSourceSet dependent, @NotNull KotlinSourceSet dependency, @NotNull ConsistencyCheck<KotlinSourceSet, S> check) {
        Intrinsics.checkParameterIsNotNull((Object)dependent, (String)"dependent");
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Intrinsics.checkParameterIsNotNull(check, (String)"check");
        Object leftValue = check.getGetValue().invoke((Object)dependent);
        Object rightValue = check.getGetValue().invoke((Object)dependency);
        if (!((Boolean)check.getLeftExtendsRightConsistently().invoke(leftValue, rightValue)).booleanValue()) {
            throw (Throwable)new InvalidUserDataException("Inconsistent settings for Kotlin source sets: '" + dependent.getName() + "' depends on '" + dependency.getName() + "'\n" + '\'' + dependent.getName() + "': " + check.getName() + " is " + leftValue + '\n' + '\'' + dependency.getName() + "': " + check.getName() + " is " + rightValue + '\n' + check.getConsistencyConditionHint());
        }
    }

    public final void runAllChecks(@NotNull KotlinSourceSet dependent, @NotNull KotlinSourceSet dependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependent, (String)"dependent");
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        for (ConsistencyCheck<KotlinSourceSet, ?> check : this.checks) {
            this.runSingleCheck(dependent, dependency, check);
        }
    }

    @NotNull
    public final List<ConsistencyCheck<KotlinSourceSet, ?>> getChecks() {
        return this.checks;
    }

    public SourceSetConsistencyChecker(@NotNull List<? extends ConsistencyCheck<KotlinSourceSet, ?>> checks) {
        Intrinsics.checkParameterIsNotNull(checks, (String)"checks");
        this.checks = checks;
    }
}

