/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileIterationResult;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilationResults;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "Ljava/rmi/server/UnicastRemoteObject;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "projectRootFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/io/File;)V", "add", "", "compilationResultCategory", "", "value", "Ljava/io/Serializable;", "kotlin-gradle-plugin"})
public final class GradleCompilationResults
extends UnicastRemoteObject
implements CompilationResults {
    private final KotlinLogger log;
    private final File projectRootFile;

    public void add(int compilationResultCategory, @NotNull Serializable value) throws RemoteException {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (compilationResultCategory == CompilationResultCategory.IC_COMPILE_ITERATION.getCode()) {
            CompileIterationResult compileIterationResult;
            Serializable serializable = value;
            if (!(serializable instanceof CompileIterationResult)) {
                serializable = null;
            }
            if ((compileIterationResult = (CompileIterationResult)serializable) != null) {
                KotlinLogger $receiver$iv;
                Iterable sourceFiles = compileIterationResult.getSourceFiles();
                if (CollectionsKt.any((Iterable)sourceFiles) && ($receiver$iv = this.log).isDebugEnabled()) {
                    String msg$iv = "compile iteration: " + FileUtilsKt.pathsAsStringRelativeTo(sourceFiles, this.projectRootFile);
                    $receiver$iv.debug("[KOTLIN] " + msg$iv);
                }
                String exitCode = compileIterationResult.getExitCode();
                KotlinLogger $receiver$iv2 = this.log;
                if ($receiver$iv2.isDebugEnabled()) {
                    String msg$iv = "compiler exit code: " + exitCode;
                    $receiver$iv2.debug("[KOTLIN] " + msg$iv);
                }
            }
        }
    }

    public GradleCompilationResults(@NotNull KotlinLogger log, @NotNull File projectRootFile) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)projectRootFile, (String)"projectRootFile");
        super(0, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.log = log;
        this.projectRootFile = projectRootFile;
    }
}

