/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporter;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterKt$configureBuildReporter$1$$special$;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"configureBuildReporter", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin-gradle-plugin"})
public final class KotlinBuildReporterKt {
    public static final void configureBuildReporter(@NotNull Gradle gradle, @NotNull Logger log) {
        File perfLogDir;
        Project rootProject;
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Project project = rootProject = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        PropertiesProvider properties = new PropertiesProvider(project);
        if (!properties.getBuildReportEnabled()) {
            return;
        }
        File file = properties.getBuildReportDir();
        if (file == null) {
            File file2 = rootProject.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootProject.buildDir");
            File file3 = FilesKt.resolve((File)file2, (String)"reports/kotlin-build");
            boolean bl = false;
            boolean bl2 = false;
            File $receiver = file3;
            boolean bl3 = false;
            $receiver.mkdirs();
            file = perfLogDir = file3;
        }
        if (perfLogDir.isFile()) {
            log.error("Kotlin build report cannot be created: '" + perfLogDir + "' is a file");
            return;
        }
        perfLogDir.mkdirs();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        String ts = simpleDateFormat.format(calendar.getTime());
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"gradle.rootProject");
        File perfReportFile = FilesKt.resolve((File)perfLogDir, (String)stringBuilder.append(project2.getName()).append("-build-").append(ts).append(".txt").toString());
        KotlinBuildReporter reporter = new KotlinBuildReporter(gradle, perfReportFile);
        gradle.addBuildListener((BuildListener)reporter);
        BuildReportMode buildReportMode = properties.getBuildReportVerbose() ? BuildReportMode.VERBOSE : BuildReportMode.SIMPLE;
        gradle.getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(buildReportMode){
            final /* synthetic */ BuildReportMode $buildReportMode;

            public final void execute(TaskExecutionGraph graph) {
                TaskExecutionGraph taskExecutionGraph = graph;
                Intrinsics.checkExpressionValueIsNotNull((Object)taskExecutionGraph, (String)"graph");
                List list2 = taskExecutionGraph.getAllTasks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"graph.allTasks");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list2);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)configureBuildReporter$1$$special$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$forEach$iv = sequence;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv;
                    boolean bl = false;
                    it.setBuildReportMode$kotlin_gradle_plugin(this.$buildReportMode);
                }
            }
            {
                this.$buildReportMode = buildReportMode;
            }
        });
        Logger $receiver$iv = log;
        boolean $i$f$kotlinDebug = false;
        if ($receiver$iv.isDebugEnabled()) {
            Logger logger = $receiver$iv;
            boolean bl = false;
            String string = "Configured Kotlin build reporter";
            GradleLoggingUtilsKt.kotlinDebug(logger, string);
        }
    }
}

