/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerRunner;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0010J\u001d\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\rH\u0002J\u000f\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/BuildAdapter;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "(Lorg/gradle/api/invocation/Gradle;)V", "loadedInProjectPath", "", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "shouldReportMemoryUsage", "", "startMemory", "", "Ljava/lang/Long;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "detectKotlinPluginLoadedInMultipleProjects", "project", "Lorg/gradle/api/Project;", "kotlinPluginVersion", "detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin", "getGcCount", "getUsedMemoryKb", "()Ljava/lang/Long;", "Companion", "kotlin-gradle-plugin"})
public final class KotlinGradleBuildServices
extends BuildAdapter {
    private final Logger log;
    private Long startMemory;
    private final boolean shouldReportMemoryUsage;
    private String loadedInProjectPath;
    private final Gradle gradle;
    private static final String CLASS_NAME;
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    @NotNull
    public static final String SHOULD_REPORT_MEMORY_USAGE_PROPERTY = "kotlin.gradle.test.report.memory.usage";
    @NotNull
    private static final String INIT_MESSAGE;
    @NotNull
    private static final String DISPOSE_MESSAGE;
    @NotNull
    private static final String ALREADY_INITIALIZED_MESSAGE;
    private static volatile KotlinGradleBuildServices instance;
    public static final Companion Companion;

    public final void buildStarted() {
        this.startMemory = this.getUsedMemoryKb();
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
        Logger logger = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        KotlinBuildReporterKt.configureBuildReporter(this.gradle, logger);
    }

    public void buildFinished(@NotNull BuildResult result2) {
        CharSequence charSequence;
        Logger logger;
        Project rootProject;
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
        Gradle gradle = result2.getGradle();
        if (gradle == null) {
            Intrinsics.throwNpe();
        }
        Gradle gradle2 = gradle;
        GradleCompilerRunner.Companion.clearBuildModulesInfo$kotlin_gradle_plugin();
        Gradle gradle3 = gradle2;
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"gradle");
        Project project = rootProject = gradle3.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        File sessionsDir = GradleCompilerRunner.Companion.sessionsDir$kotlin_gradle_plugin(project);
        if (sessionsDir.exists()) {
            File[] sessionFiles = sessionsDir.listFiles();
            if (sessionFiles.length > 1) {
                this.log.warn("w: Detected multiple Kotlin daemon sessions at " + FileUtilsKt.relativeToRoot(sessionsDir, rootProject));
            }
            for (File file : sessionFiles) {
                Logger $receiver$iv;
                file.delete();
                Intrinsics.checkExpressionValueIsNotNull((Object)this.log, (String)"log");
                boolean $i$f$kotlinDebug = false;
                if (!$receiver$iv.isDebugEnabled()) continue;
                logger = $receiver$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Deleted session-is-alive flag file: ");
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                charSequence = stringBuilder.append(FileUtilsKt.relativeToRoot(file2, rootProject)).toString();
                GradleLoggingUtilsKt.kotlinDebug(logger, (String)charSequence);
            }
        }
        if (this.shouldReportMemoryUsage) {
            Long l = this.startMemory;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            long startMem = l;
            Long l2 = this.getUsedMemoryKb();
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long endMem = l2;
            String string = "%+d";
            Object[] objectArray = new Object[]{endMem - startMem};
            charSequence = new StringBuilder().append("[KOTLIN][PERF] Used memory after build: ").append(endMem).append(" kb (difference since build start: ");
            logger = this.log;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
            String string3 = string2;
            logger.lifecycle(((StringBuilder)charSequence).append(string3).append(" kb)").toString());
        }
        gradle2.removeListener((Object)this);
        instance = null;
        Logger logger2 = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger2, DISPOSE_MESSAGE);
    }

    private final Long getUsedMemoryKb() {
        if (!this.shouldReportMemoryUsage) {
            return null;
        }
        this.log.lifecycle(FORCE_SYSTEM_GC_MESSAGE);
        long gcCountBefore = this.getGcCount();
        System.gc();
        while (this.getGcCount() == gcCountBefore) {
        }
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / (long)1024;
    }

    /*
     * WARNING - void declaration
     */
    private final long getGcCount() {
        void var3_3;
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable $this$sumByLong$iv = list2;
        boolean $i$f$sumByLong = false;
        long sum$iv = 0L;
        for (Object element$iv : $this$sumByLong$iv) {
            void it;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)element$iv;
            long l = sum$iv;
            boolean bl = false;
            long l2 = 0L;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            long l3 = v1.getCollectionCount();
            boolean bl2 = false;
            long l4 = Math.max(l2, l3);
            sum$iv = l + l4;
        }
        return (long)var3_3;
    }

    public final synchronized void detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin(@NotNull Project project, @NotNull String kotlinPluginVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        String projectPath = project.getPath();
        String loadedInProjectsPropertyName = "kotlin.plugin.loaded.in.projects." + kotlinPluginVersion;
        if (this.loadedInProjectPath == null) {
            this.loadedInProjectPath = projectPath;
            Project project2 = project.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
            ExtraPropertiesExtension ext = (ExtraPropertiesExtension)project2.getExtensions().getByType(ExtraPropertiesExtension.class);
            if (!ext.has(loadedInProjectsPropertyName)) {
                ext.set(loadedInProjectsPropertyName, (Object)projectPath);
                this.gradle.getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(ext, loadedInProjectsPropertyName, project){
                    final /* synthetic */ ExtraPropertiesExtension $ext;
                    final /* synthetic */ String $loadedInProjectsPropertyName;
                    final /* synthetic */ Project $project;

                    public final void execute(TaskExecutionGraph it) {
                        Object object = this.$ext.get(this.$loadedInProjectsPropertyName);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        List loadedInProjects = StringsKt.split$default((CharSequence)((String)object), (String[])new String[]{";"}, (boolean)false, (int)0, (int)6, null);
                        if (loadedInProjects.size() > 1) {
                            if (Intrinsics.areEqual((Object)new PropertiesProvider(this.$project).getIgnorePluginLoadedInMultipleProjects(), (Object)true) ^ true) {
                                this.$project.getLogger().warn("\nThe Kotlin Gradle plugin was loaded multiple times in different subprojects, which is not supported and may break the build. \nThis might happen in subprojects that apply the Kotlin plugins with the Gradle 'plugins { ... }' DSL if they specify explicit versions, even if the versions are equal.\nPlease add the Kotlin plugin to the common parent project or the root project, then remove the versions in the subprojects.\nIf the parent project does not need the plugin, add 'apply false' to the plugin line.\nSee: https://docs.gradle.org/current/userguide/plugins.html#sec:subprojects_plugins_dsl");
                                this.$project.getLogger().warn("The Kotlin plugin was loaded in the following projects: " + CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)4, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.1.INSTANCE, (int)23, null));
                            }
                            this.$project.getLogger().info("The full list of projects that loaded the Kotlin plugin is: : " + CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)0, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.2.INSTANCE, (int)31, null));
                        }
                    }
                    {
                        this.$ext = extraPropertiesExtension;
                        this.$loadedInProjectsPropertyName = string;
                        this.$project = project;
                    }
                });
            } else {
                Object object = ext.get(loadedInProjectsPropertyName);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                ext.set(loadedInProjectsPropertyName, (Object)((String)object + ";" + this.loadedInProjectPath));
            }
        }
    }

    private KotlinGradleBuildServices(Gradle gradle) {
        this.gradle = gradle;
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
        this.shouldReportMemoryUsage = System.getProperty(SHOULD_REPORT_MEMORY_USAGE_PROPERTY) != null;
    }

    static {
        Companion = new Companion(null);
        CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
        INIT_MESSAGE = "Initialized " + CLASS_NAME;
        DISPOSE_MESSAGE = "Disposed " + CLASS_NAME;
        ALREADY_INITIALIZED_MESSAGE = CLASS_NAME + " is already initialized";
    }

    public /* synthetic */ KotlinGradleBuildServices(Gradle gradle, DefaultConstructorMarker $constructor_marker) {
        this(gradle);
    }

    @JvmStatic
    @NotNull
    public static final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
        return Companion.getInstance(gradle);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "ALREADY_INITIALIZED_MESSAGE", "", "getALREADY_INITIALIZED_MESSAGE", "()Ljava/lang/String;", "CLASS_NAME", "kotlin.jvm.PlatformType", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "FORCE_SYSTEM_GC_MESSAGE", "INIT_MESSAGE", "getINIT_MESSAGE", "SHOULD_REPORT_MEMORY_USAGE_PROPERTY", "instance", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "getInstance", "gradle", "Lorg/gradle/api/invocation/Gradle;", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String getINIT_MESSAGE() {
            return INIT_MESSAGE;
        }

        @NotNull
        public final String getDISPOSE_MESSAGE() {
            return DISPOSE_MESSAGE;
        }

        @NotNull
        public final String getALREADY_INITIALIZED_MESSAGE() {
            return ALREADY_INITIALIZED_MESSAGE;
        }

        @JvmStatic
        @NotNull
        public final synchronized KotlinGradleBuildServices getInstance(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            Logger log2 = Logging.getLogger(KotlinGradleBuildServices.class);
            if (instance != null) {
                Logger logger = log2;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
                GradleLoggingUtilsKt.kotlinDebug(logger, this.getALREADY_INITIALIZED_MESSAGE());
                KotlinGradleBuildServices kotlinGradleBuildServices = instance;
                if (kotlinGradleBuildServices == null) {
                    Intrinsics.throwNpe();
                }
                return kotlinGradleBuildServices;
            }
            KotlinGradleBuildServices services = new KotlinGradleBuildServices(gradle, null);
            gradle.addBuildListener((BuildListener)services);
            instance = services;
            Logger logger = log2;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
            GradleLoggingUtilsKt.kotlinDebug(logger, this.getINIT_MESSAGE());
            services.buildStarted();
            return services;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

