/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.properties.KonanPropertiesLoader;
import org.jetbrains.kotlin.konan.util.DependencyDownloader;
import org.jetbrains.kotlin.konan.util.DependencyExtractor;
import org.jetbrains.kotlin.konan.util.DependencyProcessor;
import org.jetbrains.kotlin.konan.util.DependencyProcessorKt;
import org.jetbrains.kotlin.konan.util.DependencySource;
import org.jetbrains.kotlin.konan.util.InternalServer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 D2\u00020\u0001:\u0002DEB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u000bj\u0002`\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fB\u00c2\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000e0\u0011\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0014\u001a\u00020\t\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012U\b\u0002\u0010\u0019\u001aO\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u001aj\u0004\u0018\u0001`!\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\"\u001a\u00020\t\u00a2\u0006\u0002\u0010#J\u0018\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u0007H\u0002J\u0010\u0010@\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u0007H\u0002J\u000e\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u0007J\u0006\u0010C\u001a\u00020 R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\"\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010%R\u0011\u0010-\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010+R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010(R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010%R\u0011\u00106\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010+R\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010%\"\u0004\b;\u0010<\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyProcessor;", "", "dependenciesRoot", "Ljava/io/File;", "properties", "Lorg/jetbrains/kotlin/konan/properties/KonanPropertiesLoader;", "dependenciesUrl", "", "keepUnstable", "", "(Ljava/io/File;Lorg/jetbrains/kotlin/konan/properties/KonanPropertiesLoader;Ljava/lang/String;Z)V", "Ljava/util/Properties;", "Lorg/jetbrains/kotlin/konan/properties/Properties;", "dependencies", "", "(Ljava/io/File;Ljava/util/Properties;Ljava/util/List;Ljava/lang/String;Z)V", "dependencyToCandidates", "", "Lorg/jetbrains/kotlin/konan/util/DependencySource;", "homeDependencyCache", "airplaneMode", "maxAttempts", "", "attemptIntervalMs", "", "customProgressCallback", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "url", "currentBytes", "totalBytes", "", "Lorg/jetbrains/kotlin/konan/util/ProgressCallback;", "deleteArchives", "(Ljava/io/File;Ljava/lang/String;Ljava/util/Map;Ljava/io/File;ZIJLkotlin/jvm/functions/Function3;ZZ)V", "getAirplaneMode", "()Z", "archiveExtension", "getArchiveExtension", "()Ljava/lang/String;", "cacheDirectory", "getCacheDirectory", "()Ljava/io/File;", "getDeleteArchives", "dependenciesDirectory", "getDependenciesDirectory", "getDependenciesUrl", "downloader", "Lorg/jetbrains/kotlin/konan/util/DependencyDownloader;", "extractor", "Lorg/jetbrains/kotlin/konan/util/DependencyExtractor;", "isInfoShown", "getKeepUnstable", "lockFile", "getLockFile", "resolvedDependencies", "showInfo", "getShowInfo", "setShowInfo", "(Z)V", "downloadDependency", "dependency", "baseUrl", "resolveDependency", "resolveRelative", "relative", "run", "Companion", "DependencyFile", "kotlin-native-shared"})
public final class DependencyProcessor {
    @NotNull
    private final File dependenciesDirectory;
    @NotNull
    private final File cacheDirectory;
    @NotNull
    private final File lockFile;
    private boolean showInfo;
    private boolean isInfoShown;
    private final DependencyDownloader downloader;
    private final DependencyExtractor extractor;
    private final Map<String, DependencySource> resolvedDependencies;
    @NotNull
    private final String dependenciesUrl;
    private final boolean airplaneMode;
    private final boolean keepUnstable;
    private final boolean deleteArchives;
    private static final ReentrantLock lock;
    @NotNull
    private static final Lazy localKonanDir$delegate;
    public static final Companion Companion;

    @NotNull
    public final File getDependenciesDirectory() {
        return this.dependenciesDirectory;
    }

    @NotNull
    public final File getCacheDirectory() {
        return this.cacheDirectory;
    }

    @NotNull
    public final File getLockFile() {
        return this.lockFile;
    }

    public final boolean getShowInfo() {
        return this.showInfo;
    }

    public final void setShowInfo(boolean bl) {
        this.showInfo = bl;
    }

    private final String getArchiveExtension() {
        return this.extractor.getArchiveExtension$kotlin_native_shared();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void downloadDependency(String dependency, String baseUrl) {
        boolean bl;
        File depDir = new File(this.dependenciesDirectory, dependency);
        String depName = depDir.getName();
        String fileName = depName + '.' + this.getArchiveExtension();
        File archive = FilesKt.resolve((File)this.cacheDirectory, (String)fileName);
        URL url = new URL(baseUrl + '/' + fileName);
        DependencyFile extractedDependencies = new DependencyFile(this.dependenciesDirectory, ".extracted");
        String string = depName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"depName");
        if (extractedDependencies.contains(string) && depDir.exists() && depDir.isDirectory()) {
            String[] stringArray = depDir.list();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"depDir.list()");
            String[] stringArray2 = stringArray;
            bl = false;
            String[] stringArray3 = stringArray2;
            boolean bl2 = false;
            if (!(stringArray3.length == 0)) {
                if (this.keepUnstable) return;
                Object[] objectArray = depDir.list();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"depDir.list()");
                if (!ArraysKt.contains((Object[])objectArray, (Object)".unstable")) return;
                FilesKt.deleteRecursively((File)depDir);
                archive.delete();
                extractedDependencies.removeAndSave(dependency);
            }
        }
        if (this.showInfo && !this.isInfoShown) {
            String string2 = "Downloading native dependencies (LLVM, sysroot etc). This is a one-time action performed only on the first run of the compiler.";
            bl = false;
            System.out.println((Object)string2);
            this.isInfoShown = true;
        }
        if (!archive.exists()) {
            if (this.airplaneMode) {
                throw (Throwable)new FileNotFoundException(StringsKt.trimIndent((String)("\n                    Cannot find a dependency locally: " + dependency + ".\n                    Set `airplaneMode = false` in konan.properties to download it.\n                ")));
            }
            DependencyDownloader.download$default(this.downloader, url, archive, null, 4, null);
        }
        String string3 = "Extracting dependency: " + archive + " into " + this.dependenciesDirectory;
        bl = false;
        System.out.println((Object)string3);
        this.extractor.extract(archive, this.dependenciesDirectory);
        if (this.deleteArchives) {
            archive.delete();
        }
        extractedDependencies.addAndSave(depName);
    }

    private final File resolveDependency(String dependency) {
        File file;
        DependencySource candidate2 = this.resolvedDependencies.get(dependency);
        DependencySource dependencySource = candidate2;
        if (dependencySource instanceof DependencySource.Local) {
            file = ((DependencySource.Local)candidate2).getPath();
        } else if (dependencySource instanceof DependencySource.Remote) {
            file = new File(this.dependenciesDirectory, dependency);
        } else {
            if (dependencySource == null) {
                String string = dependency + " not declared as dependency";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return file;
    }

    @NotNull
    public final File resolveRelative(@NotNull String relative) {
        File file;
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        Path path2 = path = Paths.get(relative, new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        if (path2.isAbsolute()) {
            String string = "not a relative path: " + relative;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String dependency = CollectionsKt.first((Iterable)path).toString();
        File file2 = this.resolveDependency(dependency);
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        if (path.getNameCount() > 1) {
            File file3 = it.toPath().resolve(path.subpath(1, path.getNameCount())).toFile();
            file = file3;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.toPath().resolve(path\u2026path.nameCount)).toFile()");
        } else {
            file = it;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Lock lock = DependencyProcessor.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            AutoCloseable $receiver$iv = new RandomAccessFile(this.lockFile, "rw").getChannel().lock();
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                FileLock it = (FileLock)$receiver$iv;
                boolean bl3 = false;
                Map<String, DependencySource> $receiver$iv2 = this.resolvedDependencies;
                boolean $i$f$forEach = false;
                Map<String, DependencySource> map2 = $receiver$iv2;
                boolean bl4 = false;
                Iterator<Map.Entry<String, DependencySource>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    String baseUrl;
                    String string;
                    Map.Entry<String, DependencySource> element$iv;
                    Map.Entry<String, DependencySource> $dependency_candidate = element$iv = iterator.next();
                    boolean bl5 = false;
                    Map.Entry<String, DependencySource> entry = $dependency_candidate;
                    boolean bl6 = false;
                    String dependency = entry.getKey();
                    entry = $dependency_candidate;
                    bl6 = false;
                    DependencySource candidate2 = entry.getValue();
                    DependencySource dependencySource = candidate2;
                    if (dependencySource instanceof DependencySource.Local) {
                        string = null;
                    } else if (Intrinsics.areEqual((Object)dependencySource, (Object)DependencySource.Remote.Public.INSTANCE)) {
                        string = this.dependenciesUrl;
                    } else if (Intrinsics.areEqual((Object)dependencySource, (Object)DependencySource.Remote.Internal.INSTANCE)) {
                        string = InternalServer.INSTANCE.getUrl();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if ((baseUrl = string) == null) continue;
                    this.downloadDependency(dependency, baseUrl);
                }
                it = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        AutoCloseable autoCloseable = $receiver$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        AutoCloseable autoCloseable = $receiver$iv;
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    throw throwable;
                }
            }
            AutoCloseable autoCloseable = $receiver$iv;
            if (autoCloseable != null) {
                autoCloseable.close();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public final String getDependenciesUrl() {
        return this.dependenciesUrl;
    }

    public final boolean getAirplaneMode() {
        return this.airplaneMode;
    }

    public final boolean getKeepUnstable() {
        return this.keepUnstable;
    }

    public final boolean getDeleteArchives() {
        return this.deleteArchives;
    }

    /*
     * WARNING - void declaration
     */
    public DependencyProcessor(@NotNull File dependenciesRoot, @NotNull String dependenciesUrl, @NotNull Map<String, ? extends List<? extends DependencySource>> dependencyToCandidates, @NotNull File homeDependencyCache, boolean airplaneMode, int maxAttempts, long attemptIntervalMs, @Nullable Function3<? super String, ? super Long, ? super Long, Unit> customProgressCallback, boolean keepUnstable, boolean deleteArchives) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)dependenciesRoot, (String)"dependenciesRoot");
        Intrinsics.checkParameterIsNotNull((Object)dependenciesUrl, (String)"dependenciesUrl");
        Intrinsics.checkParameterIsNotNull(dependencyToCandidates, (String)"dependencyToCandidates");
        Intrinsics.checkParameterIsNotNull((Object)homeDependencyCache, (String)"homeDependencyCache");
        this.dependenciesUrl = dependenciesUrl;
        this.airplaneMode = airplaneMode;
        this.keepUnstable = keepUnstable;
        this.deleteArchives = deleteArchives;
        Object object = dependenciesRoot;
        DependencyProcessor dependencyProcessor2 = this;
        boolean bl = false;
        boolean bl2 = false;
        File $receiver = object;
        boolean bl3 = false;
        $receiver.mkdirs();
        Object object2 = object;
        dependencyProcessor2.dependenciesDirectory = object2;
        object = homeDependencyCache;
        dependencyProcessor2 = this;
        bl = false;
        bl2 = false;
        $receiver = object;
        boolean bl4 = false;
        $receiver.mkdirs();
        object2 = object;
        dependencyProcessor2.cacheDirectory = object2;
        object = new File(this.cacheDirectory, ".lock");
        dependencyProcessor2 = this;
        bl = false;
        bl2 = false;
        $receiver = object;
        boolean bl5 = false;
        if (!$receiver.exists()) {
            $receiver.createNewFile();
        }
        object2 = object;
        dependencyProcessor2.lockFile = object2;
        this.showInfo = true;
        this.downloader = new DependencyDownloader(maxAttempts, attemptIntervalMs, customProgressCallback);
        this.extractor = new DependencyExtractor();
        object = dependencyToCandidates;
        dependencyProcessor2 = this;
        boolean $i$f$map = false;
        void var14_15 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        boolean $i$f$mapTo = false;
        void var17_19 = $receiver$iv$iv;
        boolean bl6 = false;
        Iterator iterator = var17_19.entrySet().iterator();
        while (iterator.hasNext()) {
            void $dependency_candidates;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object2 = destination$iv$iv;
            boolean bl7 = false;
            void var23_25 = $dependency_candidates;
            boolean bl8 = false;
            String dependency = (String)var23_25.getKey();
            var23_25 = $dependency_candidates;
            bl8 = false;
            List candidates = (List)var23_25.getValue();
            DependencySource candidate2 = (DependencySource)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)candidates), (Function1)resolvedDependencies.1.candidate.1.INSTANCE));
            if (candidate2 == null) {
                String string = dependency + " is not available; candidates:\n" + CollectionsKt.joinToString$default((Iterable)candidates, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                boolean bl9 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Pair pair = TuplesKt.to((Object)dependency, (Object)candidate2);
            object2.add(pair);
        }
        object2 = (List)destination$iv$iv;
        dependencyProcessor2.resolvedDependencies = MapsKt.toMap((Iterable)((Iterable)object2));
    }

    public /* synthetic */ DependencyProcessor(File file, String string, Map map2, File file2, boolean bl, int n, long l, Function3 function3, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            file2 = Companion.getDefaultDependencyCacheDir();
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            n = 10;
        }
        if ((n2 & 0x40) != 0) {
            l = 3000L;
        }
        if ((n2 & 0x80) != 0) {
            function3 = null;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x200) != 0) {
            bl3 = true;
        }
        this(file, string, map2, file2, bl, n, l, (Function3<? super String, ? super Long, ? super Long, Unit>)function3, bl2, bl3);
    }

    public DependencyProcessor(@NotNull File dependenciesRoot, @NotNull KonanPropertiesLoader properties2, @NotNull String dependenciesUrl, boolean keepUnstable) {
        Intrinsics.checkParameterIsNotNull((Object)dependenciesRoot, (String)"dependenciesRoot");
        Intrinsics.checkParameterIsNotNull((Object)properties2, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)dependenciesUrl, (String)"dependenciesUrl");
        this(dependenciesRoot, properties2.getProperties(), properties2.getDependencies(), dependenciesUrl, keepUnstable);
    }

    public /* synthetic */ DependencyProcessor(File file, KonanPropertiesLoader konanPropertiesLoader, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = DependencyProcessorKt.access$getDependenciesUrl$p(konanPropertiesLoader);
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        this(file, konanPropertiesLoader, string, bl);
    }

    public DependencyProcessor(@NotNull File dependenciesRoot, @NotNull Properties properties2, @NotNull List<String> dependencies2, @NotNull String dependenciesUrl, boolean keepUnstable) {
        Intrinsics.checkParameterIsNotNull((Object)dependenciesRoot, (String)"dependenciesRoot");
        Intrinsics.checkParameterIsNotNull((Object)properties2, (String)"properties");
        Intrinsics.checkParameterIsNotNull(dependencies2, (String)"dependencies");
        Intrinsics.checkParameterIsNotNull((Object)dependenciesUrl, (String)"dependenciesUrl");
        this(dependenciesRoot, dependenciesUrl, DependencyProcessorKt.access$findCandidates(properties2, dependencies2), null, DependencyProcessorKt.access$getAirplaneMode$p(properties2), DependencyProcessorKt.access$getDownloadingAttempts$p(properties2), DependencyProcessorKt.access$getDownloadingAttemptIntervalMs$p(properties2), null, keepUnstable, false, 648, null);
    }

    public /* synthetic */ DependencyProcessor(File file, Properties properties2, List list2, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = DependencyProcessorKt.access$getDependenciesUrl$p(properties2);
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(file, properties2, list2, string, bl);
    }

    static {
        Companion = new Companion(null);
        lock = new ReentrantLock();
        localKonanDir$delegate = LazyKt.lazy((Function0)Companion.localKonanDir.2.INSTANCE);
    }

    @NotNull
    public static final File getDefaultDependenciesRoot() {
        return Companion.getDefaultDependenciesRoot();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyProcessor$DependencyFile;", "", "directory", "Ljava/io/File;", "fileName", "", "(Ljava/io/File;Ljava/lang/String;)V", "dependencies", "", "file", "getFile", "()Ljava/io/File;", "add", "", "dependency", "addAndSave", "", "contains", "remove", "removeAndSave", "save", "kotlin-native-shared"})
    public static final class DependencyFile {
        @NotNull
        private final File file;
        private final Set<String> dependencies;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final boolean contains(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            return this.dependencies.contains(dependency);
        }

        public final boolean add(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            return this.dependencies.add(dependency);
        }

        public final boolean remove(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            return this.dependencies.remove(dependency);
        }

        public final void removeAndSave(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            this.remove(dependency);
            this.save();
        }

        public final void addAndSave(@NotNull String dependency) {
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            this.add(dependency);
            this.save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void save() {
            File file = this.file;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object = file;
            boolean bl2 = false;
            object = new FileOutputStream((File)object);
            bl2 = false;
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)object, charset);
            AutoCloseable $receiver$iv = writer;
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                OutputStreamWriter it = (OutputStreamWriter)$receiver$iv;
                boolean bl3 = false;
                Iterable $receiver$iv2 = this.dependencies;
                boolean $i$f$forEach = false;
                for (Object element$iv : $receiver$iv2) {
                    String it2 = (String)element$iv;
                    boolean bl4 = false;
                    writer.write(it2);
                    writer.write("\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $receiver$iv.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $receiver$iv.close();
                    }
                    throw throwable;
                }
            }
            $receiver$iv.close();
        }

        public DependencyFile(@NotNull File directory, @NotNull String fileName) {
            File file;
            Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            File file2 = new File(directory, fileName);
            DependencyFile dependencyFile = this;
            boolean bl = false;
            boolean bl2 = false;
            File $receiver = file2;
            boolean bl3 = false;
            $receiver.createNewFile();
            dependencyFile.file = file = file2;
            this.dependencies = CollectionsKt.toMutableSet((Iterable)FilesKt.readLines$default((File)this.file, null, (int)1, null));
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyProcessor$Companion;", "", "()V", "defaultDependenciesRoot", "Ljava/io/File;", "defaultDependenciesRoot$annotations", "getDefaultDependenciesRoot", "()Ljava/io/File;", "defaultDependencyCacheDir", "getDefaultDependencyCacheDir", "localKonanDir", "getLocalKonanDir", "localKonanDir$delegate", "Lkotlin/Lazy;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "kotlin-native-shared"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "localKonanDir", "getLocalKonanDir()Ljava/io/File;"))};
        }

        @NotNull
        public final File getLocalKonanDir() {
            Lazy lazy = localKonanDir$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            boolean bl = false;
            return (File)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void defaultDependenciesRoot$annotations() {
        }

        @NotNull
        public final File getDefaultDependenciesRoot() {
            return FilesKt.resolve((File)Companion.getLocalKonanDir(), (String)"dependencies");
        }

        @NotNull
        public final File getDefaultDependencyCacheDir() {
            return FilesKt.resolve((File)Companion.getLocalKonanDir(), (String)"cache");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

