/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.internal.hash.FileHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.com.google.gson.stream.JsonReader;
import org.jetbrains.kotlin.com.google.gson.stream.JsonToken;
import org.jetbrains.kotlin.com.google.gson.stream.JsonWriter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001:\u0003567B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J'\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\u00052\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050#H\u0000\u00a2\u0006\u0002\b$J\"\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00052\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050#H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010,\u001a\u00020-H\u0002J\u001b\u0010.\u001a\u00020\u001c*\u00020-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0082\bJ\u001b\u0010.\u001a\u00020\u001c*\u0002002\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0082\bJ\f\u00101\u001a\u000202*\u00020)H\u0002J\n\u00103\u001a\u00020\u0007*\u00020\u001eJ\u0014\u00104\u001a\u00020\u001c*\u00020\u00122\u0006\u0010,\u001a\u000200H\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache;", "Ljava/lang/AutoCloseable;", "project", "Lorg/gradle/api/Project;", "targetDir", "Ljava/io/File;", "stateFileName", "", "version", "(Lorg/gradle/api/Project;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "gson", "Lorg/jetbrains/kotlin/com/google/gson/Gson;", "kotlin.jvm.PlatformType", "hasher", "Lorg/gradle/internal/hash/FileHasher;", "getProject", "()Lorg/gradle/api/Project;", "state", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$State;", "stateFile", "getTargetDir", "()Ljava/io/File;", "getVersion", "()Ljava/lang/String;", "checkTarget", "", "target", "close", "", "decodeHexString", "", "hexString", "getOrCompute", "file", "compute", "Lkotlin/Function0;", "getOrCompute$kotlin_gradle_plugin", "getOrComputeKey", "hexToByte", "", "a", "", "b", "readFrom", "json", "Lorg/jetbrains/kotlin/com/google/gson/stream/JsonReader;", "obj", "body", "Lorg/jetbrains/kotlin/com/google/gson/stream/JsonWriter;", "toDigit", "", "toHex", "writeTo", "ByteArrayWrapper", "Element", "State", "kotlin-gradle-plugin"})
public class ProcessedFilesCache
implements AutoCloseable {
    private final FileHasher hasher;
    private final Gson gson;
    private final File stateFile;
    private final State state;
    @NotNull
    private final Project project;
    @NotNull
    private final File targetDir;
    @NotNull
    private final String version;

    /*
     * WARNING - void declaration
     */
    private final State readFrom(JsonReader json) {
        void $receiver$iv;
        void $receiver$iv2;
        State result2 = new State();
        JsonReader jsonReader = json;
        ProcessedFilesCache this_$iv = this;
        boolean $i$f$obj = false;
        $receiver$iv2.beginObject();
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)json.nextName(), (Object)"version");
        boolean bl3 = false;
        boolean bl4 = false;
        bl4 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String version = json.nextString();
        if (Intrinsics.areEqual((Object)version, (Object)this.version) ^ true) {
            return null;
        }
        bl3 = Intrinsics.areEqual((Object)json.nextName(), (Object)"items");
        bl4 = false;
        bl5 = false;
        bl5 = false;
        boolean bl7 = false;
        if (!bl3) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        JsonReader jsonReader2 = json;
        ProcessedFilesCache this_$iv2 = this;
        boolean $i$f$obj2 = false;
        $receiver$iv.beginObject();
        boolean bl9 = false;
        while (json.peek() == JsonToken.NAME) {
            boolean bl10;
            String key = json.nextName();
            json.beginObject();
            boolean bl11 = Intrinsics.areEqual((Object)json.nextName(), (Object)"src");
            boolean bl12 = false;
            boolean bl13 = false;
            bl13 = false;
            boolean bl14 = false;
            if (!bl11) {
                bl10 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            String src = json.nextString();
            String target = null;
            if (json.peek() == JsonToken.NAME) {
                bl13 = Intrinsics.areEqual((Object)json.nextName(), (Object)"target");
                bl14 = false;
                bl10 = false;
                bl10 = false;
                boolean bl15 = false;
                if (!bl13) {
                    boolean bl16 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (json.peek() != JsonToken.NULL) {
                    target = json.nextString();
                }
            }
            json.endObject();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            byte[] byArray = this.decodeHexString(string);
            String string2 = src;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"src");
            result2.set(byArray, new Element(string2, target));
        }
        $receiver$iv.endObject();
        $receiver$iv2.endObject();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeTo(@NotNull State $receiver, JsonWriter json) {
        void $receiver$iv;
        void $receiver$iv2;
        JsonWriter jsonWriter = json;
        ProcessedFilesCache this_$iv = this;
        boolean $i$f$obj = false;
        $receiver$iv2.beginObject();
        boolean bl = false;
        json.name("version").value(this.version);
        json.name("items");
        JsonWriter jsonWriter2 = json;
        ProcessedFilesCache this_$iv2 = this;
        boolean $i$f$obj2 = false;
        $receiver$iv.beginObject();
        boolean bl2 = false;
        Map<ByteArrayWrapper, Element> $this$forEach$iv = $receiver.getByHash();
        boolean $i$f$forEach = false;
        Map<ByteArrayWrapper, Element> map2 = $this$forEach$iv;
        boolean bl3 = false;
        Iterator<Map.Entry<ByteArrayWrapper, Element>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void $receiver$iv3;
            Map.Entry<ByteArrayWrapper, Element> element$iv;
            Map.Entry<ByteArrayWrapper, Element> it = element$iv = iterator.next();
            boolean bl4 = false;
            json.name(this.toHex(it.getKey().getContents()));
            JsonWriter jsonWriter3 = json;
            ProcessedFilesCache this_$iv3 = this;
            boolean $i$f$obj3 = false;
            $receiver$iv3.beginObject();
            boolean bl5 = false;
            json.name("src").value(it.getValue().getSrc());
            json.name("target");
            if (it.getValue().getTarget() == null) {
                json.nullValue();
            } else {
                json.value(it.getValue().getTarget());
            }
            $receiver$iv3.endObject();
        }
        $receiver$iv.endObject();
        $receiver$iv2.endObject();
    }

    private final void obj(@NotNull JsonReader $receiver, Function0<Unit> body) {
        int $i$f$obj = 0;
        $receiver.beginObject();
        body.invoke();
        $receiver.endObject();
    }

    private final void obj(@NotNull JsonWriter $receiver, Function0<Unit> body) {
        int $i$f$obj = 0;
        $receiver.beginObject();
        body.invoke();
        $receiver.endObject();
    }

    @NotNull
    public final String toHex(@NotNull byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = $receiver.length * 2;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n2;
            int n5 = n2++;
            char[] cArray2 = cArray;
            boolean bl = false;
            cArray2[n5] = n3 = 32;
        }
        char[] result2 = cArray;
        int i2 = 0;
        byte[] $this$forEach$iv = $receiver;
        boolean $i$f$forEach = false;
        byte[] byArray = $this$forEach$iv;
        int n6 = byArray.length;
        for (int j = 0; j < n6; ++j) {
            byte element$iv;
            byte it = element$iv = byArray[j];
            boolean bl = false;
            byte n7 = it;
            int n8 = i2;
            i2 = n8 + 1;
            result2[n8] = Character.forDigit(n7 >> 4 & 0xF, 16);
            n8 = i2;
            i2 = n8 + 1;
            result2[n8] = Character.forDigit(n7 & 0xF, 16);
        }
        boolean bl = false;
        return new String(result2);
    }

    private final byte[] decodeHexString(String hexString) {
        boolean bl = hexString.length() % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] bytes = new byte[hexString.length() / 2];
        int i2 = 0;
        int o = 0;
        while (i2 < hexString.length()) {
            bytes[o++] = this.hexToByte(hexString.charAt(i2++), hexString.charAt(i2++));
        }
        return bytes;
    }

    private final byte hexToByte(char a, char b) {
        return (byte)((this.toDigit(a) << 4) + this.toDigit(b));
    }

    private final int toDigit(char $receiver) {
        int n = Character.digit($receiver, 16);
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        boolean bl4 = it != -1;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    @Nullable
    public final File getOrCompute$kotlin_gradle_plugin(@NotNull File file, @NotNull Function0<? extends File> compute) {
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(compute, (String)"compute");
        String string = this.getOrComputeKey(file, compute);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            file2 = new File(this.targetDir, it);
        } else {
            file2 = null;
        }
        return file2;
    }

    private final String getOrComputeKey(File file, Function0<? extends File> compute) {
        File file2;
        byte[] hash2 = this.hasher.hash(file).toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)hash2, (String)"hash");
        Element old = this.state.get(hash2);
        if (old != null) {
            if (this.checkTarget(old.getTarget())) {
                return old.getTarget();
            }
            Logger logger2 = this.project.getLogger();
            StringBuilder stringBuilder = new StringBuilder().append("Cannot find ");
            File file3 = this.project.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.projectDir");
            File file4 = FilesKt.relativeTo((File)this.targetDir, (File)file3);
            String string = old.getTarget();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            logger2.warn(stringBuilder.append(new File(file4, string)).append(", rebuilding").toString());
        }
        String key = (file2 = (File)compute.invoke()) != null && (file2 = FilesKt.relativeTo((File)file2, (File)this.targetDir)) != null ? file2.toString() : null;
        Map<String, Element> map2 = this.state.getByTarget();
        boolean bl = false;
        Element existedTarget = map2.get(key);
        if (key != null && existedTarget != null && !new File(existedTarget.getSrc()).exists()) {
            this.project.getLogger().warn("Removing cache for removed source `" + existedTarget.getSrc() + '`');
            this.state.remove(existedTarget);
        }
        String string = file.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
        this.state.set(hash2, new Element(string, key));
        return key;
    }

    private final boolean checkTarget(String target) {
        if (target == null) {
            return true;
        }
        return FilesKt.resolve((File)this.targetDir, (String)target).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stateFile.getParentFile().mkdirs();
        Object object = this.stateFile;
        Gson gson = this.gson;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileOutputStream((File)object2);
        bl2 = false;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object2, charset);
        object = gson.newJsonWriter(outputStreamWriter);
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            JsonWriter it = (JsonWriter)object;
            boolean bl4 = false;
            JsonWriter jsonWriter = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"it");
            this.writeTo(this.state, jsonWriter);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getTargetDir() {
        return this.targetDir;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ProcessedFilesCache(@NotNull Project project, @NotNull File targetDir, @NotNull String stateFileName, @NotNull String version) {
        State state;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
        Intrinsics.checkParameterIsNotNull((Object)stateFileName, (String)"stateFileName");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.project = project;
        this.targetDir = targetDir;
        this.version = version;
        Project project2 = this.project;
        if (project2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        }
        this.hasher = (FileHasher)((ProjectInternal)project2).getServices().get(FileHasher.class);
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.stateFile = FilesKt.resolve((File)this.targetDir, (String)stateFileName);
        this.targetDir.mkdirs();
        ProcessedFilesCache processedFilesCache = this;
        if (this.stateFile.exists()) {
            Object object2;
            ProcessedFilesCache processedFilesCache2 = processedFilesCache;
            try {
                object2 = this.stateFile;
                Object object3 = this.gson;
                ProcessedFilesCache processedFilesCache3 = processedFilesCache2;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Object object4 = object2;
                boolean bl2 = false;
                object4 = new FileInputStream((File)object4);
                bl2 = false;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object4, charset);
                object2 = ((Gson)object3).newJsonReader(inputStreamReader);
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    JsonReader it = (JsonReader)object2;
                    boolean bl4 = false;
                    JsonReader jsonReader = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonReader, (String)"it");
                    object4 = this.readFrom(jsonReader);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object3 = object4;
                processedFilesCache = processedFilesCache3;
                object2 = object3;
            }
            catch (Throwable throwable) {
                void e;
                processedFilesCache = processedFilesCache2;
                this.project.getLogger().warn("Cannot read " + this.stateFile, (Throwable)e);
                if (this.targetDir.exists()) {
                    FilesKt.deleteRecursively((File)this.targetDir);
                }
                object2 = null;
            }
            object = object2;
        } else {
            object = state = null;
        }
        if (object == null) {
            state = new State();
        }
        processedFilesCache.state = state;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$ByteArrayWrapper;", "", "contents", "", "([B)V", "getContents", "()[B", "equals", "", "other", "hashCode", "", "kotlin-gradle-plugin"})
    public static final class ByteArrayWrapper {
        @NotNull
        private final byte[] contents;

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.internal.ProcessedFilesCache.ByteArrayWrapper");
            }
            ByteArrayWrapper cfr_ignored_0 = (ByteArrayWrapper)object2;
            byte[] byArray = this.contents;
            byte[] byArray2 = ((ByteArrayWrapper)other).contents;
            boolean bl = false;
            return Arrays.equals(byArray, byArray2);
        }

        public int hashCode() {
            byte[] byArray = this.contents;
            boolean bl = false;
            return Arrays.hashCode(byArray);
        }

        @NotNull
        public final byte[] getContents() {
            return this.contents;
        }

        public ByteArrayWrapper(@NotNull byte[] contents) {
            Intrinsics.checkParameterIsNotNull((Object)contents, (String)"contents");
            this.contents = contents;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0019\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006H\u0086\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$State;", "", "()V", "byHash", "", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$ByteArrayWrapper;", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$Element;", "getByHash", "()Ljava/util/Map;", "byTarget", "", "getByTarget", "get", "elementHash", "", "remove", "", "element", "set", "kotlin-gradle-plugin"})
    private static final class State {
        @NotNull
        private final Map<ByteArrayWrapper, Element> byHash;
        @NotNull
        private final Map<String, Element> byTarget;

        @NotNull
        public final Map<ByteArrayWrapper, Element> getByHash() {
            return this.byHash;
        }

        @NotNull
        public final Map<String, Element> getByTarget() {
            return this.byTarget;
        }

        @Nullable
        public final Element get(@NotNull byte[] elementHash) {
            Intrinsics.checkParameterIsNotNull((Object)elementHash, (String)"elementHash");
            return this.byHash.get(new ByteArrayWrapper(elementHash));
        }

        public final void set(@NotNull byte[] elementHash, @NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)elementHash, (String)"elementHash");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.byHash.put(new ByteArrayWrapper(elementHash), element);
            String target = element.getTarget();
            if (target != null) {
                this.byTarget.put(target, element);
            }
        }

        public final void remove(@NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element.getTarget() != null) {
                this.byTarget.remove(element.getTarget());
            }
            this.byHash.values().removeIf(new Predicate<Element>(element){
                final /* synthetic */ Element $element;

                public final boolean test(@NotNull Element it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$element);
                }
                {
                    this.$element = element;
                }
            });
        }

        public State() {
            Map map2;
            State state = this;
            boolean bl = false;
            state.byHash = map2 = (Map)new LinkedHashMap();
            state = this;
            bl = false;
            state.byTarget = map2 = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$Element;", "", "src", "", "target", "(Ljava/lang/String;Ljava/lang/String;)V", "getSrc", "()Ljava/lang/String;", "getTarget", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-gradle-plugin"})
    public static final class Element {
        @NotNull
        private final String src;
        @Nullable
        private final String target;

        @NotNull
        public final String getSrc() {
            return this.src;
        }

        @Nullable
        public final String getTarget() {
            return this.target;
        }

        public Element(@NotNull String src, @Nullable String target) {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            this.src = src;
            this.target = target;
        }

        @NotNull
        public final String component1() {
            return this.src;
        }

        @Nullable
        public final String component2() {
            return this.target;
        }

        @NotNull
        public final Element copy(@NotNull String src, @Nullable String target) {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            return new Element(src, target);
        }

        public static /* synthetic */ Element copy$default(Element element, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = element.src;
            }
            if ((n & 2) != 0) {
                string2 = element.target;
            }
            return element.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Element(src=" + this.src + ", target=" + this.target + ")";
        }

        public int hashCode() {
            String string = this.src;
            String string2 = this.target;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Element)) break block3;
                    Element element = (Element)object;
                    if (!Intrinsics.areEqual((Object)this.src, (Object)element.src) || !Intrinsics.areEqual((Object)this.target, (Object)element.target)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

