/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.targets.js.npm.AbstractNodeModulesCacheKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.CompositeNodeModuleBuilderKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.CompositeNodeModulesCache;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJsonKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.SemverKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModuleBuilder;", "", "project", "Lorg/gradle/api/Project;", "dependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "srcDir", "Ljava/io/File;", "cache", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModulesCache;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/ResolvedDependency;Ljava/io/File;Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModulesCache;)V", "getCache", "()Lorg/jetbrains/kotlin/gradle/targets/js/npm/CompositeNodeModulesCache;", "getDependency", "()Lorg/gradle/api/artifacts/ResolvedDependency;", "getProject", "()Lorg/gradle/api/Project;", "getSrcDir", "()Ljava/io/File;", "srcPackageJsonFile", "getSrcPackageJsonFile", "setSrcPackageJsonFile", "(Ljava/io/File;)V", "rebuild", "kotlin-gradle-plugin"})
public final class CompositeNodeModuleBuilder {
    private File srcPackageJsonFile;
    private final Project project;
    private final ResolvedDependency dependency;
    private final File srcDir;
    private final CompositeNodeModulesCache cache;

    @NotNull
    public final File getSrcPackageJsonFile() {
        return this.srcPackageJsonFile;
    }

    public final void setSrcPackageJsonFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.srcPackageJsonFile = file;
    }

    @Nullable
    public final File rebuild() {
        Object object;
        boolean bl = this.srcPackageJsonFile.isFile();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unable to read package.json of composite build";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        PackageJson packageJson = PackageJsonKt.fromSrcPackageJson(this.srcPackageJsonFile);
        if (packageJson == null) {
            Intrinsics.throwNpe();
        }
        PackageJson packageJson2 = packageJson;
        packageJson2.setVersion(SemverKt.fixSemver(packageJson2.getVersion()));
        File container = this.cache.getDir$kotlin_gradle_plugin();
        File importedPackageDir = AbstractNodeModulesCacheKt.importedPackageDir(container, packageJson2.getName(), packageJson2.getVersion());
        File file = this.srcDir.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"srcDir.parentFile");
        String string = packageJson2.getMain();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if ((object = FilesKt.relativeToOrNull((File)FilesKt.resolve((File)file, (String)string), (File)importedPackageDir)) == null || (object = ((File)object).getPath()) == null) {
            throw (Throwable)new IllegalStateException("Unable to link composite builds for Kotlin/JS which have different roots");
        }
        packageJson2.setMain((String)object);
        return CompositeNodeModuleBuilderKt.access$makeNodeModule(container, packageJson2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ResolvedDependency getDependency() {
        return this.dependency;
    }

    @NotNull
    public final File getSrcDir() {
        return this.srcDir;
    }

    @NotNull
    public final CompositeNodeModulesCache getCache() {
        return this.cache;
    }

    public CompositeNodeModuleBuilder(@NotNull Project project, @NotNull ResolvedDependency dependency, @NotNull File srcDir2, @NotNull CompositeNodeModulesCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Intrinsics.checkParameterIsNotNull((Object)srcDir2, (String)"srcDir");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.project = project;
        this.dependency = dependency;
        this.srcDir = srcDir2;
        this.cache = cache;
        this.srcPackageJsonFile = this.srcDir;
    }
}

