/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.webpack;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.gradle.targets.js.NpmVersions;
import org.jetbrains.kotlin.gradle.targets.js.RequiredKotlinJsDependency;
import org.jetbrains.kotlin.gradle.targets.js.StringsKt;
import org.jetbrains.kotlin.gradle.targets.js.UtilsKt;
import org.jetbrains.kotlin.gradle.targets.js.webpack.KotlinWebpackCssRule;
import org.jetbrains.kotlin.gradle.targets.js.webpack.KotlinWebpackCssSupport;
import org.jetbrains.kotlin.gradle.targets.js.webpack.KotlinWebpackOutput;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b7\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\b\u0086\b\u0018\u00002\u00020\u0001:\u0003{|}B\u00c3\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0014\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010K\u001a\u00020L2\n\u0010M\u001a\u00060Nj\u0002`OJ\t\u0010P\u001a\u00020\u0003H\u00c6\u0003J\t\u0010Q\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010S\u001a\u00020\u0014H\u00c6\u0003J\t\u0010T\u001a\u00020\u0014H\u00c6\u0003J\t\u0010U\u001a\u00020\u0014H\u00c6\u0003J\t\u0010V\u001a\u00020\u0014H\u00c6\u0003J\u000b\u0010W\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010X\u001a\u00020\u0014H\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010[\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\\\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010]\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010^\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010_\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010`\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u00c7\u0001\u0010a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0019\u001a\u00020\u0014H\u00c6\u0001J\b\u0010b\u001a\u00020LH\u0002J\u0013\u0010c\u001a\u00020\u00142\b\u0010d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0014\u0010e\u001a\b\u0012\u0004\u0012\u00020g0f2\u0006\u0010h\u001a\u00020iJ\t\u0010j\u001a\u00020kH\u00d6\u0001J\u0010\u0010l\u001a\u00020\n2\u0006\u0010m\u001a\u00020\u0001H\u0002J\u000e\u0010n\u001a\u00020L2\u0006\u0010o\u001a\u00020\u0005J\t\u0010p\u001a\u00020\nH\u00d6\u0001J\u0010\u0010q\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010r\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010s\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010t\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010u\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010v\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010w\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010x\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010y\u001a\u00020L*\u00060Nj\u0002`OH\u0002J\u0010\u0010z\u001a\u00020L*\u00060Nj\u0002`OH\u0002R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\u001eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001c\"\u0004\b.\u0010\u001eR\u001a\u0010\u0016\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010*\"\u0004\b<\u0010,R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001c\"\u0004\b>\u0010\u001eR\u001a\u0010\u0017\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00100\"\u0004\b@\u00102R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010*\"\u0004\bB\u0010,R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u001c\"\u0004\bD\u0010\u001eR\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u00100\"\u0004\bF\u00102R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u00100\"\u0004\bH\u00102R\u001a\u0010\u0015\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u00100\"\u0004\bJ\u00102\u00a8\u0006~"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig;", "", "mode", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$Mode;", "entry", "Ljava/io/File;", "output", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackOutput;", "outputPath", "outputFileName", "", "configDirectory", "bundleAnalyzerReportDir", "reportEvaluatedConfigFile", "devServer", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$DevServer;", "cssSupport", "Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackCssSupport;", "devtool", "showProgress", "", "sourceMaps", "export", "progressReporter", "progressReporterPathFilter", "resolveFromModulesFirst", "(Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$Mode;Ljava/io/File;Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackOutput;Ljava/io/File;Ljava/lang/String;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$DevServer;Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackCssSupport;Ljava/lang/String;ZZZZLjava/lang/String;Z)V", "getBundleAnalyzerReportDir", "()Ljava/io/File;", "setBundleAnalyzerReportDir", "(Ljava/io/File;)V", "getConfigDirectory", "setConfigDirectory", "getCssSupport", "()Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackCssSupport;", "setCssSupport", "(Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackCssSupport;)V", "getDevServer", "()Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$DevServer;", "setDevServer", "(Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$DevServer;)V", "getDevtool", "()Ljava/lang/String;", "setDevtool", "(Ljava/lang/String;)V", "getEntry", "setEntry", "getExport", "()Z", "setExport", "(Z)V", "getMode", "()Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$Mode;", "setMode", "(Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$Mode;)V", "getOutput", "()Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackOutput;", "setOutput", "(Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackOutput;)V", "getOutputFileName", "setOutputFileName", "getOutputPath", "setOutputPath", "getProgressReporter", "setProgressReporter", "getProgressReporterPathFilter", "setProgressReporterPathFilter", "getReportEvaluatedConfigFile", "setReportEvaluatedConfigFile", "getResolveFromModulesFirst", "setResolveFromModulesFirst", "getShowProgress", "setShowProgress", "getSourceMaps", "setSourceMaps", "appendTo", "", "target", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "cssError", "equals", "other", "getRequiredDependencies", "", "Lorg/jetbrains/kotlin/gradle/targets/js/RequiredKotlinJsDependency;", "versions", "Lorg/jetbrains/kotlin/gradle/targets/js/NpmVersions;", "hashCode", "", "json", "obj", "save", "configFile", "toString", "appendCssSupport", "appendDevServer", "appendEntry", "appendErrorPlugin", "appendEvaluatedFileReport", "appendFromConfigDir", "appendProgressReporter", "appendReport", "appendResolveModules", "appendSourceMaps", "BundleAnalyzerPlugin", "DevServer", "Mode", "kotlin-gradle-plugin"})
public final class KotlinWebpackConfig {
    private Mode mode;
    private File entry;
    private KotlinWebpackOutput output;
    private File outputPath;
    private String outputFileName;
    private File configDirectory;
    private File bundleAnalyzerReportDir;
    private File reportEvaluatedConfigFile;
    private DevServer devServer;
    private KotlinWebpackCssSupport cssSupport;
    private String devtool;
    private boolean showProgress;
    private boolean sourceMaps;
    private boolean export;
    private boolean progressReporter;
    private String progressReporterPathFilter;
    private boolean resolveFromModulesFirst;

    @NotNull
    public final Set<RequiredKotlinJsDependency> getRequiredDependencies(@NotNull NpmVersions versions) {
        Intrinsics.checkParameterIsNotNull((Object)versions, (String)"versions");
        boolean bl = false;
        Set set2 = new LinkedHashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        Set it = set2;
        boolean bl4 = false;
        it.add(versions.getKotlinJsTestRunner());
        it.add(versions.getWebpack());
        it.add(versions.getWebpackCli());
        if (this.bundleAnalyzerReportDir != null) {
            it.add(versions.getWebpackBundleAnalyzer());
        }
        if (this.sourceMaps) {
            it.add(versions.getSourceMapLoader());
        }
        if (this.devServer != null) {
            it.add(versions.getWebpackDevServer());
        }
        if (this.cssSupport.getEnabled() && !this.cssSupport.getRules().isEmpty()) {
            it.add(versions.getCssLoader());
            Iterable $this$forEach$iv = this.cssSupport.getRules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinWebpackCssRule rule = (KotlinWebpackCssRule)element$iv;
                boolean bl5 = false;
                switch (rule.getMode()) {
                    case "extract": {
                        it.add(versions.getMiniCssExtractPlugin());
                        break;
                    }
                    case "inline": {
                        it.add(versions.getStyleLoader());
                        break;
                    }
                    case "import": {
                        it.add(versions.getToStringLoader());
                        break;
                    }
                    default: {
                        this.cssError();
                    }
                }
            }
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File configFile) {
        Intrinsics.checkParameterIsNotNull((Object)configFile, (String)"configFile");
        Object object = configFile;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileOutputStream((File)object2);
        bl2 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl4 = false;
            this.appendTo(it);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public final void appendTo(@NotNull Appendable target2) {
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        boolean bl = false;
        boolean bl2 = false;
        Appendable $receiver = target2;
        boolean bl3 = false;
        Appendable appendable = $receiver;
        CharSequence charSequence = kotlin.text.StringsKt.trimIndent((String)("\n                    let config = {\n                      mode: '" + this.mode.getCode() + "',\n                      resolve: {\n                        modules: [\n                          \"node_modules\"\n                        ]\n                      },\n                      plugins: [],\n                      module: {\n                        rules: []\n                      }\n                    };\n                    \n                "));
        boolean bl4 = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
        this.appendEntry($receiver);
        this.appendResolveModules($receiver);
        this.appendSourceMaps($receiver);
        this.appendDevServer($receiver);
        this.appendReport($receiver);
        this.appendProgressReporter($receiver);
        this.appendCssSupport($receiver);
        this.appendErrorPlugin($receiver);
        this.appendFromConfigDir($receiver);
        this.appendEvaluatedFileReport($receiver);
        if (this.export) {
            appendable = $receiver;
            charSequence = "module.exports = config";
            bl4 = false;
            Appendable appendable3 = appendable.append(charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)appendable3, (String)"append(value)");
            kotlin.text.StringsKt.appendln((Appendable)appendable3);
        }
    }

    private final void appendEvaluatedFileReport(Appendable $receiver) {
        if (this.reportEvaluatedConfigFile == null) {
            return;
        }
        File file = this.reportEvaluatedConfigFile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        String string = file.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reportEvaluatedConfigFile!!.canonicalPath");
        String filePath = StringsKt.jsQuoted(string);
        Appendable appendable = $receiver;
        CharSequence charSequence = kotlin.text.StringsKt.trimIndent((String)("\n                // save evaluated config file\n                ;(function(config) {\n                    const util = require('util');\n                    const fs = require('fs');\n                    const evaluatedConfig = util.inspect(config, {showHidden: false, depth: null, compact: false});\n                    fs.writeFile(" + filePath + ", evaluatedConfig, function (err) {});\n                })(config);\n                \n            "));
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
    }

    private final void appendFromConfigDir(Appendable $receiver) {
        block6: {
            block5: {
                if (this.configDirectory == null) break block5;
                File file = this.configDirectory;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.isDirectory()) break block6;
            }
            return;
        }
        kotlin.text.StringsKt.appendln((Appendable)$receiver);
        File file = this.configDirectory;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        UtilsKt.appendConfigsFromDir($receiver, file);
        kotlin.text.StringsKt.appendln((Appendable)$receiver);
    }

    private final void appendReport(Appendable $receiver) {
        if (this.bundleAnalyzerReportDir == null) {
            return;
        }
        if (this.entry == null) {
            String string = "Entry should be defined for report";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.bundleAnalyzerReportDir;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder2 = stringBuilder.append(file.getCanonicalPath()).append('/');
        File file2 = this.entry;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        String reportBasePath = stringBuilder2.append(file2.getName()).toString();
        BundleAnalyzerPlugin config = new BundleAnalyzerPlugin("static", reportBasePath + ".report.html", false, true, reportBasePath + ".stats.json");
        Appendable appendable = $receiver;
        CharSequence charSequence = kotlin.text.StringsKt.trimIndent((String)("\n                // save webpack-bundle-analyzer report \n                var BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin; \n                config.plugins.push(new BundleAnalyzerPlugin(" + this.json(config) + "));\n                \n           "));
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
        kotlin.text.StringsKt.appendln((Appendable)$receiver);
    }

    private final void appendDevServer(Appendable $receiver) {
        if (this.devServer == null) {
            return;
        }
        Appendable appendable = $receiver;
        CharSequence charSequence = "// dev server";
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
        appendable = $receiver;
        StringBuilder stringBuilder = new StringBuilder().append("config.devServer = ");
        DevServer devServer = this.devServer;
        if (devServer == null) {
            Intrinsics.throwNpe();
        }
        charSequence = stringBuilder.append(this.json(devServer)).append(';').toString();
        bl = false;
        Appendable appendable3 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable3, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable3);
        kotlin.text.StringsKt.appendln((Appendable)$receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendSourceMaps(Appendable $receiver) {
        boolean bl;
        CharSequence charSequence;
        Object object;
        StringBuilder stringBuilder;
        Appendable appendable;
        block5: {
            block4: {
                void it;
                if (!this.sourceMaps) {
                    return;
                }
                appendable = $receiver;
                stringBuilder = new StringBuilder().append("\n                // source maps\n                config.module.rules.push({\n                        test: /\\.js$/,\n                        use: [\"source-map-loader\"],\n                        enforce: \"pre\"\n                });\n                config.devtool = ");
                object = this.devtool;
                if (object == null) break block4;
                charSequence = object;
                bl = false;
                boolean bl2 = false;
                String string = charSequence;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl3 = false;
                String string2 = '\'' + (String)it + '\'';
                stringBuilder = stringBuilder2;
                object = string2;
                if (object != null) break block5;
            }
            object = false;
        }
        charSequence = kotlin.text.StringsKt.trimIndent((String)stringBuilder.append(object).append(";\n                config.stats = config.stats || {}\n                Object.assign(config.stats, config.stats, {\n                    warningsFilter: [/Failed to parse source map/]\n                })\n                \n            ").toString());
        bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
    }

    private final void appendEntry(Appendable $receiver) {
        if (this.entry == null || this.outputPath == null || this.output == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.outputFileName;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String multiEntryOutput = stringBuilder.append(kotlin.text.StringsKt.removeSuffix((String)string, (CharSequence)".js")).append("-[name].js").toString();
        Appendable appendable = $receiver;
        StringBuilder stringBuilder2 = new StringBuilder().append("\n                // entry\n                config.entry = {\n                    main: [");
        File file = this.entry;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        String string2 = file.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry!!.canonicalPath");
        StringBuilder stringBuilder3 = stringBuilder2.append(StringsKt.jsQuoted(string2)).append("]\n                };\n                \n                config.output = {\n                    path: ");
        File file2 = this.outputPath;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = file2.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"outputPath!!.canonicalPath");
        StringBuilder stringBuilder4 = stringBuilder3.append(StringsKt.jsQuoted(string3)).append(",\n                    filename: (chunkData) => {\n                        return chunkData.chunk.name === 'main'\n                            ? ");
        String string4 = this.outputFileName;
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder5 = stringBuilder4.append(StringsKt.jsQuoted(string4)).append("\n                            : ").append(StringsKt.jsQuoted(multiEntryOutput)).append(";\n                    },\n                    library: \"");
        KotlinWebpackOutput kotlinWebpackOutput = this.output;
        if (kotlinWebpackOutput == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder6 = stringBuilder5.append(kotlinWebpackOutput.getLibrary()).append("\",\n                    libraryTarget: \"");
        KotlinWebpackOutput kotlinWebpackOutput2 = this.output;
        if (kotlinWebpackOutput2 == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder7 = stringBuilder6.append(kotlinWebpackOutput2.getLibraryTarget()).append("\",\n                    globalObject: \"");
        KotlinWebpackOutput kotlinWebpackOutput3 = this.output;
        if (kotlinWebpackOutput3 == null) {
            Intrinsics.throwNpe();
        }
        CharSequence charSequence = kotlin.text.StringsKt.trimIndent((String)stringBuilder7.append(kotlinWebpackOutput3.getGlobalObject()).append("\"\n                };\n                \n            ").toString());
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendCssSupport(Appendable $receiver) {
        if (!this.cssSupport.getEnabled() || this.cssSupport.getRules().isEmpty()) {
            return;
        }
        Appendable appendable = $receiver;
        CharSequence charSequence = "// css settings\n;(function(config) {";
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
        String extractedCss = "       const MiniCssExtractPlugin = require('mini-css-extract-plugin');\n       use.unshift({\n           loader: MiniCssExtractPlugin.loader,\n           options: {}\n       })\n       config.plugins.push(new MiniCssExtractPlugin())";
        String inlinedCss = "       use.unshift({\n           loader: 'style-loader',\n           options: {}\n       })\n       ";
        String importedCss = "       use.unshift({\n           loader: 'to-string-loader',\n           options: {}\n       })\n       ";
        Iterable $this$forEach$iv = this.cssSupport.getRules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            StringBuilder stringBuilder;
            boolean bl2;
            Object object;
            block21: {
                block20: {
                    String string2;
                    StringBuilder stringBuilder2;
                    String string3;
                    StringBuilder stringBuilder3;
                    String included;
                    block19: {
                        block18: {
                            void it;
                            boolean bl3;
                            KotlinWebpackCssRule rule = (KotlinWebpackCssRule)element$iv;
                            boolean bl4 = false;
                            Object object2 = $receiver;
                            Object object3 = "    ;(function(config) {";
                            boolean bl5 = false;
                            Appendable appendable3 = object2.append((CharSequence)object3);
                            Intrinsics.checkExpressionValueIsNotNull((Object)appendable3, (String)"append(value)");
                            kotlin.text.StringsKt.appendln((Appendable)appendable3);
                            object2 = $receiver;
                            object3 = "       const use = [\n           {\n               loader: 'css-loader',\n               options: {},\n           }\n       ]";
                            bl5 = false;
                            Appendable appendable4 = object2.append((CharSequence)object3);
                            Intrinsics.checkExpressionValueIsNotNull((Object)appendable4, (String)"append(value)");
                            kotlin.text.StringsKt.appendln((Appendable)appendable4);
                            switch (rule.getMode()) {
                                case "extract": {
                                    object3 = $receiver;
                                    CharSequence charSequence2 = extractedCss;
                                    bl3 = false;
                                    Appendable appendable5 = object3.append(charSequence2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)appendable5, (String)"append(value)");
                                    kotlin.text.StringsKt.appendln((Appendable)appendable5);
                                    break;
                                }
                                case "inline": {
                                    object3 = $receiver;
                                    CharSequence charSequence3 = inlinedCss;
                                    boolean bl6 = false;
                                    Appendable appendable6 = object3.append(charSequence3);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)appendable6, (String)"append(value)");
                                    kotlin.text.StringsKt.appendln((Appendable)appendable6);
                                    break;
                                }
                                case "import": {
                                    object3 = $receiver;
                                    CharSequence charSequence4 = importedCss;
                                    boolean bl7 = false;
                                    Appendable appendable7 = object3.append(charSequence4);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)appendable7, (String)"append(value)");
                                    kotlin.text.StringsKt.appendln((Appendable)appendable7);
                                    break;
                                }
                                default: {
                                    this.cssError();
                                }
                            }
                            object3 = rule.getExclude();
                            boolean bl8 = false;
                            bl3 = false;
                            Object it2 = object3;
                            boolean bl9 = false;
                            Collection collection = (Collection)it2;
                            boolean bl10 = false;
                            String excluded = !collection.isEmpty() ? '[' + CollectionsKt.joinToString$default((Iterable)((Iterable)it2), null, null, null, (int)0, null, null, (int)63, null) + ']' : null;
                            object = rule.getInclude();
                            bl3 = false;
                            bl2 = false;
                            List<String> it3 = object;
                            boolean $i$a$-let-KotlinWebpackConfig$appendCssSupport$1$included$22 = false;
                            Collection collection2 = it3;
                            boolean bl11 = false;
                            included = !collection2.isEmpty() ? '[' + CollectionsKt.joinToString$default((Iterable)it3, null, null, null, (int)0, null, null, (int)63, null) + ']' : null;
                            object = $receiver;
                            stringBuilder3 = new StringBuilder().append("\n            |       config.module.rules.push({\n            |           test: /\\.css$/,\n            |           use: use,\n            |           ");
                            string3 = excluded;
                            if (string3 == null) break block18;
                            String string4 = string3;
                            bl2 = false;
                            boolean bl12 = false;
                            String $i$a$-let-KotlinWebpackConfig$appendCssSupport$1$included$22 = string4;
                            stringBuilder2 = stringBuilder3;
                            boolean bl13 = false;
                            string2 = "exclude: " + (String)it + ',';
                            stringBuilder3 = stringBuilder2;
                            string3 = string2;
                            if (string3 != null) break block19;
                        }
                        string3 = "";
                    }
                    stringBuilder = stringBuilder3.append(string3).append("\n            |           ");
                    string = included;
                    if (string == null) break block20;
                    String string5 = string;
                    bl2 = false;
                    boolean bl14 = false;
                    String it = string5;
                    stringBuilder2 = stringBuilder;
                    boolean bl15 = false;
                    string2 = "include: " + it;
                    stringBuilder = stringBuilder2;
                    string = string2;
                    if (string != null) break block21;
                }
                string = "";
            }
            CharSequence charSequence5 = kotlin.text.StringsKt.trimMargin$default((String)stringBuilder.append(string).append("\n            |       })\n\n            ").toString(), null, (int)1, null);
            bl2 = false;
            Appendable appendable8 = object.append(charSequence5);
            Intrinsics.checkExpressionValueIsNotNull((Object)appendable8, (String)"append(value)");
            kotlin.text.StringsKt.appendln((Appendable)appendable8);
            object = $receiver;
            charSequence5 = "   })(config);\n            ";
            bl2 = false;
            Appendable appendable9 = object.append(charSequence5);
            Intrinsics.checkExpressionValueIsNotNull((Object)appendable9, (String)"append(value)");
            kotlin.text.StringsKt.appendln((Appendable)appendable9);
        }
        Appendable appendable10 = $receiver;
        CharSequence charSequence6 = "})(config);\n";
        boolean bl16 = false;
        Appendable appendable11 = appendable10.append(charSequence6);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable11, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable11);
    }

    private final void appendErrorPlugin(Appendable $receiver) {
        Appendable appendable = $receiver;
        CharSequence charSequence = "// noinspection JSUnnecessarySemicolon\n;(function(config) {\n    const tcErrorPlugin = require('kotlin-test-js-runner/tc-log-error-webpack');\n    config.plugins.push(new tcErrorPlugin(tcErrorPlugin))\n    config.stats = config.stats || {}\n    Object.assign(config.stats, config.stats, {\n        warnings: false,\n        errors: false\n    })\n})(config);";
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
    }

    private final void appendResolveModules(Appendable $receiver) {
        block6: {
            block5: {
                if (!this.resolveFromModulesFirst || this.entry == null) break block5;
                File file = this.entry;
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                if (file.getParent() != null) break block6;
            }
            return;
        }
        Appendable appendable = $receiver;
        StringBuilder stringBuilder = new StringBuilder().append("\n                // resolve modules\n                config.resolve.modules.unshift(");
        File file = this.entry;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        String string = file.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry!!.parent");
        CharSequence charSequence = kotlin.text.StringsKt.trimIndent((String)stringBuilder.append(StringsKt.jsQuoted(string)).append(")\n                \n            ").toString());
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
    }

    private final void appendProgressReporter(Appendable $receiver) {
        String string;
        if (!this.progressReporter) {
            return;
        }
        Appendable appendable = $receiver;
        StringBuilder stringBuilder = new StringBuilder().append("\n                // Report progress to console\n                // noinspection JSUnnecessarySemicolon\n                ;(function(config) {\n                    const webpack = require('webpack');\n                    const handler = (percentage, message, ...args) => {\n                        const p = percentage * 100;\n                        let msg = `${Math.trunc(p / 10)}${Math.trunc(p % 10)}% ${message} ${args.join(' ')}`;\n                        ");
        if (this.progressReporterPathFilter == null) {
            string = "";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append("\n                            msg = msg.replace(new RegExp(");
            String string2 = this.progressReporterPathFilter;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = kotlin.text.StringsKt.trimIndent((String)stringBuilder2.append(StringsKt.jsQuoted(string2)).append(", 'g'), '');\n                        ").toString());
        }
        CharSequence charSequence = kotlin.text.StringsKt.trimIndent((String)stringBuilder.append(string).append(";\n                        console.log(msg);\n                    };\n            \n                    config.plugins.push(new webpack.ProgressPlugin(handler))\n                })(config);\n                \n            ").toString());
        boolean bl = false;
        Appendable appendable2 = appendable.append(charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)appendable2, (String)"append(value)");
        kotlin.text.StringsKt.appendln((Appendable)appendable2);
    }

    private final void cssError() {
        throw (Throwable)new IllegalStateException("Possible values for cssSupport.mode:\n- EXTRACT\n- INLINE\n- IMPORT");
    }

    private final String json(Object obj) {
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        boolean bl2 = false;
        StringWriter it = stringWriter;
        boolean bl3 = false;
        new GsonBuilder().setPrettyPrinting().create().toJson(obj, (Appendable)it);
        return stringWriter.toString();
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode2), (String)"<set-?>");
        this.mode = mode2;
    }

    @Nullable
    public final File getEntry() {
        return this.entry;
    }

    public final void setEntry(@Nullable File file) {
        this.entry = file;
    }

    @Nullable
    public final KotlinWebpackOutput getOutput() {
        return this.output;
    }

    public final void setOutput(@Nullable KotlinWebpackOutput kotlinWebpackOutput) {
        this.output = kotlinWebpackOutput;
    }

    @Nullable
    public final File getOutputPath() {
        return this.outputPath;
    }

    public final void setOutputPath(@Nullable File file) {
        this.outputPath = file;
    }

    @Nullable
    public final String getOutputFileName() {
        return this.outputFileName;
    }

    public final void setOutputFileName(@Nullable String string) {
        this.outputFileName = string;
    }

    @Nullable
    public final File getConfigDirectory() {
        return this.configDirectory;
    }

    public final void setConfigDirectory(@Nullable File file) {
        this.configDirectory = file;
    }

    @Nullable
    public final File getBundleAnalyzerReportDir() {
        return this.bundleAnalyzerReportDir;
    }

    public final void setBundleAnalyzerReportDir(@Nullable File file) {
        this.bundleAnalyzerReportDir = file;
    }

    @Nullable
    public final File getReportEvaluatedConfigFile() {
        return this.reportEvaluatedConfigFile;
    }

    public final void setReportEvaluatedConfigFile(@Nullable File file) {
        this.reportEvaluatedConfigFile = file;
    }

    @Nullable
    public final DevServer getDevServer() {
        return this.devServer;
    }

    public final void setDevServer(@Nullable DevServer devServer) {
        this.devServer = devServer;
    }

    @NotNull
    public final KotlinWebpackCssSupport getCssSupport() {
        return this.cssSupport;
    }

    public final void setCssSupport(@NotNull KotlinWebpackCssSupport kotlinWebpackCssSupport) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinWebpackCssSupport, (String)"<set-?>");
        this.cssSupport = kotlinWebpackCssSupport;
    }

    @Nullable
    public final String getDevtool() {
        return this.devtool;
    }

    public final void setDevtool(@Nullable String string) {
        this.devtool = string;
    }

    public final boolean getShowProgress() {
        return this.showProgress;
    }

    public final void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public final boolean getSourceMaps() {
        return this.sourceMaps;
    }

    public final void setSourceMaps(boolean bl) {
        this.sourceMaps = bl;
    }

    public final boolean getExport() {
        return this.export;
    }

    public final void setExport(boolean bl) {
        this.export = bl;
    }

    public final boolean getProgressReporter() {
        return this.progressReporter;
    }

    public final void setProgressReporter(boolean bl) {
        this.progressReporter = bl;
    }

    @Nullable
    public final String getProgressReporterPathFilter() {
        return this.progressReporterPathFilter;
    }

    public final void setProgressReporterPathFilter(@Nullable String string) {
        this.progressReporterPathFilter = string;
    }

    public final boolean getResolveFromModulesFirst() {
        return this.resolveFromModulesFirst;
    }

    public final void setResolveFromModulesFirst(boolean bl) {
        this.resolveFromModulesFirst = bl;
    }

    public KotlinWebpackConfig(@NotNull Mode mode2, @Nullable File entry, @Nullable KotlinWebpackOutput output2, @Nullable File outputPath, @Nullable String outputFileName2, @Nullable File configDirectory2, @Nullable File bundleAnalyzerReportDir, @Nullable File reportEvaluatedConfigFile, @Nullable DevServer devServer, @NotNull KotlinWebpackCssSupport cssSupport, @Nullable String devtool, boolean showProgress, boolean sourceMaps, boolean export, boolean progressReporter, @Nullable String progressReporterPathFilter, boolean resolveFromModulesFirst) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)cssSupport, (String)"cssSupport");
        this.mode = mode2;
        this.entry = entry;
        this.output = output2;
        this.outputPath = outputPath;
        this.outputFileName = outputFileName2;
        this.configDirectory = configDirectory2;
        this.bundleAnalyzerReportDir = bundleAnalyzerReportDir;
        this.reportEvaluatedConfigFile = reportEvaluatedConfigFile;
        this.devServer = devServer;
        this.cssSupport = cssSupport;
        this.devtool = devtool;
        this.showProgress = showProgress;
        this.sourceMaps = sourceMaps;
        this.export = export;
        this.progressReporter = progressReporter;
        this.progressReporterPathFilter = progressReporterPathFilter;
        this.resolveFromModulesFirst = resolveFromModulesFirst;
    }

    public /* synthetic */ KotlinWebpackConfig(Mode mode2, File file, KotlinWebpackOutput kotlinWebpackOutput, File file2, String string, File file3, File file4, File file5, DevServer devServer, KotlinWebpackCssSupport kotlinWebpackCssSupport, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mode2 = Mode.DEVELOPMENT;
        }
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            kotlinWebpackOutput = null;
        }
        if ((n & 8) != 0) {
            file2 = null;
        }
        if ((n & 0x10) != 0) {
            File file6 = file;
            String string4 = string = file6 != null ? file6.getName() : null;
        }
        if ((n & 0x20) != 0) {
            file3 = null;
        }
        if ((n & 0x40) != 0) {
            file4 = null;
        }
        if ((n & 0x80) != 0) {
            file5 = null;
        }
        if ((n & 0x100) != 0) {
            devServer = null;
        }
        if ((n & 0x200) != 0) {
            kotlinWebpackCssSupport = new KotlinWebpackCssSupport(false, null, 3, null);
        }
        if ((n & 0x400) != 0) {
            string2 = "eval-source-map";
        }
        if ((n & 0x800) != 0) {
            bl = false;
        }
        if ((n & 0x1000) != 0) {
            bl2 = false;
        }
        if ((n & 0x2000) != 0) {
            bl3 = true;
        }
        if ((n & 0x4000) != 0) {
            bl4 = false;
        }
        if ((n & 0x8000) != 0) {
            string3 = null;
        }
        if ((n & 0x10000) != 0) {
            bl5 = false;
        }
        this(mode2, file, kotlinWebpackOutput, file2, string, file3, file4, file5, devServer, kotlinWebpackCssSupport, string2, bl, bl2, bl3, bl4, string3, bl5);
    }

    public KotlinWebpackConfig() {
        this(null, null, null, null, null, null, null, null, null, null, null, false, false, false, false, null, false, 131071, null);
    }

    @NotNull
    public final Mode component1() {
        return this.mode;
    }

    @Nullable
    public final File component2() {
        return this.entry;
    }

    @Nullable
    public final KotlinWebpackOutput component3() {
        return this.output;
    }

    @Nullable
    public final File component4() {
        return this.outputPath;
    }

    @Nullable
    public final String component5() {
        return this.outputFileName;
    }

    @Nullable
    public final File component6() {
        return this.configDirectory;
    }

    @Nullable
    public final File component7() {
        return this.bundleAnalyzerReportDir;
    }

    @Nullable
    public final File component8() {
        return this.reportEvaluatedConfigFile;
    }

    @Nullable
    public final DevServer component9() {
        return this.devServer;
    }

    @NotNull
    public final KotlinWebpackCssSupport component10() {
        return this.cssSupport;
    }

    @Nullable
    public final String component11() {
        return this.devtool;
    }

    public final boolean component12() {
        return this.showProgress;
    }

    public final boolean component13() {
        return this.sourceMaps;
    }

    public final boolean component14() {
        return this.export;
    }

    public final boolean component15() {
        return this.progressReporter;
    }

    @Nullable
    public final String component16() {
        return this.progressReporterPathFilter;
    }

    public final boolean component17() {
        return this.resolveFromModulesFirst;
    }

    @NotNull
    public final KotlinWebpackConfig copy(@NotNull Mode mode2, @Nullable File entry, @Nullable KotlinWebpackOutput output2, @Nullable File outputPath, @Nullable String outputFileName2, @Nullable File configDirectory2, @Nullable File bundleAnalyzerReportDir, @Nullable File reportEvaluatedConfigFile, @Nullable DevServer devServer, @NotNull KotlinWebpackCssSupport cssSupport, @Nullable String devtool, boolean showProgress, boolean sourceMaps, boolean export, boolean progressReporter, @Nullable String progressReporterPathFilter, boolean resolveFromModulesFirst) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)cssSupport, (String)"cssSupport");
        return new KotlinWebpackConfig(mode2, entry, output2, outputPath, outputFileName2, configDirectory2, bundleAnalyzerReportDir, reportEvaluatedConfigFile, devServer, cssSupport, devtool, showProgress, sourceMaps, export, progressReporter, progressReporterPathFilter, resolveFromModulesFirst);
    }

    public static /* synthetic */ KotlinWebpackConfig copy$default(KotlinWebpackConfig kotlinWebpackConfig, Mode mode2, File file, KotlinWebpackOutput kotlinWebpackOutput, File file2, String string, File file3, File file4, File file5, DevServer devServer, KotlinWebpackCssSupport kotlinWebpackCssSupport, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string3, boolean bl5, int n, Object object) {
        if ((n & 1) != 0) {
            mode2 = kotlinWebpackConfig.mode;
        }
        if ((n & 2) != 0) {
            file = kotlinWebpackConfig.entry;
        }
        if ((n & 4) != 0) {
            kotlinWebpackOutput = kotlinWebpackConfig.output;
        }
        if ((n & 8) != 0) {
            file2 = kotlinWebpackConfig.outputPath;
        }
        if ((n & 0x10) != 0) {
            string = kotlinWebpackConfig.outputFileName;
        }
        if ((n & 0x20) != 0) {
            file3 = kotlinWebpackConfig.configDirectory;
        }
        if ((n & 0x40) != 0) {
            file4 = kotlinWebpackConfig.bundleAnalyzerReportDir;
        }
        if ((n & 0x80) != 0) {
            file5 = kotlinWebpackConfig.reportEvaluatedConfigFile;
        }
        if ((n & 0x100) != 0) {
            devServer = kotlinWebpackConfig.devServer;
        }
        if ((n & 0x200) != 0) {
            kotlinWebpackCssSupport = kotlinWebpackConfig.cssSupport;
        }
        if ((n & 0x400) != 0) {
            string2 = kotlinWebpackConfig.devtool;
        }
        if ((n & 0x800) != 0) {
            bl = kotlinWebpackConfig.showProgress;
        }
        if ((n & 0x1000) != 0) {
            bl2 = kotlinWebpackConfig.sourceMaps;
        }
        if ((n & 0x2000) != 0) {
            bl3 = kotlinWebpackConfig.export;
        }
        if ((n & 0x4000) != 0) {
            bl4 = kotlinWebpackConfig.progressReporter;
        }
        if ((n & 0x8000) != 0) {
            string3 = kotlinWebpackConfig.progressReporterPathFilter;
        }
        if ((n & 0x10000) != 0) {
            bl5 = kotlinWebpackConfig.resolveFromModulesFirst;
        }
        return kotlinWebpackConfig.copy(mode2, file, kotlinWebpackOutput, file2, string, file3, file4, file5, devServer, kotlinWebpackCssSupport, string2, bl, bl2, bl3, bl4, string3, bl5);
    }

    @NotNull
    public String toString() {
        return "KotlinWebpackConfig(mode=" + (Object)((Object)this.mode) + ", entry=" + this.entry + ", output=" + this.output + ", outputPath=" + this.outputPath + ", outputFileName=" + this.outputFileName + ", configDirectory=" + this.configDirectory + ", bundleAnalyzerReportDir=" + this.bundleAnalyzerReportDir + ", reportEvaluatedConfigFile=" + this.reportEvaluatedConfigFile + ", devServer=" + this.devServer + ", cssSupport=" + this.cssSupport + ", devtool=" + this.devtool + ", showProgress=" + this.showProgress + ", sourceMaps=" + this.sourceMaps + ", export=" + this.export + ", progressReporter=" + this.progressReporter + ", progressReporterPathFilter=" + this.progressReporterPathFilter + ", resolveFromModulesFirst=" + this.resolveFromModulesFirst + ")";
    }

    public int hashCode() {
        Mode mode2 = this.mode;
        File file = this.entry;
        KotlinWebpackOutput kotlinWebpackOutput = this.output;
        File file2 = this.outputPath;
        String string = this.outputFileName;
        File file3 = this.configDirectory;
        File file4 = this.bundleAnalyzerReportDir;
        File file5 = this.reportEvaluatedConfigFile;
        DevServer devServer = this.devServer;
        KotlinWebpackCssSupport kotlinWebpackCssSupport = this.cssSupport;
        String string2 = this.devtool;
        int n = (((((((((((mode2 != null ? ((Object)((Object)mode2)).hashCode() : 0) * 31 + (file != null ? ((Object)file).hashCode() : 0)) * 31 + (kotlinWebpackOutput != null ? ((Object)kotlinWebpackOutput).hashCode() : 0)) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (file4 != null ? ((Object)file4).hashCode() : 0)) * 31 + (file5 != null ? ((Object)file5).hashCode() : 0)) * 31 + (devServer != null ? ((Object)devServer).hashCode() : 0)) * 31 + (kotlinWebpackCssSupport != null ? ((Object)kotlinWebpackCssSupport).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
        int n2 = this.showProgress ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        int n3 = (n + n2) * 31;
        int n4 = this.sourceMaps ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        int n5 = (n3 + n4) * 31;
        int n6 = this.export ? 1 : 0;
        if (n6 != 0) {
            n6 = 1;
        }
        int n7 = (n5 + n6) * 31;
        int n8 = this.progressReporter ? 1 : 0;
        if (n8 != 0) {
            n8 = 1;
        }
        String string3 = this.progressReporterPathFilter;
        int n9 = ((n7 + n8) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31;
        int n10 = this.resolveFromModulesFirst ? 1 : 0;
        if (n10 != 0) {
            n10 = 1;
        }
        return n9 + n10;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof KotlinWebpackConfig)) break block3;
                KotlinWebpackConfig kotlinWebpackConfig = (KotlinWebpackConfig)object;
                if (!Intrinsics.areEqual((Object)((Object)this.mode), (Object)((Object)kotlinWebpackConfig.mode)) || !Intrinsics.areEqual((Object)this.entry, (Object)kotlinWebpackConfig.entry) || !Intrinsics.areEqual((Object)this.output, (Object)kotlinWebpackConfig.output) || !Intrinsics.areEqual((Object)this.outputPath, (Object)kotlinWebpackConfig.outputPath) || !Intrinsics.areEqual((Object)this.outputFileName, (Object)kotlinWebpackConfig.outputFileName) || !Intrinsics.areEqual((Object)this.configDirectory, (Object)kotlinWebpackConfig.configDirectory) || !Intrinsics.areEqual((Object)this.bundleAnalyzerReportDir, (Object)kotlinWebpackConfig.bundleAnalyzerReportDir) || !Intrinsics.areEqual((Object)this.reportEvaluatedConfigFile, (Object)kotlinWebpackConfig.reportEvaluatedConfigFile) || !Intrinsics.areEqual((Object)this.devServer, (Object)kotlinWebpackConfig.devServer) || !Intrinsics.areEqual((Object)this.cssSupport, (Object)kotlinWebpackConfig.cssSupport) || !Intrinsics.areEqual((Object)this.devtool, (Object)kotlinWebpackConfig.devtool) || this.showProgress != kotlinWebpackConfig.showProgress || this.sourceMaps != kotlinWebpackConfig.sourceMaps || this.export != kotlinWebpackConfig.export || this.progressReporter != kotlinWebpackConfig.progressReporter || !Intrinsics.areEqual((Object)this.progressReporterPathFilter, (Object)kotlinWebpackConfig.progressReporterPathFilter) || this.resolveFromModulesFirst != kotlinWebpackConfig.resolveFromModulesFirst) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$Mode;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "DEVELOPMENT", "PRODUCTION", "kotlin-gradle-plugin"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode DEVELOPMENT;
        public static final /* enum */ Mode PRODUCTION;
        private static final /* synthetic */ Mode[] $VALUES;
        private final String code;

        static {
            Mode[] modeArray = new Mode[2];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = DEVELOPMENT = new Mode("development");
            modeArray[1] = PRODUCTION = new Mode("production");
            $VALUES = modeArray;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        private Mode(String code) {
            this.code = code;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$BundleAnalyzerPlugin;", "Ljava/io/Serializable;", "analyzerMode", "", "reportFilename", "openAnalyzer", "", "generateStatsFile", "statsFilename", "(Ljava/lang/String;Ljava/lang/String;ZZLjava/lang/String;)V", "getAnalyzerMode", "()Ljava/lang/String;", "getGenerateStatsFile", "()Z", "getOpenAnalyzer", "getReportFilename", "getStatsFilename", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "kotlin-gradle-plugin"})
    public static final class BundleAnalyzerPlugin
    implements Serializable {
        private final String analyzerMode;
        private final String reportFilename;
        private final boolean openAnalyzer;
        private final boolean generateStatsFile;
        private final String statsFilename;

        @NotNull
        public final String getAnalyzerMode() {
            return this.analyzerMode;
        }

        @NotNull
        public final String getReportFilename() {
            return this.reportFilename;
        }

        public final boolean getOpenAnalyzer() {
            return this.openAnalyzer;
        }

        public final boolean getGenerateStatsFile() {
            return this.generateStatsFile;
        }

        @NotNull
        public final String getStatsFilename() {
            return this.statsFilename;
        }

        public BundleAnalyzerPlugin(@NotNull String analyzerMode, @NotNull String reportFilename, boolean openAnalyzer, boolean generateStatsFile, @NotNull String statsFilename) {
            Intrinsics.checkParameterIsNotNull((Object)analyzerMode, (String)"analyzerMode");
            Intrinsics.checkParameterIsNotNull((Object)reportFilename, (String)"reportFilename");
            Intrinsics.checkParameterIsNotNull((Object)statsFilename, (String)"statsFilename");
            this.analyzerMode = analyzerMode;
            this.reportFilename = reportFilename;
            this.openAnalyzer = openAnalyzer;
            this.generateStatsFile = generateStatsFile;
            this.statsFilename = statsFilename;
        }

        @NotNull
        public final String component1() {
            return this.analyzerMode;
        }

        @NotNull
        public final String component2() {
            return this.reportFilename;
        }

        public final boolean component3() {
            return this.openAnalyzer;
        }

        public final boolean component4() {
            return this.generateStatsFile;
        }

        @NotNull
        public final String component5() {
            return this.statsFilename;
        }

        @NotNull
        public final BundleAnalyzerPlugin copy(@NotNull String analyzerMode, @NotNull String reportFilename, boolean openAnalyzer, boolean generateStatsFile, @NotNull String statsFilename) {
            Intrinsics.checkParameterIsNotNull((Object)analyzerMode, (String)"analyzerMode");
            Intrinsics.checkParameterIsNotNull((Object)reportFilename, (String)"reportFilename");
            Intrinsics.checkParameterIsNotNull((Object)statsFilename, (String)"statsFilename");
            return new BundleAnalyzerPlugin(analyzerMode, reportFilename, openAnalyzer, generateStatsFile, statsFilename);
        }

        public static /* synthetic */ BundleAnalyzerPlugin copy$default(BundleAnalyzerPlugin bundleAnalyzerPlugin, String string, String string2, boolean bl, boolean bl2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = bundleAnalyzerPlugin.analyzerMode;
            }
            if ((n & 2) != 0) {
                string2 = bundleAnalyzerPlugin.reportFilename;
            }
            if ((n & 4) != 0) {
                bl = bundleAnalyzerPlugin.openAnalyzer;
            }
            if ((n & 8) != 0) {
                bl2 = bundleAnalyzerPlugin.generateStatsFile;
            }
            if ((n & 0x10) != 0) {
                string3 = bundleAnalyzerPlugin.statsFilename;
            }
            return bundleAnalyzerPlugin.copy(string, string2, bl, bl2, string3);
        }

        @NotNull
        public String toString() {
            return "BundleAnalyzerPlugin(analyzerMode=" + this.analyzerMode + ", reportFilename=" + this.reportFilename + ", openAnalyzer=" + this.openAnalyzer + ", generateStatsFile=" + this.generateStatsFile + ", statsFilename=" + this.statsFilename + ")";
        }

        public int hashCode() {
            String string = this.analyzerMode;
            String string2 = this.reportFilename;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
            int n2 = this.openAnalyzer ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.generateStatsFile ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            String string3 = this.statsFilename;
            return (n3 + n4) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BundleAnalyzerPlugin)) break block3;
                    BundleAnalyzerPlugin bundleAnalyzerPlugin = (BundleAnalyzerPlugin)object;
                    if (!Intrinsics.areEqual((Object)this.analyzerMode, (Object)bundleAnalyzerPlugin.analyzerMode) || !Intrinsics.areEqual((Object)this.reportFilename, (Object)bundleAnalyzerPlugin.reportFilename) || this.openAnalyzer != bundleAnalyzerPlugin.openAnalyzer || this.generateStatsFile != bundleAnalyzerPlugin.generateStatsFile || !Intrinsics.areEqual((Object)this.statsFilename, (Object)bundleAnalyzerPlugin.statsFilename)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u001e\b\u0086\b\u0018\u00002\u00020\u0001Bi\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0018\u00010\fH\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0003Jt\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010+\u001a\u00020\nH\u00d6\u0001J\t\u0010,\u001a\u00020\rH\u00d6\u0001R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$DevServer;", "Ljava/io/Serializable;", "inline", "", "lazy", "noInfo", "open", "", "overlay", "port", "", "proxy", "", "", "contentBase", "", "(ZZZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/util/Map;Ljava/util/List;)V", "getContentBase", "()Ljava/util/List;", "getInline", "()Z", "getLazy", "getNoInfo", "getOpen", "()Ljava/lang/Object;", "getOverlay", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getProxy", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(ZZZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/util/Map;Ljava/util/List;)Lorg/jetbrains/kotlin/gradle/targets/js/webpack/KotlinWebpackConfig$DevServer;", "equals", "other", "hashCode", "toString", "kotlin-gradle-plugin"})
    public static final class DevServer
    implements Serializable {
        private final boolean inline;
        private final boolean lazy;
        private final boolean noInfo;
        private final Object open;
        private final Object overlay;
        private final Integer port;
        private final Map<String, Object> proxy;
        private final List<String> contentBase;

        public final boolean getInline() {
            return this.inline;
        }

        public final boolean getLazy() {
            return this.lazy;
        }

        public final boolean getNoInfo() {
            return this.noInfo;
        }

        @NotNull
        public final Object getOpen() {
            return this.open;
        }

        @NotNull
        public final Object getOverlay() {
            return this.overlay;
        }

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        @Nullable
        public final Map<String, Object> getProxy() {
            return this.proxy;
        }

        @NotNull
        public final List<String> getContentBase() {
            return this.contentBase;
        }

        public DevServer(boolean inline, boolean lazy, boolean noInfo, @NotNull Object open, @NotNull Object overlay, @Nullable Integer port, @Nullable Map<String, ? extends Object> proxy, @NotNull List<String> contentBase) {
            Intrinsics.checkParameterIsNotNull((Object)open, (String)"open");
            Intrinsics.checkParameterIsNotNull((Object)overlay, (String)"overlay");
            Intrinsics.checkParameterIsNotNull(contentBase, (String)"contentBase");
            this.inline = inline;
            this.lazy = lazy;
            this.noInfo = noInfo;
            this.open = open;
            this.overlay = overlay;
            this.port = port;
            this.proxy = proxy;
            this.contentBase = contentBase;
        }

        public /* synthetic */ DevServer(boolean bl, boolean bl2, boolean bl3, Object object, Object object2, Integer n, Map map, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                bl3 = true;
            }
            if ((n2 & 8) != 0) {
                object = true;
            }
            if ((n2 & 0x10) != 0) {
                object2 = false;
            }
            if ((n2 & 0x20) != 0) {
                n = null;
            }
            if ((n2 & 0x40) != 0) {
                map = null;
            }
            this(bl, bl2, bl3, object, object2, n, map, list2);
        }

        public final boolean component1() {
            return this.inline;
        }

        public final boolean component2() {
            return this.lazy;
        }

        public final boolean component3() {
            return this.noInfo;
        }

        @NotNull
        public final Object component4() {
            return this.open;
        }

        @NotNull
        public final Object component5() {
            return this.overlay;
        }

        @Nullable
        public final Integer component6() {
            return this.port;
        }

        @Nullable
        public final Map<String, Object> component7() {
            return this.proxy;
        }

        @NotNull
        public final List<String> component8() {
            return this.contentBase;
        }

        @NotNull
        public final DevServer copy(boolean inline, boolean lazy, boolean noInfo, @NotNull Object open, @NotNull Object overlay, @Nullable Integer port, @Nullable Map<String, ? extends Object> proxy, @NotNull List<String> contentBase) {
            Intrinsics.checkParameterIsNotNull((Object)open, (String)"open");
            Intrinsics.checkParameterIsNotNull((Object)overlay, (String)"overlay");
            Intrinsics.checkParameterIsNotNull(contentBase, (String)"contentBase");
            return new DevServer(inline, lazy, noInfo, open, overlay, port, proxy, contentBase);
        }

        public static /* synthetic */ DevServer copy$default(DevServer devServer, boolean bl, boolean bl2, boolean bl3, Object object, Object object2, Integer n, Map map, List list2, int n2, Object object3) {
            if ((n2 & 1) != 0) {
                bl = devServer.inline;
            }
            if ((n2 & 2) != 0) {
                bl2 = devServer.lazy;
            }
            if ((n2 & 4) != 0) {
                bl3 = devServer.noInfo;
            }
            if ((n2 & 8) != 0) {
                object = devServer.open;
            }
            if ((n2 & 0x10) != 0) {
                object2 = devServer.overlay;
            }
            if ((n2 & 0x20) != 0) {
                n = devServer.port;
            }
            if ((n2 & 0x40) != 0) {
                map = devServer.proxy;
            }
            if ((n2 & 0x80) != 0) {
                list2 = devServer.contentBase;
            }
            return devServer.copy(bl, bl2, bl3, object, object2, n, map, list2);
        }

        @NotNull
        public String toString() {
            return "DevServer(inline=" + this.inline + ", lazy=" + this.lazy + ", noInfo=" + this.noInfo + ", open=" + this.open + ", overlay=" + this.overlay + ", port=" + this.port + ", proxy=" + this.proxy + ", contentBase=" + this.contentBase + ")";
        }

        public int hashCode() {
            int n = this.inline ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.lazy ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            int n4 = (n2 + n3) * 31;
            int n5 = this.noInfo ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            Object object = this.open;
            Object object2 = this.overlay;
            Integer n6 = this.port;
            Map<String, Object> map = this.proxy;
            List<String> list2 = this.contentBase;
            return (((((n4 + n5) * 31 + (object != null ? object.hashCode() : 0)) * 31 + (object2 != null ? object2.hashCode() : 0)) * 31 + (n6 != null ? ((Object)n6).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DevServer)) break block3;
                    DevServer devServer = (DevServer)object;
                    if (this.inline != devServer.inline || this.lazy != devServer.lazy || this.noInfo != devServer.noInfo || !Intrinsics.areEqual((Object)this.open, (Object)devServer.open) || !Intrinsics.areEqual((Object)this.overlay, (Object)devServer.overlay) || !Intrinsics.areEqual((Object)this.port, (Object)devServer.port) || !Intrinsics.areEqual(this.proxy, devServer.proxy) || !Intrinsics.areEqual(this.contentBase, devServer.contentBase)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

