/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.model.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.model.CompilerArguments;
import org.jetbrains.kotlin.gradle.model.ExperimentalFeatures;
import org.jetbrains.kotlin.gradle.model.KotlinProject;
import org.jetbrains.kotlin.gradle.model.SourceSet;
import org.jetbrains.kotlin.gradle.model.impl.CompilerArgumentsImpl;
import org.jetbrains.kotlin.gradle.model.impl.ExperimentalFeaturesImpl;
import org.jetbrains.kotlin.gradle.model.impl.KotlinProjectImpl;
import org.jetbrains.kotlin.gradle.model.impl.SourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "kotlinPluginVersion", "", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;)V", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "kotlin-gradle-plugin"})
public final class KotlinModelBuilder
implements ToolingModelBuilder {
    private final String kotlinPluginVersion;
    private final KotlinAndroidTarget androidTarget;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName())) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            TaskCollection taskCollection = project.getTasks().withType(AbstractKotlinCompile.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)taskCollection, (String)"project.tasks.withType(A\u2026otlinCompile::class.java)");
            List kotlinCompileTasks = CollectionsKt.toList((Iterable)((Iterable)taskCollection));
            KotlinProject.ProjectType projectType = KotlinModelBuilder.Companion.getProjectType(project);
            String string = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
            Iterable iterable = kotlinCompileTasks;
            KotlinProject.ProjectType projectType2 = projectType;
            String string2 = this.kotlinPluginVersion;
            String string3 = string;
            boolean $i$f$mapNotNull = false;
            void var7_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SourceSet sourceSet;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv$iv;
                boolean bl2 = false;
                if (this.androidTarget != null) {
                    AbstractKotlinCompile abstractKotlinCompile = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractKotlinCompile, (String)"it");
                    sourceSet = KotlinModelBuilder.Companion.createAndroidSourceSet(abstractKotlinCompile, this.androidTarget);
                } else {
                    AbstractKotlinCompile abstractKotlinCompile = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)abstractKotlinCompile, (String)"it");
                    sourceSet = KotlinModelBuilder.Companion.createSourceSet(abstractKotlinCompile, project, projectType);
                }
                if (sourceSet == null) continue;
                SourceSet sourceSet2 = sourceSet;
                boolean bl3 = false;
                boolean bl4 = false;
                SourceSet it$iv$iv = sourceSet2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            Collection collection = list2;
            Collection collection2 = KotlinModelBuilder.Companion.getExpectedByDependencies(project);
            Object object = CollectionsKt.first((List)kotlinCompileTasks);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            ExperimentalFeatures experimentalFeatures = KotlinModelBuilder.Companion.createExperimentalFeatures((AbstractKotlinCompile)object);
            Collection collection3 = collection2;
            Collection collection4 = collection;
            KotlinProject.ProjectType projectType3 = projectType2;
            String string4 = string2;
            String string5 = string3;
            return new KotlinProjectImpl(string5, string4, projectType3, collection4, collection3, experimentalFeatures);
        }
        return null;
    }

    public KotlinModelBuilder(@NotNull String kotlinPluginVersion, @Nullable KotlinAndroidTarget androidTarget) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.androidTarget = androidTarget;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u0006\u0012\u0002\b\u00030\fH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0007H\u0002J\u0014\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00050\u0005*\u00020\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion;", "", "()V", "getExpectedByDependencies", "", "", "project", "Lorg/gradle/api/Project;", "getProjectType", "Lorg/jetbrains/kotlin/gradle/model/KotlinProject$ProjectType;", "createAndroidSourceSet", "Lorg/jetbrains/kotlin/gradle/model/SourceSet;", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompile;", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "createCompilerArguments", "Lorg/jetbrains/kotlin/gradle/model/CompilerArguments;", "createExperimentalFeatures", "Lorg/jetbrains/kotlin/gradle/model/ExperimentalFeatures;", "createSourceSet", "projectType", "findFriendSourceSets", "isAndroid", "", "pathOrName", "kotlin.jvm.PlatformType", "kotlin-gradle-plugin"})
    public static final class Companion {
        private final boolean isAndroid(Project $receiver) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            return project.getPlugins().hasPlugin("kotlin-android");
        }

        private final KotlinProject.ProjectType getProjectType(Project project) {
            return project.getPlugins().hasPlugin("kotlin") || project.getPlugins().hasPlugin("kotlin-platform-jvm") || this.isAndroid(project) ? KotlinProject.ProjectType.PLATFORM_JVM : (project.getPlugins().hasPlugin("kotlin2js") || project.getPlugins().hasPlugin("kotlin-platform-js") ? KotlinProject.ProjectType.PLATFORM_JS : KotlinProject.ProjectType.PLATFORM_COMMON);
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> getExpectedByDependencies(Project project) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])new String[]{"expectedBy", "implement"});
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                Configuration configuration2 = (Configuration)project.getConfigurations().findByName(it);
                list$iv$iv = configuration2 != null && (configuration2 = configuration2.getDependencies()) != null ? (Set)configuration2 : SetsKt.emptySet();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProjectDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            list$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                Project project2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                boolean bl = false;
                ProjectDependency it2 = (ProjectDependency)element$iv$iv;
                boolean bl2 = false;
                if (it2.getDependencyProject() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Project it$iv$iv = project2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = Companion.pathOrName((Project)it);
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        private final String pathOrName(Project $receiver) {
            return Intrinsics.areEqual((Object)$receiver.getPath(), (Object)":") ? $receiver.getName() : $receiver.getPath();
        }

        private final SourceSet createSourceSet(AbstractKotlinCompile<?> $receiver, Project project, KotlinProject.ProjectType projectType) {
            SourceSet sourceSet;
            KotlinSourceSet kotlinSourceSet;
            Object object;
            org.gradle.api.tasks.SourceSet javaSourceSet;
            org.gradle.api.tasks.SourceSet sourceSet2;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention != null && (javaPluginConvention = javaPluginConvention.getSourceSets()) != null) {
                Object v2;
                block7: {
                    Iterable iterable = (Iterable)javaPluginConvention;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        org.gradle.api.tasks.SourceSet it = (org.gradle.api.tasks.SourceSet)t;
                        boolean bl3 = false;
                        org.gradle.api.tasks.SourceSet sourceSet3 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet3, (String)"it");
                        if (!Intrinsics.areEqual((Object)sourceSet3.getName(), (Object)$receiver.getSourceSetName$kotlin_gradle_plugin())) continue;
                        v2 = t;
                        break block7;
                    }
                    v2 = null;
                }
                sourceSet2 = v2;
            } else {
                sourceSet2 = null;
            }
            org.gradle.api.tasks.SourceSet sourceSet4 = javaSourceSet = sourceSet2;
            if (!((sourceSet4 != null ? GradleUtilsKt.getConvention(sourceSet4, projectType == KotlinProject.ProjectType.PLATFORM_JS ? KotlinPluginKt.getKOTLIN_JS_DSL_NAME() : KotlinPluginKt.getKOTLIN_DSL_NAME()) : (object = null)) instanceof KotlinSourceSet)) {
                object = null;
            }
            if ((kotlinSourceSet = (KotlinSourceSet)object) != null) {
                String string = $receiver.getSourceSetName$kotlin_gradle_plugin();
                SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)$receiver.getSourceSetName$kotlin_gradle_plugin(), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
                Collection<String> collection = this.findFriendSourceSets($receiver);
                Set set2 = kotlinSourceSet.getKotlin().getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"kotlinSourceSet.kotlin.srcDirs");
                Collection collection2 = set2;
                SourceDirectorySet sourceDirectorySet = javaSourceSet.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceDirectorySet, (String)"javaSourceSet.resources");
                Set set3 = sourceDirectorySet.getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"javaSourceSet.resources.srcDirs");
                Collection collection3 = set3;
                File file = $receiver.getDestinationDir();
                SourceSetOutput sourceSetOutput = javaSourceSet.getOutput();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceSetOutput, (String)"javaSourceSet.output");
                File file2 = sourceSetOutput.getResourcesDir();
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"javaSourceSet.output.resourcesDir!!");
                sourceSet = new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, file, file2, this.createCompilerArguments($receiver));
            } else {
                sourceSet = null;
            }
            return sourceSet;
        }

        /*
         * WARNING - void declaration
         */
        private final SourceSet createAndroidSourceSet(AbstractKotlinCompile<?> $receiver, KotlinAndroidTarget androidTarget) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            String variantName = $receiver.getSourceSetName$kotlin_gradle_plugin();
            KotlinJvmAndroidCompilation compilation2 = (KotlinJvmAndroidCompilation)androidTarget.getCompilations().getByName(variantName);
            Iterable $this$flatMap$iv = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getKotlin().getSrcDirs();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            Iterable list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                File it = (File)e$iv;
                boolean bl = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                String key$iv = file.getAbsolutePath();
                if (!set$iv.add(key$iv)) continue;
                ((ArrayList)list$iv).add(e$iv);
            }
            List sources = (List)list$iv;
            Iterable $this$flatMap$iv2 = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap2 = false;
            list$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getResources().getSrcDirs();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable $this$distinctBy$iv2 = (List)destination$iv$iv2;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv2 = new HashSet<String>();
            ArrayList list$iv2 = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv2) {
                File it = (File)e$iv;
                boolean bl = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                String key$iv = file.getAbsolutePath();
                if (!set$iv2.add(key$iv)) continue;
                list$iv2.add(e$iv);
            }
            List resources = list$iv2;
            return new SourceSetImpl($receiver.getSourceSetName$kotlin_gradle_plugin(), StringsKt.contains((CharSequence)$receiver.getSourceSetName$kotlin_gradle_plugin(), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION, this.findFriendSourceSets($receiver), sources, resources, $receiver.getDestinationDir(), compilation2.getOutput().getResourcesDir(), this.createCompilerArguments($receiver));
        }

        private final Collection<String> findFriendSourceSets(AbstractKotlinCompile<?> $receiver) {
            ArrayList<String> friendSourceSets = new ArrayList<String>();
            Iterable<KotlinCompilation<?>> $this$forEach$iv = KotlinCompilationsKt.getAssociateWithTransitiveClosure($receiver.getTaskData$kotlin_gradle_plugin().getCompilation());
            boolean $i$f$forEach = false;
            Iterator<KotlinCompilation<?>> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                KotlinCompilation<?> element$iv;
                KotlinCompilation<?> associateCompilation = element$iv = iterator.next();
                boolean bl = false;
                friendSourceSets.add(associateCompilation.getName());
            }
            return friendSourceSets;
        }

        private final CompilerArguments createCompilerArguments(AbstractKotlinCompile<?> $receiver) {
            return new CompilerArgumentsImpl($receiver.getSerializedCompilerArguments(), $receiver.getDefaultSerializedCompilerArguments(), CollectionsKt.toList($receiver.getCompileClasspath$kotlin_gradle_plugin()));
        }

        private final ExperimentalFeatures createExperimentalFeatures(AbstractKotlinCompile<?> $receiver) {
            return new ExperimentalFeaturesImpl((String)$receiver.getCoroutinesStr$kotlin_gradle_plugin().get());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

