/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandler;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporter;", "Lorg/gradle/BuildAdapter;", "Lorg/gradle/api/execution/TaskExecutionListener;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "perfReportFile", "Ljava/io/File;", "(Lorg/gradle/api/invocation/Gradle;Ljava/io/File;)V", "allTasksTimeNs", "", "kotlinTaskTimeNs", "Ljava/util/HashMap;", "Lorg/gradle/api/Task;", "taskStartNs", "tasksSb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "afterExecute", "", "task", "state", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "buildFinished", "result", "Lorg/gradle/BuildResult;", "kotlin-gradle-plugin"})
public final class KotlinBuildReporter
extends BuildAdapter
implements TaskExecutionListener {
    private final HashMap<Task, Long> taskStartNs;
    private final HashMap<Task, Long> kotlinTaskTimeNs;
    private final StringBuilder tasksSb;
    private volatile long allTasksTimeNs;
    private final Gradle gradle;
    private final File perfReportFile;

    public synchronized void beforeExecute(@NotNull Task task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        ((Map)this.taskStartNs).put(task, System.nanoTime());
    }

    public synchronized void afterExecute(@NotNull Task task, @NotNull TaskState state) {
        String path;
        boolean bl;
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Long l = this.taskStartNs.get(task);
        if (l == null) {
            return;
        }
        Long startNs = l;
        long endNs = System.nanoTime();
        Long l2 = startNs;
        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"startNs");
        long timeNs = endNs - l2;
        this.allTasksTimeNs += timeNs;
        String string2 = task.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.javaClass.name");
        if (!StringsKt.startsWith$default((String)string2, (String)"org.jetbrains.kotlin", (boolean)false, (int)2, null)) {
            return;
        }
        ((Map)this.kotlinTaskTimeNs).put(task, timeNs);
        StringsKt.appendln((StringBuilder)this.tasksSb);
        String skipMessage = state.getSkipMessage();
        if (skipMessage != null) {
            stringBuilder = this.tasksSb;
            string = task + " was skipped: " + skipMessage;
            bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
        } else {
            stringBuilder = this.tasksSb;
            string = task + " finished in " + KotlinBuildReporterHandlerKt.formatTime(timeNs);
            bl = false;
            StringBuilder stringBuilder3 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
        }
        String string3 = path = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
        TaskExecutionResult executionResult = TaskExecutionResults.INSTANCE.get(string3);
        if (executionResult != null) {
            Object object = this.tasksSb;
            String string4 = "Execution strategy: " + executionResult.getExecutionStrategy();
            boolean bl2 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)object).append(string4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            List<String> list2 = executionResult.getIcLogLines();
            if (list2 != null) {
                object = list2;
                boolean bl3 = false;
                bl2 = false;
                Object lines = object;
                boolean bl4 = false;
                StringBuilder stringBuilder5 = this.tasksSb;
                String string5 = "Compilation log for " + task + ':';
                boolean bl5 = false;
                StringBuilder stringBuilder6 = stringBuilder5.append(string5);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
                Iterable $this$forEach$iv = (Iterable)lines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl6 = false;
                    StringBuilder stringBuilder7 = this.tasksSb;
                    String string6 = "  " + it;
                    boolean bl7 = false;
                    StringBuilder stringBuilder8 = stringBuilder7.append(string6);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder8);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void buildFinished(@NotNull BuildResult result2) {
        Map map;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Map map2 = this.kotlinTaskTimeNs;
        File file = this.perfReportFile;
        Gradle gradle = this.gradle;
        KotlinBuildReporterHandler kotlinBuildReporterHandler = new KotlinBuildReporterHandler();
        boolean $i$f$mapKeys = false;
        void var4_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            String string = ((Task)it.getKey()).getPath();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = string;
            Map map3 = map;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string2, entry);
        }
        map = destination$iv$iv;
        kotlinBuildReporterHandler.buildFinished(gradle, file, map, this.allTasksTimeNs, result2.getFailure());
    }

    public KotlinBuildReporter(@NotNull Gradle gradle, @NotNull File perfReportFile) {
        File dir;
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull((Object)perfReportFile, (String)"perfReportFile");
        this.gradle = gradle;
        this.perfReportFile = perfReportFile;
        File file = dir = this.perfReportFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
        boolean bl = file.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = dir + " does not exist or is a file";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !this.perfReportFile.isFile();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Build report log file " + this.perfReportFile + " exists already";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.taskStartNs = new HashMap();
        this.kotlinTaskTimeNs = new HashMap();
        this.tasksSb = new StringBuilder();
    }
}

