/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.compilerRunner.ProjectFilesForCompilation;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoProvider;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaTarget;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompileTaskData;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 82\u00020\u0001:\u00018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0014J2\u0010)\u001a\u00020!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010-\u001a\u00020.2\u0006\u0010%\u001a\u00020&JJ\u0010/\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060+2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060+2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0006032\b\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u0002052\u0006\u0010%\u001a\u00020&J$\u00106\u001a\u00020!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010-\u001a\u0002072\u0006\u0010%\u001a\u00020&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0014\u0010\u0018\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u0014\u0010\u001c\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;)V", "buildDirProvider", "Ljava/io/File;", "getBuildDirProvider$kotlin_gradle_plugin", "()Ljava/io/File;", "incrementalModuleInfoProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/incremental/IncrementalModuleInfoProvider;", "getIncrementalModuleInfoProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "loggerProvider", "Lorg/gradle/api/logging/Logger;", "getLoggerProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/logging/Logger;", "pathProvider", "", "getPathProvider$kotlin_gradle_plugin", "()Ljava/lang/String;", "projectDirProvider", "getProjectDirProvider$kotlin_gradle_plugin", "projectNameProvider", "getProjectNameProvider$kotlin_gradle_plugin", "projectRootDirProvider", "getProjectRootDirProvider$kotlin_gradle_plugin", "sessionDirProvider", "getSessionDirProvider$kotlin_gradle_plugin", "getTaskProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "runCompilerAsync", "", "compilerClassName", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "runJsCompilerAsync", "kotlinSources", "", "kotlinCommonSources", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "runJvmCompilerAsync", "sourcesToCompile", "commonSources", "javaSourceRoots", "", "javaPackagePrefix", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "runMetadataCompilerAsync", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "Companion", "kotlin-gradle-plugin"})
public class GradleCompilerRunner {
    private final String pathProvider;
    private final Logger loggerProvider;
    private final File buildDirProvider;
    private final File projectDirProvider;
    private final File projectRootDirProvider;
    private final File sessionDirProvider;
    private final String projectNameProvider;
    private final Provider<? extends IncrementalModuleInfoProvider> incrementalModuleInfoProvider;
    private final GradleCompileTaskProvider taskProvider;
    private static volatile WeakReference<Gradle> cachedGradle;
    private static volatile IncrementalModuleInfo cachedModulesInfo;
    private static volatile File clientIsAliveFlagFile;
    private static volatile File sessionFlagFile;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getPathProvider$kotlin_gradle_plugin() {
        return this.pathProvider;
    }

    @NotNull
    public final Logger getLoggerProvider$kotlin_gradle_plugin() {
        return this.loggerProvider;
    }

    @NotNull
    public final File getBuildDirProvider$kotlin_gradle_plugin() {
        return this.buildDirProvider;
    }

    @NotNull
    public final File getProjectDirProvider$kotlin_gradle_plugin() {
        return this.projectDirProvider;
    }

    @NotNull
    public final File getProjectRootDirProvider$kotlin_gradle_plugin() {
        return this.projectRootDirProvider;
    }

    @NotNull
    public final File getSessionDirProvider$kotlin_gradle_plugin() {
        return this.sessionDirProvider;
    }

    @NotNull
    public final String getProjectNameProvider$kotlin_gradle_plugin() {
        return this.projectNameProvider;
    }

    @NotNull
    public final Provider<? extends IncrementalModuleInfoProvider> getIncrementalModuleInfoProvider$kotlin_gradle_plugin() {
        return this.incrementalModuleInfoProvider;
    }

    public final void runJvmCompilerAsync(@NotNull List<? extends File> sourcesToCompile, @NotNull List<? extends File> commonSources, @NotNull Iterable<? extends File> javaSourceRoots2, @Nullable String javaPackagePrefix2, @NotNull K2JVMCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        File it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkParameterIsNotNull(commonSources, (String)"commonSources");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots2, (String)"javaSourceRoots");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        K2JVMCompilerArguments k2JVMCompilerArguments = args;
        Iterable iterable = sourcesToCompile;
        Collection collection = k2JVMCompilerArguments.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments2 = k2JVMCompilerArguments;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JVMCompilerArguments2.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        $this$map$iv = commonSources;
        k2JVMCompilerArguments2 = args;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        Iterable<Object> $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments2.setCommonSources(stringArray);
        $this$toTypedArray$iv = javaSourceRoots2;
        k2JVMCompilerArguments2 = args;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments2.setJavaSourceRoots(stringArray2);
        args.setJavaPackagePrefix(javaPackagePrefix2);
        this.runCompilerAsync("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler", (CommonCompilerArguments)args, environment);
    }

    public final void runJsCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull List<? extends File> kotlinCommonSources, @NotNull K2JSCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        File it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull(kotlinCommonSources, (String)"kotlinCommonSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        K2JSCompilerArguments k2JSCompilerArguments = args;
        Iterable iterable = kotlinSources;
        Collection collection = k2JSCompilerArguments.getFreeArgs();
        K2JSCompilerArguments k2JSCompilerArguments2 = k2JSCompilerArguments;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JSCompilerArguments2.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        $this$map$iv = kotlinCommonSources;
        k2JSCompilerArguments2 = args;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = collection = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JSCompilerArguments2.setCommonSources(stringArray);
        this.runCompilerAsync("org.jetbrains.kotlin.cli.js.K2JSCompiler", (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    public final void runMetadataCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull K2MetadataCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        K2MetadataCompilerArguments k2MetadataCompilerArguments = args;
        Iterable iterable = kotlinSources;
        Collection collection2 = k2MetadataCompilerArguments.getFreeArgs();
        K2MetadataCompilerArguments k2MetadataCompilerArguments2 = k2MetadataCompilerArguments;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        k2MetadataCompilerArguments2.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        this.runCompilerAsync("org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler", (CommonCompilerArguments)args, environment);
    }

    private final void runCompilerAsync(String compilerClassName, CommonCompilerArguments compilerArgs, GradleCompilerEnvironment environment) {
        IncrementalModuleInfo incrementalModuleInfo;
        IncrementalCompilationEnvironment incrementalCompilationEnvironment;
        if (compilerArgs.getVersion()) {
            this.loggerProvider.lifecycle("Kotlin version " + ReportUtilsKt.loadCompilerVersion(environment.getCompilerClasspath()) + " (JRE " + System.getProperty("java.runtime.version") + ")");
            compilerArgs.setVersion(false);
        }
        List list2 = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)((CommonToolArguments)compilerArgs));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ArgumentUtils.convertArg\u2026oStringList(compilerArgs)");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super IStatisticsValuesConsumer, Unit>)((Function1)new Function1<IStatisticsValuesConsumer, Unit>(compilerArgs, argsArray){
            final /* synthetic */ CommonCompilerArguments $compilerArgs;
            final /* synthetic */ String[] $argsArray;

            public final void invoke(@NotNull IStatisticsValuesConsumer it) {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (!(this.$compilerArgs instanceof K2JVMCompilerArguments)) break block2;
                    K2JVMCompilerArguments args = new K2JVMCompilerArguments();
                    ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])this.$argsArray), (CommonToolArguments)((CommonToolArguments)args));
                    IStatisticsValuesConsumer iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance();
                    if (iStatisticsValuesConsumer != null) {
                        IStatisticsValuesConsumer.DefaultImpls.report$default(iStatisticsValuesConsumer, BooleanMetrics.JVM_COMPILER_IR_MODE, args.getUseIR(), null, 4, null);
                    }
                    IStatisticsValuesConsumer iStatisticsValuesConsumer2 = KotlinBuildStatsService.Companion.getInstance();
                    if (iStatisticsValuesConsumer2 != null) {
                        IStatisticsValuesConsumer.DefaultImpls.report$default(iStatisticsValuesConsumer2, StringMetrics.JVM_DEFAULTS, args.getJvmDefault(), null, 4, null);
                    }
                }
            }
            {
                this.$compilerArgs = commonCompilerArguments;
                this.$argsArray = stringArray;
                super(1);
            }
        }));
        IncrementalCompilationEnvironment incrementalCompilationEnvironment2 = incrementalCompilationEnvironment = environment.getIncrementalCompilationEnvironment();
        if (incrementalCompilationEnvironment2 != null) {
            thisCollection$iv = incrementalCompilationEnvironment2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = thisCollection$iv;
            boolean bl3 = false;
            incrementalModuleInfo = ((IncrementalModuleInfoProvider)this.incrementalModuleInfoProvider.get()).getInfo();
        } else {
            incrementalModuleInfo = null;
        }
        IncrementalModuleInfo modulesInfo = incrementalModuleInfo;
        GradleKotlinCompilerWorkArguments workArgs = new GradleKotlinCompilerWorkArguments(new ProjectFilesForCompilation(this.loggerProvider, this.projectDirProvider, this.buildDirProvider, this.projectNameProvider, this.projectRootDirProvider, this.sessionDirProvider), environment.getCompilerFullClasspath(), compilerClassName, argsArray, compilerArgs.getVerbose(), incrementalCompilationEnvironment, modulesInfo, CollectionsKt.toList((Iterable)((Iterable)environment.getOutputFiles())), this.pathProvider, environment.getBuildReportMode(), environment.getKotlinScriptExtensions(), compilerArgs.getAllWarningsAsErrors());
        TaskLoggers.INSTANCE.put(this.pathProvider, this.loggerProvider);
        this.runCompilerAsync(workArgs);
    }

    protected void runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs) {
        Intrinsics.checkParameterIsNotNull((Object)workArgs, (String)"workArgs");
        GradleKotlinCompilerWork kotlinCompilerRunnable = new GradleKotlinCompilerWork(workArgs);
        kotlinCompilerRunnable.run();
    }

    @NotNull
    protected final GradleCompileTaskProvider getTaskProvider() {
        return this.taskProvider;
    }

    public GradleCompilerRunner(@NotNull GradleCompileTaskProvider taskProvider) {
        Intrinsics.checkParameterIsNotNull((Object)taskProvider, (String)"taskProvider");
        this.taskProvider = taskProvider;
        this.pathProvider = this.taskProvider.getPath();
        this.loggerProvider = this.taskProvider.getLogger();
        this.buildDirProvider = this.taskProvider.getBuildDir();
        this.projectDirProvider = this.taskProvider.getProjectDir();
        this.projectRootDirProvider = this.taskProvider.getRootDir();
        this.sessionDirProvider = this.taskProvider.getSessionsDir();
        this.projectNameProvider = this.taskProvider.getProjectName();
        this.incrementalModuleInfoProvider = this.taskProvider.getBuildModulesInfo();
    }

    static {
        Companion = new Companion(null);
        cachedGradle = new WeakReference<Object>(null);
    }

    public static final /* synthetic */ File access$getClientIsAliveFlagFile$cp() {
        return clientIsAliveFlagFile;
    }

    public static final /* synthetic */ void access$setClientIsAliveFlagFile$cp(File file) {
        clientIsAliveFlagFile = file;
    }

    public static final /* synthetic */ File access$getSessionFlagFile$cp() {
        return sessionFlagFile;
    }

    public static final /* synthetic */ void access$setSessionFlagFile$cp(File file) {
        sessionFlagFile = file;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J=\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J%\u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001fH\u0002J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b)J\u0011\u0010*\u001a\u00020\u001f*\u00020\u001fH\u0000\u00a2\u0006\u0002\b+R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner$Companion;", "", "()V", "cachedGradle", "Ljava/lang/ref/WeakReference;", "Lorg/gradle/api/invocation/Gradle;", "cachedModulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "clientIsAliveFlagFile", "Ljava/io/File;", "sessionFlagFile", "buildModulesInfo", "gradle", "buildModulesInfo$kotlin_gradle_plugin", "clearBuildModulesInfo", "", "clearBuildModulesInfo$kotlin_gradle_plugin", "getDaemonConnectionImpl", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "sessionIsAliveFlagFile", "compilerFullClasspath", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "isDebugEnabled", "", "getDaemonConnectionImpl$kotlin_gradle_plugin", "getOrCreateClientFlagFile", "log", "Lorg/gradle/api/logging/Logger;", "projectName", "", "getOrCreateClientFlagFile$kotlin_gradle_plugin", "getOrCreateSessionFlagFile", "sessionsDir", "projectRootDir", "getOrCreateSessionFlagFile$kotlin_gradle_plugin", "jarForSourceSet", "project", "Lorg/gradle/api/Project;", "sourceSetName", "sessionsDir$kotlin_gradle_plugin", "normalizeForFlagFile", "normalizeForFlagFile$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
    public static final class Companion {
        @Nullable
        public final synchronized CompileServiceSession getDaemonConnectionImpl$kotlin_gradle_plugin(@NotNull File clientIsAliveFlagFile, @NotNull File sessionIsAliveFlagFile, @NotNull List<? extends File> compilerFullClasspath, @NotNull MessageCollector messageCollector, boolean isDebugEnabled) {
            Intrinsics.checkParameterIsNotNull((Object)clientIsAliveFlagFile, (String)"clientIsAliveFlagFile");
            Intrinsics.checkParameterIsNotNull((Object)sessionIsAliveFlagFile, (String)"sessionIsAliveFlagFile");
            Intrinsics.checkParameterIsNotNull(compilerFullClasspath, (String)"compilerFullClasspath");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)compilerFullClasspath);
            boolean bl = false;
            ArrayList additionalJvmParams = new ArrayList();
            Collection $this$toTypedArray$iv = additionalJvmParams;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)clientIsAliveFlagFile, (File)sessionIsAliveFlagFile, (MessageCollector)messageCollector, (boolean)isDebugEnabled, null, (String[])stringArray, (int)32, null);
        }

        @NotNull
        public final synchronized IncrementalModuleInfo buildModulesInfo$kotlin_gradle_plugin(@NotNull Gradle gradle) {
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            if ((Gradle)cachedGradle.get() == gradle && cachedModulesInfo != null) {
                IncrementalModuleInfo incrementalModuleInfo = cachedModulesInfo;
                if (incrementalModuleInfo == null) {
                    Intrinsics.throwNpe();
                }
                return incrementalModuleInfo;
            }
            HashMap dirToModule = new HashMap();
            HashMap nameToModules = new HashMap();
            HashMap jarToClassListFile = new HashMap();
            HashMap jarToModule = new HashMap();
            Project project = gradle.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
            Iterator iterator = project.getAllprojects().iterator();
            while (iterator.hasNext()) {
                Project project2;
                Project project3 = project2 = (Project)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                if (KotlinProjectExtensionKt.getKotlinExtensionOrNull(project3) == null) continue;
                boolean isMultiplatformProject = KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(project2) != null;
                Iterable<KotlinCompileTaskData> $this$forEach$iv = KotlinCompileTaskData.Companion.getTaskDataContainer(project2);
                boolean $i$f$forEach = false;
                Iterator<KotlinCompileTaskData> iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    File $this$getOrPut$iv;
                    Object it;
                    boolean bl;
                    Object object2;
                    KotlinCompileTaskData element$iv;
                    KotlinCompileTaskData taskData = element$iv = iterator2.next();
                    boolean bl2 = false;
                    KotlinCompilation<?> compilation2 = taskData.getCompilation();
                    KotlinTarget target2 = taskData.getCompilation().getTarget();
                    String string = project2.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.path");
                    String string2 = KotlinCompilationsKt.getOwnModuleName(compilation2);
                    File file = project2.getBuildDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
                    IncrementalModuleEntry module = new IncrementalModuleEntry(string, string2, file, taskData.getBuildHistoryFile());
                    Map map = dirToModule;
                    Object object3 = taskData.getDestinationDir().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"taskData.destinationDir.get()");
                    map.put(object3, module);
                    File file2 = taskData.getJavaOutputDir();
                    if (file2 != null) {
                        object2 = file2;
                        boolean bl3 = false;
                        bl = false;
                        it = object2;
                        boolean bl4 = false;
                        ((Map)dirToModule).put(it, module);
                    }
                    object2 = nameToModules;
                    String key$iv = module.getName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        HashSet answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((HashSet)object).add(module);
                    if (compilation2.getPlatformType() == KotlinPlatformType.js && Companion.jarForSourceSet(project2, compilation2.getName()) != null) {
                        boolean bl6 = false;
                        bl = false;
                        it = $this$getOrPut$iv;
                        boolean bl7 = false;
                        ((Map)jarToModule).put(it, module);
                    }
                    if (!KotlinCompilationsKt.isMain(compilation2)) continue;
                    if (isMultiplatformProject) {
                        try {
                            Task task = project2.getTasks().getByName(target2.getArtifactsTaskName());
                            if (task == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.bundling.AbstractArchiveTask");
                            }
                            AbstractArchiveTask archiveTask = (AbstractArchiveTask)task;
                            Map map2 = jarToModule;
                            File file3 = CompatibiltiyKt.getArchivePathCompatible(archiveTask).getCanonicalFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"archiveTask.archivePathCompatible.canonicalFile");
                            map2.put(file3, module);
                        }
                        catch (UnknownTaskException archiveTask) {}
                        continue;
                    }
                    if (!(target2 instanceof KotlinWithJavaTarget)) continue;
                    Task task = project2.getTasks().getByName(target2.getArtifactsTaskName());
                    if (task == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.jvm.tasks.Jar");
                    }
                    Jar jar = (Jar)task;
                    Map map3 = jarToClassListFile;
                    File file4 = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"jar.archivePathCompatible.canonicalFile");
                    Object object4 = ((KotlinWithJavaTarget)target2).getDefaultArtifactClassesListFile$kotlin_gradle_plugin().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"target.defaultArtifactClassesListFile.get()");
                    map3.put(file4, object4);
                }
            }
            Project project4 = gradle.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"gradle.rootProject");
            File file = project4.getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"gradle.rootProject.projectDir");
            IncrementalModuleInfo incrementalModuleInfo = new IncrementalModuleInfo(file, (Map)dirToModule, (Map)nameToModules, (Map)jarToClassListFile, (Map)jarToModule);
            boolean bl = false;
            boolean bl8 = false;
            IncrementalModuleInfo it = incrementalModuleInfo;
            boolean bl9 = false;
            cachedGradle = new WeakReference<Gradle>(gradle);
            cachedModulesInfo = it;
            return incrementalModuleInfo;
        }

        private final File jarForSourceSet(Project project, String sourceSetName) {
            Jar jarTask;
            Jar jar;
            JavaPluginConvention javaConvention;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                return null;
            }
            JavaPluginConvention javaPluginConvention2 = javaConvention = javaPluginConvention;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention2, (String)"javaConvention");
            SourceSet sourceSet = (SourceSet)javaPluginConvention2.getSourceSets().findByName(sourceSetName);
            if (sourceSet == null) {
                return null;
            }
            SourceSet sourceSet2 = sourceSet;
            TaskContainer taskContainer = project.getTasks();
            SourceSet sourceSet3 = sourceSet2;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceSet3, (String)"sourceSet");
            Object object = taskContainer.findByName(sourceSet3.getJarTaskName());
            if (!(object instanceof Jar)) {
                object = null;
            }
            return (jar = (jarTask = (Jar)object)) != null && (jar = jar.getArchiveFile()) != null && (jar = (RegularFile)jar.get()) != null ? jar.getAsFile() : null;
        }

        public final synchronized void clearBuildModulesInfo$kotlin_gradle_plugin() {
            cachedGradle = new WeakReference<Object>(null);
            cachedModulesInfo = null;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateClientFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull String projectName) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            if (GradleCompilerRunner.access$getClientIsAliveFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                GradleCompilerRunner.access$setClientIsAliveFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-in-" + projectName + '-', ".alive", null, false, 12, null));
                $receiver$iv = log;
                $i$f$kotlinDebug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    var6_7 = $receiver$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$1 = false;
                    v1 = new StringBuilder().append("Created client-is-alive flag file: ");
                    v2 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    var7_11 = v1.append(v2.getCanonicalPath()).toString();
                    GradleLoggingUtilsKt.kotlinDebug(var6_7, var7_11);
                }
            } else {
                $receiver$iv = log;
                $i$f$kotlinDebug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    var6_8 = $receiver$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$2 = false;
                    v3 = new StringBuilder().append("Existing client-is-alive flag file: ");
                    v4 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    var7_12 = v3.append(v4.getCanonicalPath()).toString();
                    GradleLoggingUtilsKt.kotlinDebug(var6_8, var7_12);
                }
            }
            v5 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            return v5;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String normalizeForFlagFile$kotlin_gradle_plugin(@NotNull String $receiver) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            char c = 'a';
            CharRange charRange = new CharRange(c, 'z');
            c = '0';
            List validChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)new CharRange(c, '9'))), (Object)"-_");
            String $this$filter$iv = $receiver;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = 0;
            int n2 = $this$filterTo$iv$iv.length();
            while (n < n2) {
                void index$iv$iv;
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                boolean bl = false;
                if (validChars.contains(Character.valueOf(it))) {
                    destination$iv$iv.append(element$iv$iv);
                }
                ++index$iv$iv;
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateSessionFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull File sessionsDir, @NotNull File projectRootDir) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)sessionsDir, (String)"sessionsDir");
            Intrinsics.checkParameterIsNotNull((Object)projectRootDir, (String)"projectRootDir");
            if (GradleCompilerRunner.access$getSessionFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                var5_4 = sessionsDir;
                var6_6 = false;
                var7_8 = false;
                $receiver = var5_4;
                $i$a$-apply-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$sessionFilesDir$1 = false;
                $receiver.mkdirs();
                sessionFilesDir = var5_4;
                GradleCompilerRunner.access$setSessionFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-", ".salive", sessionFilesDir, false, 8, null));
                $receiver$iv = log;
                $i$f$kotlinDebug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    var10_13 = $receiver$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$1 = false;
                    v1 = new StringBuilder().append("Created session-is-alive flag file: ");
                    v2 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    var11_15 = v1.append(FileUtilsKt.relativeOrCanonical(v2, projectRootDir)).toString();
                    GradleLoggingUtilsKt.kotlinDebug(var10_13, var11_15);
                }
            } else {
                $receiver$iv = log;
                $i$f$kotlinDebug = false;
                if ($receiver$iv.isDebugEnabled()) {
                    var10_14 = $receiver$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$2 = false;
                    v3 = new StringBuilder().append("Existing session-is-alive flag file: ");
                    v4 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    var11_16 = v3.append(FileUtilsKt.relativeOrCanonical(v4, projectRootDir)).toString();
                    GradleLoggingUtilsKt.kotlinDebug(var10_14, var11_16);
                }
            }
            v5 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            return v5;
        }

        @NotNull
        public final File sessionsDir$kotlin_gradle_plugin(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project project2 = project.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
            return new File(new File(project2.getBuildDir(), "kotlin"), "sessions");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

