/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmDependency;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJsonKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\n\u0010\u0011\u001a\u00020\f*\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"FILE_VERSION_PREFIX", "", "directoryNpmDependency", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmDependency;", "project", "Lorg/gradle/api/Project;", "name", "directory", "Ljava/io/File;", "scope", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmDependency$Scope;", "generateExternals", "", "fileVersion", "moduleName", "onlyNameNpmDependency", "", "isFileVersion", "kotlin-gradle-plugin"})
public final class NpmDependencyKt {
    @NotNull
    public static final String FILE_VERSION_PREFIX = "file:";

    @NotNull
    public static final NpmDependency directoryNpmDependency(@NotNull Project project, @NotNull String name, @NotNull File directory2, @NotNull NpmDependency.Scope scope, boolean generateExternals) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)directory2, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scope), (String)"scope");
        boolean bl = directory2.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Dependency on local path should point on directory but " + directory2 + " found";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new NpmDependency(project, name, NpmDependencyKt.fileVersion(directory2), scope, generateExternals);
    }

    @NotNull
    public static final Void onlyNameNpmDependency(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        throw (Throwable)new IllegalArgumentException("NPM dependency '" + name + "' doesn't have version. Please, set version explicitly.");
    }

    public static final boolean isFileVersion(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.startsWith$default((String)$receiver, (String)FILE_VERSION_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String fileVersion(@NotNull File directory2) {
        Intrinsics.checkParameterIsNotNull((Object)directory2, (String)"directory");
        return FILE_VERSION_PREFIX + directory2.getCanonicalPath();
    }

    @NotNull
    public static final String moduleName(@NotNull File directory2) {
        Intrinsics.checkParameterIsNotNull((Object)directory2, (String)"directory");
        File packageJson2 = FilesKt.resolve((File)directory2, (String)"package.json");
        if (packageJson2.isFile()) {
            PackageJson packageJson3 = PackageJsonKt.fromSrcPackageJson(packageJson2);
            if (packageJson3 == null) {
                Intrinsics.throwNpe();
            }
            return packageJson3.getName();
        }
        String string = directory2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"directory.name");
        return string;
    }
}

