/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics.fileloggers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.AnonymizerUtilsKt;
import org.jetbrains.kotlin.statistics.fileloggers.IRecordLogger;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IMetricContainer;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0013J\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\"\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000bH\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "Lorg/jetbrains/kotlin/statistics/metrics/IStatisticsValuesConsumer;", "()V", "booleanMetrics", "Ljava/util/TreeMap;", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer$MetricDescriptor;", "Lorg/jetbrains/kotlin/statistics/metrics/IMetricContainer;", "", "numericalMetrics", "", "stringMetrics", "", "flush", "", "trackingFile", "Lorg/jetbrains/kotlin/statistics/fileloggers/IRecordLogger;", "getMetric", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "processProjectName", "subprojectName", "perProject", "report", "value", "Companion", "MetricDescriptor", "kotlin-gradle-statistics"})
public final class MetricsContainer
implements IStatisticsValuesConsumer {
    private final TreeMap<MetricDescriptor, IMetricContainer<Long>> numericalMetrics = new TreeMap();
    private final TreeMap<MetricDescriptor, IMetricContainer<Boolean>> booleanMetrics = new TreeMap();
    private final TreeMap<MetricDescriptor, IMetricContainer<String>> stringMetrics = new TreeMap();
    private static final String BUILD_SESSION_SEPARATOR = "BUILD FINISHED";
    private static final Charset ENCODING;
    private static final Map<String, StringMetrics> stringMetricsMap;
    private static final Map<String, BooleanMetrics> booleanMetricsMap;
    private static final Map<String, NumericalMetrics> numericalMetricsMap;
    @NotNull
    public static final Companion Companion;

    private final String processProjectName(String subprojectName, boolean perProject) {
        return perProject && subprojectName != null ? AnonymizerUtilsKt.sha256(subprojectName) : null;
    }

    @Override
    public void report(@NotNull BooleanMetrics metric, boolean value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        String projectHash = subprojectName == null ? null : this.processProjectName(subprojectName, metric.getPerProject());
        IMetricContainer<Boolean> iMetricContainer = this.booleanMetrics.get(new MetricDescriptor(metric.name(), projectHash));
        if (iMetricContainer == null) {
            IMetricContainer iMetricContainer2 = metric.getType().newMetricContainer();
            boolean bl = false;
            boolean bl2 = false;
            IMetricContainer it = iMetricContainer2;
            boolean bl3 = false;
            ((Map)this.booleanMetrics).put(new MetricDescriptor(metric.name(), projectHash), it);
            iMetricContainer = iMetricContainer2;
        }
        Intrinsics.checkNotNullExpressionValue(iMetricContainer, (String)"booleanMetrics[MetricDes\u2026ame, projectHash)] = it }");
        IMetricContainer<Boolean> metricContainer = iMetricContainer;
        metricContainer.addValue(metric.getAnonymization().anonymize(value));
    }

    @Override
    public void report(@NotNull NumericalMetrics metric, long value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        String projectHash = subprojectName == null ? null : this.processProjectName(subprojectName, metric.getPerProject());
        IMetricContainer<Long> iMetricContainer = this.numericalMetrics.get(new MetricDescriptor(metric.name(), projectHash));
        if (iMetricContainer == null) {
            IMetricContainer iMetricContainer2 = metric.getType().newMetricContainer();
            boolean bl = false;
            boolean bl2 = false;
            IMetricContainer it = iMetricContainer2;
            boolean bl3 = false;
            ((Map)this.numericalMetrics).put(new MetricDescriptor(metric.name(), projectHash), it);
            iMetricContainer = iMetricContainer2;
        }
        Intrinsics.checkNotNullExpressionValue(iMetricContainer, (String)"numericalMetrics[MetricD\u2026ame, projectHash)] = it }");
        IMetricContainer<Long> metricContainer = iMetricContainer;
        metricContainer.addValue(metric.getAnonymization().anonymize(value));
    }

    @Override
    public void report(@NotNull StringMetrics metric, @NotNull String value, @Nullable String subprojectName) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String projectHash = subprojectName == null ? null : this.processProjectName(subprojectName, metric.getPerProject());
        IMetricContainer<String> iMetricContainer = this.stringMetrics.get(new MetricDescriptor(metric.name(), projectHash));
        if (iMetricContainer == null) {
            IMetricContainer iMetricContainer2 = metric.getType().newMetricContainer();
            boolean bl = false;
            boolean bl2 = false;
            IMetricContainer it = iMetricContainer2;
            boolean bl3 = false;
            ((Map)this.stringMetrics).put(new MetricDescriptor(metric.name(), projectHash), it);
            iMetricContainer = iMetricContainer2;
        }
        Intrinsics.checkNotNullExpressionValue(iMetricContainer, (String)"stringMetrics[MetricDesc\u2026ame, projectHash)] = it }");
        IMetricContainer<String> metricContainer = iMetricContainer;
        metricContainer.addValue(metric.getAnonymization().anonymize(value));
    }

    public final void flush(@Nullable IRecordLogger trackingFile) {
        if (trackingFile == null) {
            return;
        }
        Set<Map.Entry<MetricDescriptor, IMetricContainer<Long>>> set2 = this.numericalMetrics.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"numericalMetrics.entries");
        Iterable iterable = set2;
        Set<Map.Entry<MetricDescriptor, IMetricContainer<Boolean>>> set3 = this.booleanMetrics.entrySet();
        Intrinsics.checkNotNullExpressionValue(set3, (String)"booleanMetrics.entries");
        Iterable iterable2 = CollectionsKt.union((Iterable)iterable, (Iterable)set3);
        Set<Map.Entry<MetricDescriptor, IMetricContainer<String>>> set4 = this.stringMetrics.entrySet();
        Intrinsics.checkNotNullExpressionValue(set4, (String)"stringMetrics.entries");
        for (Map.Entry entry : CollectionsKt.union((Iterable)iterable2, (Iterable)set4)) {
            String suffix = ((MetricDescriptor)entry.getKey()).getProjectHash() == null ? "" : '.' + ((MetricDescriptor)entry.getKey()).getProjectHash();
            trackingFile.append(((MetricDescriptor)entry.getKey()).getName() + suffix + '=' + ((IMetricContainer)entry.getValue()).toStringRepresentation());
        }
        trackingFile.append(BUILD_SESSION_SEPARATOR);
        this.stringMetrics.clear();
        this.booleanMetrics.clear();
        this.numericalMetrics.clear();
    }

    @Nullable
    public final IMetricContainer<Long> getMetric(@NotNull NumericalMetrics metric) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.numericalMetrics.get(new MetricDescriptor(metric.name(), null));
    }

    @Nullable
    public final IMetricContainer<String> getMetric(@NotNull StringMetrics metric) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.stringMetrics.get(new MetricDescriptor(metric.name(), null));
    }

    @Nullable
    public final IMetricContainer<Boolean> getMetric(@NotNull BooleanMetrics metric) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.booleanMetrics.get(new MetricDescriptor(metric.name(), null));
    }

    static {
        int n;
        String string;
        Enum receiver;
        boolean bl;
        Map map;
        Enum element$iv$iv2;
        Enum[] $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        ENCODING = Charsets.UTF_8;
        Enum[] $this$associateBy$iv = StringMetrics.values();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        StringMetrics[] stringMetricsArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Enum element$iv$iv2 : $this$associateByTo$iv$iv) {
            void var10_10 = element$iv$iv2;
            map = destination$iv$iv;
            bl = false;
            string = receiver.name();
            map.put(string, element$iv$iv2);
        }
        stringMetricsMap = destination$iv$iv;
        $this$associateBy$iv = BooleanMetrics.values();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        Enum[] enumArray = $this$associateByTo$iv$iv;
        int n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            receiver = element$iv$iv2 = enumArray[n];
            map = destination$iv$iv;
            bl = false;
            string = receiver.name();
            map.put(string, element$iv$iv2);
        }
        booleanMetricsMap = destination$iv$iv;
        $this$associateBy$iv = NumericalMetrics.values();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        enumArray = $this$associateByTo$iv$iv;
        n2 = enumArray.length;
        for (n = 0; n < n2; ++n) {
            receiver = element$iv$iv2 = enumArray[n];
            map = destination$iv$iv;
            bl = false;
            string = receiver.name();
            map.put(string, element$iv$iv2);
        }
        numericalMetricsMap = destination$iv$iv;
    }

    public static final /* synthetic */ Map access$getStringMetricsMap$cp() {
        return stringMetricsMap;
    }

    public static final /* synthetic */ TreeMap access$getStringMetrics$p(MetricsContainer $this) {
        return $this.stringMetrics;
    }

    public static final /* synthetic */ Map access$getBooleanMetricsMap$cp() {
        return booleanMetricsMap;
    }

    public static final /* synthetic */ TreeMap access$getBooleanMetrics$p(MetricsContainer $this) {
        return $this.booleanMetrics;
    }

    public static final /* synthetic */ Map access$getNumericalMetricsMap$cp() {
        return numericalMetricsMap;
    }

    public static final /* synthetic */ TreeMap access$getNumericalMetrics$p(MetricsContainer $this) {
        return $this.numericalMetrics;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer$MetricDescriptor;", "", "name", "", "projectHash", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getProjectHash", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "kotlin-gradle-statistics"})
    public static final class MetricDescriptor
    implements Comparable<MetricDescriptor> {
        private final String name;
        private final String projectHash;

        @Override
        public int compareTo(@NotNull MetricDescriptor other) {
            int n;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int compareNames = this.name.compareTo(other.name);
            if (compareNames != 0) {
                n = compareNames;
            } else if (Intrinsics.areEqual((Object)this.projectHash, (Object)other.projectHash)) {
                n = 0;
            } else {
                String string;
                String string2 = this.projectHash;
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = other.projectHash) == null) {
                    string = "";
                }
                n = string2.compareTo(string);
            }
            return n;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getProjectHash() {
            return this.projectHash;
        }

        public MetricDescriptor(@NotNull String name, @Nullable String projectHash) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.projectHash = projectHash;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.projectHash;
        }

        @NotNull
        public final MetricDescriptor copy(@NotNull String name, @Nullable String projectHash) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new MetricDescriptor(name, projectHash);
        }

        public static /* synthetic */ MetricDescriptor copy$default(MetricDescriptor metricDescriptor, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = metricDescriptor.name;
            }
            if ((n & 2) != 0) {
                string2 = metricDescriptor.projectHash;
            }
            return metricDescriptor.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MetricDescriptor(name=" + this.name + ", projectHash=" + this.projectHash + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.projectHash;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MetricDescriptor)) break block3;
                    MetricDescriptor metricDescriptor = (MetricDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)metricDescriptor.name) || !Intrinsics.areEqual((Object)this.projectHash, (Object)metricDescriptor.projectHash)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer$Companion;", "", "()V", "BUILD_SESSION_SEPARATOR", "", "ENCODING", "Ljava/nio/charset/Charset;", "getENCODING", "()Ljava/nio/charset/Charset;", "booleanMetricsMap", "", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "numericalMetricsMap", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "stringMetricsMap", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "readFromFile", "", "file", "Ljava/io/File;", "consumer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "", "kotlin-gradle-statistics"})
    public static final class Companion {
        @NotNull
        public final Charset getENCODING() {
            return ENCODING;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final boolean readFromFile(@NotNull File file, @NotNull Function1<? super MetricsContainer, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            FileChannel channel = FileChannel.open(Paths.get(file.toURI()), StandardOpenOption.WRITE, StandardOpenOption.READ);
            if (channel.tryLock() == null) {
                return false;
            }
            InputStream inputStream = Channels.newInputStream(channel);
            try {
                void container;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = new MetricsContainer();
                TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(inputStream, this.getENCODING())), (Function1)((Function1)new Function1<String, Unit>(consumer, (Ref.ObjectRef)container){
                    final /* synthetic */ Function1 $consumer;
                    final /* synthetic */ Ref.ObjectRef $container;

                    public final void invoke(@NotNull String line) {
                        block7: {
                            IMetricContainer<T> it;
                            boolean bl;
                            boolean bl2;
                            IMetricContainer<T> iMetricContainer;
                            Enum metricType;
                            boolean bl3;
                            boolean bl4;
                            Enum enum_;
                            block6: {
                                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                if (!Intrinsics.areEqual((Object)"BUILD FINISHED", (Object)line)) break block6;
                                this.$consumer.invoke((Object)((MetricsContainer)this.$container.element));
                                this.$container.element = new MetricsContainer();
                                break block7;
                            }
                            List lineParts = StringsKt.split$default((CharSequence)line, (char[])new char[]{'='}, (boolean)false, (int)0, (int)6, null);
                            if (lineParts.size() != 2) break block7;
                            String name = (String)StringsKt.split$default((CharSequence)((CharSequence)lineParts.get(0)), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null).get(0);
                            String subProjectHash = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)((CharSequence)lineParts.get(0)), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null), (int)1);
                            String representation = (String)lineParts.get(1);
                            StringMetrics stringMetrics = (StringMetrics)((Object)MetricsContainer.access$getStringMetricsMap$cp().get(name));
                            if (stringMetrics != null) {
                                enum_ = stringMetrics;
                                bl4 = false;
                                bl3 = false;
                                metricType = enum_;
                                boolean bl5 = false;
                                IMetricContainer<T> iMetricContainer2 = ((StringMetrics)metricType).getType().fromStringRepresentation(representation);
                                if (iMetricContainer2 != null) {
                                    iMetricContainer = iMetricContainer2;
                                    bl2 = false;
                                    bl = false;
                                    it = iMetricContainer;
                                    boolean bl6 = false;
                                    ((Map)MetricsContainer.access$getStringMetrics$p((MetricsContainer)this.$container.element)).put(new MetricDescriptor(name, subProjectHash), it);
                                }
                            }
                            BooleanMetrics booleanMetrics = (BooleanMetrics)((Object)MetricsContainer.access$getBooleanMetricsMap$cp().get(name));
                            if (booleanMetrics != null) {
                                enum_ = booleanMetrics;
                                bl4 = false;
                                bl3 = false;
                                metricType = enum_;
                                boolean bl7 = false;
                                IMetricContainer<T> iMetricContainer3 = ((BooleanMetrics)metricType).getType().fromStringRepresentation(representation);
                                if (iMetricContainer3 != null) {
                                    iMetricContainer = iMetricContainer3;
                                    bl2 = false;
                                    bl = false;
                                    it = iMetricContainer;
                                    boolean bl8 = false;
                                    ((Map)MetricsContainer.access$getBooleanMetrics$p((MetricsContainer)this.$container.element)).put(new MetricDescriptor(name, subProjectHash), it);
                                }
                            }
                            NumericalMetrics numericalMetrics = (NumericalMetrics)((Object)MetricsContainer.access$getNumericalMetricsMap$cp().get(name));
                            if (numericalMetrics != null) {
                                enum_ = numericalMetrics;
                                bl4 = false;
                                bl3 = false;
                                metricType = enum_;
                                boolean bl9 = false;
                                IMetricContainer<T> iMetricContainer4 = ((NumericalMetrics)metricType).getType().fromStringRepresentation(representation);
                                if (iMetricContainer4 != null) {
                                    iMetricContainer = iMetricContainer4;
                                    bl2 = false;
                                    bl = false;
                                    it = iMetricContainer;
                                    boolean bl10 = false;
                                    ((Map)MetricsContainer.access$getNumericalMetrics$p((MetricsContainer)this.$container.element)).put(new MetricDescriptor(name, subProjectHash), it);
                                }
                            }
                        }
                    }
                    {
                        this.$consumer = function1;
                        this.$container = objectRef;
                        super(1);
                    }
                }));
            }
            finally {
                channel.close();
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

