/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.testing;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.testing.TCServiceMessageOutputStreamHandler;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\fH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessageOutputStreamHandler;", "Ljava/io/OutputStream;", "client", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageParserCallback;", "onException", "Lkotlin/Function0;", "", "logger", "Lorg/slf4j/Logger;", "ignoreTcsmOverflow", "", "messageLimitBytes", "", "(Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageParserCallback;Lkotlin/jvm/functions/Function0;Lorg/slf4j/Logger;ZI)V", "buffer", "Ljava/io/ByteArrayOutputStream;", "closed", "overflowInsideMessage", "close", "flushLine", "overflow", "parse", "text", "", "write", "b", "", "off", "len", "Companion", "kotlin-gradle-plugin"})
public final class TCServiceMessageOutputStreamHandler
extends OutputStream {
    private boolean closed;
    private final ByteArrayOutputStream buffer;
    private boolean overflowInsideMessage;
    private final ServiceMessageParserCallback client;
    private final Function0<Unit> onException;
    private final Logger logger;
    private final boolean ignoreTcsmOverflow;
    private final int messageLimitBytes;
    private static final int MESSAGE_LIMIT_BYTES = 0x100000;
    @NotNull
    public static final String IGNORE_TCSM_OVERFLOW = "kotlin.ignore.tcsm.overflow";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushLine();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        void last;
        void i2;
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        if (this.closed) {
            throw (Throwable)new IOException("The stream has been closed.");
        }
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = off;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = off;
        Function0<Integer> $fun$bytesToAppend$1 = new Function0<Integer>((Ref.IntRef)i2, (Ref.IntRef)last){
            final /* synthetic */ Ref.IntRef $i;
            final /* synthetic */ Ref.IntRef $last;

            public final int invoke() {
                return this.$i.element - this.$last.element;
            }
            {
                this.$i = intRef;
                this.$last = intRef2;
                super(0);
            }
        };
        int end = off + len;
        Function1<Integer, Unit> $fun$append$2 = new Function1<Integer, Unit>(this, b, (Ref.IntRef)last, (Ref.IntRef)i2, $fun$bytesToAppend$1){
            final /* synthetic */ TCServiceMessageOutputStreamHandler this$0;
            final /* synthetic */ byte[] $b;
            final /* synthetic */ Ref.IntRef $last;
            final /* synthetic */ Ref.IntRef $i;
            final /* synthetic */ write.1 $bytesToAppend$1;

            public final void invoke(int len) {
                TCServiceMessageOutputStreamHandler.access$getBuffer$p(this.this$0).write(this.$b, this.$last.element, this.$i.element - this.$last.element);
                this.$last.element += len;
            }

            public static /* synthetic */ void invoke$default(write.2 var0, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = var0.$bytesToAppend$1.invoke();
                }
                var0.invoke(n);
            }
            {
                this.this$0 = tCServiceMessageOutputStreamHandler;
                this.$b = byArray;
                this.$last = intRef;
                this.$i = intRef2;
                this.$bytesToAppend$1 = var5_5;
                super(1);
            }
        };
        while (i2.element < end) {
            int n = i2.element;
            i2.element = n + 1;
            byte c = b[n];
            if (c == (byte)10) {
                write.2.invoke$default($fun$append$2, 0, 1, null);
                this.flushLine();
                continue;
            }
            if (this.buffer.size() + $fun$bytesToAppend$1.invoke() < this.messageLimitBytes) continue;
            $fun$append$2.invoke(this.messageLimitBytes - this.buffer.size());
            this.overflow();
        }
        write.2.invoke$default($fun$append$2, 0, 1, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    private final void flushLine() {
        this.overflowInsideMessage = false;
        if (this.buffer.size() > 0) {
            String text;
            String string = text = this.buffer.toString("utf-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            this.parse(string);
            this.buffer.reset();
        }
    }

    private final void overflow() {
        int i2;
        int n;
        String text = this.buffer.toString("utf-8");
        if (this.overflowInsideMessage) {
            if (!this.ignoreTcsmOverflow) {
                String string = text;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                if (!StringsKt.endsWith$default((String)string, (String)"]", (boolean)false, (int)2, null)) {
                    this.logger.warn(text);
                    this.overflowInsideMessage = false;
                    this.buffer.reset();
                    this.client.serviceMessage(new TestFailed("overflow-message", (Throwable)new GradleException("Cannot process output: too long teamcity service message (more than 1Mb). Event was lost.\nBuild failed to prevent inconsistent behaviour. To ignore it use Gradle property 'kotlin.ignore.tcsm.overflow=true'")));
                }
            }
            n = -1;
        } else {
            String string = text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            n = i2 = StringsKt.indexOf$default((CharSequence)string, (String)"##teamcity[", (int)0, (boolean)false, (int)6, null);
        }
        if (i2 != -1) {
            String string = text;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            String string2 = string;
            int n2 = 0;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2, i2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.client.regularText(string4);
            this.buffer.reset();
            string2 = text;
            n2 = 0;
            String string5 = string2.substring(i2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string2 = string5;
            Charset charset = Charsets.UTF_8;
            bl = false;
            String string6 = string2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string6.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            this.buffer.write(byArray);
            this.overflowInsideMessage = true;
        } else {
            this.flushLine();
        }
    }

    private final void parse(String text) {
        try {
            ServiceMessage.parse(text, this.client);
        }
        catch (Exception e) {
            this.onException.invoke();
            this.logger.error("Error while processing test process output message \"" + text + '\"', (Throwable)e);
        }
    }

    public TCServiceMessageOutputStreamHandler(@NotNull ServiceMessageParserCallback client, @NotNull Function0<Unit> onException, @NotNull Logger logger, boolean ignoreTcsmOverflow, int messageLimitBytes) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull(onException, (String)"onException");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.client = client;
        this.onException = onException;
        this.logger = logger;
        this.ignoreTcsmOverflow = ignoreTcsmOverflow;
        this.messageLimitBytes = messageLimitBytes;
        this.buffer = new ByteArrayOutputStream();
    }

    public /* synthetic */ TCServiceMessageOutputStreamHandler(ServiceMessageParserCallback serviceMessageParserCallback, Function0 function0, Logger logger, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        if ((n2 & 0x10) != 0) {
            n = 0x100000;
        }
        this(serviceMessageParserCallback, (Function0<Unit>)function0, logger, bl, n);
    }

    public static final /* synthetic */ ByteArrayOutputStream access$getBuffer$p(TCServiceMessageOutputStreamHandler $this) {
        return $this.buffer;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/testing/TCServiceMessageOutputStreamHandler$Companion;", "", "()V", "IGNORE_TCSM_OVERFLOW", "", "MESSAGE_LIMIT_BYTES", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

