/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilationToRunnableFiles;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCompilationsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.targets.js.KotlinJsCompilerAttribute;
import org.jetbrains.kotlin.gradle.targets.js.KotlinJsTarget;
import org.jetbrains.kotlin.gradle.targets.js.ir.KotlinJsIrTarget;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n\"\u001c\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"deprecatedCompileConfigurationName", "", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getDeprecatedCompileConfigurationName", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;)Ljava/lang/String;", "deprecatedRuntimeConfigurationName", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilationToRunnableFiles;", "getDeprecatedRuntimeConfigurationName", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilationToRunnableFiles;)Ljava/lang/String;", "testTaskName", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "getTestTaskName", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;)Ljava/lang/String;", "usageByName", "Lorg/gradle/api/attributes/Usage;", "Lorg/gradle/api/Project;", "usageName", "usesPlatformOf", "Lorg/gradle/api/artifacts/Configuration;", "target", "kotlin-gradle-plugin"})
public final class KotlinTargetConfiguratorKt {
    @NotNull
    public static final String getDeprecatedCompileConfigurationName(@NotNull KotlinCompilation<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return KotlinCompilationsKt.disambiguateName($receiver, "compile");
    }

    @NotNull
    public static final String getDeprecatedRuntimeConfigurationName(@NotNull KotlinCompilationToRunnableFiles<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return KotlinCompilationsKt.disambiguateName((KotlinCompilation)$receiver, "runtime");
    }

    @NotNull
    public static final String getTestTaskName(@NotNull KotlinTarget $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringUtilsKt.lowerCamelCaseName($receiver.getTargetName(), "test");
    }

    @NotNull
    public static final Usage usageByName(@NotNull Project $receiver, @NotNull String usageName) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)usageName, (String)"usageName");
        Project project = $receiver.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Named named = project.getObjects().named(Usage.class, usageName);
        Intrinsics.checkExpressionValueIsNotNull((Object)named, (String)"project.objects.named(Us\u2026e::class.java, usageName)");
        return (Usage)named;
    }

    @NotNull
    public static final Configuration usesPlatformOf(@NotNull Configuration $receiver, @NotNull KotlinTarget target2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        $receiver.getAttributes().attribute(KotlinPlatformType.Companion.getAttribute(), (Object)target2.getPlatformType());
        if (target2 instanceof KotlinJsTarget) {
            $receiver.getAttributes().attribute(KotlinJsCompilerAttribute.Companion.getJsCompilerAttribute(), (Object)KotlinJsCompilerAttribute.legacy);
        }
        if (target2 instanceof KotlinJsIrTarget) {
            $receiver.getAttributes().attribute(KotlinJsCompilerAttribute.Companion.getJsCompilerAttribute(), (Object)KotlinJsCompilerAttribute.ir);
        }
        if (target2 instanceof KotlinNativeTarget) {
            $receiver.getAttributes().attribute(KotlinNativeTarget.Companion.getKonanTargetAttribute(), (Object)((KotlinNativeTarget)target2).getKonanTarget().getName());
        }
        return $receiver;
    }
}

