/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporterImpl;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileIterationResult;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilationResults;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "Ljava/rmi/server/UnicastRemoteObject;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "projectRootFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;Ljava/io/File;)V", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "getBuildMetrics", "()Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "buildMetricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "icLogLines", "", "", "getIcLogLines", "()Ljava/util/List;", "setIcLogLines", "(Ljava/util/List;)V", "add", "", "compilationResultCategory", "", "value", "Ljava/io/Serializable;", "kotlin-gradle-plugin"})
public final class GradleCompilationResults
extends UnicastRemoteObject
implements CompilationResults {
    @NotNull
    private List<String> icLogLines;
    private final BuildMetricsReporterImpl buildMetricsReporter;
    private final KotlinLogger log;
    private final File projectRootFile;

    @NotNull
    public final List<String> getIcLogLines() {
        return this.icLogLines;
    }

    public final void setIcLogLines(@NotNull List<String> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.icLogLines = list2;
    }

    @NotNull
    public final BuildMetrics getBuildMetrics() {
        return this.buildMetricsReporter.getMetrics();
    }

    public void add(int compilationResultCategory, @NotNull Serializable value) throws RemoteException {
        block7: {
            int n;
            block8: {
                block6: {
                    CompileIterationResult compileIterationResult;
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    n = compilationResultCategory;
                    if (n != CompilationResultCategory.IC_COMPILE_ITERATION.getCode()) break block6;
                    Serializable serializable = value;
                    if (!(serializable instanceof CompileIterationResult)) {
                        serializable = null;
                    }
                    if ((compileIterationResult = (CompileIterationResult)serializable) == null) break block7;
                    Iterable sourceFiles = compileIterationResult.getSourceFiles();
                    if (CollectionsKt.any((Iterable)sourceFiles)) {
                        KotlinLogger $this$kotlinDebug$iv = this.log;
                        boolean $i$f$kotlinDebug = false;
                        if ($this$kotlinDebug$iv.isDebugEnabled()) {
                            boolean bl = false;
                            String msg$iv = "compile iteration: " + FileUtilsKt.pathsAsStringRelativeTo(sourceFiles, this.projectRootFile);
                            $this$kotlinDebug$iv.debug("[KOTLIN] " + msg$iv);
                        }
                    }
                    String exitCode = compileIterationResult.getExitCode();
                    KotlinLogger $this$kotlinDebug$iv = this.log;
                    boolean $i$f$kotlinDebug = false;
                    if ($this$kotlinDebug$iv.isDebugEnabled()) {
                        boolean bl = false;
                        String msg$iv = "compiler exit code: " + exitCode;
                        $this$kotlinDebug$iv.debug("[KOTLIN] " + msg$iv);
                    }
                    break block7;
                }
                if (n != CompilationResultCategory.BUILD_REPORT_LINES.getCode() && n != CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES.getCode()) break block8;
                Serializable serializable = value;
                if (!(serializable instanceof List)) {
                    serializable = null;
                }
                List list2 = (List)((Object)serializable);
                if (list2 == null) break block7;
                List list3 = list2;
                boolean bl = false;
                boolean bl2 = false;
                List it = list3;
                boolean bl3 = false;
                this.icLogLines = it;
                break block7;
            }
            if (n != CompilationResultCategory.BUILD_METRICS.getCode()) break block7;
            Serializable serializable = value;
            if (!(serializable instanceof BuildMetrics)) {
                serializable = null;
            }
            this.buildMetricsReporter.addMetrics((BuildMetrics)serializable);
        }
    }

    public GradleCompilationResults(@NotNull KotlinLogger log, @NotNull File projectRootFile) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)projectRootFile, (String)"projectRootFile");
        super(0, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.log = log;
        this.projectRootFile = projectRootFile;
        this.icLogLines = CollectionsKt.emptyList();
        this.buildMetricsReporter = new BuildMetricsReporterImpl();
    }
}

