/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.report.BuildDataRecorder;
import org.jetbrains.kotlin.gradle.report.BuildReportMode;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt$configureReporting$1$$special$;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriter;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"configurePlainTextReportWriter", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "reportingSettings", "Lorg/jetbrains/kotlin/gradle/report/ReportingSettings;", "configureReporting", "", "rootProject", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin"})
public final class ConfigureReporingKt {
    public static final void configureReporting(@NotNull Gradle gradle) {
        boolean bl;
        Object object;
        Project rootProject;
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        ArrayList<Object> buildDataProcessors = new ArrayList<Object>();
        Project project = rootProject = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rootProject");
        ReportingSettings reportingSettings2 = ConfigureReporingKt.reportingSettings(project);
        gradle.getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(reportingSettings2){
            final /* synthetic */ ReportingSettings $reportingSettings;

            public final void execute(TaskExecutionGraph graph) {
                TaskExecutionGraph taskExecutionGraph = graph;
                Intrinsics.checkExpressionValueIsNotNull((Object)taskExecutionGraph, (String)"graph");
                List list2 = taskExecutionGraph.getAllTasks();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"graph.allTasks");
                Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list2);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)configureReporting$1$$special$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$forEach$iv = sequence;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv;
                    boolean bl = false;
                    it.setReportingSettings$kotlin_gradle_plugin(this.$reportingSettings);
                }
            }
            {
                this.$reportingSettings = reportingSettings2;
            }
        });
        if (reportingSettings2.getBuildReportMode() != BuildReportMode.NONE && reportingSettings2.getBuildReportDir() != null) {
            BuildExecutionDataProcessor buildExecutionDataProcessor = ConfigureReporingKt.configurePlainTextReportWriter(gradle, reportingSettings2);
            if (buildExecutionDataProcessor != null) {
                object = buildExecutionDataProcessor;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                buildDataProcessors.add(it);
            }
        }
        if (reportingSettings2.getMetricsOutputFile() != null) {
            File file = reportingSettings2.getMetricsOutputFile().getAbsoluteFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"reportingSettings.metricsOutputFile.absoluteFile");
            Logger logger = rootProject.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"rootProject.logger");
            buildDataProcessors.add(new MetricsWriter(file, logger));
        }
        object = buildDataProcessors;
        bl = false;
        if (!object.isEmpty() && !ConfigurationCacheKt.isConfigurationCacheAvailable(gradle)) {
            BuildDataRecorder listener = new BuildDataRecorder(gradle, (Iterable<? extends BuildExecutionDataProcessor>)buildDataProcessors);
            gradle.addBuildListener((BuildListener)listener);
        }
    }

    private static final ReportingSettings reportingSettings(Project rootProject) {
        PropertiesProvider properties = PropertiesProvider.Companion.invoke(rootProject);
        BuildReportMode buildReportMode = !properties.getBuildReportEnabled() ? BuildReportMode.NONE : (properties.getBuildReportVerbose() ? BuildReportMode.VERBOSE : BuildReportMode.SIMPLE);
        File metricsOutputFile = properties.getSingleBuildMetricsFile();
        File file = properties.getBuildReportDir();
        if (file == null) {
            File file2 = rootProject.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rootProject.buildDir");
            file = FilesKt.resolve((File)file2, (String)"reports/kotlin-build");
        }
        File buildReportDir = file;
        boolean includeMetricsInReport = properties.getBuildReportMetrics() || buildReportMode == BuildReportMode.VERBOSE;
        return new ReportingSettings(metricsOutputFile, buildReportDir, metricsOutputFile != null || includeMetricsInReport, includeMetricsInReport, buildReportMode);
    }

    private static final BuildExecutionDataProcessor configurePlainTextReportWriter(Gradle gradle, ReportingSettings reportingSettings2) {
        Project project = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
        Logger log = project.getLogger();
        File file = reportingSettings2.getBuildReportDir();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File file2 = file;
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file2;
        boolean bl3 = false;
        $this$apply.mkdirs();
        File reportDir = file2;
        if (reportDir.isFile()) {
            log.error("Kotlin build report cannot be created: '" + reportDir + "' is a file");
            return null;
        }
        reportDir.mkdirs();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        String ts = simpleDateFormat.format(calendar.getTime());
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"gradle.rootProject");
        File reportFile = FilesKt.resolve((File)reportDir, (String)stringBuilder.append(project2.getName()).append("-build-").append(ts).append(".txt").toString());
        boolean bl4 = reportingSettings2.getIncludeMetricsInReport();
        Logger logger = log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        return new PlainTextBuildReportWriter(reportFile, bl4, logger);
    }
}

