/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributeKind;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporterHandlerKt;
import org.jetbrains.kotlin.gradle.report.PlainTextBuildReportWriterKt;
import org.jetbrains.kotlin.gradle.report.TextTable;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionDataProcessor;
import org.jetbrains.kotlin.gradle.report.data.TaskExecutionData;
import org.jetbrains.kotlin.gradle.utils.Printer;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/gradle/report/PlainTextBuildReportWriter;", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionDataProcessor;", "outputFile", "Ljava/io/File;", "printMetrics", "", "log", "Lorg/gradle/api/logging/Logger;", "(Ljava/io/File;ZLorg/gradle/api/logging/Logger;)V", "p", "Lorg/jetbrains/kotlin/gradle/utils/Printer;", "printBuildAttributes", "", "buildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "printBuildInfo", "build", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "printBuildReport", "printBuildTimes", "buildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "buildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "printTaskLog", "task", "Lorg/jetbrains/kotlin/gradle/report/data/TaskExecutionData;", "printTaskOverview", "printTasksLog", "process", "kotlin-gradle-plugin"})
public final class PlainTextBuildReportWriter
implements BuildExecutionDataProcessor {
    private Printer p;
    private final File outputFile;
    private final boolean printMetrics;
    private final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull BuildExecutionData build2) {
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        try {
            Object object = this.outputFile;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileOutputStream((File)object3);
            bl3 = false;
            object2 = new OutputStreamWriter((OutputStream)object3, charset);
            bl2 = false;
            object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl5 = false;
                this.p = new Printer(writer, null, null, 6, null);
                this.printBuildReport(build2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            this.log.lifecycle("Kotlin build report is written to " + this.outputFile.getCanonicalPath());
        }
        catch (Exception e) {
            this.log.error("Could not write Kotlin build report to " + this.outputFile.getCanonicalPath(), (Throwable)e);
        }
    }

    private final void printBuildReport(BuildExecutionData build2) {
        this.printBuildInfo(build2);
        this.printMetrics(build2.getAggregatedMetrics());
        this.printTaskOverview(build2);
        this.printTasksLog(build2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildInfo(BuildExecutionData build2) {
        void this_$iv;
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        Printer printer2 = printer;
        String headLine$iv = "Gradle start parameters:";
        boolean $i$f$withIndent = false;
        this_$iv.println(headLine$iv);
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = build2.getStartParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                Printer printer3 = this.p;
                if (printer3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                }
                printer3.println(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer4 = this.p;
        if (printer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer4.println(new String[0]);
        if (build2.getFailure() != null) {
            Printer printer5 = this.p;
            if (printer5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            }
            printer5.println("Build failed: " + build2.getFailure());
        }
        Printer printer6 = this.p;
        if (printer6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer6.println(new String[0]);
    }

    private final void printMetrics(BuildMetrics buildMetrics) {
        if (!this.printMetrics) {
            return;
        }
        this.printBuildTimes(buildMetrics.getBuildTimes());
        this.printBuildAttributes(buildMetrics.getBuildAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void printBuildTimes(BuildTimes buildTimes) {
        Map collectedBuildTimes = buildTimes.asMap();
        if (collectedBuildTimes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer.println("Time metrics:");
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        Printer this_$iv = printer2;
        String headLine$iv = null;
        boolean $i$f$withIndent = false;
        this_$iv.pushIndent();
        try {
            boolean bl = false;
            HashSet visitedBuildTimes = new HashSet();
            Function1<BuildTime, Unit> $fun$printBuildTime$1 = new Function1<BuildTime, Unit>(visitedBuildTimes, this, collectedBuildTimes){
                final /* synthetic */ HashSet $visitedBuildTimes;
                final /* synthetic */ PlainTextBuildReportWriter this$0;
                final /* synthetic */ Map $collectedBuildTimes$inlined;
                {
                    this.$visitedBuildTimes = hashSet;
                    this.this$0 = plainTextBuildReportWriter;
                    this.$collectedBuildTimes$inlined = map;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull BuildTime buildTime) {
                    Intrinsics.checkParameterIsNotNull((Object)buildTime, (String)"buildTime");
                    if (!this.$visitedBuildTimes.add(buildTime)) {
                        return;
                    }
                    Long l = (Long)this.$collectedBuildTimes$inlined.get(buildTime);
                    if (l == null) {
                        return;
                    }
                    long timeNs = l;
                    PlainTextBuildReportWriter.access$getP$p(this.this$0).println(buildTime.name() + ": " + KotlinBuildReporterHandlerKt.formatTime(timeNs));
                    Printer this_$iv = PlainTextBuildReportWriter.access$getP$p(this.this$0);
                    String headLine$iv = null;
                    boolean $i$f$withIndent = false;
                    this_$iv.pushIndent();
                    try {
                        Unit unit;
                        boolean bl = false;
                        List list2 = (List)BuildTime.Companion.getChildren().get(buildTime);
                        if (list2 != null) {
                            Iterable $this$forEach$iv = list2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                BuildTime it = (BuildTime)element$iv;
                                boolean bl2 = false;
                                this.invoke(it);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    finally {
                        this_$iv.popIndent();
                    }
                }
            };
            for (BuildTime buildTime : BuildTime.values()) {
                if (buildTime.getParent() != null) continue;
                $fun$printBuildTime$1.invoke(buildTime);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer3.println(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printBuildAttributes(BuildAttributes buildAttributes) {
        void this_$iv;
        Map allAttributes = buildAttributes.asMap();
        if (allAttributes.isEmpty()) {
            return;
        }
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        Printer printer2 = printer;
        String headLine$iv = "Build attributes:";
        boolean $i$f$withIndent = false;
        this_$iv.println(headLine$iv);
        this_$iv.pushIndent();
        try {
            Object element$iv$iv;
            Map $this$groupByTo$iv$iv;
            boolean bl = false;
            Iterable $this$groupBy$iv = allAttributes.entrySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv22 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                element$iv$iv = iterator.next();
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                BuildAttributeKind key$iv$iv = ((BuildAttribute)it.getKey()).getKind();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            SortedMap attributesByKind = MapsKt.toSortedMap((Map)destination$iv$iv22);
            $this$groupByTo$iv$iv = attributesByKind;
            boolean destination$iv$iv22 = false;
            for (Map.Entry entry : $this$groupByTo$iv$iv.entrySet()) {
                Printer printer3;
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void kind;
                Object $i$f$groupByTo2 = entry;
                boolean bl4 = false;
                $this$groupByTo$iv$iv = (BuildAttributeKind)$i$f$groupByTo2.getKey();
                $i$f$groupByTo2 = entry;
                bl4 = false;
                List attributesCounts = (List)$i$f$groupByTo2.getValue();
                if (this.p == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                }
                String string = kind.name();
                List list2 = attributesCounts;
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"attributesCounts");
                $i$f$groupByTo2 = list2;
                String string2 = string;
                boolean $i$f$map = false;
                element$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void k;
                    void $dstr$k$v;
                    Map.Entry $i$f$getOrPut = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl5 = false;
                    void var20_27 = $dstr$k$v;
                    boolean bl6 = false;
                    BuildAttribute buildAttribute = (BuildAttribute)var20_27.getKey();
                    var20_27 = $dstr$k$v;
                    bl6 = false;
                    int v = ((Number)var20_27.getValue()).intValue();
                    Pair pair = TuplesKt.to((Object)k.name(), (Object)v);
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                PlainTextBuildReportWriterKt.access$printMap(printer3, string2, MapsKt.toMap((Iterable)collection));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.popIndent();
        }
        Printer printer4 = this.p;
        if (printer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer4.println(new String[0]);
    }

    private final void printTaskOverview(BuildExecutionData build2) {
        long allTasksTimeNs = 0L;
        long kotlinTotalTimeNs = 0L;
        ArrayList<TaskExecutionData> kotlinTasks = new ArrayList<TaskExecutionData>();
        for (TaskExecutionData task : build2.getTaskExecutionData()) {
            long taskTimeNs = task.getTotalTimeNs();
            allTasksTimeNs += taskTimeNs;
            if (!task.isKotlinTask()) continue;
            kotlinTotalTimeNs += taskTimeNs;
            kotlinTasks.add(task);
        }
        if (kotlinTasks.isEmpty()) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            }
            printer.println("No Kotlin task was run");
            return;
        }
        String ktTaskPercent = KotlinBuildReporterHandlerKt.asString((double)kotlinTotalTimeNs / (double)allTasksTimeNs * (double)100, 1);
        Printer printer = this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer.println("Total time for Kotlin tasks: " + KotlinBuildReporterHandlerKt.formatTime(kotlinTotalTimeNs) + " (" + ktTaskPercent + " % of all tasks time)");
        TextTable table = new TextTable("Time", "% of Kotlin time", "Task");
        Iterable $this$sortedByDescending$iv = kotlinTasks;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TaskExecutionData it = (TaskExecutionData)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getTotalTimeNs());
                it = (TaskExecutionData)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getTotalTimeNs();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        for (TaskExecutionData task : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)) {
            long timeNs = task.getTotalTimeNs();
            String percent = KotlinBuildReporterHandlerKt.asString((double)timeNs / (double)kotlinTotalTimeNs * (double)100, 1);
            String[] stringArray = new String[3];
            stringArray[0] = KotlinBuildReporterHandlerKt.formatTime(timeNs);
            stringArray[1] = percent + " %";
            String string = task.getTask().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.task.path");
            stringArray[2] = string;
            table.addRow(stringArray);
        }
        Printer printer2 = this.p;
        if (printer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        table.printTo(printer2);
        Printer printer3 = this.p;
        if (printer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        printer3.println(new String[0]);
    }

    private final void printTasksLog(BuildExecutionData build2) {
        for (TaskExecutionData task : build2.getTaskExecutionData()) {
            this.printTaskLog(task);
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            }
            printer.println(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void printTaskLog(TaskExecutionData task) {
        String skipMessage = task.getResultState().getSkipMessage();
        if (skipMessage != null) {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            }
            printer.println(task + " was skipped: " + skipMessage);
        } else {
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            }
            printer.println(task + " finished in " + KotlinBuildReporterHandlerKt.formatTime(task.getTotalTimeNs()));
        }
        Object object = task.getIcLogLines();
        boolean bl = false;
        if (!object.isEmpty()) {
            void this_$iv;
            Printer printer = this.p;
            if (printer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            }
            object = printer;
            String headLine$iv = "Compilation log for " + task + ':';
            boolean $i$f$withIndent = false;
            if (headLine$iv != null) {
                this_$iv.println(headLine$iv);
            }
            this_$iv.pushIndent();
            try {
                boolean bl2 = false;
                Iterable $this$forEach$iv = task.getIcLogLines();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Printer printer2 = this.p;
                    if (printer2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    }
                    printer2.println(it);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.popIndent();
            }
        }
        this.printMetrics(task.getBuildMetrics());
    }

    public PlainTextBuildReportWriter(@NotNull File outputFile2, boolean printMetrics, @NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)outputFile2, (String)"outputFile");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.outputFile = outputFile2;
        this.printMetrics = printMetrics;
        this.log = log;
    }

    public static final /* synthetic */ Printer access$getP$p(PlainTextBuildReportWriter $this) {
        Printer printer = $this.p;
        if (printer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
        }
        return printer;
    }

    public static final /* synthetic */ void access$setP$p(PlainTextBuildReportWriter $this, Printer printer) {
        $this.p = printer;
    }
}

