/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.npm;

import com.github.gundy.semver4j.generated.grammar.NodeSemverExpressionLexer;
import com.github.gundy.semver4j.generated.grammar.NodeSemverExpressionParser;
import com.github.gundy.semver4j.model.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmRange;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmRangeKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmRangeVisitor;
import org.jetbrains.kotlin.gradle.targets.js.npm.SemVer;
import org.jetbrains.kotlin.gradle.targets.js.npm.SemverKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\f\u0010\r\u001a\u00020\b*\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"buildNpmVersion", "", "includedVersions", "", "excludedVersions", "includedWithCaret", "", "includedRange", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmRange;", "includedVersion", "versionToNpmRanges", "", "version", "caretizeSingleVersion", "kotlin-gradle-plugin"})
public final class NpmVersionsKt {
    @NotNull
    public static final Set<NpmRange> versionToNpmRanges(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        NodeSemverExpressionLexer lexer = new NodeSemverExpressionLexer((CharStream)new ANTLRInputStream(version));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        NodeSemverExpressionParser parser = new NodeSemverExpressionParser((TokenStream)tokens);
        Object object = new NpmRangeVisitor().visit((ParseTree)parser.rangeSet());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Set)object;
    }

    @NotNull
    public static final NpmRange includedRange(@NotNull String includedVersion, boolean includedWithCaret) {
        Intrinsics.checkParameterIsNotNull((Object)includedVersion, (String)"includedVersion");
        return NpmVersionsKt.includedRange(CollectionsKt.listOf((Object)includedVersion), includedWithCaret);
    }

    public static /* synthetic */ NpmRange includedRange$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return NpmVersionsKt.includedRange(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final NpmRange includedRange(@NotNull List<String> includedVersions, boolean includedWithCaret) {
        NpmRange npmRange;
        Intrinsics.checkParameterIsNotNull(includedVersions, (String)"includedVersions");
        try {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = includedVersions;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = NpmVersionsKt.versionToNpmRanges(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (NpmRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = includedWithCaret ? NpmVersionsKt.caretizeSingleVersion((NpmRange)((Object)it)) : it;
                collection.add(object);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void next;
                NpmRange $i$f$mapTo2 = (NpmRange)iterator$iv.next();
                NpmRange acc = (NpmRange)accumulator$iv;
                boolean bl = false;
                NpmRange intersection = NpmRangeKt.intersect(acc, (NpmRange)next);
                boolean bl2 = false;
                boolean bl3 = false;
                if (intersection == null) {
                    boolean bl4 = false;
                    String string = "Included versions have no intersection " + includedVersions;
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                accumulator$iv = intersection;
            }
            npmRange = (NpmRange)accumulator$iv;
        }
        catch (UnsupportedOperationException e) {
            throw (Throwable)new InvalidUserDataException("No ranges for included versions " + includedVersions);
        }
        return npmRange;
    }

    public static /* synthetic */ NpmRange includedRange$default(List list2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return NpmVersionsKt.includedRange(list2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String buildNpmVersion(@NotNull List<String> includedVersions, @NotNull List<String> excludedVersions, boolean includedWithCaret) {
        String string;
        Iterator iterator$iv;
        Iterable $this$reduce$iv;
        Collection destination$iv$iv;
        void var7_7;
        Intrinsics.checkParameterIsNotNull(includedVersions, (String)"includedVersions");
        Intrinsics.checkParameterIsNotNull(excludedVersions, (String)"excludedVersions");
        NpmRange includedRange = NpmVersionsKt.includedRange(includedVersions, includedWithCaret);
        if (excludedVersions.isEmpty()) {
            return includedRange.toString();
        }
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object list$iv$iv;
            String it;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Iterable iterable = excludedVersions;
            boolean $i$f$flatMap = false;
            var7_7 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                list$iv$iv = NpmVersionsKt.versionToNpmRanges(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (NpmRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Set<NpmRange> set2 = NpmRangeKt.invert((NpmRange)((Object)it));
                collection.add(set2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void next;
                Set $i$f$mapTo2 = (Set)iterator$iv.next();
                Set acc = (Set)accumulator$iv;
                boolean bl = false;
                accumulator$iv = NpmRangeKt.intersect(acc, (Set<NpmRange>)next);
            }
            $this$reduce$iv = (Set)accumulator$iv;
        }
        catch (UnsupportedOperationException e) {
            throw (Throwable)new InvalidUserDataException("No ranges for excluded versions " + excludedVersions);
        }
        Set excludedRanges = $this$reduce$iv;
        if (excludedRanges.isEmpty()) {
            string = includedRange.toString();
        } else {
            void $this$sortedBy$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            $this$reduce$iv = excludedRanges;
            boolean $i$f$mapNotNull = false;
            iterator$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                NpmRange npmRange;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                NpmRange it = (NpmRange)element$iv$iv;
                boolean bl2 = false;
                if (NpmRangeKt.intersect(it, includedRange) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                NpmRange it$iv$iv = npmRange;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            var7_7 = $this$sortedBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    NpmRange it = (NpmRange)a;
                    boolean bl2 = false;
                    Comparable comparable = it.getStartVersion();
                    it = (NpmRange)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    SemVer semVer = it.getStartVersion();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)semVer);
                }
            };
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)var7_7, (Comparator)comparator), (CharSequence)" || ", null, null, (int)0, null, null, (int)62, null);
        }
        return string;
    }

    public static /* synthetic */ String buildNpmVersion$default(List list2, List list3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return NpmVersionsKt.buildNpmVersion(list2, list3, bl);
    }

    private static final NpmRange caretizeSingleVersion(NpmRange $this$caretizeSingleVersion) {
        SemVer semVer = $this$caretizeSingleVersion.getStartVersion();
        SemVer semVer2 = $this$caretizeSingleVersion.getEndVersion();
        if (Intrinsics.areEqual((Object)(semVer != null ? SemverKt.toVersion(semVer) : null), (Object)(semVer2 != null ? SemverKt.toVersion(semVer2) : null)) && ($this$caretizeSingleVersion.getStartInclusive() || $this$caretizeSingleVersion.getEndInclusive())) {
            SemVer semVer3;
            return new NpmRange($this$caretizeSingleVersion.getStartVersion(), $this$caretizeSingleVersion.getStartInclusive(), (semVer3 = $this$caretizeSingleVersion.getStartVersion()) != null && (semVer3 = SemverKt.toVersion(semVer3)) != null && (semVer3 = semVer3.incrementMajor()) != null ? SemverKt.toSemVer((Version)semVer3) : null, false, 8, null);
        }
        return $this$caretizeSingleVersion;
    }
}

