/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import de.undercouch.gradle.tasks.download.DownloadAction;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnEnv;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnRootExtensionKt;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnSetupTask;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0007R\u0017\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\u00020\t8G\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "destination", "Ljava/io/File;", "destination$annotations", "getDestination", "()Ljava/io/File;", "downloadUrl", "", "downloadUrl$annotations", "getDownloadUrl", "()Ljava/lang/String;", "env", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEnv;", "getEnv", "()Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnEnv;", "env$delegate", "Lkotlin/Lazy;", "settings", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnRootExtension;", "download", "tar", "extract", "", "archive", "setup", "Companion", "kotlin-gradle-plugin"})
public class YarnSetupTask
extends DefaultTask {
    private final YarnRootExtension settings;
    private final Lazy env$delegate;
    @NotNull
    public static final String NAME = "kotlinYarnSetup";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final YarnEnv getEnv() {
        Lazy lazy = this.env$delegate;
        YarnSetupTask yarnSetupTask = this;
        Object var3_3 = null;
        boolean bl = false;
        return (YarnEnv)lazy.getValue();
    }

    public static /* synthetic */ void downloadUrl$annotations() {
    }

    @Input
    @NotNull
    public final String getDownloadUrl() {
        return this.getEnv().getDownloadUrl();
    }

    public static /* synthetic */ void destination$annotations() {
    }

    @OutputDirectory
    @NotNull
    public final File getDestination() {
        return this.getEnv().getHome();
    }

    @TaskAction
    public final void setup() {
        File dir;
        File file = dir = this.getTemporaryDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
        File tar = this.download(file);
        this.extract(tar, this.getDestination());
    }

    private final File download(File tar) {
        DownloadAction action = new DownloadAction(this.getProject());
        action.src((Object)this.getDownloadUrl());
        action.dest((Object)tar);
        action.execute();
        List list2 = action.getOutputFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"action.outputFiles");
        File file = (File)CollectionsKt.singleOrNull((List)list2);
        if (file == null) {
            String string = "Cannot get downloaded file " + this.getDownloadUrl();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return file;
    }

    private final void extract(File archive, File destination) {
        String string = archive.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"archive.name");
        String dirInTar = StringsKt.removeSuffix((String)string, (CharSequence)".tar.gz");
        this.getProject().copy((Action)new Action<CopySpec>(this, archive, destination, dirInTar){
            final /* synthetic */ YarnSetupTask this$0;
            final /* synthetic */ File $archive;
            final /* synthetic */ File $destination;
            final /* synthetic */ String $dirInTar;

            public final void execute(CopySpec it) {
                it.from(new Object[]{this.this$0.getProject().tarTree((Object)this.$archive)});
                it.into((Object)this.$destination);
                CopySpec copySpec = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)copySpec, (String)"it");
                copySpec.setIncludeEmptyDirs(false);
                it.eachFile((Action)new Action<FileCopyDetails>(this){
                    final /* synthetic */ extract.1 this$0;

                    public final void execute(FileCopyDetails fileCopy) {
                        FileCopyDetails fileCopyDetails = fileCopy;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileCopyDetails, (String)"fileCopy");
                        String string = fileCopy.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileCopy.path");
                        fileCopyDetails.setPath(StringsKt.removePrefix((String)string, (CharSequence)this.this$0.$dirInTar));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = yarnSetupTask;
                this.$archive = file;
                this.$destination = file2;
                this.$dirInTar = string;
            }
        });
    }

    public YarnSetupTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.settings = YarnRootExtensionKt.getYarn(project);
        this.env$delegate = LazyKt.lazy((Function0)((Function0)new Function0<YarnEnv>(this){
            final /* synthetic */ YarnSetupTask this$0;

            @NotNull
            public final YarnEnv invoke() {
                return (YarnEnv)YarnSetupTask.access$getSettings$p(this.this$0).requireConfigured();
            }
            {
                this.this$0 = yarnSetupTask;
                super(0);
            }
        }));
        this.setGroup("nodeJs");
        this.setDescription("Download and install a local yarn version");
    }

    public static final /* synthetic */ YarnRootExtension access$getSettings$p(YarnSetupTask $this) {
        return $this.settings;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnSetupTask$Companion;", "", "()V", "NAME", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

