/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.testing.internal;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestReport;
import org.gradle.api.tasks.testing.TestResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.testing.KotlinTestRunnerListener;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.tasks.KotlinTest;
import org.jetbrains.kotlin.gradle.testing.internal.KotlinTestReport;
import org.jetbrains.kotlin.gradle.testing.internal.MultiCauseException;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u000f\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bJ\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/H\u0002J\b\u0010\u0003\u001a\u00020)H\u0007J\b\u00100\u001a\u00020)H\u0002J\b\u00101\u001a\u00020)H\u0002J\u0010\u00102\u001a\u00020)2\u0006\u0010,\u001a\u00020&H\u0002J\b\u00103\u001a\u00020\u0015H\u0002J\u000e\u00104\u001a\u00020)2\u0006\u00105\u001a\u000206J\b\u0010\u001b\u001a\u00020)H\u0002J\u000e\u00107\u001a\u00020)2\u0006\u0010,\u001a\u00020&J\u0010\u00108\u001a\u00020)2\u0006\u0010,\u001a\u00020&H\u0002J\u0016\u00109\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00000\u000bH\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R$\u0010\u001d\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 j\u0002`!0\u001e0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\r\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/gradle/testing/internal/KotlinTestReport;", "Lorg/gradle/api/tasks/testing/TestReport;", "()V", "checkFailedTests", "", "getCheckFailedTests", "()Z", "setCheckFailedTests", "(Z)V", "children", "", "Lorg/gradle/api/tasks/TaskProvider;", "getChildren", "()Ljava/util/List;", "failedTestsListener", "org/jetbrains/kotlin/gradle/testing/internal/KotlinTestReport$failedTestsListener$1", "Lorg/jetbrains/kotlin/gradle/testing/internal/KotlinTestReport$failedTestsListener$1;", "hasFailedTests", "getHasFailedTests", "hasOwnFailedTests", "htmlReportUrl", "", "getHtmlReportUrl", "()Ljava/lang/String;", "ignoreFailures", "getIgnoreFailures", "setIgnoreFailures", "overrideReporting", "getOverrideReporting", "ownSuppressedRunningFailures", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTest;", "Ljava/lang/Error;", "Lkotlin/Error;", "parent", "projectProperties", "Lorg/jetbrains/kotlin/gradle/plugin/PropertiesProvider;", "testTasks", "Lorg/gradle/api/tasks/testing/AbstractTestTask;", "getTestTasks", "addChild", "", "childProvider", "addToParents", "task", "asClickableFileUrl", "path", "Ljava/io/File;", "checkSuppressedRunningFailures", "disableIndividualTestTaskReportingAndFailing", "disableTestReporting", "getFailingTestsMessage", "maybeOverrideReporting", "graph", "Lorg/gradle/api/execution/TaskExecutionGraph;", "registerTestTask", "reportOn", "reportOnChildTasks", "kotlin-gradle-plugin"})
public class KotlinTestReport
extends TestReport {
    @Internal
    @NotNull
    private final List<AbstractTestTask> testTasks;
    @Nullable
    private KotlinTestReport parent;
    @Internal
    @NotNull
    private final List<TaskProvider<KotlinTestReport>> children;
    @NotNull
    private final PropertiesProvider projectProperties;
    @Input
    private boolean checkFailedTests;
    @Input
    private boolean ignoreFailures;
    private boolean hasOwnFailedTests;
    @NotNull
    private final List<Pair<KotlinTest, Error>> ownSuppressedRunningFailures;
    @NotNull
    private final failedTestsListener.1 failedTestsListener;

    public KotlinTestReport() {
        boolean bl = false;
        this.testTasks = new ArrayList();
        bl = false;
        this.children = new ArrayList();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.projectProperties = PropertiesProvider.Companion.invoke(project);
        boolean bl2 = false;
        this.ownSuppressedRunningFailures = new ArrayList();
        this.failedTestsListener = new TestListener(this){
            final /* synthetic */ KotlinTestReport this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeTest(@NotNull TestDescriptor testDescriptor) {
                Intrinsics.checkParameterIsNotNull((Object)testDescriptor, (String)"testDescriptor");
            }

            public void afterSuite(@NotNull TestDescriptor suite, @NotNull TestResult result2) {
                Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            }

            public void beforeSuite(@NotNull TestDescriptor suite) {
                Intrinsics.checkParameterIsNotNull((Object)suite, (String)"suite");
            }

            public void afterTest(@NotNull TestDescriptor testDescriptor, @NotNull TestResult result2) {
                Intrinsics.checkParameterIsNotNull((Object)testDescriptor, (String)"testDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                if (result2.getFailedTestCount() > 0L) {
                    KotlinTestReport.access$setHasOwnFailedTests$p(this.this$0, true);
                }
            }
        };
    }

    @NotNull
    public final List<AbstractTestTask> getTestTasks() {
        return this.testTasks;
    }

    @NotNull
    public final List<TaskProvider<KotlinTestReport>> getChildren() {
        return this.children;
    }

    @Input
    public final boolean getOverrideReporting() {
        return this.projectProperties.getIndividualTaskReports() == null;
    }

    public final boolean getCheckFailedTests() {
        return this.checkFailedTests;
    }

    public final void setCheckFailedTests(boolean bl) {
        this.checkFailedTests = bl;
    }

    public final boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public final void setIgnoreFailures(boolean bl) {
        this.ignoreFailures = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getHasFailedTests() {
        TaskProvider it;
        if (this.hasOwnFailedTests) return true;
        Iterable $this$any$iv = this.children;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (TaskProvider)element$iv;
            boolean bl = false;
        } while (!((KotlinTestReport)((Object)it.get())).getHasFailedTests());
        return true;
    }

    public final void addChild(@NotNull TaskProvider<KotlinTestReport> childProvider) {
        Intrinsics.checkParameterIsNotNull(childProvider, (String)"childProvider");
        KotlinTestReport child = (KotlinTestReport)((Object)childProvider.get());
        boolean bl = child.parent == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = (Object)((Object)child) + " already registers as child of " + (Object)((Object)child.parent);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        child.parent = this;
        this.children.add(childProvider);
        this.reportOnChildTasks(childProvider);
    }

    private final void reportOnChildTasks(TaskProvider<KotlinTestReport> childProvider) {
        AbstractTestTask it;
        KotlinTestReport child = (KotlinTestReport)((Object)childProvider.get());
        Iterable $this$forEach$iv = child.testTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AbstractTestTask)element$iv;
            boolean bl = false;
            this.reportOn(it);
        }
        $this$forEach$iv = child.children;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TaskProvider)element$iv;
            boolean bl = false;
            this.reportOnChildTasks((TaskProvider<KotlinTestReport>)it);
        }
    }

    public final void registerTestTask(@NotNull AbstractTestTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.testTasks.add(task);
        task.addTestListener((TestListener)this.failedTestsListener);
        if (task instanceof KotlinTest) {
            ((KotlinTest)task).addRunListener(new KotlinTestRunnerListener(this, task){
                final /* synthetic */ KotlinTestReport this$0;
                final /* synthetic */ AbstractTestTask $task;
                {
                    this.this$0 = $receiver;
                    this.$task = $task;
                }

                public void runningFailure(@NotNull Error failure) {
                    Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                    KotlinTestReport.access$getOwnSuppressedRunningFailures$p(this.this$0).add(TuplesKt.to((Object)this.$task, (Object)failure));
                }
            });
        }
        this.reportOn(task);
        this.addToParents(task);
    }

    private final void addToParents(AbstractTestTask task) {
        KotlinTestReport parent = this.parent;
        if (parent != null) {
            parent.reportOn(task);
            parent.addToParents(task);
        }
    }

    private final void reportOn(AbstractTestTask task) {
        Object[] objectArray = new Object[]{task.getBinResultsDir()};
        this.reportOn(objectArray);
    }

    @Internal
    @Nullable
    public String getHtmlReportUrl() {
        String string;
        File file = this.getDestinationDir();
        if (file == null) {
            string = null;
        } else {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            string = this.asClickableFileUrl(FilesKt.resolve((File)it, (String)"index.html"));
        }
        return string;
    }

    private final String asClickableFileUrl(File path) {
        String string = new URI("file", "", path.toURI().getPath(), null, null).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URI(\"file\", \"\", path.toURI().path, null, null).toString()");
        return string;
    }

    @TaskAction
    public final void checkFailedTests() {
        if (this.checkFailedTests) {
            this.checkSuppressedRunningFailures();
            if (this.getHasFailedTests()) {
                if (this.ignoreFailures) {
                    this.getLogger().warn(this.getFailingTestsMessage());
                } else {
                    throw new GradleException(this.getFailingTestsMessage());
                }
            }
        }
    }

    private final String getFailingTestsMessage() {
        StringBuilder message2 = new StringBuilder("There were failing tests.");
        String reportUrl = this.getHtmlReportUrl();
        if (reportUrl != null) {
            message2.append(Intrinsics.stringPlus((String)" See the report at: ", (Object)reportUrl));
        }
        String string = message2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSuppressedRunningFailures() {
        boolean bl = false;
        List allSuppressedRunningFailures = new ArrayList();
        KotlinTestReport.checkSuppressedRunningFailures$visitSuppressedRunningFailures(allSuppressedRunningFailures, this);
        Collection collection = allSuppressedRunningFailures;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            void $this$groupByTo$iv$iv;
            bl2 = false;
            List allErrors = new ArrayList();
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            StringBuilder $this$checkSuppressedRunningFailures_u24lambda_u2d8 = stringBuilder;
            boolean bl6 = false;
            StringBuilder stringBuilder2 = $this$checkSuppressedRunningFailures_u24lambda_u2d8;
            String string = "Failed to execute all tests:";
            boolean bl7 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            Iterable $this$groupBy$iv = allSuppressedRunningFailures;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                Pair it = (Pair)element$iv$iv;
                boolean bl8 = false;
                KotlinTest key$iv$iv = (KotlinTest)((Object)it.getFirst());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl9 = false;
                    ArrayList answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv.forEach((BiConsumer)new BiConsumer<KotlinTest, List<? extends Pair<? extends KotlinTest, ? extends Error>>>($this$checkSuppressedRunningFailures_u24lambda_u2d8, (List<Error>)allErrors){
                final /* synthetic */ StringBuilder $this_anonymous;
                final /* synthetic */ List<Error> $allErrors;
                {
                    this.$this_anonymous = $receiver;
                    this.$allErrors = $allErrors;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void accept(@NotNull KotlinTest test2, @NotNull List<? extends Pair<? extends KotlinTest, ? extends Error>> errors) {
                    void $this$forEach$iv;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)test2), (String)"test");
                    Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
                    this.$this_anonymous.append(test2.getPath());
                    this.$this_anonymous.append(": ");
                    boolean first = false;
                    first = true;
                    Iterable iterable = errors;
                    List<Error> list2 = this.$allErrors;
                    StringBuilder stringBuilder = this.$this_anonymous;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair $dstr$_u24__u24$error = (Pair)element$iv;
                        boolean bl = false;
                        Error error = (Error)$dstr$_u24__u24$error.component2();
                        list2.add(error);
                        stringBuilder.append(error.getMessage());
                        if (first) {
                            first = false;
                            continue;
                        }
                        StringsKt.appendln((StringBuilder)stringBuilder);
                    }
                }
            });
            if (this.getHasFailedTests()) {
                String failedTestsMessage = this.getFailingTestsMessage();
                if (this.getIgnoreFailures()) {
                    this.getLogger().warn(this.getFailingTestsMessage());
                } else {
                    allErrors.add(new Error(failedTestsMessage));
                    StringBuilder stringBuilder4 = $this$checkSuppressedRunningFailures_u24lambda_u2d8;
                    object = Intrinsics.stringPlus((String)"Also: ", (Object)failedTestsMessage);
                    boolean bl10 = false;
                    StringBuilder stringBuilder5 = stringBuilder4.append((String)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder5);
                }
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String msg2 = string2;
            throw new MultiCauseException(msg2, allErrors);
        }
    }

    public final void maybeOverrideReporting(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        if (!this.getOverrideReporting()) {
            return;
        }
        if (!graph.hasTask((Task)this)) {
            return;
        }
        KotlinTestReport parent = this.parent;
        while (parent != null) {
            if (parent.getOverrideReporting() && graph.hasTask((Task)parent)) {
                return;
            }
            parent = parent.parent;
        }
        this.overrideReporting();
    }

    private final void overrideReporting() {
        this.ignoreFailures = false;
        this.checkFailedTests = true;
        this.disableIndividualTestTaskReportingAndFailing();
    }

    private final void disableIndividualTestTaskReportingAndFailing() {
        Iterable $this$forEach$iv = this.testTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractTestTask it = (AbstractTestTask)element$iv;
            boolean bl = false;
            this.disableTestReporting(it);
        }
        $this$forEach$iv = this.children;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskProvider child = (TaskProvider)element$iv;
            boolean bl = false;
            child.configure((Action)disableIndividualTestTaskReportingAndFailing.2.1.INSTANCE);
        }
    }

    private final void disableTestReporting(AbstractTestTask task) {
        task.setIgnoreFailures(true);
        if (task instanceof KotlinTest) {
            ((KotlinTest)task).setIgnoreRunFailures(true);
        }
        task.getReports().getHtml().setEnabled(false);
        task.getReports().getJunitXml().setEnabled(false);
    }

    private static final void checkSuppressedRunningFailures$visitSuppressedRunningFailures(List<Pair<KotlinTest, Error>> $allSuppressedRunningFailures, KotlinTestReport report2) {
        Pair it;
        Iterable $this$forEach$iv = report2.ownSuppressedRunningFailures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            $allSuppressedRunningFailures.add((Pair<KotlinTest, Error>)it);
        }
        $this$forEach$iv = report2.children;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TaskProvider)element$iv;
            boolean bl = false;
            Object object = it.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.get()");
            KotlinTestReport.checkSuppressedRunningFailures$visitSuppressedRunningFailures($allSuppressedRunningFailures, (KotlinTestReport)((Object)object));
        }
    }

    public static final /* synthetic */ List access$getOwnSuppressedRunningFailures$p(KotlinTestReport $this) {
        return $this.ownSuppressedRunningFailures;
    }

    public static final /* synthetic */ void access$disableIndividualTestTaskReportingAndFailing(KotlinTestReport $this) {
        $this.disableIndividualTestTaskReportingAndFailing();
    }

    public static final /* synthetic */ void access$setHasOwnFailedTests$p(KotlinTestReport $this, boolean bl) {
        $this.hasOwnFailedTests = bl;
    }
}

