/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.messages.serviceMessages.RequiredAttribute;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import jetbrains.buildServer.messages.serviceMessages.SimpleServiceMessageParserCallback;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessage {
    @NotNull
    public static final String SERVICE_MESSAGE_START = "##teamcity[";
    @NotNull
    public static final String SERVICE_MESSAGE_END = "]";
    public static final String TAGS_SEPARATOR = ",";
    @NonNls
    public static final String ENABLE = "enableServiceMessages";
    @NonNls
    public static final String DISABLE = "disableServiceMessages";
    private static final String RESERVED_ATTRIBUTE_PREFIX = "tc:";
    public static final String ARG_ATTRIBUTE = "tc:arg";
    public static final String TAGS_ATRRIBUTE = "tc:tags";
    @NotNull
    private static final String FORMAT_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    @NotNull
    private static final String FORMAT_WITHOUT_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int FORMAT_WITHOUT_TZ_LEN = "yyyy-MM-dd'T'HH:mm:ss.SSS".replace("'", "").length();
    private String myMessageName;
    @NotNull
    private final Map<String, String> myAttributes;
    @Nullable
    private String myArgument;
    @Nullable
    private Timestamp myCreationTimestamp;
    @Nullable
    private String myFlowId;
    @NotNull
    private List<String> myTags;
    public static final String PARSE_SERVICE_MESSAGES_INSIDE_TAG = "tc:parseServiceMessagesInside";

    ServiceMessage() {
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
    }

    protected ServiceMessage(@NotNull String messageName) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(0);
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
    }

    protected ServiceMessage(@NotNull String messageName, @Nullable String argument) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(1);
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
        this.myArgument = argument;
    }

    protected ServiceMessage(@NotNull String messageName, @NotNull Map<String, String> attributes) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            ServiceMessage.$$$reportNull$$$0(3);
        }
        this.myAttributes = new LinkedHashMap<String, String>();
        this.myTags = Collections.emptyList();
        this.myMessageName = messageName;
        try {
            this.populateAttributes(attributes);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text) throws ParseException {
        if (text == null) {
            ServiceMessage.$$$reportNull$$$0(4);
        }
        if (text.startsWith(SERVICE_MESSAGE_START) && text.endsWith(SERVICE_MESSAGE_END)) {
            SimpleServiceMessageParserCallback callback = new SimpleServiceMessageParserCallback();
            new ServiceMessagesParser().parse(text, callback);
            if (!callback.getErrors().isEmpty()) {
                throw callback.getErrors().get(0);
            }
            if (callback.getMessages().isEmpty()) {
                return null;
            }
            return callback.getMessages().get(0);
        }
        return null;
    }

    public static void parse(@NotNull String text, @NotNull ServiceMessageParserCallback parserCallback) {
        if (text == null) {
            ServiceMessage.$$$reportNull$$$0(5);
        }
        if (parserCallback == null) {
            ServiceMessage.$$$reportNull$$$0(6);
        }
        new ServiceMessagesParser().parse(text, parserCallback);
    }

    private static boolean isReservedName(@NotNull String name) {
        if (name == null) {
            ServiceMessage.$$$reportNull$$$0(7);
        }
        return name.startsWith(RESERVED_ATTRIBUTE_PREFIX) && MapSerializerUtil.isValidJavaIdentifier(name.substring(RESERVED_ATTRIBUTE_PREFIX.length()));
    }

    @NotNull
    public String getMessageName() {
        String string = this.myMessageName;
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getArgument() {
        return this.myArgument;
    }

    @Nullable
    public Timestamp getCreationTimestamp() {
        return this.myCreationTimestamp;
    }

    @Nullable
    public String getFlowId() {
        return this.myFlowId;
    }

    @NotNull
    public Collection<String> getTags() {
        List<String> list2 = this.myTags;
        if (list2 == null) {
            ServiceMessage.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Map<String, String> map = Collections.unmodifiableMap(this.myAttributes);
        if (map == null) {
            ServiceMessage.$$$reportNull$$$0(10);
        }
        return map;
    }

    public void visit(@NotNull ServiceMessageVisitor visitor) {
        if (visitor == null) {
            ServiceMessage.$$$reportNull$$$0(11);
        }
        visitor.visitServiceMessage(this);
    }

    public void setTimestamp(@NotNull Date timestamp) {
        if (timestamp == null) {
            ServiceMessage.$$$reportNull$$$0(12);
        }
        this.myAttributes.put("timestamp", new SimpleDateFormat(FORMAT_WITH_TZ).format(timestamp));
        this.myCreationTimestamp = new Timestamp(timestamp, true);
    }

    public void setFlowId(@NotNull String flowId) {
        if (flowId == null) {
            ServiceMessage.$$$reportNull$$$0(13);
        }
        this.myAttributes.put("flowId", flowId);
        this.myFlowId = flowId;
    }

    public void addTag(@NotNull String tag) {
        if (tag == null) {
            ServiceMessage.$$$reportNull$$$0(14);
        }
        this.myTags = new ArrayList<String>(this.myTags);
        if (!this.myTags.contains(tag)) {
            this.myTags.add(tag);
        }
    }

    @Nullable
    protected String getAttributeValue(@NotNull String attrName) {
        if (attrName == null) {
            ServiceMessage.$$$reportNull$$$0(15);
        }
        return this.getAttributes().get(attrName);
    }

    private void parseArgument(@Nullable String argumentsStr) throws ParseException {
        this.myArgument = argumentsStr == null ? null : ServiceMessage.stringToText(argumentsStr);
    }

    private void parseAttributes(@Nullable String argumentsStr) throws ParseException {
        this.reset();
        if (argumentsStr != null) {
            Map<String, String> parsedAttributes = MapSerializerUtil.stringToProperties(argumentsStr, MapSerializerUtil.STD_ESCAPER2, false);
            for (String attrName : parsedAttributes.keySet()) {
                if (ServiceMessage.isReservedName(attrName) || MapSerializerUtil.isValidJavaIdentifier(attrName)) continue;
                throw new ParseException("Invalid attribute name: " + attrName, 0);
            }
            this.populateAttributes(parsedAttributes);
        }
    }

    private void populateAttributes(Map<String, String> attributes) throws ParseException {
        this.myAttributes.putAll(attributes);
        if (this.myAttributes.containsKey(ARG_ATTRIBUTE)) {
            this.myArgument = this.myAttributes.get(ARG_ATTRIBUTE);
            this.myAttributes.remove(ARG_ATTRIBUTE);
        }
        if (this.myAttributes.containsKey(TAGS_ATRRIBUTE)) {
            String tagsStr = this.myAttributes.get(TAGS_ATRRIBUTE);
            this.myTags = ServiceMessage.splitTags(tagsStr);
            this.myAttributes.remove(TAGS_ATRRIBUTE);
        }
        this.parseCreationTimestamp();
        this.parseFlowId();
    }

    private void reset() {
        this.myAttributes.clear();
        this.myCreationTimestamp = null;
        this.myFlowId = null;
        this.myTags = Collections.emptyList();
        this.myArgument = null;
    }

    private static List<String> splitTags(String tagsStr) {
        StringTokenizer tok = new StringTokenizer(tagsStr, TAGS_SEPARATOR);
        ArrayList<String> result2 = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            result2.add(tok.nextToken().trim());
        }
        return Collections.unmodifiableList(result2);
    }

    private void parseFlowId() {
        this.myFlowId = this.getAttributeValue("flowId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseCreationTimestamp() throws ParseException {
        String creationTimestampStr = this.getAttributeValue("timestamp");
        if (creationTimestampStr == null) {
            this.myCreationTimestamp = null;
            return;
        }
        creationTimestampStr = creationTimestampStr.replace("'T'", "T");
        ServiceMessage serviceMessage = this;
        synchronized (serviceMessage) {
            this.myCreationTimestamp = creationTimestampStr.length() == FORMAT_WITHOUT_TZ_LEN ? new Timestamp(new SimpleDateFormat(FORMAT_WITHOUT_TZ).parse(creationTimestampStr), false) : new Timestamp(new SimpleDateFormat(FORMAT_WITH_TZ).parse(creationTimestampStr), true);
        }
    }

    private static int indexOfAnyWhitespace(@NotNull String text) {
        if (text == null) {
            ServiceMessage.$$$reportNull$$$0(16);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static ServiceMessage parseSimple(@NotNull String text, boolean shouldValidate) throws ParseException {
        int sepIndex;
        if (text == null) {
            ServiceMessage.$$$reportNull$$$0(17);
        }
        String key = (sepIndex = ServiceMessage.indexOfAnyWhitespace(text)) == -1 ? text : text.substring(0, sepIndex);
        String argumentsStr = sepIndex == -1 ? null : text.substring(sepIndex).trim();
        ServiceMessage msg2 = new ServiceMessage();
        msg2.init(key, argumentsStr);
        ServiceMessage serviceMessage = msg2;
        if (serviceMessage == null) {
            ServiceMessage.$$$reportNull$$$0(18);
        }
        return serviceMessage;
    }

    protected void validate() throws ParseException {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            RequiredAttribute required = method.getAnnotation(RequiredAttribute.class);
            if (required == null) continue;
            try {
                Object invoke = method.invoke((Object)this, new Object[0]);
                if (invoke != null) continue;
                throw new ParseException("Attribute '" + required.attributeName() + "' is not specified in service message {" + this.toString() + "}", 0);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private static String stringToText(@NotNull String message2) throws ParseException {
        if (message2 == null) {
            ServiceMessage.$$$reportNull$$$0(19);
        }
        if ((message2 = message2.trim()).startsWith("'") && message2.endsWith("'") && message2.length() >= 2) {
            String string = MapSerializerUtil.unescapeStr(message2.substring(1, message2.length() - 1), MapSerializerUtil.STD_ESCAPER2);
            if (string == null) {
                ServiceMessage.$$$reportNull$$$0(20);
            }
            return string;
        }
        throw new ParseException("Cannot extract text message [" + message2 + SERVICE_MESSAGE_END, 0);
    }

    void init(@NotNull String key, @Nullable String argumentsStr) throws ParseException {
        if (key == null) {
            ServiceMessage.$$$reportNull$$$0(21);
        }
        this.myMessageName = key;
        if (argumentsStr != null && argumentsStr.trim().startsWith("'")) {
            this.parseArgument(argumentsStr);
        } else {
            this.parseAttributes(argumentsStr);
        }
    }

    @NotNull
    public String asString() {
        if (this.myArgument != null && this.myTags.isEmpty()) {
            String string = ServiceMessage.asString(this.myMessageName, this.myArgument);
            if (string == null) {
                ServiceMessage.$$$reportNull$$$0(22);
            }
            return string;
        }
        LinkedHashMap<String, String> fullAttrMap = new LinkedHashMap<String, String>();
        if (this.myArgument != null) {
            fullAttrMap.put(ARG_ATTRIBUTE, this.myArgument);
        }
        if (!this.myTags.isEmpty()) {
            StringBuilder tagsStr = new StringBuilder();
            for (String tag : this.myTags) {
                if (tagsStr.length() > 0) {
                    tagsStr.append(TAGS_SEPARATOR);
                }
                tagsStr.append(tag);
            }
            fullAttrMap.put(TAGS_ATRRIBUTE, tagsStr.toString());
        }
        fullAttrMap.putAll(this.myAttributes);
        String string = ServiceMessage.asString(this.myMessageName, fullAttrMap);
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String asString(@NotNull String messageName, @NotNull Map<String, String> attributes) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(24);
        }
        if (attributes == null) {
            ServiceMessage.$$$reportNull$$$0(25);
        }
        StringBuilder text = new StringBuilder();
        ServiceMessage.appendMessageName(text, messageName);
        if (!attributes.isEmpty()) {
            text.append(' ');
            text.append(MapSerializerUtil.propertiesToString(attributes, MapSerializerUtil.STD_ESCAPER2));
        }
        text.append(SERVICE_MESSAGE_END);
        String string = text.toString();
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String asString(@NotNull String messageName, @NotNull String argument) {
        if (messageName == null) {
            ServiceMessage.$$$reportNull$$$0(27);
        }
        if (argument == null) {
            ServiceMessage.$$$reportNull$$$0(28);
        }
        StringBuilder text = new StringBuilder();
        ServiceMessage.appendMessageName(text, messageName);
        text.append(" '");
        text.append(MapSerializerUtil.escapeStr(argument, MapSerializerUtil.STD_ESCAPER2));
        text.append("'");
        text.append(SERVICE_MESSAGE_END);
        String string = text.toString();
        if (string == null) {
            ServiceMessage.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static void appendMessageName(StringBuilder target2, String messageName) {
        target2.append(SERVICE_MESSAGE_START);
        target2.append(messageName);
    }

    public String toString() {
        return this.asString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageName";
                break;
            }
            case 3: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flowId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/ServiceMessage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSimple";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToText";
                break;
            }
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReservedName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFlowId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAnyWhitespace";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseSimple";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "stringToText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Timestamp {
        private final Date myTimestamp;
        private final boolean myTimeZoneWasSpecified;

        public Date getTimestamp() {
            return this.myTimestamp;
        }

        public boolean isTimeZoneSpecified() {
            return this.myTimeZoneWasSpecified;
        }

        public Timestamp(Date timestamp, boolean timeZoneWasSpecified) {
            this.myTimestamp = timestamp;
            this.myTimeZoneWasSpecified = timeZoneWasSpecified;
        }
    }
}

