/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.performance;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinTargetsKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBinary;
import org.jetbrains.kotlin.gradle.plugin.performance.PerformanceExtension;
import org.jetbrains.kotlin.gradle.plugin.performance.TaskTimerListener;
import org.jetbrains.kotlin.gradle.targets.native.tasks.NativePerformanceReport;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeLink;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/performance/KotlinPerformancePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "checkSettings", "", "performanceExtension", "Lorg/jetbrains/kotlin/gradle/plugin/performance/PerformanceExtension;", "configureTasks", "Companion", "kotlin-gradle-plugin"})
public class KotlinPerformancePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String EXTENSION_NAME = "performance";
    @NotNull
    public static final String TASK_GROUP = "Kotlin/Native Performance";

    private final boolean checkSettings(Project project, PerformanceExtension performanceExtension) {
        boolean result2 = true;
        if (performanceExtension.getMetrics().isEmpty()) {
            project.getLogger().warn("There is no tracked metrics. Please, provide metrics in settings of performance plugin.");
            result2 = false;
        }
        if (performanceExtension.getTrackedBinaries().isEmpty()) {
            project.getLogger().warn("There is no tracked binaries. Please, provide binaries in settings of performance plugin.");
            result2 = false;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void configureTasks(Project project, PerformanceExtension performanceExtension) {
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        if (!ConfigurationCacheKt.isConfigurationCacheAvailable(gradle)) {
            TaskTimerListener timeListener = new TaskTimerListener(project);
            project.getGradle().addListener((Object)timeListener);
            Iterable $this$forEach$iv = performanceExtension.getTrackedBinaries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void body$iv;
                void name$iv;
                void $this$registerTask_u24default$iv;
                NativeBinary binary = (NativeBinary)element$iv;
                boolean bl = false;
                Project project2 = project;
                Object object = new String[]{"perfReport", binary.getName()};
                object = KotlinTargetsKt.disambiguateName(binary.getTarget(), StringUtilsKt.lowerCamelCaseName(object));
                Function1 function1 = (Function1)new Function1<NativePerformanceReport, Unit>(binary, performanceExtension, timeListener){
                    final /* synthetic */ NativeBinary $binary;
                    final /* synthetic */ PerformanceExtension $performanceExtension;
                    final /* synthetic */ TaskTimerListener $timeListener;
                    {
                        this.$binary = $binary;
                        this.$performanceExtension = $performanceExtension;
                        this.$timeListener = $timeListener;
                        super(1);
                    }

                    public final void invoke(@NotNull NativePerformanceReport it) {
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        it.setBinary(this.$binary);
                        it.setSettings(this.$performanceExtension);
                        it.setTimeListener(this.$timeListener);
                        it.setGroup("Kotlin/Native Performance");
                        it.setDescription("Report performance measurement results for binary '" + this.$binary.getName() + "' of target '" + this.$binary.getTarget().getName() + "'.");
                    }
                };
                List args$iv = CollectionsKt.emptyList();
                boolean $i$f$registerTask = false;
                TaskProvider<NativePerformanceReport> perfReport2 = TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, (String)name$iv, NativePerformanceReport.class, args$iv, body$iv);
                binary.getLinkTaskProvider().configure((Action)new Action<KotlinNativeLink>(perfReport2){
                    final /* synthetic */ TaskProvider<NativePerformanceReport> $perfReport;
                    {
                        this.$perfReport = $perfReport;
                    }

                    public final void execute(KotlinNativeLink linkTask) {
                        Object[] objectArray = new Object[]{this.$perfReport};
                        linkTask.finalizedBy(objectArray);
                    }
                });
            }
        }
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        boolean bl = false;
        boolean bl2 = false;
        Project $this$apply_u24lambda_u2d1 = project;
        boolean bl3 = false;
        $this$apply_u24lambda_u2d1.getPluginManager().withPlugin("kotlin-multiplatform", (Action)new Action<AppliedPlugin>(project, $this$apply_u24lambda_u2d1, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ Project $this_anonymous;
            final /* synthetic */ KotlinPerformancePlugin this$0;
            {
                this.$project = $project;
                this.$this_anonymous = $receiver;
                this.this$0 = $receiver2;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(AppliedPlugin it) {
                void $this$addExtension$iv;
                KotlinMultiplatformExtension kotlinExtension = KotlinProjectExtensionKt.getMultiplatformExtension(this.$project);
                PerformanceExtension performanceExtension = new PerformanceExtension(this.$this_anonymous);
                KotlinMultiplatformExtension kotlinMultiplatformExtension = kotlinExtension;
                String name$iv = "performance";
                boolean $i$f$addExtension = false;
                ((ExtensionAware)$this$addExtension$iv).getExtensions().add(PerformanceExtension.class, name$iv, (Object)performanceExtension);
                this.$this_anonymous.afterEvaluate((Action)new Action<Project>(this.this$0, this.$project, performanceExtension){
                    final /* synthetic */ KotlinPerformancePlugin this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ PerformanceExtension $performanceExtension;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$performanceExtension = $performanceExtension;
                    }

                    public final void execute(Project it) {
                        if (KotlinPerformancePlugin.access$checkSettings(this.this$0, this.$project, this.$performanceExtension)) {
                            KotlinPerformancePlugin.access$configureTasks(this.this$0, this.$project, this.$performanceExtension);
                        }
                    }
                });
            }
        });
    }

    public static final /* synthetic */ boolean access$checkSettings(KotlinPerformancePlugin $this, Project project, PerformanceExtension performanceExtension) {
        return $this.checkSettings(project, performanceExtension);
    }

    public static final /* synthetic */ void access$configureTasks(KotlinPerformancePlugin $this, Project project, PerformanceExtension performanceExtension) {
        $this.configureTasks(project, performanceExtension);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/performance/KotlinPerformancePlugin$Companion;", "", "()V", "EXTENSION_NAME", "", "TASK_GROUP", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

