/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.BuildEventsListenerRegistryHolder;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleFinishBuildHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginInMultipleProjectsHolder;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.report.ConfigureReporingKt;
import org.jetbrains.kotlin.gradle.utils.ConfigurationCacheKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\rJ\u001d\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/BuildAdapter;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "(Lorg/gradle/api/invocation/Gradle;)V", "buildHandler", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "multipleProjectsHolder", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginInMultipleProjectsHolder;", "buildFinished", "", "result", "Lorg/gradle/BuildResult;", "buildStarted", "detectKotlinPluginLoadedInMultipleProjects", "project", "Lorg/gradle/api/Project;", "kotlinPluginVersion", "", "detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin", "Companion", "kotlin-gradle-plugin"})
public final class KotlinGradleBuildServices
extends BuildAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Gradle gradle;
    private final Logger log;
    @Nullable
    private KotlinGradleFinishBuildHandler buildHandler;
    @NotNull
    private final KotlinPluginInMultipleProjectsHolder multipleProjectsHolder;
    private static final String CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
    @NotNull
    public static final String FORCE_SYSTEM_GC_MESSAGE = "Forcing System.gc()";
    @NotNull
    public static final String SHOULD_REPORT_MEMORY_USAGE_PROPERTY = "kotlin.gradle.test.report.memory.usage";
    @NotNull
    private static final String INIT_MESSAGE = Intrinsics.stringPlus((String)"Initialized ", (Object)CLASS_NAME);
    @NotNull
    private static final String DISPOSE_MESSAGE = Intrinsics.stringPlus((String)"Disposed ", (Object)CLASS_NAME);
    @NotNull
    private static final String ALREADY_INITIALIZED_MESSAGE = Intrinsics.stringPlus((String)CLASS_NAME, (Object)" is already initialized");
    @Nullable
    private static volatile KotlinGradleBuildServices instance;

    private KotlinGradleBuildServices(Gradle gradle) {
        this.gradle = gradle;
        this.log = Logging.getLogger(((Object)((Object)this)).getClass());
        this.multipleProjectsHolder = new KotlinPluginInMultipleProjectsHolder(true);
    }

    public final void buildStarted() {
        this.buildHandler = new KotlinGradleFinishBuildHandler();
        KotlinGradleFinishBuildHandler kotlinGradleFinishBuildHandler = this.buildHandler;
        if (kotlinGradleFinishBuildHandler == null) {
            Intrinsics.throwNpe();
        }
        kotlinGradleFinishBuildHandler.buildStart();
        TaskLoggers.INSTANCE.clear();
        TaskExecutionResults.INSTANCE.clear();
        ConfigureReporingKt.configureReporting(this.gradle);
    }

    public void buildFinished(@NotNull BuildResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        KotlinGradleFinishBuildHandler kotlinGradleFinishBuildHandler = this.buildHandler;
        if (kotlinGradleFinishBuildHandler == null) {
            Intrinsics.throwNpe();
        }
        KotlinGradleFinishBuildHandler kotlinGradleFinishBuildHandler2 = kotlinGradleFinishBuildHandler;
        Gradle gradle = result2.getGradle();
        if (gradle == null) {
            Intrinsics.throwNpe();
        }
        kotlinGradleFinishBuildHandler = gradle;
        kotlinGradleFinishBuildHandler2.buildFinished((Gradle)kotlinGradleFinishBuildHandler);
        Companion.setInstance$kotlin_gradle_plugin(null);
        kotlinGradleFinishBuildHandler = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinGradleFinishBuildHandler, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug((Logger)kotlinGradleFinishBuildHandler, Companion.getDISPOSE_MESSAGE());
    }

    public final synchronized void detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin(@NotNull Project project, @NotNull String kotlinPluginVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        Function0 onRegister2 = (Function0)new Function0<Unit>(this, project, kotlinPluginVersion){
            final /* synthetic */ KotlinGradleBuildServices this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $kotlinPluginVersion;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$kotlinPluginVersion = $kotlinPluginVersion;
                super(0);
            }

            public final void invoke() {
                KotlinGradleBuildServices.access$getGradle$p(this.this$0).getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(this.this$0, this.$project, this.$kotlinPluginVersion){
                    final /* synthetic */ KotlinGradleBuildServices this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $kotlinPluginVersion;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$kotlinPluginVersion = $kotlinPluginVersion;
                    }

                    public final void execute(TaskExecutionGraph it) {
                        if (KotlinGradleBuildServices.access$getMultipleProjectsHolder$p(this.this$0).isInMultipleProjects(this.$project, this.$kotlinPluginVersion)) {
                            List<String> list2 = KotlinGradleBuildServices.access$getMultipleProjectsHolder$p(this.this$0).getAffectedProjects(this.$project, this.$kotlinPluginVersion);
                            if (list2 == null) {
                                Intrinsics.throwNpe();
                            }
                            List<String> loadedInProjects = list2;
                            if (!Intrinsics.areEqual((Object)PropertiesProvider.Companion.invoke(this.$project).getIgnorePluginLoadedInMultipleProjects(), (Object)true)) {
                                this.$project.getLogger().warn("\nThe Kotlin Gradle plugin was loaded multiple times in different subprojects, which is not supported and may break the build. \nThis might happen in subprojects that apply the Kotlin plugins with the Gradle 'plugins { ... }' DSL if they specify explicit versions, even if the versions are equal.\nPlease add the Kotlin plugin to the common parent project or the root project, then remove the versions in the subprojects.\nIf the parent project does not need the plugin, add 'apply false' to the plugin line.\nSee: https://docs.gradle.org/current/userguide/plugins.html#sec:subprojects_plugins_dsl");
                                this.$project.getLogger().warn(Intrinsics.stringPlus((String)"The Kotlin plugin was loaded in the following projects: ", (Object)CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)4, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.onRegister.1.INSTANCE, (int)23, null)));
                            }
                            this.$project.getLogger().info(Intrinsics.stringPlus((String)"The full list of projects that loaded the Kotlin plugin is: : ", (Object)CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)0, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.onRegister.2.INSTANCE, (int)31, null)));
                        }
                    }
                });
            }
        };
        this.multipleProjectsHolder.addProject(project, kotlinPluginVersion, (Function0<Unit>)onRegister2);
    }

    @JvmStatic
    @NotNull
    public static final synchronized KotlinGradleBuildServices getInstance(@NotNull Project project, @NotNull BuildEventsListenerRegistryHolder listenerRegistryHolder) {
        return Companion.getInstance(project, listenerRegistryHolder);
    }

    public /* synthetic */ KotlinGradleBuildServices(Gradle gradle, DefaultConstructorMarker $constructor_marker) {
        this(gradle);
    }

    public static final /* synthetic */ Gradle access$getGradle$p(KotlinGradleBuildServices $this) {
        return $this.gradle;
    }

    public static final /* synthetic */ KotlinPluginInMultipleProjectsHolder access$getMultipleProjectsHolder$p(KotlinGradleBuildServices $this) {
        return $this.multipleProjectsHolder;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "ALREADY_INITIALIZED_MESSAGE", "", "getALREADY_INITIALIZED_MESSAGE", "()Ljava/lang/String;", "CLASS_NAME", "kotlin.jvm.PlatformType", "DISPOSE_MESSAGE", "getDISPOSE_MESSAGE", "FORCE_SYSTEM_GC_MESSAGE", "INIT_MESSAGE", "getINIT_MESSAGE", "SHOULD_REPORT_MEMORY_USAGE_PROPERTY", "instance", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "getInstance$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "setInstance$kotlin_gradle_plugin", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;)V", "getInstance", "project", "Lorg/gradle/api/Project;", "listenerRegistryHolder", "Lorg/jetbrains/kotlin/gradle/plugin/BuildEventsListenerRegistryHolder;", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getINIT_MESSAGE() {
            return INIT_MESSAGE;
        }

        @NotNull
        public final String getDISPOSE_MESSAGE() {
            return DISPOSE_MESSAGE;
        }

        @NotNull
        public final String getALREADY_INITIALIZED_MESSAGE() {
            return ALREADY_INITIALIZED_MESSAGE;
        }

        @Nullable
        public final KotlinGradleBuildServices getInstance$kotlin_gradle_plugin() {
            return instance;
        }

        public final void setInstance$kotlin_gradle_plugin(@Nullable KotlinGradleBuildServices kotlinGradleBuildServices) {
            instance = kotlinGradleBuildServices;
        }

        @JvmStatic
        @NotNull
        public final synchronized KotlinGradleBuildServices getInstance(@NotNull Project project, @NotNull BuildEventsListenerRegistryHolder listenerRegistryHolder) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)listenerRegistryHolder, (String)"listenerRegistryHolder");
            Logger log = Logging.getLogger(KotlinGradleBuildServices.class);
            Object object = project.provider((Callable)getInstance.kotlinGradleListenerProvider.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.provider {\n                KotlinGradleBuildListener(KotlinGradleFinishBuildHandler())\n            }");
            Provider kotlinGradleListenerProvider2 = object;
            if (this.getInstance$kotlin_gradle_plugin() != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"log");
                GradleLoggingUtilsKt.kotlinDebug(log, this.getALREADY_INITIALIZED_MESSAGE());
                object = this.getInstance$kotlin_gradle_plugin();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                return object;
            }
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"gradle");
            KotlinGradleBuildServices services = new KotlinGradleBuildServices(gradle, null);
            if (ConfigurationCacheKt.isConfigurationCacheAvailable(gradle)) {
                BuildEventsListenerRegistry buildEventsListenerRegistry = listenerRegistryHolder.getListenerRegistry();
                if (buildEventsListenerRegistry == null) {
                    Intrinsics.throwNpe();
                }
                buildEventsListenerRegistry.onTaskCompletion(kotlinGradleListenerProvider2);
            } else {
                gradle.addBuildListener((BuildListener)services);
                Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"log");
                GradleLoggingUtilsKt.kotlinDebug(log, this.getINIT_MESSAGE());
            }
            this.setInstance$kotlin_gradle_plugin(services);
            services.buildStarted();
            return services;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

