/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootExtension;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsRootPlugin;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmApi;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.npm.resolved.KotlinCompilationNpmResolution;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnBasics;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnImportedPackagesVersionResolver;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0002J2\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\tH\u0016J4\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0016J:\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnWorkspaces;", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnBasics;", "()V", "prepareRootPackageJson", "", "rootProject", "Lorg/gradle/api/Project;", "npmProjects", "", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/resolved/KotlinCompilationNpmResolution;", "resolutions", "", "", "prepareRootProject", "subProjects", "preparedFiles", "Ljava/io/File;", "project", "resolveProject", "resolvedNpmProject", "resolveRootProject", "skipExecution", "", "cliArgs", "", "saveRootProjectWorkspacesPackageJson", "rootPackageJsonFile", "kotlin-gradle-plugin"})
public final class YarnWorkspaces
extends YarnBasics {
    @Override
    public void resolveProject(@NotNull KotlinCompilationNpmResolution resolvedNpmProject) {
        Intrinsics.checkParameterIsNotNull((Object)resolvedNpmProject, (String)"resolvedNpmProject");
    }

    @Override
    @NotNull
    public Collection<File> preparedFiles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        return CollectionsKt.listOf((Object)FilesKt.resolve((File)NodeJsRootPlugin.Companion.apply(project2).getRootPackageDir(), (String)"package.json"));
    }

    @Override
    public void prepareRootProject(@NotNull Project rootProject, @NotNull Collection<KotlinCompilationNpmResolution> subProjects, @NotNull Map<String, String> resolutions) {
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull(subProjects, (String)"subProjects");
        Intrinsics.checkParameterIsNotNull(resolutions, (String)"resolutions");
        boolean bl = Intrinsics.areEqual((Object)rootProject, (Object)rootProject.getRootProject());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.setup(rootProject);
        this.prepareRootPackageJson(rootProject, subProjects, resolutions);
    }

    private final void prepareRootPackageJson(Project rootProject, Collection<KotlinCompilationNpmResolution> npmProjects, Map<String, String> resolutions) {
        File rootPackageJsonFile = (File)CollectionsKt.single((Iterable)this.preparedFiles(rootProject));
        this.saveRootProjectWorkspacesPackageJson(rootProject, npmProjects, resolutions, rootPackageJsonFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resolveRootProject(@NotNull Project rootProject, @NotNull Collection<KotlinCompilationNpmResolution> npmProjects, boolean skipExecution, @NotNull List<String> cliArgs) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull(npmProjects, (String)"npmProjects");
        Intrinsics.checkParameterIsNotNull(cliArgs, (String)"cliArgs");
        NodeJsRootExtension nodeJs = NodeJsRootPlugin.Companion.apply(rootProject);
        File nodeJsWorldDir = nodeJs.getRootPackageDir();
        this.yarnExec(rootProject, nodeJsWorldDir, NpmApi.Companion.resolveOperationDescription("yarn"), cliArgs);
        FilesKt.writeText$default((File)nodeJs.getRootNodeModulesStateFile$kotlin_gradle_plugin(), (String)String.valueOf(System.currentTimeMillis()), null, (int)2, null);
        Iterable iterable = npmProjects;
        File file = nodeJsWorldDir;
        YarnWorkspaces yarnWorkspaces = this;
        boolean $i$f$flatMap = false;
        void var9_11 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KotlinCompilationNpmResolution it = (KotlinCompilationNpmResolution)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getExternalNpmDependencies();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        yarnWorkspaces.yarnLockReadTransitiveDependencies(file, list2);
    }

    /*
     * WARNING - void declaration
     */
    private final void saveRootProjectWorkspacesPackageJson(Project rootProject, Collection<KotlinCompilationNpmResolution> npmProjects, Map<String, String> resolutions, File rootPackageJsonFile) {
        void $this$mapTo$iv$iv;
        File nodeJsWorldDir = rootPackageJsonFile.getParentFile();
        String string = rootProject.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rootProject.name");
        PackageJson rootPackageJson2 = new PackageJson(string, rootProject.getVersion().toString());
        rootPackageJson2.setPrivate(true);
        Iterable $this$map$iv = npmProjects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinCompilationNpmResolution kotlinCompilationNpmResolution = (KotlinCompilationNpmResolution)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.getNpmProject().getDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsWorldDir, (String)"nodeJsWorldDir");
            String string2 = FilesKt.relativeTo((File)file, (File)nodeJsWorldDir).getPath();
            collection.add(string2);
        }
        List npmProjectWorkspaces = (List)destination$iv$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsWorldDir, (String)"nodeJsWorldDir");
        List<String> importedProjectWorkspaces = new YarnImportedPackagesVersionResolver(rootProject, npmProjects, nodeJsWorldDir).resolveAndUpdatePackages();
        rootPackageJson2.setWorkspaces(CollectionsKt.plus((Collection)npmProjectWorkspaces, (Iterable)importedProjectWorkspaces));
        rootPackageJson2.setResolutions(resolutions);
        rootPackageJson2.saveTo(rootPackageJsonFile);
    }
}

