/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.Framework;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.AppleXcodeTasksKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.apple.XcodeEnvironment;
import org.jetbrains.kotlin.gradle.tasks.TasksProviderKt;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\r*\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"EMBED_AND_SIGN_APPLE_FRAMEWORK", "", "UMBRELLA_ASSEMBLE_APPLE_FRAMEWORK", "umbrellaAssembleAppleFrameworkTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "Lorg/gradle/api/Project;", "getUmbrellaAssembleAppleFrameworkTask", "(Lorg/gradle/api/Project;)Lorg/gradle/api/tasks/TaskProvider;", "appleFrameworkDir", "Ljava/io/File;", "frameworkSearchDir", "registerAssembleAppleFrameworkTask", "", "framework", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "registerEmbedAndSignAppleFrameworkTask", "kotlin-gradle-plugin"})
public final class AppleXcodeTasksKt {
    @NotNull
    private static final String UMBRELLA_ASSEMBLE_APPLE_FRAMEWORK = "assembleAppleFrameworkForXcode";
    @NotNull
    private static final String EMBED_AND_SIGN_APPLE_FRAMEWORK = "embedAndSignAppleFrameworkForXcode";

    /*
     * WARNING - void declaration
     */
    public static final void registerAssembleAppleFrameworkTask(@NotNull Project $this$registerAssembleAppleFrameworkTask, @NotNull Framework framework2) {
        void $this$registerTask_u24default$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$registerAssembleAppleFrameworkTask, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)framework2, (String)"framework");
        if (!framework2.getKonanTarget$kotlin_gradle_plugin().getFamily().isAppleFamily() || !KotlinNativeTargetPresetKt.getEnabledOnCurrentHost(framework2.getKonanTarget$kotlin_gradle_plugin())) {
            return;
        }
        NativeBuildType frameworkBuildType = framework2.getBuildType();
        KotlinNativeTarget frameworkTarget = framework2.getTarget();
        String[] stringArray = new String[]{"assemble", framework2.getBaseName(), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)frameworkBuildType.name()), "AppleFrameworkForXcode", frameworkTarget.getName()};
        String frameworkTaskName = StringUtilsKt.lowerCamelCaseName(stringArray);
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        KonanTarget envTarget = XcodeEnvironment.INSTANCE.getTarget();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        if (envBuildType == null || envTarget == null || envFrameworkSearchDir == null) {
            String envConfiguration = System.getenv("CONFIGURATION");
            if (envTarget != null && envConfiguration != null) {
                $this$registerAssembleAppleFrameworkTask.getLogger().warn("Unable to detect Kotlin framework build type for CONFIGURATION=" + envConfiguration + " automatically. Specify 'KOTLIN_FRAMEWORK_BUILD_TYPE' to 'debug' or 'release'");
            } else {
                $this$registerAssembleAppleFrameworkTask.getLogger().debug("Not registering " + frameworkTaskName + ", since not called from Xcode ('SDK_NAME' and 'CONFIGURATION' not provided)");
            }
            return;
        }
        if (frameworkBuildType != envBuildType || !Intrinsics.areEqual((Object)frameworkTarget.getKonanTarget(), (Object)envTarget)) {
            return;
        }
        Project envConfiguration = $this$registerAssembleAppleFrameworkTask;
        Function1 body$iv = (Function1)new Function1<Copy, Unit>(frameworkBuildType, frameworkTarget, framework2, $this$registerAssembleAppleFrameworkTask, envFrameworkSearchDir){
            final /* synthetic */ NativeBuildType $frameworkBuildType;
            final /* synthetic */ KotlinNativeTarget $frameworkTarget;
            final /* synthetic */ Framework $framework;
            final /* synthetic */ Project $this_registerAssembleAppleFrameworkTask;
            final /* synthetic */ File $envFrameworkSearchDir;
            {
                this.$frameworkBuildType = $frameworkBuildType;
                this.$frameworkTarget = $frameworkTarget;
                this.$framework = $framework;
                this.$this_registerAssembleAppleFrameworkTask = $receiver;
                this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                super(1);
            }

            public final void invoke(@NotNull Copy task) {
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                task.setGroup("build");
                task.setDescription("Packs " + this.$frameworkBuildType + ' ' + this.$frameworkTarget.getName() + " framework for Xcode");
                Object[] objectArray = new Object[]{this.$framework.getLinkTaskName()};
                task.dependsOn(objectArray);
                objectArray = new Object[]{this.$framework.getOutputDirectory()};
                task.from(objectArray);
                task.into((Object)AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerAssembleAppleFrameworkTask, this.$envFrameworkSearchDir));
            }
        };
        List args$iv = CollectionsKt.emptyList();
        boolean $i$f$registerTask = false;
        TasksProviderKt.dependsOn(AppleXcodeTasksKt.getUmbrellaAssembleAppleFrameworkTask($this$registerAssembleAppleFrameworkTask), TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, frameworkTaskName, Copy.class, args$iv, body$iv));
    }

    /*
     * WARNING - void declaration
     */
    private static final TaskProvider<Task> getUmbrellaAssembleAppleFrameworkTask(Project $this$umbrellaAssembleAppleFrameworkTask) {
        TaskProvider taskProvider2;
        TaskProvider taskProvider3;
        void name$iv;
        void $this$locateOrRegisterTask$iv;
        Project project = $this$umbrellaAssembleAppleFrameworkTask;
        String string = UMBRELLA_ASSEMBLE_APPLE_FRAMEWORK;
        Function1 body$iv = umbrellaAssembleAppleFrameworkTask.1.INSTANCE;
        boolean $i$f$locateOrRegisterTask = false;
        Project project2 = $this$locateOrRegisterTask$iv.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Project $this$locateTask$iv$iv = project2;
        boolean $i$f$locateTask = false;
        try {
            taskProvider3 = $this$locateTask$iv$iv.getTasks().withType(Task.class).named((String)name$iv);
        }
        catch (UnknownTaskException e$iv$iv) {
            taskProvider3 = null;
        }
        TaskProvider taskProvider4 = taskProvider3;
        if (taskProvider4 == null) {
            project2 = $this$locateOrRegisterTask$iv.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            taskProvider2 = TasksProviderKt.registerTask$default(project2, (String)name$iv, Task.class, null, body$iv, 4, null);
        } else {
            taskProvider2 = taskProvider4;
        }
        return taskProvider2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerEmbedAndSignAppleFrameworkTask(@NotNull Project $this$registerEmbedAndSignAppleFrameworkTask) {
        void name$iv;
        void $this$registerTask_u24default$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$registerEmbedAndSignAppleFrameworkTask, (String)"<this>");
        NativeBuildType envBuildType = XcodeEnvironment.INSTANCE.getBuildType();
        KonanTarget envTarget = XcodeEnvironment.INSTANCE.getTarget();
        File envEmbeddedFrameworksDir = XcodeEnvironment.INSTANCE.getEmbeddedFrameworksDir();
        File envFrameworkSearchDir = XcodeEnvironment.INSTANCE.getFrameworkSearchDir();
        String envSign = XcodeEnvironment.INSTANCE.getSign();
        if (envBuildType == null || envTarget == null || envEmbeddedFrameworksDir == null || envFrameworkSearchDir == null) {
            $this$registerEmbedAndSignAppleFrameworkTask.getLogger().debug("Not registering embedAndSignAppleFrameworkForXcode, since not called from Xcode ('SDK_NAME', 'CONFIGURATION', 'TARGET_BUILD_DIR' and 'FRAMEWORKS_FOLDER_PATH' not provided)");
            return;
        }
        Project project = $this$registerEmbedAndSignAppleFrameworkTask;
        String string = EMBED_AND_SIGN_APPLE_FRAMEWORK;
        Function1 body$iv = (Function1)new Function1<Copy, Unit>($this$registerEmbedAndSignAppleFrameworkTask, envFrameworkSearchDir, envEmbeddedFrameworksDir, envSign, envTarget, envBuildType){
            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
            final /* synthetic */ File $envFrameworkSearchDir;
            final /* synthetic */ File $envEmbeddedFrameworksDir;
            final /* synthetic */ String $envSign;
            final /* synthetic */ KonanTarget $envTarget;
            final /* synthetic */ NativeBuildType $envBuildType;
            {
                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                this.$envFrameworkSearchDir = $envFrameworkSearchDir;
                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                this.$envSign = $envSign;
                this.$envTarget = $envTarget;
                this.$envBuildType = $envBuildType;
                super(1);
            }

            public final void invoke(@NotNull Copy task) {
                Object[] objectArray;
                Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                task.setGroup("build");
                task.setDescription("Embed and sign all frameworks as requested by Xcode's environment variables");
                KotlinMultiplatformExtension kotlinMultiplatformExtension = KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(this.$this_registerEmbedAndSignAppleFrameworkTask);
                Object[] objectArray2 = objectArray = kotlinMultiplatformExtension == null ? null : kotlinMultiplatformExtension.getTargets();
                NamedDomainObjectCollection appleTargets2 = objectArray == null ? null : ((kotlinMultiplatformExtension = objectArray.withType(KotlinNativeTarget.class)) == null ? null : kotlinMultiplatformExtension.matching((Spec)new Spec<KotlinNativeTarget>(this.$envTarget){
                    final /* synthetic */ KonanTarget $envTarget;
                    {
                        this.$envTarget = $envTarget;
                    }

                    public final boolean isSatisfiedBy(KotlinNativeTarget it) {
                        return Intrinsics.areEqual((Object)it.getKonanTarget(), (Object)this.$envTarget);
                    }
                }));
                objectArray = new Object[]{"assembleAppleFrameworkForXcode"};
                task.dependsOn(objectArray);
                objectArray = task.getInputs();
                kotlinMultiplatformExtension = this.$envBuildType;
                KonanTarget konanTarget2 = this.$envTarget;
                File file = this.$envEmbeddedFrameworksDir;
                String string = this.$envSign;
                boolean bl = false;
                boolean bl2 = false;
                Object[] $this$invoke_u24lambda_u2d0 = objectArray;
                boolean bl3 = false;
                $this$invoke_u24lambda_u2d0.property("type", (Object)kotlinMultiplatformExtension);
                $this$invoke_u24lambda_u2d0.property("target", (Object)konanTarget2);
                $this$invoke_u24lambda_u2d0.property("embeddedFrameworksDir", (Object)file);
                $this$invoke_u24lambda_u2d0.property("sign", (Object)string);
                task.onlyIf((Spec)new Spec<Task>((NamedDomainObjectCollection<KotlinNativeTarget>)appleTargets2){
                    final /* synthetic */ NamedDomainObjectCollection<KotlinNativeTarget> $appleTargets;
                    {
                        this.$appleTargets = $appleTargets;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        Collection collection = (Collection)this.$appleTargets;
                        boolean bl = false;
                        boolean bl2 = false;
                        return !(collection == null || collection.isEmpty());
                    }
                });
                task.from((Object)AppleXcodeTasksKt.access$appleFrameworkDir(this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envFrameworkSearchDir), (Action)new Action<CopySpec>((NamedDomainObjectCollection<KotlinNativeTarget>)appleTargets2, this.$envBuildType){
                    final /* synthetic */ NamedDomainObjectCollection<KotlinNativeTarget> $appleTargets;
                    final /* synthetic */ NativeBuildType $envBuildType;
                    {
                        this.$appleTargets = $appleTargets;
                        this.$envBuildType = $envBuildType;
                    }

                    public final void execute(CopySpec spec) {
                        NamedDomainObjectCollection<KotlinNativeTarget> namedDomainObjectCollection = this.$appleTargets;
                        if (namedDomainObjectCollection != null) {
                            namedDomainObjectCollection.all((Action)new Action<KotlinNativeTarget>(this.$envBuildType, spec){
                                final /* synthetic */ NativeBuildType $envBuildType;
                                final /* synthetic */ CopySpec $spec;
                                {
                                    this.$envBuildType = $envBuildType;
                                    this.$spec = $spec;
                                }

                                public final void execute(KotlinNativeTarget target2) {
                                    target2.getBinaries().withType(Framework.class).matching((Spec)new Spec<Framework>(this.$envBuildType){
                                        final /* synthetic */ NativeBuildType $envBuildType;
                                        {
                                            this.$envBuildType = $envBuildType;
                                        }

                                        public final boolean isSatisfiedBy(Framework f) {
                                            return f.getBuildType() == this.$envBuildType;
                                        }
                                    }).all((Action)new Action<Framework>(this.$spec){
                                        final /* synthetic */ CopySpec $spec;
                                        {
                                            this.$spec = $spec;
                                        }

                                        public final void execute(Framework framework2) {
                                            String[] stringArray = new String[]{Intrinsics.stringPlus((String)framework2.getOutputFile().getName(), (Object)"/**")};
                                            this.$spec.include(stringArray);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
                task.into((Object)this.$envEmbeddedFrameworksDir);
                if (this.$envSign != null) {
                    task.doLast((Action)new Action<Task>((NamedDomainObjectCollection<KotlinNativeTarget>)appleTargets2, this.$envBuildType, this.$envEmbeddedFrameworksDir, this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envSign){
                        final /* synthetic */ NamedDomainObjectCollection<KotlinNativeTarget> $appleTargets;
                        final /* synthetic */ NativeBuildType $envBuildType;
                        final /* synthetic */ File $envEmbeddedFrameworksDir;
                        final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
                        final /* synthetic */ String $envSign;
                        {
                            this.$appleTargets = $appleTargets;
                            this.$envBuildType = $envBuildType;
                            this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                            this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                            this.$envSign = $envSign;
                        }

                        public final void execute(Task it) {
                            NamedDomainObjectCollection<KotlinNativeTarget> namedDomainObjectCollection = this.$appleTargets;
                            if (namedDomainObjectCollection != null) {
                                namedDomainObjectCollection.all((Action)new Action<KotlinNativeTarget>(this.$envBuildType, this.$envEmbeddedFrameworksDir, this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envSign){
                                    final /* synthetic */ NativeBuildType $envBuildType;
                                    final /* synthetic */ File $envEmbeddedFrameworksDir;
                                    final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
                                    final /* synthetic */ String $envSign;
                                    {
                                        this.$envBuildType = $envBuildType;
                                        this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                                        this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                                        this.$envSign = $envSign;
                                    }

                                    public final void execute(KotlinNativeTarget target2) {
                                        target2.getBinaries().withType(Framework.class).matching((Spec)new Spec<Framework>(this.$envBuildType){
                                            final /* synthetic */ NativeBuildType $envBuildType;
                                            {
                                                this.$envBuildType = $envBuildType;
                                            }

                                            public final boolean isSatisfiedBy(Framework f) {
                                                return f.getBuildType() == this.$envBuildType;
                                            }
                                        }).all((Action)new Action<Framework>(this.$envEmbeddedFrameworksDir, this.$this_registerEmbedAndSignAppleFrameworkTask, this.$envSign){
                                            final /* synthetic */ File $envEmbeddedFrameworksDir;
                                            final /* synthetic */ Project $this_registerEmbedAndSignAppleFrameworkTask;
                                            final /* synthetic */ String $envSign;
                                            {
                                                this.$envEmbeddedFrameworksDir = $envEmbeddedFrameworksDir;
                                                this.$this_registerEmbedAndSignAppleFrameworkTask = $receiver;
                                                this.$envSign = $envSign;
                                            }

                                            public final void execute(Framework framework2) {
                                                String string = framework2.getOutputFile().getName();
                                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"framework.outputFile.name");
                                                File binary = FilesKt.resolve((File)FilesKt.resolve((File)this.$envEmbeddedFrameworksDir, (String)string), (String)FilesKt.getNameWithoutExtension((File)framework2.getOutputFile()));
                                                this.$this_registerEmbedAndSignAppleFrameworkTask.exec((Action)new Action<ExecSpec>(this.$envSign, binary){
                                                    final /* synthetic */ String $envSign;
                                                    final /* synthetic */ File $binary;
                                                    {
                                                        this.$envSign = $envSign;
                                                        this.$binary = $binary;
                                                    }

                                                    public final void execute(ExecSpec it) {
                                                        Object[] objectArray = new Object[]{"codesign", "--force", "--sign", this.$envSign, "--", this.$binary};
                                                        it.commandLine(objectArray);
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    });
                }
            }
        };
        List args$iv = CollectionsKt.emptyList();
        boolean $i$f$registerTask = false;
        TasksProviderKt.registerTask((Project)$this$registerTask_u24default$iv, (String)name$iv, Copy.class, args$iv, body$iv);
    }

    private static final File appleFrameworkDir(Project $this$appleFrameworkDir, File frameworkSearchDir) {
        File file = $this$appleFrameworkDir.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDir");
        return FilesKt.resolve((File)FilesKt.resolve((File)file, (String)"xcode-frameworks"), (File)frameworkSearchDir);
    }

    public static final /* synthetic */ File access$appleFrameworkDir(Project $receiver, File frameworkSearchDir) {
        return AppleXcodeTasksKt.appleFrameworkDir($receiver, frameworkSearchDir);
    }
}

