/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.gradle.plugin.sources.ConsistencyCheck;
import org.jetbrains.kotlin.gradle.plugin.sources.DefaultLanguageSettingsBuilderKt;
import org.jetbrains.kotlin.gradle.plugin.sources.FragmentConsistencyChecks;
import org.jetbrains.kotlin.project.model.LanguageSettings;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B&\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tR%\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00120\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/sources/FragmentConsistencyChecks;", "T", "", "unitName", "", "languageSettings", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/project/model/LanguageSettings;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "allChecks", "", "Lorg/jetbrains/kotlin/gradle/plugin/sources/ConsistencyCheck;", "getAllChecks", "()Ljava/util/List;", "defaultLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "experimentalAnnotationsCheck", "", "getExperimentalAnnotationsCheck", "()Lorg/jetbrains/kotlin/gradle/plugin/sources/ConsistencyCheck;", "experimentalAnnotationsInUseHint", "languageVersionCheck", "getLanguageVersionCheck", "languageVersionCheckHint", "unstableFeaturesCheck", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "getUnstableFeaturesCheck", "unstableFeaturesHint", "kotlin-gradle-plugin"})
public final class FragmentConsistencyChecks<T> {
    @NotNull
    private final Function1<T, LanguageSettings> languageSettings;
    @NotNull
    private final LanguageVersion defaultLanguageVersion;
    @NotNull
    private final String languageVersionCheckHint;
    @NotNull
    private final ConsistencyCheck<T, LanguageVersion> languageVersionCheck;
    @NotNull
    private final String unstableFeaturesHint;
    @NotNull
    private final ConsistencyCheck<T, Set<LanguageFeature>> unstableFeaturesCheck;
    @NotNull
    private final String experimentalAnnotationsInUseHint;
    @NotNull
    private final ConsistencyCheck<T, Set<String>> experimentalAnnotationsCheck;
    @NotNull
    private final List<ConsistencyCheck<T, ? extends Object>> allChecks;

    public FragmentConsistencyChecks(@NotNull String unitName, @NotNull Function1<? super T, ? extends LanguageSettings> languageSettings2) {
        Intrinsics.checkParameterIsNotNull((Object)unitName, (String)"unitName");
        Intrinsics.checkParameterIsNotNull(languageSettings2, (String)"languageSettings");
        this.languageSettings = languageSettings2;
        this.defaultLanguageVersion = LanguageVersion.LATEST_STABLE;
        this.languageVersionCheckHint = "The language version of the dependent " + unitName + " must be greater than or equal to that of its dependency.";
        this.languageVersionCheck = new ConsistencyCheck("language version", (Function1)new Function1<T, LanguageVersion>(this){
            final /* synthetic */ FragmentConsistencyChecks<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LanguageVersion invoke(T unit) {
                LanguageVersion languageVersion2;
                String string = ((LanguageSettings)FragmentConsistencyChecks.access$getLanguageSettings$p(this.this$0).invoke(unit)).getLanguageVersion();
                if (string == null) {
                    languageVersion2 = null;
                } else {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    languageVersion2 = DefaultLanguageSettingsBuilderKt.parseLanguageVersionSetting(it);
                }
                LanguageVersion languageVersion3 = languageVersion2;
                return languageVersion3 == null ? FragmentConsistencyChecks.access$getDefaultLanguageVersion$p(this.this$0) : languageVersion3;
            }
        }, languageVersionCheck.2.INSTANCE, this.languageVersionCheckHint);
        this.unstableFeaturesHint = "The dependent " + unitName + " must enable all unstable language features that its dependency has.";
        this.unstableFeaturesCheck = new ConsistencyCheck("unstable language feature set", (Function1)new Function1<T, Set<LanguageFeature>>(this){
            final /* synthetic */ FragmentConsistencyChecks<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<LanguageFeature> invoke(T unit) {
                void var3_4;
                void $this$filterTo$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((LanguageSettings)FragmentConsistencyChecks.access$getLanguageSettings$p(this.this$0).invoke(unit)).getEnabledLanguageFeatures();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    LanguageFeature languageFeature = DefaultLanguageSettingsBuilderKt.parseLanguageFeature((String)it);
                    if (languageFeature == null) {
                        Intrinsics.throwNpe();
                    }
                    LanguageFeature languageFeature2 = languageFeature;
                    collection.add(languageFeature2);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv : $this$filterTo$iv) {
                    LanguageFeature it = (LanguageFeature)element$iv;
                    boolean bl = false;
                    if (!(it.getKind() == LanguageFeature.Kind.UNSTABLE_FEATURE)) continue;
                    destination$iv.add(element$iv);
                }
                return (Set)var3_4;
            }
        }, unstableFeaturesCheck.2.INSTANCE, this.unstableFeaturesHint);
        this.experimentalAnnotationsInUseHint = "The dependent " + unitName + " must use all experimental annotations that its dependency uses.";
        this.experimentalAnnotationsCheck = new ConsistencyCheck("set of experimental annotations in use", (Function1)new Function1<T, Set<? extends String>>(this){
            final /* synthetic */ FragmentConsistencyChecks<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Set<String> invoke(T unit) {
                return ((LanguageSettings)FragmentConsistencyChecks.access$getLanguageSettings$p(this.this$0).invoke(unit)).getExperimentalAnnotationsInUse();
            }
        }, experimentalAnnotationsCheck.2.INSTANCE, this.experimentalAnnotationsInUseHint);
        Object[] objectArray = new ConsistencyCheck[]{this.languageVersionCheck, this.unstableFeaturesCheck, this.experimentalAnnotationsCheck};
        this.allChecks = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final ConsistencyCheck<T, LanguageVersion> getLanguageVersionCheck() {
        return this.languageVersionCheck;
    }

    @NotNull
    public final ConsistencyCheck<T, Set<LanguageFeature>> getUnstableFeaturesCheck() {
        return this.unstableFeaturesCheck;
    }

    @NotNull
    public final ConsistencyCheck<T, Set<String>> getExperimentalAnnotationsCheck() {
        return this.experimentalAnnotationsCheck;
    }

    @NotNull
    public final List<ConsistencyCheck<T, ? extends Object>> getAllChecks() {
        return this.allChecks;
    }

    public static final /* synthetic */ Function1 access$getLanguageSettings$p(FragmentConsistencyChecks $this) {
        return $this.languageSettings;
    }

    public static final /* synthetic */ LanguageVersion access$getDefaultLanguageVersion$p(FragmentConsistencyChecks $this) {
        return $this.defaultLanguageVersion;
    }
}

