/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.model.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.Coroutines;
import org.jetbrains.kotlin.gradle.model.CompilerArguments;
import org.jetbrains.kotlin.gradle.model.ExperimentalFeatures;
import org.jetbrains.kotlin.gradle.model.KotlinProject;
import org.jetbrains.kotlin.gradle.model.SourceSet;
import org.jetbrains.kotlin.gradle.model.impl.CompilerArgumentsImpl;
import org.jetbrains.kotlin.gradle.model.impl.ExperimentalFeaturesImpl;
import org.jetbrains.kotlin.gradle.model.impl.KotlinProjectImpl;
import org.jetbrains.kotlin.gradle.model.impl.SourceSetImpl;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder;", "Lorg/gradle/tooling/provider/model/ToolingModelBuilder;", "kotlinPluginVersion", "", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;)V", "buildAll", "", "modelName", "project", "Lorg/gradle/api/Project;", "canBuild", "", "Companion", "kotlin-gradle-plugin"})
public final class KotlinModelBuilder
implements ToolingModelBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kotlinPluginVersion;
    @Nullable
    private final KotlinAndroidTarget androidTarget;

    public KotlinModelBuilder(@NotNull String kotlinPluginVersion, @Nullable KotlinAndroidTarget androidTarget) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.androidTarget = androidTarget;
    }

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)modelName, (String)"modelName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (Intrinsics.areEqual((Object)modelName, (Object)KotlinProject.class.getName())) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            TaskCollection taskCollection = project.getTasks().withType(AbstractKotlinCompile.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)taskCollection, (String)"project.tasks.withType(AbstractKotlinCompile::class.java)");
            List kotlinCompileTasks = CollectionsKt.toList((Iterable)((Iterable)taskCollection));
            KotlinProject.ProjectType projectType = KotlinModelBuilder.Companion.getProjectType(project);
            Object object = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.name");
            String string = object;
            object = kotlinCompileTasks;
            KotlinProject.ProjectType projectType2 = projectType;
            String string2 = this.kotlinPluginVersion;
            String string3 = string;
            boolean $i$f$mapNotNull = false;
            void var7_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SourceSet sourceSet;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                AbstractKotlinCompile it = (AbstractKotlinCompile)element$iv$iv;
                boolean bl2 = false;
                if (this.androidTarget != null) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    sourceSet = KotlinModelBuilder.Companion.createAndroidSourceSet(it, this.androidTarget);
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                    sourceSet = KotlinModelBuilder.Companion.createSourceSet(it, project, projectType);
                }
                if (sourceSet == null) continue;
                SourceSet sourceSet2 = sourceSet;
                boolean bl3 = false;
                boolean bl4 = false;
                SourceSet it$iv$iv = sourceSet2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            Collection collection = list2;
            Collection collection2 = KotlinModelBuilder.Companion.getExpectedByDependencies(project);
            object = (AbstractKotlinCompile)CollectionsKt.first((List)kotlinCompileTasks);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            ExperimentalFeatures experimentalFeatures = KotlinModelBuilder.Companion.createExperimentalFeatures((AbstractKotlinCompile)object);
            Collection collection3 = collection2;
            Collection collection4 = collection;
            KotlinProject.ProjectType projectType3 = projectType2;
            String string4 = string2;
            String string5 = string3;
            return new KotlinProjectImpl(string5, string4, projectType3, collection4, collection3, experimentalFeatures);
        }
        return null;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\tH\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0007H\u0002J\u0014\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00050\u0005*\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/gradle/model/builder/KotlinModelBuilder$Companion;", "", "()V", "getExpectedByDependencies", "", "", "project", "Lorg/gradle/api/Project;", "getProjectType", "Lorg/jetbrains/kotlin/gradle/model/KotlinProject$ProjectType;", "createAndroidSourceSet", "Lorg/jetbrains/kotlin/gradle/model/SourceSet;", "Lorg/jetbrains/kotlin/gradle/tasks/AbstractKotlinCompile;", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "createCompilerArguments", "Lorg/jetbrains/kotlin/gradle/model/CompilerArguments;", "createExperimentalFeatures", "Lorg/jetbrains/kotlin/gradle/model/ExperimentalFeatures;", "createSourceSet", "projectType", "isAndroid", "", "pathOrName", "kotlin.jvm.PlatformType", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isAndroid(Project $this$isAndroid) {
            return $this$isAndroid.getProject().getPlugins().hasPlugin("kotlin-android");
        }

        private final KotlinProject.ProjectType getProjectType(Project project) {
            return project.getPlugins().hasPlugin("kotlin") || project.getPlugins().hasPlugin("kotlin-platform-jvm") || this.isAndroid(project) ? KotlinProject.ProjectType.PLATFORM_JVM : (project.getPlugins().hasPlugin("kotlin2js") || project.getPlugins().hasPlugin("kotlin-platform-js") ? KotlinProject.ProjectType.PLATFORM_JS : KotlinProject.ProjectType.PLATFORM_COMMON);
        }

        /*
         * WARNING - void declaration
         */
        private final Collection<String> getExpectedByDependencies(Project project) {
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object list$iv$iv;
            String it;
            Iterable $this$flatMapTo$iv$iv;
            Object[] objectArray = new String[]{"expectedBy", "implement"};
            Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                Configuration configuration2 = (Configuration)project.getConfigurations().findByName(it);
                DependencySet dependencySet = configuration2 == null ? null : configuration2.getDependencies();
                list$iv$iv = dependencySet == null ? SetsKt.emptySet() : (Set)dependencySet;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProjectDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            list$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (list$iv$iv.hasNext()) {
                Project project2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                boolean bl = false;
                ProjectDependency it2 = (ProjectDependency)element$iv$iv;
                boolean bl2 = false;
                if (it2.getDependencyProject() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Project it$iv$iv = project2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = Companion.pathOrName((Project)it);
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        private final String pathOrName(Project $this$pathOrName) {
            return Intrinsics.areEqual((Object)$this$pathOrName.getPath(), (Object)":") ? $this$pathOrName.getName() : $this$pathOrName.getPath();
        }

        private final SourceSet createSourceSet(AbstractKotlinCompile<?> $this$createSourceSet, Project project, KotlinProject.ProjectType projectType) {
            SourceSet sourceSet;
            KotlinSourceSet kotlinSourceSet;
            Object object;
            Object object2;
            Iterable iterable;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                iterable = null;
            } else {
                object2 = javaPluginConvention.getSourceSets();
                if (object2 == null) {
                    iterable = null;
                } else {
                    Object v1;
                    block8: {
                        object = (Iterable)object2;
                        boolean bl = false;
                        Iterable iterable2 = object;
                        boolean bl2 = false;
                        for (Object t : iterable2) {
                            org.gradle.api.tasks.SourceSet it = (org.gradle.api.tasks.SourceSet)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$createSourceSet.getSourceSetName$kotlin_gradle_plugin().get())) continue;
                            v1 = t;
                            break block8;
                        }
                        v1 = null;
                    }
                    iterable = v1;
                }
            }
            Iterable javaSourceSet = iterable;
            object = javaSourceSet;
            object2 = object == null ? null : GradleUtilsKt.getConvention(object, projectType == KotlinProject.ProjectType.PLATFORM_JS ? KotlinPluginKt.getKOTLIN_JS_DSL_NAME() : KotlinPluginKt.getKOTLIN_DSL_NAME());
            KotlinSourceSet kotlinSourceSet2 = kotlinSourceSet = object2 instanceof KotlinSourceSet ? (KotlinSourceSet)object2 : null;
            if (kotlinSourceSet != null) {
                object2 = $this$createSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"sourceSetName.get()");
                String string = (String)object2;
                object2 = $this$createSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"sourceSetName.get()");
                SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)((CharSequence)object2), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
                object2 = $this$createSourceSet.getFriendSourceSets$kotlin_gradle_plugin().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"friendSourceSets.get()");
                Collection collection = (Collection)object2;
                object2 = kotlinSourceSet.getKotlin().getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"kotlinSourceSet.kotlin.srcDirs");
                Collection collection2 = (Collection)object2;
                object2 = javaSourceSet.getResources().getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"javaSourceSet.resources.srcDirs");
                Collection collection3 = (Collection)object2;
                object2 = $this$createSourceSet.getDestinationDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"destinationDir");
                Object object3 = object2;
                object = javaSourceSet.getOutput().getResourcesDir();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                object2 = object;
                sourceSet = new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, (File)object3, (File)object2, this.createCompilerArguments($this$createSourceSet));
            } else {
                sourceSet = null;
            }
            return sourceSet;
        }

        /*
         * WARNING - void declaration
         */
        private final SourceSet createAndroidSourceSet(AbstractKotlinCompile<?> $this$createAndroidSourceSet, KotlinAndroidTarget androidTarget) {
            void $this$distinctBy$iv;
            void $this$flatMapTo$iv$iv;
            void $this$distinctBy$iv2;
            void $this$flatMapTo$iv$iv2;
            String variantName = (String)$this$createAndroidSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
            KotlinJvmAndroidCompilation compilation2 = (KotlinJvmAndroidCompilation)androidTarget.getCompilations().getByName(variantName);
            Iterable $this$flatMap$iv = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Set set2 = it.getKotlin().getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"it.kotlin.srcDirs");
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            Iterable list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv2) {
                File it = (File)e$iv;
                boolean bl = false;
                String key$iv = it.getAbsolutePath();
                if (!set$iv.add(key$iv)) continue;
                ((ArrayList)list$iv).add(e$iv);
            }
            List sources = (List)list$iv;
            Iterable $this$flatMap$iv2 = compilation2.getAllKotlinSourceSets();
            boolean $i$f$flatMap2 = false;
            list$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KotlinSourceSet it = (KotlinSourceSet)element$iv$iv;
                boolean bl = false;
                Set set3 = it.getResources().getSrcDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"it.resources.srcDirs");
                Iterable list$iv$iv = set3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv2;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv2 = new HashSet<String>();
            ArrayList list$iv2 = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                File it = (File)e$iv;
                boolean bl = false;
                String key$iv = it.getAbsolutePath();
                if (!set$iv2.add(key$iv)) continue;
                list$iv2.add(e$iv);
            }
            List resources = list$iv2;
            Object object = $this$createAndroidSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sourceSetName.get()");
            String string = (String)object;
            object = $this$createAndroidSourceSet.getSourceSetName$kotlin_gradle_plugin().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sourceSetName.get()");
            SourceSet.SourceSetType sourceSetType = StringsKt.contains((CharSequence)((CharSequence)object), (CharSequence)"test", (boolean)true) ? SourceSet.SourceSetType.TEST : SourceSet.SourceSetType.PRODUCTION;
            object = $this$createAndroidSourceSet.getFriendSourceSets$kotlin_gradle_plugin().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"friendSourceSets.get()");
            Collection collection = (Collection)object;
            Collection collection2 = sources;
            Collection collection3 = resources;
            object = $this$createAndroidSourceSet.getDestinationDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"destinationDir");
            return new SourceSetImpl(string, sourceSetType, collection, collection2, collection3, (File)object, compilation2.getOutput().getResourcesDir(), this.createCompilerArguments($this$createAndroidSourceSet));
        }

        private final CompilerArguments createCompilerArguments(AbstractKotlinCompile<?> $this$createCompilerArguments) {
            List<String> list2 = $this$createCompilerArguments.getSerializedCompilerArguments();
            List<String> list3 = $this$createCompilerArguments.getDefaultSerializedCompilerArguments();
            FileCollection fileCollection2 = $this$createCompilerArguments.getClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"classpath");
            return new CompilerArgumentsImpl(list2, list3, CollectionsKt.toList((Iterable)((Iterable)fileCollection2)));
        }

        private final ExperimentalFeatures createExperimentalFeatures(AbstractKotlinCompile<?> $this$createExperimentalFeatures) {
            return new ExperimentalFeaturesImpl(((Coroutines)((Object)$this$createExperimentalFeatures.getCoroutines$kotlin_gradle_plugin().get())).name());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

