/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.kapt.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassDependencies;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.KaptClasspathChanges;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.UnknownSnapshot;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001#BA\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J2\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0017`\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0002J\u0006\u0010\"\u001a\u00020\u001eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot;", "", "cacheDir", "Ljava/io/File;", "classpath", "", "annotationProcessorClasspath", "dataForFiles", "", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathEntryData;", "(Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "diff", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/KaptClasspathChanges;", "previousSnapshot", "changedFiles", "", "findAllImpacted", "", "changedClasses", "getAllDataFiles", "", "getHashesToAnalyze", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "filesToLoad", "isCompatible", "", "snapshot", "loadAll", "", "loadEntriesFor", "file", "", "writeToCache", "ClasspathSnapshotFactory", "kotlin-gradle-plugin"})
public class ClasspathSnapshot {
    @NotNull
    private final File cacheDir;
    @NotNull
    private final List<File> classpath;
    @NotNull
    private final List<File> annotationProcessorClasspath;
    @NotNull
    private final Map<File, ClasspathEntryData> dataForFiles;

    protected ClasspathSnapshot(@NotNull File cacheDir, @NotNull List<? extends File> classpath2, @NotNull List<? extends File> annotationProcessorClasspath, @NotNull Map<File, ClasspathEntryData> dataForFiles) {
        Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
        Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
        Intrinsics.checkParameterIsNotNull(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
        Intrinsics.checkParameterIsNotNull(dataForFiles, (String)"dataForFiles");
        this.cacheDir = cacheDir;
        this.classpath = classpath2;
        this.annotationProcessorClasspath = annotationProcessorClasspath;
        this.dataForFiles = dataForFiles;
    }

    @NotNull
    public final Set<File> getAllDataFiles() {
        return this.dataForFiles.keySet();
    }

    private final boolean isCompatible(ClasspathSnapshot snapshot) {
        return !Intrinsics.areEqual((Object)this, (Object)UnknownSnapshot.INSTANCE) && !Intrinsics.areEqual((Object)snapshot, (Object)UnknownSnapshot.INSTANCE) && Intrinsics.areEqual(this.classpath, snapshot.classpath) && Intrinsics.areEqual(this.annotationProcessorClasspath, snapshot.annotationProcessorClasspath);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KaptClasspathChanges diff(@NotNull ClasspathSnapshot previousSnapshot2, @NotNull Set<? extends File> changedFiles2) {
        void $this$filterTo$iv$iv42;
        void $this$filterTo$iv$iv22;
        void $this$filterTo$iv$iv3;
        Object element$iv2;
        boolean bl;
        block14: {
            Intrinsics.checkParameterIsNotNull((Object)previousSnapshot2, (String)"previousSnapshot");
            Intrinsics.checkParameterIsNotNull(changedFiles2, (String)"changedFiles");
            if (!this.isCompatible(previousSnapshot2)) {
                return KaptClasspathChanges.Unknown.INSTANCE;
            }
            Iterable $this$any$iv = this.annotationProcessorClasspath;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    File it = (File)element$iv2;
                    boolean bl2 = false;
                    if (!changedFiles2.contains(it)) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return KaptClasspathChanges.Unknown.INSTANCE;
        }
        Iterable $this$filter$iv = CollectionsKt.intersect((Iterable)this.dataForFiles.keySet(), (Iterable)previousSnapshot2.dataForFiles.keySet());
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            File it = (File)element$iv$iv;
            boolean bl3 = false;
            if (!(!changedFiles2.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unchangedBetweenCompilations = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = this.dataForFiles.keySet();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv22) {
            File it = (File)element$iv$iv;
            boolean bl4 = false;
            if (!(!unchangedBetweenCompilations.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        $i$f$filter2 = false;
        boolean $this$filterTo$iv$iv22 = false;
        Iterable it = $this$filter$iv2;
        boolean bl5 = false;
        this.loadEntriesFor(it);
        Iterable currentToLoad = $this$filter$iv2;
        Iterable $this$filter$iv222 = previousSnapshot2.dataForFiles.keySet();
        boolean $i$f$filter3 = false;
        it = $this$filter$iv222;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo222 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv42) {
            File it2 = (File)element$iv$iv;
            boolean bl6 = false;
            if (!(!unchangedBetweenCompilations.contains(it2))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List previousToLoad = (List)destination$iv$iv3;
        boolean $this$filter$iv222 = currentToLoad.size() == previousToLoad.size();
        $i$f$filter3 = false;
        boolean $this$filterTo$iv$iv42 = false;
        if (!$this$filter$iv222) {
            boolean bl7 = false;
            String $this$filterTo$iv$iv42 = StringsKt.trimIndent((String)("\n            Number of loaded files in snapshots differs. Reported changed files: " + changedFiles2 + "\n            Current snapshot data files: " + this.dataForFiles.keySet() + "\n            Previous snapshot data files: " + previousSnapshot2.dataForFiles.keySet() + "\n        "));
            throw (Throwable)new IllegalStateException($this$filterTo$iv$iv42.toString());
        }
        HashMap<String, byte[]> currentHashesToAnalyze = this.getHashesToAnalyze((List<? extends File>)currentToLoad);
        HashMap<String, byte[]> previousHashesToAnalyze = previousSnapshot2.getHashesToAnalyze(previousToLoad);
        boolean bl7 = false;
        Set changedClasses = new LinkedHashSet();
        Set<String> $i$f$filterTo222 = previousHashesToAnalyze.keySet();
        Intrinsics.checkExpressionValueIsNotNull($i$f$filterTo222, (String)"previousHashesToAnalyze.keys");
        Set<String> set2 = $i$f$filterTo222;
        $i$f$filterTo222 = currentHashesToAnalyze.keySet();
        Intrinsics.checkExpressionValueIsNotNull($i$f$filterTo222, (String)"currentHashesToAnalyze.keys");
        for (String key : SetsKt.plus(set2, (Iterable)$i$f$filterTo222)) {
            byte[] previousHash = previousHashesToAnalyze.get(key);
            if (previousHash == null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                changedClasses.add(key);
                continue;
            }
            byte[] currentHash = currentHashesToAnalyze.get(key);
            if (currentHash == null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
                changedClasses.add(key);
                continue;
            }
            byte[] byArray = previousHash;
            boolean bl8 = false;
            byte[] byArray2 = byArray;
            boolean bl9 = false;
            if (Arrays.equals(byArray2, currentHash)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
            changedClasses.add(key);
        }
        for (File unchanged : unchangedBetweenCompilations) {
            Map<File, ClasspathEntryData> map = this.dataForFiles;
            ClasspathEntryData classpathEntryData = previousSnapshot2.dataForFiles.get(unchanged);
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            boolean bl10 = false;
            map.put(unchanged, classpathEntryData);
        }
        Set<String> allImpactedClasses = this.findAllImpacted(changedClasses);
        return new KaptClasspathChanges.Known(allImpactedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, byte[]> getHashesToAnalyze(List<? extends File> filesToLoad) {
        Iterable $this$sumBy$iv = filesToLoad;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            File file = (File)element$iv;
            int n = sum$iv;
            boolean bl = false;
            ClasspathEntryData classpathEntryData = this.dataForFiles.get(it);
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            int n2 = classpathEntryData.getClassAbiHash().size();
            sum$iv = n + n2;
        }
        int hashAbiSize = sum$iv;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(hashAbiSize);
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, byte[]> hashes = hashMap;
        boolean bl3 = false;
        Iterable $this$forEach$iv = filesToLoad;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl4 = false;
            ClasspathEntryData classpathEntryData = this.dataForFiles.get(it);
            if (classpathEntryData == null) {
                Intrinsics.throwNpe();
            }
            hashes.putAll(classpathEntryData.getClassAbiHash());
        }
        return hashMap;
    }

    private final void loadEntriesFor(Iterable<? extends File> file) {
        for (File file2 : file) {
            if (this.dataForFiles.get(file2) != null) continue;
            Map<File, ClasspathEntryData> map = this.dataForFiles;
            ClasspathEntryData classpathEntryData = ClasspathEntryData.ClasspathEntrySerializer.INSTANCE.loadFrom(file2);
            boolean bl = false;
            map.put(file2, classpathEntryData);
        }
    }

    private final void loadAll() {
        this.loadEntriesFor((Iterable<? extends File>)this.dataForFiles.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToCache() {
        this.loadAll();
        File classpathEntries = FilesKt.resolve((File)this.cacheDir, (String)"classpath-entries.bin");
        Object object = classpathEntries;
        boolean bl = false;
        object = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((File)object)));
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object;
            boolean bl3 = false;
            it.writeObject(this.classpath);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        File annotationProcessorClasspathEntries = FilesKt.resolve((File)this.cacheDir, (String)"ap-classpath-entries.bin");
        Object object2 = annotationProcessorClasspathEntries;
        boolean bl4 = false;
        object2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((File)object2)));
        bl4 = false;
        boolean bl5 = false;
        Throwable throwable3 = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object2;
            boolean bl6 = false;
            it.writeObject(this.annotationProcessorClasspath);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable3);
        }
        File classpathStructureData = FilesKt.resolve((File)this.cacheDir, (String)"classpath-structure.bin");
        Object object3 = classpathStructureData;
        boolean bl7 = false;
        object3 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((File)object3)));
        bl7 = false;
        boolean bl8 = false;
        Throwable throwable5 = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)object3;
            boolean bl9 = false;
            it.writeObject(this.dataForFiles);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable5 = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable5);
        }
    }

    private final Set<String> findAllImpacted(Set<String> changedClasses) {
        boolean bl;
        Object object;
        Object object2;
        HashMap transitiveDeps = new HashMap();
        HashMap nonTransitiveDeps = new HashMap();
        for (ClasspathEntryData entry : this.dataForFiles.values()) {
            if (entry == null) {
                Intrinsics.throwNpe();
            }
            Map<String, ClassDependencies> bl9 = entry.getClassDependencies();
            boolean bl2 = false;
            for (Map.Entry entry2 : bl9.entrySet()) {
                boolean bl3;
                List list2;
                Map map;
                List it;
                boolean bl4;
                boolean bl5;
                List list3;
                object2 = entry2;
                boolean bl6 = false;
                String className = (String)object2.getKey();
                object = entry2;
                bl = false;
                ClassDependencies classDependency = (ClassDependencies)object.getValue();
                for (String abiType : classDependency.getAbiTypes()) {
                    list3 = (List)transitiveDeps.get(abiType);
                    list3 = list3 == null ? (List)new LinkedList() : list3;
                    bl5 = false;
                    bl4 = false;
                    it = list3;
                    boolean bl7 = false;
                    it.add(className);
                    map = transitiveDeps;
                    list2 = it;
                    bl3 = false;
                    map.put(abiType, list2);
                }
                for (String privateType : classDependency.getPrivateTypes()) {
                    list3 = (List)nonTransitiveDeps.get(privateType);
                    list3 = list3 == null ? (List)new LinkedList() : list3;
                    bl5 = false;
                    bl4 = false;
                    it = list3;
                    boolean bl8 = false;
                    it.add(className);
                    map = nonTransitiveDeps;
                    list2 = it;
                    bl3 = false;
                    map.put(privateType, list2);
                }
            }
        }
        boolean entry = false;
        Set allImpacted = new LinkedHashSet();
        Set current = changedClasses;
        while (true) {
            Collection collection = current;
            boolean bl7 = false;
            if (!(!collection.isEmpty())) break;
            boolean bl8 = false;
            Set newRound = new LinkedHashSet();
            for (String klass : current) {
                Object it;
                boolean bl9;
                if (!allImpacted.add(klass)) continue;
                object2 = (List)transitiveDeps.get(klass);
                if (object2 != null) {
                    object = object2;
                    bl = false;
                    bl9 = false;
                    it = object;
                    boolean bl11 = false;
                    newRound.addAll((Collection)it);
                }
                object2 = (List)nonTransitiveDeps.get(klass);
                if (object2 == null) continue;
                object = object2;
                bl = false;
                bl9 = false;
                it = object;
                boolean bl12 = false;
                allImpacted.addAll((Collection)it);
            }
            current = newRound;
        }
        return allImpacted;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot$ClasspathSnapshotFactory;", "", "()V", "createCurrent", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathSnapshot;", "cacheDir", "Ljava/io/File;", "classpath", "", "annotationProcessorClasspath", "allStructureData", "", "getEmptySnapshot", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/UnknownSnapshot;", "loadFrom", "kotlin-gradle-plugin"})
    public static final class ClasspathSnapshotFactory {
        @NotNull
        public static final ClasspathSnapshotFactory INSTANCE = new ClasspathSnapshotFactory();

        private ClasspathSnapshotFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ClasspathSnapshot loadFrom(@NotNull File cacheDir) {
            Map map;
            List list2;
            List list3;
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            File classpathEntries = FilesKt.resolve((File)cacheDir, (String)"classpath-entries.bin");
            File classpathStructureData = FilesKt.resolve((File)cacheDir, (String)"classpath-structure.bin");
            File annotationProcessorClasspathEntries = FilesKt.resolve((File)cacheDir, (String)"ap-classpath-entries.bin");
            if (!(classpathEntries.exists() && classpathStructureData.exists() && annotationProcessorClasspathEntries.exists())) {
                return UnknownSnapshot.INSTANCE;
            }
            Object object = classpathEntries;
            boolean bl = false;
            object = new ObjectInputStream(new BufferedInputStream(new FileInputStream((File)object)));
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object;
                boolean bl3 = false;
                Object object2 = it.readObject();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                }
                list3 = (List)object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            List classpathFiles = list3;
            Object object3 = annotationProcessorClasspathEntries;
            boolean bl4 = false;
            object3 = new ObjectInputStream(new BufferedInputStream(new FileInputStream((File)object3)));
            bl4 = false;
            boolean bl5 = false;
            Throwable throwable3 = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object3;
                boolean bl6 = false;
                Object object4 = it.readObject();
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<java.io.File>");
                }
                list2 = (List)object4;
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable3);
            }
            List annotationProcessorClasspathFiles = list2;
            Object object5 = classpathStructureData;
            boolean bl7 = false;
            object5 = new ObjectInputStream(new BufferedInputStream(new FileInputStream((File)object5)));
            bl7 = false;
            boolean bl8 = false;
            Throwable throwable5 = null;
            try {
                ObjectInputStream it = (ObjectInputStream)object5;
                boolean bl9 = false;
                Object object6 = it.readObject();
                if (object6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<java.io.File, org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData?>");
                }
                map = TypeIntrinsics.asMutableMap((Object)object6);
            }
            catch (Throwable throwable6) {
                throwable5 = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object5, (Throwable)throwable5);
            }
            Map dataForFiles = map;
            return new ClasspathSnapshot(cacheDir, classpathFiles, annotationProcessorClasspathFiles, dataForFiles);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClasspathSnapshot createCurrent(@NotNull File cacheDir, @NotNull List<? extends File> classpath2, @NotNull List<? extends File> annotationProcessorClasspath, @NotNull Set<? extends File> allStructureData) {
            void $this$associateTo$iv;
            Intrinsics.checkParameterIsNotNull((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkParameterIsNotNull(classpath2, (String)"classpath");
            Intrinsics.checkParameterIsNotNull(annotationProcessorClasspath, (String)"annotationProcessorClasspath");
            Intrinsics.checkParameterIsNotNull(allStructureData, (String)"allStructureData");
            Iterable iterable = allStructureData;
            Map destination$iv = new HashMap(allStructureData.size());
            boolean $i$f$associateTo = false;
            for (Object element$iv : $this$associateTo$iv) {
                Map map = destination$iv;
                File it = (File)element$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, null);
                boolean bl2 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            HashMap data = (HashMap)destination$iv;
            return new ClasspathSnapshot(cacheDir, classpath2, annotationProcessorClasspath, data);
        }

        @NotNull
        public final UnknownSnapshot getEmptySnapshot() {
            return UnknownSnapshot.INSTANCE;
        }
    }
}

