/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.GradleCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWork;
import org.jetbrains.kotlin.compilerRunner.GradleKotlinCompilerWorkArguments;
import org.jetbrains.kotlin.compilerRunner.IncrementalCompilationEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunnerUtils;
import org.jetbrains.kotlin.compilerRunner.ProjectFilesForCompilation;
import org.jetbrains.kotlin.compilerRunner.ReportUtilsKt;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.incremental.IncrementalModuleInfoProvider;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskLoggers;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinWithJavaTarget;
import org.jetbrains.kotlin.gradle.plugin.statistics.KotlinBuildStatsService;
import org.jetbrains.kotlin.gradle.tasks.AbstractKotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.GradleCompileTaskProvider;
import org.jetbrains.kotlin.gradle.tasks.InspectClassesForMultiModuleIC;
import org.jetbrains.kotlin.gradle.tasks.Kotlin2JsCompile;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;
import org.jetbrains.kotlin.gradle.utils.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalModuleEntry;
import org.jetbrains.kotlin.incremental.IncrementalModuleInfo;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.IStatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0014J2\u0010,\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050.2\u0006\u00100\u001a\u0002012\u0006\u0010(\u001a\u00020)JR\u00102\u001a\u00020$2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050.2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050.2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0005062\b\u00107\u001a\u0004\u0018\u00010\u00162\u0006\u00100\u001a\u0002082\u0006\u0010(\u001a\u00020)2\u0006\u00109\u001a\u00020\u0005J$\u0010:\u001a\u00020$2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050.2\u0006\u00100\u001a\u00020;2\u0006\u0010(\u001a\u00020)R\u001c\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001c\u0010\u0011\u001a\n \b*\u0004\u0018\u00010\u00120\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\n \b*\u0004\u0018\u00010\u00160\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\n \b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u001c\u0010\u001b\u001a\n \b*\u0004\u0018\u00010\u00160\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u001c\u0010\u001d\u001a\n \b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\nR\u001c\u0010\u001f\u001a\n \b*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner;", "", "taskProvider", "Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "jdkToolsJar", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;Ljava/io/File;)V", "buildDirProvider", "kotlin.jvm.PlatformType", "getBuildDirProvider$kotlin_gradle_plugin", "()Ljava/io/File;", "incrementalModuleInfoProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/incremental/IncrementalModuleInfoProvider;", "getIncrementalModuleInfoProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/provider/Provider;", "getJdkToolsJar", "loggerProvider", "Lorg/gradle/api/logging/Logger;", "getLoggerProvider$kotlin_gradle_plugin", "()Lorg/gradle/api/logging/Logger;", "pathProvider", "", "getPathProvider$kotlin_gradle_plugin", "()Ljava/lang/String;", "projectDirProvider", "getProjectDirProvider$kotlin_gradle_plugin", "projectNameProvider", "getProjectNameProvider$kotlin_gradle_plugin", "projectRootDirProvider", "getProjectRootDirProvider$kotlin_gradle_plugin", "sessionDirProvider", "getSessionDirProvider$kotlin_gradle_plugin", "getTaskProvider", "()Lorg/jetbrains/kotlin/gradle/tasks/GradleCompileTaskProvider;", "runCompilerAsync", "", "compilerClassName", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerEnvironment;", "workArgs", "Lorg/jetbrains/kotlin/compilerRunner/GradleKotlinCompilerWorkArguments;", "runJsCompilerAsync", "kotlinSources", "", "kotlinCommonSources", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "runJvmCompilerAsync", "sourcesToCompile", "commonSources", "javaSourceRoots", "", "javaPackagePrefix", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "jdkHome", "runMetadataCompilerAsync", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "Companion", "kotlin-gradle-plugin"})
public class GradleCompilerRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleCompileTaskProvider taskProvider;
    @Nullable
    private final File jdkToolsJar;
    private final String pathProvider;
    private final Logger loggerProvider;
    private final File buildDirProvider;
    private final File projectDirProvider;
    private final File projectRootDirProvider;
    private final File sessionDirProvider;
    private final String projectNameProvider;
    @NotNull
    private final Provider<? extends IncrementalModuleInfoProvider> incrementalModuleInfoProvider;
    @NotNull
    private static volatile WeakReference<Gradle> cachedGradle = new WeakReference<Object>(null);
    @Nullable
    private static volatile IncrementalModuleInfo cachedModulesInfo;
    @Nullable
    private static volatile File clientIsAliveFlagFile;
    @Nullable
    private static volatile File sessionFlagFile;

    public GradleCompilerRunner(@NotNull GradleCompileTaskProvider taskProvider, @Nullable File jdkToolsJar) {
        Intrinsics.checkParameterIsNotNull((Object)taskProvider, (String)"taskProvider");
        this.taskProvider = taskProvider;
        this.jdkToolsJar = jdkToolsJar;
        this.pathProvider = (String)this.taskProvider.getPath().get();
        this.loggerProvider = (Logger)this.taskProvider.getLogger().get();
        this.buildDirProvider = ((Directory)this.taskProvider.getBuildDir().get()).getAsFile();
        this.projectDirProvider = (File)this.taskProvider.getProjectDir().get();
        this.projectRootDirProvider = (File)this.taskProvider.getRootDir().get();
        this.sessionDirProvider = (File)this.taskProvider.getSessionsDir().get();
        this.projectNameProvider = (String)this.taskProvider.getProjectName().get();
        this.incrementalModuleInfoProvider = this.taskProvider.getBuildModulesInfo();
    }

    @NotNull
    protected final GradleCompileTaskProvider getTaskProvider() {
        return this.taskProvider;
    }

    @Nullable
    protected final File getJdkToolsJar() {
        return this.jdkToolsJar;
    }

    public final String getPathProvider$kotlin_gradle_plugin() {
        return this.pathProvider;
    }

    public final Logger getLoggerProvider$kotlin_gradle_plugin() {
        return this.loggerProvider;
    }

    public final File getBuildDirProvider$kotlin_gradle_plugin() {
        return this.buildDirProvider;
    }

    public final File getProjectDirProvider$kotlin_gradle_plugin() {
        return this.projectDirProvider;
    }

    public final File getProjectRootDirProvider$kotlin_gradle_plugin() {
        return this.projectRootDirProvider;
    }

    public final File getSessionDirProvider$kotlin_gradle_plugin() {
        return this.sessionDirProvider;
    }

    public final String getProjectNameProvider$kotlin_gradle_plugin() {
        return this.projectNameProvider;
    }

    @NotNull
    public final Provider<? extends IncrementalModuleInfoProvider> getIncrementalModuleInfoProvider$kotlin_gradle_plugin() {
        return this.incrementalModuleInfoProvider;
    }

    /*
     * WARNING - void declaration
     */
    public final void runJvmCompilerAsync(@NotNull List<? extends File> sourcesToCompile, @NotNull List<? extends File> commonSources, @NotNull Iterable<? extends File> javaSourceRoots, @Nullable String javaPackagePrefix, @NotNull K2JVMCompilerArguments args, @NotNull GradleCompilerEnvironment environment, @NotNull File jdkHome) {
        Iterable<? extends File> $this$toTypedArray$iv;
        File it;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkParameterIsNotNull(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkParameterIsNotNull(commonSources, (String)"commonSources");
        Intrinsics.checkParameterIsNotNull(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)jdkHome, (String)"jdkHome");
        Object object2 = args;
        Iterable iterable = sourcesToCompile;
        Collection collection = object2.getFreeArgs();
        K2JVMCompilerArguments k2JVMCompilerArguments = object2;
        boolean $i$f$map22 = false;
        void var11_15 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it2;
            File file = (File)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it2.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JVMCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        object2 = commonSources;
        k2JVMCompilerArguments = args;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        Iterable<Object> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setCommonSources(stringArray);
        $this$toTypedArray$iv = javaSourceRoots;
        k2JVMCompilerArguments = args;
        $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JVMCompilerArguments.setJavaSourceRoots(stringArray2);
        args.setJavaPackagePrefix(javaPackagePrefix);
        if (args.getJdkHome() == null) {
            args.setJdkHome(jdkHome.getAbsolutePath());
        }
        object2 = this.loggerProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"loggerProvider");
        GradleLoggingUtilsKt.kotlinInfo((Logger)object2, Intrinsics.stringPlus((String)"Kotlin compilation 'jdkHome' argument: ", (Object)args.getJdkHome()));
        this.runCompilerAsync("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler", (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    public final void runJsCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull List<? extends File> kotlinCommonSources, @NotNull K2JSCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull(kotlinCommonSources, (String)"kotlinCommonSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        Object object2 = args;
        Iterable iterable = kotlinSources;
        Collection collection = object2.getFreeArgs();
        K2JSCompilerArguments k2JSCompilerArguments = object2;
        boolean $i$f$map22 = false;
        void var8_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            File file = (File)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        k2JSCompilerArguments.setFreeArgs(CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object)));
        object2 = kotlinCommonSources;
        k2JSCompilerArguments = args;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = it.getAbsolutePath();
            collection.add(object);
        }
        $this$map$iv = collection = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        k2JSCompilerArguments.setCommonSources(stringArray);
        this.runCompilerAsync("org.jetbrains.kotlin.cli.js.K2JSCompiler", (CommonCompilerArguments)args, environment);
    }

    /*
     * WARNING - void declaration
     */
    public final void runMetadataCompilerAsync(@NotNull List<? extends File> kotlinSources, @NotNull K2MetadataCompilerArguments args, @NotNull GradleCompilerEnvironment environment) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(kotlinSources, (String)"kotlinSources");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
        K2MetadataCompilerArguments k2MetadataCompilerArguments = args;
        Iterable iterable = kotlinSources;
        Collection collection2 = k2MetadataCompilerArguments.getFreeArgs();
        K2MetadataCompilerArguments k2MetadataCompilerArguments2 = k2MetadataCompilerArguments;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        k2MetadataCompilerArguments2.setFreeArgs(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        this.runCompilerAsync("org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler", (CommonCompilerArguments)args, environment);
    }

    private final void runCompilerAsync(String compilerClassName, CommonCompilerArguments compilerArgs, GradleCompilerEnvironment environment) {
        Object object;
        IncrementalModuleInfo incrementalModuleInfo;
        if (compilerArgs.getVersion()) {
            this.loggerProvider.lifecycle("Kotlin version " + ReportUtilsKt.loadCompilerVersion(environment.getCompilerClasspath()) + " (JRE " + System.getProperty("java.runtime.version") + ')');
            compilerArgs.setVersion(false);
        }
        List list2 = ArgumentUtils.convertArgumentsToStringList((CommonToolArguments)((CommonToolArguments)compilerArgs));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"convertArgumentsToStringList(compilerArgs)");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Object thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argsArray = stringArray;
        KotlinBuildStatsService.Companion.applyIfInitialised((Function1<? super IStatisticsValuesConsumer, Unit>)((Function1)new Function1<IStatisticsValuesConsumer, Unit>(compilerArgs, argsArray){
            final /* synthetic */ CommonCompilerArguments $compilerArgs;
            final /* synthetic */ String[] $argsArray;
            {
                this.$compilerArgs = $compilerArgs;
                this.$argsArray = $argsArray;
                super(1);
            }

            public final void invoke(@NotNull IStatisticsValuesConsumer it) {
                IStatisticsValuesConsumer iStatisticsValuesConsumer;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (this.$compilerArgs instanceof K2JVMCompilerArguments && (iStatisticsValuesConsumer = KotlinBuildStatsService.Companion.getInstance()) != null) {
                    IStatisticsValuesConsumer iStatisticsValuesConsumer2 = iStatisticsValuesConsumer;
                    Object[] objectArray = this.$argsArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    IStatisticsValuesConsumer $this$invoke_u24lambda_u2d0 = iStatisticsValuesConsumer2;
                    boolean bl3 = false;
                    K2JVMCompilerArguments args = new K2JVMCompilerArguments();
                    ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.toList((Object[])objectArray), (CommonToolArguments)((CommonToolArguments)args));
                    IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, BooleanMetrics.JVM_COMPILER_IR_MODE, args.getUseIR(), null, 4, null);
                    IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.JVM_DEFAULTS, args.getJvmDefault(), null, 4, null);
                    IStatisticsValuesConsumer.DefaultImpls.report$default($this$invoke_u24lambda_u2d0, StringMetrics.USE_OLD_BACKEND, String.valueOf(args.getUseOldBackend()), null, 4, null);
                }
            }
        }));
        IncrementalCompilationEnvironment incrementalCompilationEnvironment = environment.getIncrementalCompilationEnvironment();
        thisCollection$iv = incrementalCompilationEnvironment;
        if (thisCollection$iv == null) {
            incrementalModuleInfo = null;
        } else {
            object = thisCollection$iv;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            incrementalModuleInfo = ((IncrementalModuleInfoProvider)this.getIncrementalModuleInfoProvider$kotlin_gradle_plugin().get()).getInfo();
        }
        IncrementalModuleInfo modulesInfo = incrementalModuleInfo;
        object = this.loggerProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"loggerProvider");
        Object object2 = object;
        object = this.projectDirProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"projectDirProvider");
        Object object3 = object;
        object = this.buildDirProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"buildDirProvider");
        Object object4 = object;
        object = this.projectNameProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"projectNameProvider");
        Object object5 = object;
        object = this.projectRootDirProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"projectRootDirProvider");
        Object object6 = object;
        object = this.sessionDirProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sessionDirProvider");
        ProjectFilesForCompilation projectFilesForCompilation = new ProjectFilesForCompilation((Logger)object2, (File)object3, (File)object4, (String)object5, (File)object6, (File)object);
        List<File> list3 = environment.compilerFullClasspath(this.jdkToolsJar);
        boolean bl = compilerArgs.getVerbose();
        List list4 = CollectionsKt.toList((Iterable)((Iterable)environment.getOutputFiles()));
        object = this.pathProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pathProvider");
        GradleKotlinCompilerWorkArguments workArgs = new GradleKotlinCompilerWorkArguments(projectFilesForCompilation, list3, compilerClassName, argsArray, bl, incrementalCompilationEnvironment, modulesInfo, list4, (String)object, environment.getReportingSettings(), environment.getKotlinScriptExtensions(), compilerArgs.getAllWarningsAsErrors());
        object = this.pathProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pathProvider");
        Object object7 = object;
        object = this.loggerProvider;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"loggerProvider");
        TaskLoggers.INSTANCE.put((String)object7, (Logger)object);
        this.runCompilerAsync(workArgs);
    }

    protected void runCompilerAsync(@NotNull GradleKotlinCompilerWorkArguments workArgs) {
        Intrinsics.checkParameterIsNotNull((Object)workArgs, (String)"workArgs");
        GradleKotlinCompilerWork kotlinCompilerRunnable = new GradleKotlinCompilerWork(workArgs);
        kotlinCompilerRunnable.run();
    }

    public static final /* synthetic */ File access$getClientIsAliveFlagFile$cp() {
        return clientIsAliveFlagFile;
    }

    public static final /* synthetic */ void access$setClientIsAliveFlagFile$cp(File file) {
        clientIsAliveFlagFile = file;
    }

    public static final /* synthetic */ File access$getSessionFlagFile$cp() {
        return sessionFlagFile;
    }

    public static final /* synthetic */ void access$setSessionFlagFile$cp(File file) {
        sessionFlagFile = file;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J=\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J%\u0010!\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u0004\u0018\u00010\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001fH\u0002J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b*J\u0011\u0010+\u001a\u00020\u001f*\u00020\u001fH\u0000\u00a2\u0006\u0002\b,R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/GradleCompilerRunner$Companion;", "", "()V", "cachedGradle", "Ljava/lang/ref/WeakReference;", "Lorg/gradle/api/invocation/Gradle;", "cachedModulesInfo", "Lorg/jetbrains/kotlin/incremental/IncrementalModuleInfo;", "clientIsAliveFlagFile", "Ljava/io/File;", "sessionFlagFile", "buildModulesInfo", "gradle", "buildModulesInfo$kotlin_gradle_plugin", "clearBuildModulesInfo", "", "clearBuildModulesInfo$kotlin_gradle_plugin", "getDaemonConnectionImpl", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "sessionIsAliveFlagFile", "compilerFullClasspath", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "isDebugEnabled", "", "getDaemonConnectionImpl$kotlin_gradle_plugin", "getOrCreateClientFlagFile", "log", "Lorg/gradle/api/logging/Logger;", "projectName", "", "getOrCreateClientFlagFile$kotlin_gradle_plugin", "getOrCreateSessionFlagFile", "sessionsDir", "projectRootDir", "getOrCreateSessionFlagFile$kotlin_gradle_plugin", "jarForSourceSet", "project", "Lorg/gradle/api/Project;", "sourceSetName", "rootProjectBuildDir", "sessionsDir$kotlin_gradle_plugin", "normalizeForFlagFile", "normalizeForFlagFile$kotlin_gradle_plugin", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final synchronized CompileServiceSession getDaemonConnectionImpl$kotlin_gradle_plugin(@NotNull File clientIsAliveFlagFile, @NotNull File sessionIsAliveFlagFile, @NotNull List<? extends File> compilerFullClasspath, @NotNull MessageCollector messageCollector, boolean isDebugEnabled) {
            Intrinsics.checkParameterIsNotNull((Object)clientIsAliveFlagFile, (String)"clientIsAliveFlagFile");
            Intrinsics.checkParameterIsNotNull((Object)sessionIsAliveFlagFile, (String)"sessionIsAliveFlagFile");
            Intrinsics.checkParameterIsNotNull(compilerFullClasspath, (String)"compilerFullClasspath");
            Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
            CompilerId compilerId = CompilerId.Companion.makeCompilerId((Iterable)compilerFullClasspath);
            boolean bl = false;
            ArrayList additionalJvmParams = new ArrayList();
            Collection $this$toTypedArray$iv = additionalJvmParams;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return KotlinCompilerRunnerUtils.newDaemonConnection$default((CompilerId)compilerId, (File)clientIsAliveFlagFile, (File)sessionIsAliveFlagFile, (MessageCollector)messageCollector, (boolean)isDebugEnabled, null, (String[])stringArray, (int)32, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final synchronized IncrementalModuleInfo buildModulesInfo$kotlin_gradle_plugin(@NotNull Gradle gradle) {
            Object object;
            Object task22;
            Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
            if (cachedGradle.get() == gradle && cachedModulesInfo != null) {
                IncrementalModuleInfo incrementalModuleInfo = cachedModulesInfo;
                if (incrementalModuleInfo == null) {
                    Intrinsics.throwNpe();
                }
                return incrementalModuleInfo;
            }
            HashMap dirToModule = new HashMap();
            HashMap nameToModules = new HashMap();
            HashMap jarToClassListFile = new HashMap();
            HashMap jarToModule = new HashMap();
            HashMap jarToAbiSnapshot = new HashMap();
            boolean bl = false;
            Map multiplatformProjectTasks = new LinkedHashMap();
            Object object2 = gradle.getTaskGraph().getAllTasks();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gradle.taskGraph.allTasks");
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object key$iv;
                Map module;
                boolean bl2;
                Object object3;
                Object object4;
                task22 = (Task)element$iv;
                boolean bl3 = false;
                Project project = task22.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                if (KotlinProjectExtensionKt.getMultiplatformExtensionOrNull(project) != null) {
                    Set set2;
                    object4 = (Set)multiplatformProjectTasks.get(project);
                    if (object4 == null) {
                        boolean bl4 = false;
                        set2 = new LinkedHashSet();
                    } else {
                        set2 = object4;
                    }
                    Set tasksInProject = set2;
                    object4 = task22.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"task.name");
                    tasksInProject.add(object4);
                    object4 = multiplatformProjectTasks;
                    object3 = project;
                    bl2 = false;
                    object4.put(object3, tasksInProject);
                }
                if (task22 instanceof AbstractKotlinCompile) {
                    Object object5;
                    void $this$getOrPut$iv;
                    object4 = project.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"project.path");
                    Object object6 = object4;
                    object4 = ((AbstractKotlinCompile)task22).getModuleName$kotlin_gradle_plugin().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"task.moduleName.get()");
                    String string = (String)object4;
                    object4 = project.getBuildDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"project.buildDir");
                    Object object7 = object4;
                    object4 = ((RegularFile)((AbstractKotlinCompile)task22).getBuildHistoryFile$kotlin_gradle_plugin().get()).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"task.buildHistoryFile.get().asFile");
                    Object object8 = object4;
                    object4 = ((RegularFile)((AbstractKotlinCompile)task22).getAbiSnapshotFile().get()).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"task.abiSnapshotFile.get().asFile");
                    module = new IncrementalModuleEntry((String)object6, string, (File)object7, (File)object8, (File)object4);
                    object4 = dirToModule;
                    object3 = ((AbstractKotlinCompile)task22).getDestinationDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"task.destinationDir");
                    bl2 = false;
                    object4.put(object3, module);
                    object4 = (Directory)((AbstractKotlinCompile)task22).getJavaOutputDir$kotlin_gradle_plugin().getOrNull();
                    if (object4 != null && (object3 = object4.getAsFile()) != null) {
                        Object object9 = object3;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        Object it = object9;
                        boolean bl7 = false;
                        object = dirToModule;
                        boolean bl8 = false;
                        object.put(it, module);
                    }
                    object4 = nameToModules;
                    key$iv = module.getName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv22 = $this$getOrPut$iv.get(key$iv);
                    if (value$iv22 == null) {
                        boolean bl9 = false;
                        HashSet answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object5 = answer$iv;
                    } else {
                        object5 = value$iv22;
                    }
                    ((HashSet)object5).add(module);
                    if (!(task22 instanceof Kotlin2JsCompile)) continue;
                    key$iv = ((AbstractKotlinCompile)task22).getSourceSetName$kotlin_gradle_plugin().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)key$iv, (String)"task.sourceSetName.get()");
                    object4 = Companion.jarForSourceSet(project, (String)key$iv);
                    if (object4 == null) continue;
                    key$iv = object4;
                    bl2 = false;
                    boolean value$iv22 = false;
                    Object it = key$iv;
                    boolean bl10 = false;
                    Map bl7 = jarToModule;
                    boolean bl11 = false;
                    bl7.put(it, module);
                    continue;
                }
                if (!(task22 instanceof InspectClassesForMultiModuleIC)) continue;
                module = jarToClassListFile;
                object4 = new File((String)((InspectClassesForMultiModuleIC)((Object)task22)).getArchivePath$kotlin_gradle_plugin().get());
                key$iv = ((InspectClassesForMultiModuleIC)((Object)task22)).getClassesListFile$kotlin_gradle_plugin();
                bl2 = false;
                module.put(object4, key$iv);
            }
            Object object10 = multiplatformProjectTasks;
            boolean bl12 = false;
            object2 = object10.entrySet().iterator();
            while (object2.hasNext()) {
                Object element$iv;
                element$iv = object10 = (Map.Entry)object2.next();
                boolean task22 = false;
                Project project = (Project)element$iv.getKey();
                task22 = object10;
                boolean bl13 = false;
                Set tasksInProject = (Set)task22.getValue();
                task22 = (KotlinMultiplatformExtension)project.getExtensions().findByType(KotlinMultiplatformExtension.class);
                if (task22 == null) continue;
                Object object11 = task22;
                boolean bl14 = false;
                boolean bl15 = false;
                Object kotlinExt = object11;
                boolean bl16 = false;
                for (KotlinTarget target2 : ((KotlinMultiplatformExtension)kotlinExt).getTargets()) {
                    Object object12;
                    KotlinCompilation mainCompilation;
                    KotlinCompilation it = (KotlinCompilation)target2.getCompilations().findByName("main");
                    if (it == null || !tasksInProject.contains((mainCompilation = it).getCompileKotlinTaskName()) || !tasksInProject.contains(target2.getArtifactsTaskName())) continue;
                    Object bl7 = mainCompilation.getCompileKotlinTask();
                    Object object13 = object = bl7 instanceof AbstractKotlinCompile ? (AbstractKotlinCompile)bl7 : null;
                    if (object == null) continue;
                    AbstractKotlinCompile kotlinTask = object;
                    bl7 = project.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl7, (String)"project.path");
                    Object object14 = bl7;
                    bl7 = kotlinTask.getModuleName$kotlin_gradle_plugin().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl7, (String)"kotlinTask.moduleName.get()");
                    String string = (String)bl7;
                    bl7 = project.getBuildDir();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl7, (String)"project.buildDir");
                    Object object15 = bl7;
                    bl7 = ((RegularFile)kotlinTask.getBuildHistoryFile$kotlin_gradle_plugin().get()).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl7, (String)"kotlinTask.buildHistoryFile.get().asFile");
                    Object object16 = bl7;
                    bl7 = ((RegularFile)kotlinTask.getAbiSnapshotFile().get()).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl7, (String)"kotlinTask.abiSnapshotFile.get().asFile");
                    IncrementalModuleEntry module = new IncrementalModuleEntry((String)object14, string, (File)object15, (File)object16, (File)bl7);
                    Object object17 = project.getTasks().findByName(target2.getArtifactsTaskName());
                    Object object18 = object12 = object17 instanceof AbstractArchiveTask ? (AbstractArchiveTask)object17 : null;
                    if (object12 == null) continue;
                    AbstractArchiveTask jarTask = object12;
                    object12 = jarToModule;
                    object17 = CompatibiltiyKt.getArchivePathCompatible(jarTask).getCanonicalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object17, (String)"jarTask.archivePathCompatible.canonicalFile");
                    boolean bl17 = false;
                    object12.put(object17, module);
                    if (!(target2 instanceof KotlinWithJavaTarget)) continue;
                    object17 = project.getTasks().getByName(target2.getArtifactsTaskName());
                    if (object17 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.jvm.tasks.Jar");
                    }
                    Jar jar = (Jar)object17;
                    object17 = jarToClassListFile;
                    File file = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jar.archivePathCompatible.canonicalFile");
                    Object object19 = ((KotlinWithJavaTarget)target2).getDefaultArtifactClassesListFile$kotlin_gradle_plugin().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object19, (String)"target.defaultArtifactClassesListFile.get()");
                    boolean bl18 = false;
                    object17.put(file, object19);
                    object17 = jarToAbiSnapshot;
                    file = CompatibiltiyKt.getArchivePathCompatible((AbstractArchiveTask)jar).getCanonicalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jar.archivePathCompatible.canonicalFile");
                    object19 = ((RegularFile)((Directory)((KotlinWithJavaTarget)target2).getBuildDir$kotlin_gradle_plugin().get()).file((Provider)kotlinTask.getAbiSnapshotRelativePath()).get()).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object19, (String)"target.buildDir.get().fi\u2026elativePath).get().asFile");
                    bl18 = false;
                    object17.put(file, object19);
                }
            }
            object2 = gradle.getRootProject().getProjectDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gradle.rootProject.projectDir");
            Object object20 = object2;
            object2 = gradle.getRootProject().getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"gradle.rootProject.buildDir");
            object2 = new IncrementalModuleInfo((File)object20, (File)object2, (Map)dirToModule, (Map)nameToModules, (Map)jarToClassListFile, (Map)jarToModule, (Map)jarToAbiSnapshot);
            boolean bl19 = false;
            boolean bl20 = false;
            Object it = object2;
            boolean bl21 = false;
            cachedGradle = new WeakReference<Gradle>(gradle);
            cachedModulesInfo = (IncrementalModuleInfo)it;
            return object2;
        }

        private final File jarForSourceSet(Project project, String sourceSetName) {
            RegularFile regularFile;
            Provider provider;
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                return null;
            }
            JavaPluginConvention javaPluginConvention2 = javaPluginConvention;
            JavaPluginConvention javaConvention = javaPluginConvention2;
            Object object = (SourceSet)javaConvention.getSourceSets().findByName(sourceSetName);
            if (object == null) {
                return null;
            }
            JavaPluginConvention sourceSet = javaPluginConvention = object;
            object = project.getTasks().findByName(sourceSet.getJarTaskName());
            Jar jarTask = object instanceof Jar ? (Jar)object : null;
            object = jarTask;
            return object == null ? null : ((provider = object.getArchiveFile()) == null ? null : ((regularFile = (RegularFile)provider.get()) == null ? null : regularFile.getAsFile()));
        }

        public final synchronized void clearBuildModulesInfo$kotlin_gradle_plugin() {
            cachedGradle = new WeakReference<Object>(null);
            cachedModulesInfo = null;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateClientFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull String projectName) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
            if (GradleCompilerRunner.access$getClientIsAliveFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                GradleCompilerRunner.access$setClientIsAliveFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-in-" + projectName + '-', ".alive", null, false, 12, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var6_7 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$1 = false;
                    v1 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    var7_11 = Intrinsics.stringPlus((String)"Created client-is-alive flag file: ", (Object)v1.getCanonicalPath());
                    GradleLoggingUtilsKt.kotlinDebug(var6_7, var7_11);
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var6_8 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateClientFlagFile$2 = false;
                    v2 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    var7_12 = Intrinsics.stringPlus((String)"Existing client-is-alive flag file: ", (Object)v2.getCanonicalPath());
                    GradleLoggingUtilsKt.kotlinDebug(var6_8, var7_12);
                }
            }
            v3 = GradleCompilerRunner.access$getClientIsAliveFlagFile$cp();
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            return v3;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String normalizeForFlagFile$kotlin_gradle_plugin(@NotNull String $this$normalizeForFlagFile) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$this$normalizeForFlagFile, (String)"<this>");
            List validChars = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9'))), (Object)"-_");
            String $this$filter$iv = $this$normalizeForFlagFile;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = 0;
            int n2 = $this$filterTo$iv$iv.length();
            while (n < n2) {
                void index$iv$iv;
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                boolean bl = false;
                if (validChars.contains(Character.valueOf(it))) {
                    destination$iv$iv.append(element$iv$iv);
                }
                ++index$iv$iv;
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            return string;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final synchronized File getOrCreateSessionFlagFile$kotlin_gradle_plugin(@NotNull Logger log, @NotNull File sessionsDir, @NotNull File projectRootDir) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            Intrinsics.checkParameterIsNotNull((Object)sessionsDir, (String)"sessionsDir");
            Intrinsics.checkParameterIsNotNull((Object)projectRootDir, (String)"projectRootDir");
            if (GradleCompilerRunner.access$getSessionFlagFile$cp() == null) ** GOTO lbl-1000
            v0 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            if (!v0.exists()) lbl-1000:
            // 2 sources

            {
                var5_4 = sessionsDir;
                var6_6 = false;
                var7_8 = false;
                $this$getOrCreateSessionFlagFile_u24lambda_u2d9 = var5_4;
                $i$a$-apply-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$sessionFilesDir$1 = false;
                $this$getOrCreateSessionFlagFile_u24lambda_u2d9.mkdirs();
                sessionFilesDir = var5_4;
                GradleCompilerRunner.access$setSessionFlagFile$cp(FileUtilsKt.newTmpFile$default("kotlin-compiler-", ".salive", sessionFilesDir, false, 8, null));
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var10_13 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$1 = false;
                    v1 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    var11_15 = Intrinsics.stringPlus((String)"Created session-is-alive flag file: ", (Object)FileUtilsKt.relativeOrCanonical(v1, projectRootDir));
                    GradleLoggingUtilsKt.kotlinDebug(var10_13, var11_15);
                }
            } else {
                $this$kotlinDebug$iv = log;
                $i$f$kotlinDebug = false;
                if ($this$kotlinDebug$iv.isDebugEnabled()) {
                    var10_14 = $this$kotlinDebug$iv;
                    $i$a$-kotlinDebug-GradleCompilerRunner$Companion$getOrCreateSessionFlagFile$2 = false;
                    v2 = GradleCompilerRunner.access$getSessionFlagFile$cp();
                    if (v2 == null) {
                        Intrinsics.throwNpe();
                    }
                    var11_16 = Intrinsics.stringPlus((String)"Existing session-is-alive flag file: ", (Object)FileUtilsKt.relativeOrCanonical(v2, projectRootDir));
                    GradleLoggingUtilsKt.kotlinDebug(var10_14, var11_16);
                }
            }
            v3 = GradleCompilerRunner.access$getSessionFlagFile$cp();
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            return v3;
        }

        @NotNull
        public final File sessionsDir$kotlin_gradle_plugin(@NotNull File rootProjectBuildDir) {
            Intrinsics.checkParameterIsNotNull((Object)rootProjectBuildDir, (String)"rootProjectBuildDir");
            return new File(new File(rootProjectBuildDir, "kotlin"), "sessions");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

