/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinAndroidProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.internal.KotlinDependenciesManagementKt;
import org.jetbrains.kotlin.gradle.model.builder.KotlinModelBuilder;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.Android25ProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinConfigurationTools;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.tasks.AndroidTasksProvider;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "apply", "", "project", "Companion", "kotlin-gradle-plugin"})
public class KotlinAndroidPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolingModelBuilderRegistry registry;

    public KotlinAndroidPlugin(@NotNull ToolingModelBuilderRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CompatibiltiyKt.checkGradleCompatibility$default(null, null, 3, null);
        KotlinAndroidTarget androidTarget = new KotlinAndroidTarget("", project);
        ((KotlinAndroidProjectExtension)KotlinProjectExtensionKt.getKotlinExtension(project)).setTarget$kotlin_gradle_plugin(androidTarget);
        Companion.applyToTarget(androidTarget);
        org.jetbrains.kotlin.gradle.plugin.mpp.KotlinMultiplatformPluginKt.applyUserDefinedAttributes(androidTarget);
        KotlinDependenciesManagementKt.customizeKotlinDependencies(project);
        this.registry.register((ToolingModelBuilder)new KotlinModelBuilder(KotlinPluginWrapperKt.getKotlinPluginVersion(project), androidTarget));
        KotlinMultiplatformPluginKt.whenEvaluated(project, (Function1)new Function1<Project, Boolean>(project, androidTarget){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinAndroidTarget $androidTarget;
            {
                this.$project = $project;
                this.$androidTarget = $androidTarget;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Project $this$whenEvaluated) {
                Intrinsics.checkParameterIsNotNull((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                return this.$project.getComponents().addAll((Collection)this.$androidTarget.getComponents());
            }
        });
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin$Companion;", "", "()V", "androidTargetHandler", "Lorg/jetbrains/kotlin/gradle/plugin/AbstractAndroidProjectHandler;", "applyToTarget", "", "kotlinTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "kotlin-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AbstractAndroidProjectHandler androidTargetHandler() {
            AndroidTasksProvider tasksProvider = new AndroidTasksProvider();
            if (KotlinPluginKt.getAndroidPluginVersion() != null) {
                String minimalVersion = "3.0.0";
                if (KotlinPluginKt.compareVersionNumbers(KotlinPluginKt.getAndroidPluginVersion(), minimalVersion) < 0) {
                    throw new IllegalStateException("Kotlin: Unsupported version of com.android.tools.build:gradle plugin: version " + minimalVersion + " or higher should be used with kotlin-android plugin");
                }
            }
            KotlinConfigurationTools kotlinTools = new KotlinConfigurationTools(tasksProvider);
            return new Android25ProjectHandler(kotlinTools);
        }

        public final void applyToTarget(@NotNull KotlinAndroidTarget kotlinTarget) {
            Intrinsics.checkParameterIsNotNull((Object)kotlinTarget, (String)"kotlinTarget");
            this.androidTargetHandler().configureTarget(kotlinTarget);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

